/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.layout;

import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import org.qbicc.type.CompoundType;
import org.qbicc.type.definition.element.FieldElement;

public final class LayoutInfo {
    private final BitSet allocated;
    private final CompoundType compoundType;
    private final Map<FieldElement, CompoundType.Member> fieldToMember;

    LayoutInfo(BitSet allocated, CompoundType compoundType, Map<FieldElement, CompoundType.Member> fieldToMember) {
        this.allocated = allocated;
        this.compoundType = compoundType;
        this.fieldToMember = fieldToMember;
    }

    public BitSet getAllocatedBits() {
        return (BitSet)this.allocated.clone();
    }

    public CompoundType getCompoundType() {
        return this.compoundType;
    }

    public Map<FieldElement, CompoundType.Member> getFieldsMap() {
        return Collections.unmodifiableMap(this.fieldToMember);
    }

    public CompoundType.Member getMember(FieldElement element) {
        return this.fieldToMember.get(element);
    }
}

