/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.layout;

import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Value;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.layout.Layout;
import org.qbicc.plugin.layout.LayoutInfo;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ArrayType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InstanceFieldElement;

public class ObjectAccessLoweringBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();

    public ObjectAccessLoweringBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value valueConvert(Value value, WordType toType) {
        PointerType pt;
        ValueType valueType;
        if (toType instanceof PointerType && (valueType = (pt = (PointerType)toType).getPointeeType()) instanceof PhysicalObjectType) {
            PhysicalObjectType pot = (PhysicalObjectType)valueType;
            BasicBlockBuilder fb = this.getFirstBuilder();
            Layout layout = Layout.get(this.ctxt);
            LayoutInfo info = layout.getInstanceLayoutInfo(pot.getDefinition());
            PointerType newType = info.getCompoundType().getPointer();
            if (value.getType() instanceof PointerType) {
                return fb.bitCast(value, (WordType)newType);
            }
            return fb.valueConvert(value, (WordType)newType);
        }
        return this.getDelegate().valueConvert(value, toType);
    }

    public Value stackAllocate(ValueType type, Value count, Value align) {
        if (type instanceof PhysicalObjectType) {
            PhysicalObjectType pot = (PhysicalObjectType)type;
            BasicBlockBuilder fb = this.getFirstBuilder();
            Layout layout = Layout.get(this.ctxt);
            LayoutInfo info = layout.getInstanceLayoutInfo(pot.getDefinition());
            PointerType newType = info.getCompoundType().getPointer();
            return fb.stackAllocate((ValueType)newType, count, align);
        }
        return super.stackAllocate(type, count, align);
    }

    public Value elementOf(Value arrayPointer, Value index) {
        CompoundType.Member lastMember;
        CompoundType ct;
        ValueType valueType = arrayPointer.getPointeeType();
        if (valueType instanceof CompoundType && (ct = (CompoundType)valueType).getMemberCount() > 0 && (lastMember = ct.getMember(ct.getMemberCount() - 1)).getType() instanceof ArrayType) {
            BasicBlockBuilder fb = this.getFirstBuilder();
            return fb.elementOf(fb.memberOf(arrayPointer, lastMember), index);
        }
        return this.getDelegate().elementOf(arrayPointer, index);
    }

    public Value decodeReference(Value reference, PointerType pointerType) {
        ValueType valueType = reference.getType();
        if (valueType instanceof ReferenceType) {
            LayoutInfo info;
            ReferenceType referenceType = (ReferenceType)valueType;
            Layout layout = Layout.get(this.ctxt);
            PhysicalObjectType upperBound = referenceType.getUpperBound();
            if (upperBound instanceof ReferenceArrayObjectType) {
                ReferenceArrayObjectType raot = (ReferenceArrayObjectType)upperBound;
                info = layout.getArrayLayoutInfo(CoreClasses.get((CompilationContext)this.ctxt).getArrayContentField((ObjectType)upperBound).getEnclosingType(), raot.getElementObjectType());
            } else {
                info = upperBound instanceof ArrayObjectType ? layout.getInstanceLayoutInfo(CoreClasses.get((CompilationContext)this.ctxt).getArrayContentField((ObjectType)upperBound).getEnclosingType()) : layout.getInstanceLayoutInfo(upperBound.getDefinition());
            }
            return super.decodeReference(reference, info.getCompoundType().getPointer());
        }
        return super.decodeReference(reference, pointerType);
    }

    public Value instanceFieldOf(Value instance, InstanceFieldElement field) {
        BasicBlockBuilder fb = this.getFirstBuilder();
        Layout layout = Layout.get(this.ctxt);
        LayoutInfo layoutInfo = layout.getInstanceLayoutInfo(field.getEnclosingType());
        return fb.memberOf(instance, layoutInfo.getMember((FieldElement)field));
    }

    public Value byteOffsetPointer(Value base, Value offset, ValueType outputType) {
        BasicBlockBuilder fb = this.getFirstBuilder();
        UnsignedIntegerType u8 = this.ctxt.getTypeSystem().getUnsignedInteger8Type();
        Value valueHandle = fb.offsetPointer(fb.bitCast(base, (WordType)u8.getPointer()), offset);
        return fb.bitCast(valueHandle, (WordType)outputType.getPointer());
    }
}

