/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.linker;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import org.qbicc.context.CompilationContext;
import org.qbicc.driver.Driver;
import org.qbicc.machine.tool.CToolChain;
import org.qbicc.machine.tool.LinkerInvoker;
import org.qbicc.machine.tool.ToolMessageHandler;
import org.qbicc.plugin.linker.Linker;

public class LinkStage
implements Consumer<CompilationContext> {
    private final String outputName;
    private final boolean isPie;
    private final List<Path> librarySearchPaths;

    public LinkStage(String outputName, boolean isPie, List<Path> librarySearchPaths) {
        this.outputName = outputName;
        this.isPie = isPie;
        this.librarySearchPaths = librarySearchPaths;
    }

    @Override
    public void accept(CompilationContext context) {
        CToolChain cToolChain = (CToolChain)context.getAttachment(Driver.C_TOOL_CHAIN_KEY);
        if (cToolChain == null) {
            context.error("No C tool chain is available", new Object[0]);
            return;
        }
        LinkerInvoker linkerInvoker = cToolChain.newLinkerInvoker();
        Linker linker = Linker.get(context);
        linkerInvoker.setWorkingDirectory(context.getOutputDirectory());
        linkerInvoker.addObjectFiles(linker.getObjectFilePathsInLinkOrder());
        linkerInvoker.addLibraries(linker.getLibraries());
        linkerInvoker.addLibraryPaths(this.librarySearchPaths);
        linkerInvoker.setOutputPath(context.getOutputDirectory().resolve(this.outputName));
        linkerInvoker.setMessageHandler(ToolMessageHandler.reporting((CompilationContext)context));
        linkerInvoker.setIsPie(this.isPie);
        try {
            linkerInvoker.invoke();
        }
        catch (IOException e) {
            context.error("Linker invocation failed: %s", new Object[]{e.toString()});
        }
    }
}

