/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.linker;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.type.definition.LoadedTypeDefinition;

public final class Linker {
    private static final AttachmentKey<Linker> KEY = new AttachmentKey();
    private final Map<LoadedTypeDefinition, Path> objectPathsByType = new ConcurrentHashMap<LoadedTypeDefinition, Path>();
    private final Set<String> libraries = ConcurrentHashMap.newKeySet();
    private final CompilationContext ctxt;

    private Linker(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static Linker get(CompilationContext ctxt) {
        return (Linker)ctxt.computeAttachmentIfAbsent(KEY, () -> new Linker(ctxt));
    }

    public void addObjectFilePath(LoadedTypeDefinition typeDefinition, Path objectFilePath) {
        if (objectFilePath != null && this.objectPathsByType.putIfAbsent(typeDefinition, objectFilePath) != null) {
            this.ctxt.error("Multiple object files for type %s", new Object[]{typeDefinition});
        }
    }

    public List<Map.Entry<LoadedTypeDefinition, Path>> getObjectFilePathsWithTypeInLinkOrder() {
        ArrayList<Map.Entry<LoadedTypeDefinition, Path>> list = new ArrayList<Map.Entry<LoadedTypeDefinition, Path>>(this.objectPathsByType.entrySet());
        list.sort(Comparator.comparingInt(entry -> ((LoadedTypeDefinition)entry.getKey()).typeId().getTypeIdValueElse(Integer.MAX_VALUE)));
        return list;
    }

    public List<Path> getObjectFilePathsInLinkOrder() {
        ArrayList<LoadedTypeDefinition> types = new ArrayList<LoadedTypeDefinition>(this.objectPathsByType.keySet());
        types.sort(Comparator.comparingInt(def -> def.typeId().getTypeIdValueElse(Integer.MAX_VALUE)));
        ArrayList<Path> sortedPaths = new ArrayList<Path>(types.size());
        for (LoadedTypeDefinition type : types) {
            sortedPaths.add(this.objectPathsByType.get(type));
        }
        return sortedPaths;
    }

    public void addLibrary(String library) {
        this.libraries.add(library);
    }

    public List<String> getLibraries() {
        return List.copyOf(this.libraries);
    }
}

