/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.GlobalAccessMode;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.machine.arch.Cpu;
import org.qbicc.object.Function;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.ProgramObject;
import org.qbicc.plugin.layout.Layout;
import org.qbicc.plugin.layout.LayoutInfo;
import org.qbicc.plugin.llvm.LLVMConfiguration;
import org.qbicc.plugin.unwind.UnwindExceptionStrategy;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FloatType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NumericType;
import org.qbicc.type.PointerType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.definition.element.MethodElement;

public class LLVMCompatibleBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt;
    private final LLVMConfiguration config;

    public LLVMCompatibleBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate, LLVMConfiguration config) {
        super(delegate);
        this.config = config;
        this.ctxt = this.getContext();
    }

    public Value decodeReference(Value refVal, PointerType pointerType) {
        return super.decodeReference(refVal, pointerType);
    }

    public Value valueConvert(Value value, WordType toType) {
        return super.valueConvert(value, toType);
    }

    public Value min(Value v1, Value v2) {
        return this.minMax(false, v1, v2);
    }

    public Value max(Value v1, Value v2) {
        return this.minMax(true, v1, v2);
    }

    private Value minMax(boolean isMax, Value v1, Value v2) {
        String funcName;
        TypeSystem tps = this.ctxt.getTypeSystem();
        BasicBlockBuilder fb = this.getFirstBuilder();
        String string = funcName = isMax ? "max" : "min";
        if (v1.getType() instanceof FloatType && v2.getType() instanceof FloatType) {
            FloatType t1 = (FloatType)v1.getType();
            FloatType t2 = (FloatType)v2.getType();
            if (this.ctxt.getPlatform().getCpu() == Cpu.AARCH64) {
                FloatType numericType = t1.getSize() == 4L ? tps.getFloat32Type() : tps.getFloat64Type();
                String fullFuncName = "llvm." + funcName + "imum.f" + numericType.getMinBits();
                return this.minMaxIntrinsic(fullFuncName, (NumericType)numericType, v1, v2);
            }
            Value lt1 = this.isLt(v1, v2);
            Value gt1 = this.isGt(v1, v2);
            Value notNan1 = this.isEq(v1, v1);
            Value notNan2 = this.isEq(v2, v2);
            Value bc1 = this.bitCast(v1, (WordType)t1.getSameSizeSignedIntegerType());
            Value bc2 = this.bitCast(v2, (WordType)t2.getSameSizeSignedIntegerType());
            Value last = this.bitCast(this.minMax(isMax, bc1, bc2), (WordType)t1);
            return fb.select(isMax ? gt1 : lt1, v1, fb.select(isMax ? lt1 : gt1, v2, fb.select(notNan1, fb.select(notNan2, last, v2), v1)));
        }
        if (v1.getType() instanceof SignedIntegerType && v2.getType() instanceof SignedIntegerType) {
            SignedIntegerType numericType = v1.getType().getSize() == 4L ? tps.getSignedInteger32Type() : tps.getSignedInteger64Type();
            String fullFuncName = "llvm.s" + funcName + ".i" + numericType.getMinBits();
            return this.minMaxIntrinsic(fullFuncName, (NumericType)numericType, v1, v2);
        }
        if (v1.getType() instanceof UnsignedIntegerType && v2.getType() instanceof UnsignedIntegerType) {
            UnsignedIntegerType numericType = v1.getType().getSize() == 4L ? tps.getUnsignedInteger32Type() : tps.getUnsignedInteger64Type();
            String fullFuncName = "llvm.u" + funcName + ".i" + numericType.getMinBits();
            return this.minMaxIntrinsic(fullFuncName, (NumericType)numericType, v1, v2);
        }
        return fb.select(isMax ? fb.isGt(v1, v2) : fb.isLt(v1, v2), v1, v2);
    }

    private Value minMaxIntrinsic(String funcName, NumericType numericType, Value v1, Value v2) {
        TypeSystem tps = this.ctxt.getTypeSystem();
        FunctionType functionType = tps.getFunctionType((ValueType)numericType, new ValueType[]{numericType, numericType});
        FunctionDeclaration declaration = this.ctxt.getOrAddProgramModule((MemberElement)this.getRootElement()).declareFunction(null, funcName, functionType, 6);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        return this.getFirstBuilder().callNoSideEffects((Value)lf.literalOf((ProgramObject)declaration), List.of(v1, v2));
    }

    public Value byteSwap(Value v) {
        TypeSystem tps = this.ctxt.getTypeSystem();
        IntegerType inputType = (IntegerType)v.getType();
        FunctionType functionType = tps.getFunctionType((ValueType)inputType, new ValueType[]{inputType});
        int minBits = inputType.getMinBits();
        if ((minBits & 0xF) != 0) {
            throw new IllegalArgumentException("Invalid integer type " + inputType + " for byte swap (must be a multiple of 16 bits)");
        }
        String functionName = "llvm.bswap.i" + minBits;
        FunctionDeclaration declaration = this.ctxt.getOrAddProgramModule((MemberElement)this.getRootElement()).declareFunction(null, functionName, functionType, 6);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        return this.getFirstBuilder().callNoSideEffects((Value)lf.literalOf((ProgramObject)declaration), List.of(v));
    }

    public Value bitReverse(Value v) {
        TypeSystem tps = this.ctxt.getTypeSystem();
        IntegerType inputType = (IntegerType)v.getType();
        FunctionType functionType = tps.getFunctionType((ValueType)inputType, new ValueType[]{inputType});
        int minBits = inputType.getMinBits();
        String functionName = "llvm.bitreverse.i" + minBits;
        FunctionDeclaration declaration = this.ctxt.getOrAddProgramModule((MemberElement)this.getRootElement()).declareFunction(null, functionName, functionType, 6);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        return this.getFirstBuilder().callNoSideEffects((Value)lf.literalOf((ProgramObject)declaration), List.of(v));
    }

    public Value countLeadingZeros(Value v) {
        TypeSystem tps = this.ctxt.getTypeSystem();
        IntegerType inputType = (IntegerType)v.getType();
        FunctionType functionType = tps.getFunctionType((ValueType)inputType.asUnsigned(), new ValueType[]{inputType, tps.getBooleanType()});
        int minBits = inputType.getMinBits();
        String functionName = "llvm.ctlz.i" + minBits;
        FunctionDeclaration declaration = this.ctxt.getOrAddProgramModule((MemberElement)this.getRootElement()).declareFunction(null, functionName, functionType, 6);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        Value result = this.getFirstBuilder().callNoSideEffects((Value)lf.literalOf((ProgramObject)declaration), List.of(v, lf.literalOf(false)));
        if (minBits < 32) {
            result = this.getFirstBuilder().extend(result, (WordType)tps.getUnsignedInteger32Type());
            result = this.getFirstBuilder().bitCast(result, (WordType)tps.getSignedInteger32Type());
        } else if (minBits == 32) {
            result = this.getFirstBuilder().bitCast(result, (WordType)tps.getSignedInteger32Type());
        } else {
            assert (minBits > 32);
            result = this.getFirstBuilder().truncate(result, (WordType)tps.getSignedInteger32Type());
        }
        return result;
    }

    public Value countTrailingZeros(Value v) {
        TypeSystem tps = this.ctxt.getTypeSystem();
        IntegerType inputType = (IntegerType)v.getType();
        FunctionType functionType = tps.getFunctionType((ValueType)inputType.asUnsigned(), new ValueType[]{inputType, tps.getBooleanType()});
        int minBits = inputType.getMinBits();
        String functionName = "llvm.cttz.i" + minBits;
        FunctionDeclaration declaration = this.ctxt.getOrAddProgramModule((MemberElement)this.getRootElement()).declareFunction(null, functionName, functionType, 6);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        Value result = this.getFirstBuilder().callNoSideEffects((Value)lf.literalOf((ProgramObject)declaration), List.of(v, lf.literalOf(false)));
        if (minBits < 32) {
            result = this.getFirstBuilder().extend(result, (WordType)tps.getUnsignedInteger32Type());
            result = this.getFirstBuilder().bitCast(result, (WordType)tps.getSignedInteger32Type());
        } else if (minBits == 32) {
            result = this.getFirstBuilder().bitCast(result, (WordType)tps.getSignedInteger32Type());
        } else {
            assert (minBits > 32);
            result = this.getFirstBuilder().truncate(result, (WordType)tps.getSignedInteger32Type());
        }
        return result;
    }

    public Value populationCount(Value v) {
        TypeSystem tps = this.ctxt.getTypeSystem();
        IntegerType inputType = (IntegerType)v.getType();
        FunctionType functionType = tps.getFunctionType((ValueType)inputType.asUnsigned(), new ValueType[]{inputType});
        int minBits = inputType.getMinBits();
        String functionName = "llvm.ctpop.i" + minBits;
        FunctionDeclaration declaration = this.ctxt.getOrAddProgramModule((MemberElement)this.getRootElement()).declareFunction(null, functionName, functionType, 6);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        Value result = this.getFirstBuilder().callNoSideEffects((Value)lf.literalOf((ProgramObject)declaration), List.of(v));
        if (minBits < 32) {
            result = this.getFirstBuilder().extend(result, (WordType)tps.getUnsignedInteger32Type());
            result = this.getFirstBuilder().bitCast(result, (WordType)tps.getSignedInteger32Type());
        } else if (minBits == 32) {
            result = this.getFirstBuilder().bitCast(result, (WordType)tps.getSignedInteger32Type());
        } else {
            assert (minBits > 32);
            result = this.getFirstBuilder().truncate(result, (WordType)tps.getSignedInteger32Type());
        }
        return result;
    }

    public Value negate(Value v) {
        if (v.getType() instanceof IntegerType) {
            IntegerLiteral zero = this.ctxt.getLiteralFactory().literalOf((IntegerType)v.getType(), 0L);
            return super.sub((Value)zero, v);
        }
        return super.negate(v);
    }

    public Value offsetOfField(FieldElement fieldElement) {
        if (fieldElement.isStatic()) {
            return this.ctxt.getLiteralFactory().literalOf(-1);
        }
        LayoutInfo layoutInfo = Layout.get((CompilationContext)this.ctxt).getInstanceLayoutInfo(fieldElement.getEnclosingType());
        return this.ctxt.getLiteralFactory().literalOf(layoutInfo.getMember(fieldElement).getOffset());
    }

    public Value pointerDifference(Value leftPointer, Value rightPointer) {
        BasicBlockBuilder fb = this.getFirstBuilder();
        SignedIntegerType intType = ((PointerType)leftPointer.getType(PointerType.class)).getSameSizedSignedInteger();
        Value leftCast = fb.valueConvert(leftPointer, (WordType)intType);
        Value rightCast = fb.valueConvert(rightPointer, (WordType)intType);
        Value byteDiff = fb.sub(leftCast, rightCast);
        ValueType pointeeType = leftPointer.getPointeeType();
        long size = pointeeType.getSize();
        if (size <= 1L) {
            return byteDiff;
        }
        return fb.divide(byteDiff, (Value)this.getLiteralFactory().literalOf((IntegerType)intType, size));
    }

    public Value load(Value pointer, ReadAccessMode accessMode) {
        ValueType lf;
        if (accessMode.includes((AccessMode)AccessModes.GlobalAcquire)) {
            Value loaded = super.load(pointer, (ReadAccessMode)AccessModes.SingleUnshared);
            this.fence((GlobalAccessMode)accessMode.getGlobalAccess());
            return loaded;
        }
        if (accessMode.includes((AccessMode)AccessModes.GlobalPlain)) {
            return super.load(pointer, (ReadAccessMode)AccessModes.SinglePlain);
        }
        if (accessMode.includes((AccessMode)AccessModes.GlobalUnshared)) {
            return super.load(pointer, (ReadAccessMode)AccessModes.SingleUnshared);
        }
        ValueType valueType = pointer.getPointeeType();
        if (valueType instanceof CompoundType) {
            CompoundType ct = (CompoundType)valueType;
            lf = this.ctxt.getLiteralFactory();
            Literal res = lf.zeroInitializerLiteralOfType((ValueType)ct);
            for (CompoundType.Member member : ct.getPaddedMembers()) {
                res = this.insertMember((Value)res, member, this.load(this.memberOf(pointer, member), accessMode));
            }
            return res;
        }
        lf = pointer.getPointeeType();
        if (lf instanceof ArrayType) {
            ArrayType at = (ArrayType)lf;
            long ec = at.getElementCount();
            LiteralFactory lf2 = this.ctxt.getLiteralFactory();
            if (ec < 16L) {
                Literal res = lf2.zeroInitializerLiteralOfType((ValueType)at);
                for (long i = 0L; i < ec; ++i) {
                    IntegerLiteral idxLit = lf2.literalOf(i);
                    res = this.insertElement((Value)res, (Value)idxLit, this.load(this.elementOf(pointer, (Value)idxLit), accessMode));
                }
                return res;
            }
            BlockLabel top = new BlockLabel();
            BlockLabel exit = new BlockLabel();
            SignedIntegerType idxType = this.ctxt.getTypeSystem().getSignedInteger64Type();
            this.goto_(top, Map.of(Slot.temp((int)0), lf2.literalOf((IntegerType)idxType, 0L), Slot.temp((int)1), lf2.zeroInitializerLiteralOfType((ValueType)at)));
            this.begin(top);
            BlockParameter idx = this.addParam(top, Slot.temp((int)0), (ValueType)idxType);
            BlockParameter val = this.addParam(top, Slot.temp((int)1), (ValueType)at);
            Value modVal = this.insertElement((Value)val, (Value)idx, this.load(this.elementOf(pointer, (Value)idx), accessMode));
            this.if_(this.isLt((Value)idx, (Value)lf2.literalOf((IntegerType)idxType, ec)), top, exit, Map.of(Slot.temp((int)0), this.add((Value)idx, (Value)lf2.literalOf((IntegerType)idxType, 1L)), Slot.temp((int)1), modVal));
            this.begin(exit);
            return this.addParam(exit, Slot.temp((int)1), (ValueType)at);
        }
        return super.load(pointer, accessMode);
    }

    public BasicBlock unreachable() {
        TypeSystem ts = this.ctxt.getTypeSystem();
        FunctionDeclaration decl = this.ctxt.getOrAddProgramModule((MemberElement)this.getRootElement()).declareFunction(null, "llvm.trap", ts.getFunctionType((ValueType)ts.getVoidType(), new ValueType[0]));
        return this.callNoReturn((Value)this.ctxt.getLiteralFactory().literalOf((ProgramObject)decl), List.of());
    }

    public Node store(Value pointer, Value value, WriteAccessMode accessMode) {
        ValueType lit;
        if (pointer.getPointeeType() instanceof BooleanType) {
            this.ctxt.error("Invalid boolean-typed handle %s", new Object[]{pointer});
        }
        if (value.getType() instanceof BooleanType) {
            this.ctxt.error("Invalid boolean-typed value %s", new Object[]{value});
        }
        if (accessMode.includes((AccessMode)AccessModes.GlobalRelease)) {
            Node store = this.store(pointer, value, (WriteAccessMode)AccessModes.SingleUnshared);
            this.fence((GlobalAccessMode)accessMode.getGlobalAccess());
            return store;
        }
        if (accessMode.includes((AccessMode)AccessModes.GlobalPlain)) {
            return this.store(pointer, value, (WriteAccessMode)AccessModes.SinglePlain);
        }
        if (accessMode.includes((AccessMode)AccessModes.GlobalUnshared)) {
            return this.store(pointer, value, (WriteAccessMode)AccessModes.SingleUnshared);
        }
        ValueType valueType = pointer.getPointeeType();
        if (valueType instanceof CompoundType) {
            CompoundType ct = (CompoundType)valueType;
            if (value instanceof Literal && (lit = (Literal)value).isZero()) {
                LiteralFactory lf = this.getLiteralFactory();
                for (CompoundType.Member member : ct.getPaddedMembers()) {
                    this.store(this.memberOf(pointer, member), (Value)lf.zeroInitializerLiteralOfType(member.getType()), accessMode);
                }
                return this.nop();
            }
            for (CompoundType.Member member : ct.getPaddedMembers()) {
                this.store(this.memberOf(pointer, member), this.extractMember(value, member), accessMode);
            }
            return this.nop();
        }
        lit = pointer.getPointeeType();
        if (lit instanceof ArrayType) {
            Literal lit2;
            ArrayType at = (ArrayType)lit;
            long ec = at.getElementCount();
            LiteralFactory lf = this.ctxt.getLiteralFactory();
            if (ec < 16L) {
                Literal lit3;
                if (value instanceof Literal && (lit3 = (Literal)value).isZero()) {
                    for (long i = 0L; i < ec; ++i) {
                        IntegerLiteral idxLit = lf.literalOf((int)i);
                        this.store(this.elementOf(pointer, (Value)idxLit), (Value)lf.zeroInitializerLiteralOfType(at.getElementType()));
                    }
                } else {
                    for (long i = 0L; i < ec; ++i) {
                        IntegerLiteral idxLit = lf.literalOf((int)i);
                        this.store(this.elementOf(pointer, (Value)idxLit), this.extractElement(value, (Value)idxLit));
                    }
                }
                return this.nop();
            }
            BlockLabel top = new BlockLabel();
            BlockLabel exit = new BlockLabel();
            SignedIntegerType idxType = this.ctxt.getTypeSystem().getSignedInteger64Type();
            this.goto_(top, Slot.temp((int)0), (Value)lf.literalOf((IntegerType)idxType, 0L));
            this.begin(top);
            BlockParameter idx = this.addParam(top, Slot.temp((int)0), (ValueType)idxType);
            if (value instanceof Literal && (lit2 = (Literal)value).isZero()) {
                this.store(this.elementOf(pointer, (Value)idx), (Value)lf.zeroInitializerLiteralOfType(at.getElementType()));
            } else {
                this.store(this.elementOf(pointer, (Value)idx), this.extractElement(value, (Value)idx));
            }
            Value incIdx = this.add((Value)idx, (Value)lf.literalOf((IntegerType)idxType, 1L));
            this.if_(this.isLt(incIdx, (Value)lf.literalOf((IntegerType)idxType, ec)), top, exit, Map.of(Slot.temp((int)0), incIdx));
            this.begin(exit);
            return this.nop();
        }
        return super.store(pointer, value, accessMode);
    }

    public Value cmpAndSwap(Value pointer, Value expect, Value update, ReadAccessMode readMode, WriteAccessMode writeMode, CmpAndSwap.Strength strength) {
        Value result;
        BasicBlockBuilder fb = this.getFirstBuilder();
        CompoundType resultType = CmpAndSwap.getResultType((CompilationContext)this.ctxt, (ValueType)pointer.getPointeeType());
        ReadAccessMode lowerReadMode = readMode;
        WriteAccessMode lowerWriteMode = writeMode;
        if (AccessModes.GlobalPlain.includes((AccessMode)readMode) && AccessModes.GlobalPlain.includes((AccessMode)writeMode)) {
            Value compareVal = fb.load(pointer, readMode);
            BlockLabel success = new BlockLabel();
            BlockLabel resume = new BlockLabel();
            Value compareResult = fb.isEq(compareVal, expect);
            LiteralFactory lf = this.ctxt.getLiteralFactory();
            Literal zeroStruct = lf.zeroInitializerLiteralOfType((ValueType)resultType);
            Value withCompareVal = fb.insertMember((Value)zeroStruct, resultType.getMember(0), compareVal);
            result = fb.insertMember(withCompareVal, resultType.getMember(1), compareResult);
            fb.if_(compareResult, success, resume, Map.of());
            fb.begin(success);
            fb.store(pointer, update, writeMode);
            fb.goto_(resume, Map.of());
            fb.begin(resume);
        } else {
            boolean readRequiresFence = readMode.includes((AccessMode)AccessModes.GlobalAcquire);
            if (readMode instanceof GlobalAccessMode) {
                lowerReadMode = AccessModes.SingleOpaque;
            }
            boolean writeRequiresFence = writeMode.includes((AccessMode)AccessModes.GlobalRelease);
            if (writeMode instanceof GlobalAccessMode) {
                lowerWriteMode = AccessModes.SingleOpaque;
            }
            result = super.cmpAndSwap(pointer, expect, update, lowerReadMode, lowerWriteMode, strength);
            if (readRequiresFence) {
                this.fence((GlobalAccessMode)readMode.getGlobalAccess());
            }
            if (writeRequiresFence) {
                Value successFlag = fb.extractMember(result, resultType.getMember(1));
                BlockLabel success = new BlockLabel();
                BlockLabel resume = new BlockLabel();
                fb.if_(successFlag, success, resume, Map.of());
                fb.begin(success);
                fb.fence((GlobalAccessMode)writeMode.getGlobalAccess());
                fb.goto_(resume, Map.of());
                fb.begin(resume);
            }
        }
        return result;
    }

    public Value readModifyWrite(Value pointer, ReadModifyWrite.Op op, Value update, ReadAccessMode readMode, WriteAccessMode writeMode) {
        Value result;
        BasicBlockBuilder fb = this.getFirstBuilder();
        ReadAccessMode lowerReadMode = readMode;
        WriteAccessMode lowerWriteMode = writeMode;
        if (AccessModes.GlobalPlain.includes((AccessMode)readMode) && AccessModes.GlobalPlain.includes((AccessMode)writeMode)) {
            result = fb.load(pointer, readMode);
            Value computed = switch (op) {
                default -> throw new IncompatibleClassChangeError();
                case ReadModifyWrite.Op.SET -> update;
                case ReadModifyWrite.Op.ADD -> fb.add(result, update);
                case ReadModifyWrite.Op.SUB -> fb.sub(result, update);
                case ReadModifyWrite.Op.BITWISE_AND -> fb.and(result, update);
                case ReadModifyWrite.Op.BITWISE_NAND -> fb.complement(fb.and(result, update));
                case ReadModifyWrite.Op.BITWISE_OR -> fb.or(result, update);
                case ReadModifyWrite.Op.BITWISE_XOR -> fb.xor(result, update);
                case ReadModifyWrite.Op.MIN -> fb.min(result, update);
                case ReadModifyWrite.Op.MAX -> fb.max(result, update);
            };
            fb.store(pointer, computed, writeMode);
        } else {
            boolean readRequiresFence = readMode.includes((AccessMode)AccessModes.GlobalAcquire);
            if (readMode instanceof GlobalAccessMode) {
                lowerReadMode = AccessModes.SingleOpaque;
            }
            boolean writeRequiresFence = writeMode.includes((AccessMode)AccessModes.GlobalRelease);
            if (writeMode instanceof GlobalAccessMode) {
                lowerWriteMode = AccessModes.SingleOpaque;
            }
            result = super.readModifyWrite(pointer, op, update, lowerReadMode, lowerWriteMode);
            if (readRequiresFence) {
                this.fence((GlobalAccessMode)readMode.getGlobalAccess());
            }
            if (writeRequiresFence) {
                fb.fence((GlobalAccessMode)writeMode.getGlobalAccess());
            }
        }
        return result;
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        if (this.isTailCallSafe()) {
            return super.tailCall(targetPtr, receiver, arguments);
        }
        return super.return_(super.call(targetPtr, receiver, arguments));
    }

    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        MethodElement personalityMethod = UnwindExceptionStrategy.get((CompilationContext)this.ctxt).getPersonalityMethod();
        Function function = this.ctxt.getExactFunction((ExecutableElement)personalityMethod);
        this.ctxt.getOrAddProgramModule((MemberElement)this.getRootElement()).declareFunction(function);
        return super.invokeNoReturn(targetPtr, receiver, arguments, catchLabel, targetArguments);
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        MethodElement personalityMethod = UnwindExceptionStrategy.get((CompilationContext)this.ctxt).getPersonalityMethod();
        Function function = this.ctxt.getExactFunction((ExecutableElement)personalityMethod);
        this.ctxt.getOrAddProgramModule((MemberElement)this.getRootElement()).declareFunction(function);
        return super.invoke(targetPtr, receiver, arguments, catchLabel, resumeLabel, targetArguments);
    }

    private boolean isTailCallSafe() {
        if (this.getCurrentElement().hasAllModifiersOf(262144)) {
            for (Node callSite = this.getCallSite(); callSite != null; callSite = callSite.getCallSite()) {
                ExecutableElement element = callSite.getElement();
                if (element.hasAllModifiersOf(262144)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

