/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Location;
import org.qbicc.driver.Driver;
import org.qbicc.machine.tool.CCompilerInvoker;
import org.qbicc.machine.tool.CToolChain;
import org.qbicc.machine.tool.ToolMessageHandler;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;
import org.qbicc.object.ProgramModule;
import org.qbicc.plugin.linker.Linker;
import org.qbicc.plugin.llvm.LLVMCompiler;
import org.qbicc.plugin.llvm.LLVMConfiguration;
import org.qbicc.plugin.llvm.LLVMModuleGenerator;
import org.qbicc.tool.llvm.LlcInvoker;
import org.qbicc.tool.llvm.LlvmToolChain;
import org.qbicc.tool.llvm.OutputFormat;
import org.qbicc.tool.llvm.RelocationModel;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;

public class LLVMCompilerImpl
implements LLVMCompiler {
    private final boolean useCcForIr;
    private final boolean emitIr;
    private final boolean emitAssembly;
    private final LlcInvoker llcInvoker;
    private final CCompilerInvoker ccInvoker;
    private final boolean compileOutput;

    public LLVMCompilerImpl(CompilationContext ctxt, LLVMConfiguration config, LLVMModuleGenerator generator) {
        this.useCcForIr = config.isWasm();
        this.emitIr = config.isEmitIr();
        boolean bl = this.emitAssembly = config.isEmitAssembly() && !this.useCcForIr;
        if (this.useCcForIr) {
            this.llcInvoker = null;
        } else {
            this.llcInvoker = LLVMCompilerImpl.createLlcInvoker(ctxt, config);
            if (this.llcInvoker != null) {
                if (this.emitAssembly) {
                    this.llcInvoker.setOutputFormat(OutputFormat.ASM);
                } else {
                    this.llcInvoker.setOutputFormat(OutputFormat.OBJ);
                }
            }
        }
        this.ccInvoker = LLVMCompilerImpl.createCCompilerInvoker(ctxt);
        if (this.ccInvoker != null) {
            if (this.useCcForIr) {
                this.ccInvoker.setSourceLanguage(CCompilerInvoker.SourceLanguage.LLVM_IR);
            } else {
                this.ccInvoker.setSourceLanguage(CCompilerInvoker.SourceLanguage.ASM);
            }
        }
        this.compileOutput = config.isCompileOutput();
    }

    @Override
    public void compileModule(CompilationContext ctxt, LoadedTypeDefinition typeDefinition, LLVMModuleGenerator moduleGenerator) {
        Path directory = ctxt.getOutputDirectory((DefinedTypeDefinition)typeDefinition);
        Path objectFile = ctxt.getOutputFile((DefinedTypeDefinition)typeDefinition, ctxt.getPlatform().getObjectType().objectSuffix());
        Path irFile = ctxt.getOutputFile((DefinedTypeDefinition)typeDefinition, "ll");
        Path asmFile = ctxt.getOutputFile((DefinedTypeDefinition)typeDefinition, "s");
        ProgramModule programModule = ctxt.getOrAddProgramModule((DefinedTypeDefinition)typeDefinition);
        InputSource generatorSource = InputSource.from(writer -> {
            try (BufferedWriter bw = new BufferedWriter((Writer)writer);){
                moduleGenerator.processProgramModule(programModule, bw, irFile);
            }
        }, (Charset)StandardCharsets.UTF_8);
        if (!this.compileOutput) {
            try {
                generatorSource.transferTo(OutputDestination.discarding());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            Files.createDirectories(directory.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            ctxt.error(Location.builder().setType((DefinedTypeDefinition)typeDefinition).build(), "Failed to create directory %s: %s", new Object[]{directory, e.toString()});
            return;
        }
        if (this.emitIr) {
            try {
                generatorSource.transferTo(OutputDestination.of((Path)irFile));
            }
            catch (IOException e) {
                ctxt.error(Location.builder().setSourceFilePath(irFile.toString()).build(), "Error writing LLVM IR file: %s", new Object[]{e.toString()});
                return;
            }
            if (this.useCcForIr) {
                this.ccInvoker.setSource(InputSource.from((Path)irFile));
            } else {
                this.llcInvoker.setSource(InputSource.from((Path)irFile));
            }
        } else if (this.useCcForIr) {
            this.ccInvoker.setSource(generatorSource);
        } else {
            this.llcInvoker.setSource(generatorSource);
        }
        if (this.useCcForIr) {
            this.ccInvoker.setOutputPath(objectFile);
        } else {
            this.llcInvoker.setDestination(OutputDestination.of((Path)(this.emitAssembly ? asmFile : objectFile)));
        }
        int errCnt = ctxt.errors();
        try {
            if (this.useCcForIr) {
                this.ccInvoker.invoke();
            } else {
                this.llcInvoker.invoke();
            }
        }
        catch (IOException e) {
            if (errCnt == ctxt.errors()) {
                ctxt.error(Location.builder().setSourceFilePath(irFile.toString()).build(), "`llc` invocation has failed: %s", new Object[]{e.toString()});
            }
            return;
        }
        if (this.emitAssembly && !this.useCcForIr) {
            this.ccInvoker.setSource(InputSource.from((Path)asmFile));
            this.ccInvoker.setOutputPath(objectFile);
            try {
                this.ccInvoker.invoke();
            }
            catch (IOException e) {
                ctxt.error("Compiler invocation has failed for %s: %s", new Object[]{asmFile, e.toString()});
                return;
            }
        }
        Linker.get((CompilationContext)ctxt).addObjectFilePath(typeDefinition, objectFile);
    }

    private static CCompilerInvoker createCCompilerInvoker(CompilationContext context) {
        CToolChain cToolChain = (CToolChain)context.getAttachment(Driver.C_TOOL_CHAIN_KEY);
        if (cToolChain == null) {
            context.error("No C tool chain is available", new Object[0]);
            return null;
        }
        CCompilerInvoker ccInvoker = cToolChain.newCompilerInvoker();
        ccInvoker.setMessageHandler(ToolMessageHandler.reporting((CompilationContext)context));
        return ccInvoker;
    }

    private static LlcInvoker createLlcInvoker(CompilationContext context, LLVMConfiguration config) {
        LlvmToolChain llvmToolChain = (LlvmToolChain)context.getAttachment(Driver.LLVM_TOOL_KEY);
        if (llvmToolChain == null) {
            context.error("No LLVM tool chain is available", new Object[0]);
            return null;
        }
        LlcInvoker llcInvoker = llvmToolChain.newLlcInvoker();
        llcInvoker.setMessageHandler(ToolMessageHandler.reporting((CompilationContext)context));
        llcInvoker.setRelocationModel(config.isPie() ? RelocationModel.Pic : RelocationModel.Static);
        llcInvoker.setOptions(config.getLlcOptions());
        llcInvoker.setOutputFormat(OutputFormat.ASM);
        llcInvoker.setOpaquePointers(config.isOpaquePointers());
        return llcInvoker;
    }
}

