/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.object.ProgramModule;
import org.qbicc.plugin.llvm.LLVMCompilerImpl;
import org.qbicc.plugin.llvm.LLVMConfiguration;
import org.qbicc.plugin.llvm.LLVMModuleGenerator;

public class LLVMGenerator
implements Consumer<CompilationContext>,
ValueVisitor<CompilationContext, LLValue> {
    private final LLVMConfiguration config;

    public LLVMGenerator(LLVMConfiguration config) {
        this.config = config;
    }

    @Override
    public void accept(CompilationContext compilationContext) {
        LLVMModuleGenerator generator = new LLVMModuleGenerator(compilationContext, this.config);
        List allProgramModules = compilationContext.getAllProgramModules();
        Iterator iterator = allProgramModules.iterator();
        compilationContext.runParallelTask(ctxt -> {
            LLVMCompilerImpl compiler = new LLVMCompilerImpl((CompilationContext)ctxt, this.config, generator);
            while (true) {
                ProgramModule programModule;
                Iterator iterator2 = iterator;
                synchronized (iterator2) {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    programModule = (ProgramModule)iterator.next();
                }
                compiler.compileModule((CompilationContext)ctxt, programModule.getTypeDefinition().load(), generator);
            }
        });
    }

    public int getLlvmMajor() {
        return this.config.getMajorVersion();
    }
}

