/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.InvocationNode;
import org.qbicc.type.definition.LoadedTypeDefinition;

public final class LLVMInfo {
    private static final AttachmentKey<LLVMInfo> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Map<LoadedTypeDefinition, List<InvocationNode>> statePointIds = new ConcurrentHashMap<LoadedTypeDefinition, List<InvocationNode>>();

    private LLVMInfo(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static LLVMInfo get(CompilationContext ctxt) {
        LLVMInfo appearing;
        LLVMInfo info = (LLVMInfo)ctxt.getAttachment(KEY);
        if (info == null && (appearing = (LLVMInfo)ctxt.putAttachmentIfAbsent(KEY, (Object)(info = new LLVMInfo(ctxt)))) != null) {
            info = appearing;
        }
        return info;
    }

    public List<InvocationNode> getStatePointIds(LoadedTypeDefinition def) {
        return this.statePointIds.get(def);
    }

    public void setStatePointIds(LoadedTypeDefinition def, List<InvocationNode> ids) {
        if (this.statePointIds.putIfAbsent(def, ids) != null) {
            throw new IllegalStateException("State point IDs set twice");
        }
    }
}

