/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.ClassOf;
import org.qbicc.graph.Load;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.AsmLiteral;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.graph.literal.StaticMethodLiteral;
import org.qbicc.graph.literal.StringLiteral;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmString;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.ProgramObject;
import org.qbicc.plugin.intrinsics.Intrinsics;
import org.qbicc.plugin.intrinsics.StaticIntrinsic;
import org.qbicc.type.ArrayType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class LLVMIntrinsics {
    static final int ASM_FLAG_SIDE_EFFECT = 1;
    static final int ASM_FLAG_ALIGN_STACK = 2;
    static final int ASM_FLAG_INTEL_DIALECT = 4;
    static final int ASM_FLAG_UNWIND = 8;
    static final int ASM_FLAG_IMPLICIT_SIDE_EFFECT = 16;
    static final int ASM_FLAG_NO_RETURN = 32;

    public static void register(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get((CompilationContext)ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor buildTargetDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/Build$Target");
        MethodDescriptor emptyToBool = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of());
        StaticIntrinsic isLlvm = (builder, targetPtr, arguments) -> ctxt.getLiteralFactory().literalOf(true);
        intrinsics.registerIntrinsic((TypeDescriptor)buildTargetDesc, "isLlvm", emptyToBool, isLlvm);
        ClassTypeDescriptor llvmRuntimeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/llvm/LLVM");
        ClassTypeDescriptor thingDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative$object");
        ClassTypeDescriptor vaListDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stdarg$va_list");
        ClassTypeDescriptor vaListPtrDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stdarg$va_list_ptr");
        ClassTypeDescriptor classDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class");
        ClassTypeDescriptor stringDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/String");
        ArrayTypeDescriptor arrayOfThingDesc = ArrayTypeDescriptor.of((ClassContext)classContext, (TypeDescriptor)thingDesc);
        MethodDescriptor asmDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)thingDesc, List.of(classDesc, stringDesc, stringDesc, BaseTypeDescriptor.I, arrayOfThingDesc));
        MethodDescriptor vaListClassToThing = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)thingDesc, List.of(vaListDesc, classDesc));
        MethodDescriptor vaListToVoid = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(vaListDesc));
        MethodDescriptor vaListVaListToVoid = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(vaListDesc, vaListDesc));
        MethodDescriptor vaListPtrToVoid = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(vaListPtrDesc));
        MethodDescriptor vaListPtrVaListPtrToVoid = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(vaListPtrDesc, vaListPtrDesc));
        intrinsics.registerIntrinsic((TypeDescriptor)llvmRuntimeDesc, "asm", asmDesc, LLVMIntrinsics::asm);
        Literal voidLiteral = ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)ctxt.getTypeSystem().getVoidType());
        ClassTypeDescriptor stdArgDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/stdc/Stdarg");
        StaticIntrinsic saVaStart = (builder, targetPtr, arguments) -> {
            BasicBlockBuilder fb = builder.getFirstBuilder();
            Value vaList = (Value)arguments.get(0);
            if (!(vaList instanceof Load)) {
                ctxt.error(builder.getLocation(), "Invalid ap argument to va_start: must have an address", new Object[0]);
                return voidLiteral;
            }
            Load load = (Load)vaList;
            Value vaListPtr = load.getPointer();
            return fb.call(fb.resolveStaticMethod((TypeDescriptor)llvmRuntimeDesc, "va_start", vaListPtrToVoid), List.of(vaListPtr));
        };
        intrinsics.registerIntrinsic((TypeDescriptor)stdArgDesc, "va_start", vaListToVoid, saVaStart);
        StaticIntrinsic saVaEnd = (builder, targetPtr, arguments) -> {
            BasicBlockBuilder fb = builder.getFirstBuilder();
            Value vaList = (Value)arguments.get(0);
            if (!(vaList instanceof Load)) {
                ctxt.error(builder.getLocation(), "Invalid ap argument to va_end: must have an address", new Object[0]);
                return voidLiteral;
            }
            Load load = (Load)vaList;
            Value vaListPtr = load.getPointer();
            return fb.call(fb.resolveStaticMethod((TypeDescriptor)llvmRuntimeDesc, "va_end", vaListPtrToVoid), List.of(vaListPtr));
        };
        intrinsics.registerIntrinsic((TypeDescriptor)stdArgDesc, "va_end", vaListToVoid, saVaEnd);
        StaticIntrinsic saVaCopy = (builder, targetPtr, arguments) -> {
            BasicBlockBuilder fb = builder.getFirstBuilder();
            Value destList = (Value)arguments.get(0);
            if (!(destList instanceof Load)) {
                ctxt.error(builder.getLocation(), "Invalid dest argument to va_copy: must have an address", new Object[0]);
                return voidLiteral;
            }
            Load load = (Load)destList;
            Value destPtr = load.getPointer();
            Value srcList = (Value)arguments.get(1);
            if (!(srcList instanceof Load)) {
                ctxt.error(builder.getLocation(), "Invalid src argument to va_copy: must have an address", new Object[0]);
                return voidLiteral;
            }
            Load load2 = (Load)srcList;
            Value srcPtr = load2.getPointer();
            return fb.call(fb.resolveStaticMethod((TypeDescriptor)llvmRuntimeDesc, "va_copy", vaListPtrVaListPtrToVoid), List.of(destPtr, srcPtr));
        };
        intrinsics.registerIntrinsic((TypeDescriptor)stdArgDesc, "va_copy", vaListVaListToVoid, saVaCopy);
        StaticIntrinsic saVaArg = (builder, targetPtr, arguments) -> {
            ClassOf co;
            Value patt7629$temp;
            Value vaList = (Value)arguments.get(0);
            if (!(vaList instanceof Load)) {
                ctxt.error(builder.getLocation(), "Invalid ap argument to va_arg: must have an address", new Object[0]);
                throw new BlockEarlyTermination(builder.unreachable());
            }
            Load load = (Load)vaList;
            Value vaListPtr = load.getPointer();
            Value outputType = (Value)arguments.get(1);
            if (outputType instanceof ClassOf && (patt7629$temp = (co = (ClassOf)outputType).getInput()) instanceof TypeLiteral) {
                TypeLiteral tl = (TypeLiteral)patt7629$temp;
                return builder.vaArg(vaListPtr, tl.getValue());
            }
            ctxt.error(builder.getLocation(), "Invalid type argument to va_arg (must be a class literal)", new Object[0]);
            throw new BlockEarlyTermination(builder.unreachable());
        };
        intrinsics.registerIntrinsic((TypeDescriptor)stdArgDesc, "va_arg", vaListClassToThing, saVaArg);
        ClassTypeDescriptor cNativeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/CNative");
        MethodDescriptor floatToInt = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(BaseTypeDescriptor.F));
        MethodDescriptor floatToLong = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of(BaseTypeDescriptor.F));
        MethodDescriptor doubleToInt = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.I, List.of(BaseTypeDescriptor.D));
        MethodDescriptor doubleToLong = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.J, List.of(BaseTypeDescriptor.D));
        StaticIntrinsic floatToInt1 = (builder, targetPtr, arguments) -> {
            TypeSystem ts = ctxt.getTypeSystem();
            LiteralFactory lf = ctxt.getLiteralFactory();
            FunctionType fnType = ts.getFunctionType((ValueType)ts.getSignedInteger32Type(), List.of(ts.getFloat32Type()));
            FunctionDeclaration decl = ctxt.getOrAddProgramModule((MemberElement)builder.getRootElement()).declareFunction(null, "llvm.fptosi.sat.i32.f32", fnType);
            return builder.getFirstBuilder().callNoSideEffects((Value)lf.literalOf((ProgramObject)decl), arguments);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "floatToInt1", floatToInt, floatToInt1);
        StaticIntrinsic floatToLong1 = (builder, targetPtr, arguments) -> {
            TypeSystem ts = ctxt.getTypeSystem();
            LiteralFactory lf = ctxt.getLiteralFactory();
            FunctionType fnType = ts.getFunctionType((ValueType)ts.getSignedInteger64Type(), List.of(ts.getFloat32Type()));
            FunctionDeclaration decl = ctxt.getOrAddProgramModule((MemberElement)builder.getRootElement()).declareFunction(null, "llvm.fptosi.sat.i64.f32", fnType);
            return builder.getFirstBuilder().callNoSideEffects((Value)lf.literalOf((ProgramObject)decl), arguments);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "floatToLong1", floatToLong, floatToLong1);
        StaticIntrinsic doubleToInt1 = (builder, targetPtr, arguments) -> {
            TypeSystem ts = ctxt.getTypeSystem();
            LiteralFactory lf = ctxt.getLiteralFactory();
            FunctionType fnType = ts.getFunctionType((ValueType)ts.getSignedInteger32Type(), List.of(ts.getFloat64Type()));
            FunctionDeclaration decl = ctxt.getOrAddProgramModule((MemberElement)builder.getRootElement()).declareFunction(null, "llvm.fptosi.sat.i32.f64", fnType);
            return builder.getFirstBuilder().callNoSideEffects((Value)lf.literalOf((ProgramObject)decl), arguments);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "doubleToInt1", doubleToInt, doubleToInt1);
        StaticIntrinsic doubleToLong1 = (builder, targetPtr, arguments) -> {
            TypeSystem ts = ctxt.getTypeSystem();
            LiteralFactory lf = ctxt.getLiteralFactory();
            FunctionType fnType = ts.getFunctionType((ValueType)ts.getSignedInteger64Type(), List.of(ts.getFloat64Type()));
            FunctionDeclaration decl = ctxt.getOrAddProgramModule((MemberElement)builder.getRootElement()).declareFunction(null, "llvm.fptosi.sat.i64.f64", fnType);
            return builder.getFirstBuilder().callNoSideEffects((Value)lf.literalOf((ProgramObject)decl), arguments);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)cNativeDesc, "doubleToLong1", doubleToLong, doubleToLong1);
    }

    private static Value asm(BasicBlockBuilder bb, StaticMethodLiteral handle, List<Value> parameters) {
        FunctionType type;
        List<Object> args;
        ObjectLiteral ol;
        VmObject vmObject;
        String operands;
        ObjectLiteral ol2;
        VmObject vmObject2;
        String instruction;
        ClassOf co;
        Value value;
        ExecutableElement element = bb.getCurrentElement();
        DefinedTypeDefinition enclosingType = element.getEnclosingType();
        ClassContext classContext = enclosingType.getContext();
        CompilationContext ctxt = classContext.getCompilationContext();
        LiteralFactory lf = ctxt.getLiteralFactory();
        TypeSystem ts = ctxt.getTypeSystem();
        Value returnTypeClazzValue = parameters.get(0);
        Value instructionValue = parameters.get(1);
        Value operandsValue = parameters.get(2);
        Value flagsValue = parameters.get(3);
        Value argsValue = parameters.get(4);
        if (!(returnTypeClazzValue instanceof ClassOf) || !((value = (co = (ClassOf)returnTypeClazzValue).getInput()) instanceof TypeLiteral)) {
            ctxt.error(bb.getLocation(), "Type argument to `asm` must be a class literal or constant value", new Object[0]);
            return lf.zeroInitializerLiteralOfType((ValueType)ts.getVoidType());
        }
        TypeLiteral tl = (TypeLiteral)value;
        ValueType returnType = tl.getValue();
        if (instructionValue instanceof StringLiteral) {
            StringLiteral sl = (StringLiteral)instructionValue;
            instruction = sl.getValue();
        } else if (instructionValue instanceof ObjectLiteral && (vmObject2 = (ol2 = (ObjectLiteral)instructionValue).getValue()) instanceof VmString) {
            VmString vs = (VmString)vmObject2;
            instruction = vs.getContent();
        } else {
            ctxt.error(bb.getLocation(), "Instruction argument to `asm` must be a string literal or constant value", new Object[0]);
            return lf.zeroInitializerLiteralOfType((ValueType)ts.getVoidType());
        }
        if (operandsValue instanceof StringLiteral) {
            StringLiteral sl = (StringLiteral)operandsValue;
            operands = sl.getValue();
        } else if (operandsValue instanceof ObjectLiteral && (vmObject = (ol = (ObjectLiteral)operandsValue).getValue()) instanceof VmString) {
            VmString vs = (VmString)vmObject;
            operands = vs.getContent();
        } else {
            ctxt.error(bb.getLocation(), "Operands argument to `asm` must be a string literal or constant value", new Object[0]);
            return lf.zeroInitializerLiteralOfType((ValueType)ts.getVoidType());
        }
        if (!(flagsValue instanceof IntegerLiteral)) {
            ctxt.error(bb.getLocation(), "Flags argument to `asm` must be an integer literal or constant value", new Object[0]);
            return lf.zeroInitializerLiteralOfType((ValueType)ts.getVoidType());
        }
        IntegerLiteral il = (IntegerLiteral)flagsValue;
        int flags = il.intValue();
        ValueType valueType = argsValue.getType();
        if (valueType instanceof ArrayType) {
            ArrayType at = (ArrayType)valueType;
            long length = at.getElementCount();
            if (length > 255L) {
                ctxt.error(bb.getLocation(), "Too many arguments to `asm`", new Object[0]);
                return lf.zeroInitializerLiteralOfType((ValueType)ts.getVoidType());
            }
            if (length == 0L) {
                args = List.of();
                type = ts.getFunctionType(returnType, List.of());
            } else if (length == 1L) {
                args = List.of(bb.extractElement(argsValue, (Value)lf.literalOf(0)));
                type = ts.getFunctionType(returnType, List.of(((Value)args.get(0)).getType()));
            } else {
                int cnt = (int)length;
                args = new ArrayList(cnt);
                ArrayList<ValueType> argTypes = new ArrayList<ValueType>(cnt);
                for (int i = 0; i < cnt; ++i) {
                    Value itemValue = bb.extractElement(argsValue, (Value)lf.literalOf(i));
                    args.add(itemValue);
                    argTypes.add(itemValue.getType());
                }
                type = ts.getFunctionType(returnType, argTypes);
            }
        } else {
            ctxt.error(bb.getLocation(), "Arguments to `asm` must be an immediate new array creation", new Object[0]);
            return lf.zeroInitializerLiteralOfType((ValueType)ts.getVoidType());
        }
        EnumSet<AsmLiteral.Flag> flagSet = EnumSet.of(AsmLiteral.Flag.NO_THROW);
        boolean generalSideEffects = false;
        if ((flags & 1) != 0) {
            flagSet.add(AsmLiteral.Flag.SIDE_EFFECT);
            generalSideEffects = true;
        }
        if ((flags & 0x10) != 0) {
            flagSet.add(AsmLiteral.Flag.IMPLICIT_SIDE_EFFECT);
            generalSideEffects = true;
        }
        if ((flags & 2) != 0) {
            flagSet.add(AsmLiteral.Flag.ALIGN_STACK);
        }
        if ((flags & 4) != 0) {
            flagSet.add(AsmLiteral.Flag.INTEL_DIALECT);
        }
        if ((flags & 8) != 0) {
            flagSet.remove(AsmLiteral.Flag.NO_THROW);
            generalSideEffects = true;
        }
        boolean noReturn = (flags & 0x20) != 0;
        AsmLiteral asm = lf.literalOfAsm(instruction, operands, type, (AsmLiteral.Flag[])flagSet.toArray(AsmLiteral.Flag[]::new));
        if (noReturn) {
            throw new BlockEarlyTermination(bb.callNoReturn((Value)asm, args));
        }
        if (generalSideEffects) {
            return bb.call((Value)asm, args);
        }
        return bb.callNoSideEffects((Value)asm, args);
    }
}

