/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import io.smallrye.common.constraint.Assert;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Location;
import org.qbicc.facts.Fact;
import org.qbicc.facts.Facts;
import org.qbicc.facts.core.ExecutableReachabilityFacts;
import org.qbicc.graph.InvocationNode;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.llvm.FunctionAttributes;
import org.qbicc.machine.llvm.FunctionDefinition;
import org.qbicc.machine.llvm.Global;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.Linkage;
import org.qbicc.machine.llvm.Module;
import org.qbicc.machine.llvm.ModuleFlagBehavior;
import org.qbicc.machine.llvm.RuntimePreemption;
import org.qbicc.machine.llvm.ThreadLocalStorageModel;
import org.qbicc.machine.llvm.Types;
import org.qbicc.machine.llvm.Values;
import org.qbicc.object.Data;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.Declaration;
import org.qbicc.object.Function;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.GlobalXtor;
import org.qbicc.object.ModuleSection;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.ProgramObject;
import org.qbicc.object.SectionObject;
import org.qbicc.object.Segment;
import org.qbicc.object.ThreadLocalMode;
import org.qbicc.plugin.llvm.LLVMConfiguration;
import org.qbicc.plugin.llvm.LLVMInfo;
import org.qbicc.plugin.llvm.LLVMModuleDebugInfo;
import org.qbicc.plugin.llvm.LLVMModuleNodeVisitor;
import org.qbicc.plugin.llvm.LLVMNodeVisitor;
import org.qbicc.type.ArrayType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.NullableType;
import org.qbicc.type.PointerType;
import org.qbicc.type.Type;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.VariadicType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.definition.element.MethodElement;

final class LLVMModuleGenerator {
    private final CompilationContext context;
    private final LLVMConfiguration config;
    private final int picLevel;
    private final int pieLevel;

    LLVMModuleGenerator(CompilationContext context, LLVMConfiguration config) {
        this.context = context;
        this.config = config;
        if (config.isPie()) {
            this.picLevel = 2;
            this.pieLevel = 2;
        } else {
            this.picLevel = 0;
            this.pieLevel = 0;
        }
    }

    public void processProgramModule(ProgramModule programModule, BufferedWriter writer, Path irFile) {
        Module module = Module.newModule();
        TypeSystem ts = this.context.getTypeSystem();
        module.dataLayout().byteOrder(ts.getEndianness()).pointerSize(ts.getPointerSize() * 8).pointerAlign(ts.getPointerAlignment() * 8).refSize(ts.getReferenceSize() * 8).refAlign(ts.getReferenceAlignment() * 8).int8Align(ts.getUnsignedInteger8Type().getAlign() * 8).int16Align(ts.getUnsignedInteger16Type().getAlign() * 8).int32Align(ts.getUnsignedInteger32Type().getAlign() * 8).int64Align(ts.getUnsignedInteger64Type().getAlign() * 8).float32Align(ts.getFloat32Type().getAlign() * 8).float64Align(ts.getFloat64Type().getAlign() * 8);
        module.sourceFileName(irFile.toString());
        LLVMModuleNodeVisitor moduleVisitor = new LLVMModuleNodeVisitor(this, module, this.context, this.config);
        LLVMModuleDebugInfo debugInfo = new LLVMModuleDebugInfo(programModule, module, this.context);
        if (this.picLevel != 0) {
            module.addFlag(ModuleFlagBehavior.Max, "PIC Level", Types.i32, Values.intConstant((int)this.picLevel));
        }
        if (this.pieLevel != 0) {
            module.addFlag(ModuleFlagBehavior.Max, "PIE Level", Types.i32, Values.intConstant((int)this.pieLevel));
        }
        Platform platform = this.context.getPlatform();
        org.qbicc.machine.llvm.Function decl = module.declare("llvm.dbg.value");
        decl.returns(Types.void_);
        decl.param(Types.metadata).param(Types.metadata).param(Types.metadata);
        this.processXtors(programModule.constructors(), "llvm.global_ctors", module, moduleVisitor);
        this.processXtors(programModule.destructors(), "llvm.global_dtors", module, moduleVisitor);
        for (Declaration item : programModule.declarations()) {
            String name = item.getName();
            Linkage linkage = this.map(item.getLinkage());
            if (item instanceof FunctionDeclaration) {
                FunctionDeclaration fn = (FunctionDeclaration)item;
                decl = module.declare(name).linkage(linkage);
                FunctionType fnType = fn.getValueType();
                decl.returns(moduleVisitor.map((Type)fnType.getReturnType()));
                int cnt = fnType.getParameterCount();
                for (int i = 0; i < cnt; ++i) {
                    ValueType type = fnType.getParameterType(i);
                    if (type instanceof VariadicType) {
                        if (i < cnt - 1) {
                            throw new IllegalStateException("Variadic type as non-final parameter type");
                        }
                        decl.variadic();
                        continue;
                    }
                    decl.param(moduleVisitor.map((Type)type));
                }
                continue;
            }
            if (!(item instanceof DataDeclaration)) continue;
            Global obj = module.global(moduleVisitor.map((Type)item.getValueType())).linkage(Linkage.EXTERNAL);
            ThreadLocalMode tlm = item.getThreadLocalMode();
            if (tlm != null) {
                obj.threadLocal(this.map(tlm));
            }
            obj.asGlobal(item.getName());
        }
        for (ModuleSection section : programModule.sections()) {
            String sectionName = section.getName();
            Segment segment = section.getSection().getSegment();
            for (SectionObject item : section.contents()) {
                String name = item.getName();
                Linkage linkage = this.map(item.getLinkage());
                if (item instanceof Function) {
                    LLValue topSubprogram;
                    boolean isExact;
                    Function fn = (Function)item;
                    ExecutableElement element = fn.getOriginalElement();
                    if (!Facts.get((CompilationContext)this.context).hadFact((Object)element, (Fact)ExecutableReachabilityFacts.IS_INVOKED)) continue;
                    MethodBody body = fn.getBody();
                    boolean bl = isExact = item == this.context.getExactFunction(element);
                    if (body == null) {
                        this.context.error("Function `%s` has no body", new Object[]{name});
                        continue;
                    }
                    FunctionDefinition functionDefinition = module.define(name).linkage(linkage);
                    if (element instanceof MethodElement) {
                        MethodElement me = (MethodElement)element;
                        functionDefinition.comment(me.getEnclosingType().getInternalName() + "." + me.getName() + " " + me.getDescriptor());
                    } else if (element instanceof ConstructorElement) {
                        ConstructorElement ce = (ConstructorElement)element;
                        functionDefinition.comment(ce.getEnclosingType().getInternalName() + ".<init> " + ce.getDescriptor());
                    }
                    if (isExact) {
                        topSubprogram = debugInfo.getDebugInfoForFunction(element).getSubprogram();
                        functionDefinition.meta("dbg", topSubprogram);
                    } else {
                        topSubprogram = debugInfo.createThunkSubprogram(fn).asRef();
                        functionDefinition.meta("dbg", topSubprogram);
                    }
                    functionDefinition.attribute(FunctionAttributes.framePointer((String)"non-leaf"));
                    functionDefinition.attribute(FunctionAttributes.uwtable);
                    if (this.config.isStatepointEnabled()) {
                        functionDefinition.gc("statepoint-example");
                    }
                    if (fn.isNoReturn()) {
                        functionDefinition.attribute(FunctionAttributes.noreturn);
                    }
                    LLVMNodeVisitor nodeVisitor = new LLVMNodeVisitor(this.context, module, debugInfo, topSubprogram, moduleVisitor, fn, functionDefinition);
                    if (!sectionName.equals("__implicit__")) {
                        functionDefinition.section(platform.formatSectionName(segment.toString(), new String[]{segment.toString(), sectionName}));
                    }
                    nodeVisitor.execute();
                    continue;
                }
                if (item instanceof Data) {
                    MemberElement element;
                    Data data = (Data)item;
                    Literal value = (Literal)data.getValue();
                    Global obj = data.isConstant() ? module.constant(moduleVisitor.map((Type)data.getValueType())) : module.global(moduleVisitor.map((Type)data.getValueType()));
                    if (value != null) {
                        obj.value(moduleVisitor.map(value));
                    } else {
                        obj.value(Values.zeroinitializer);
                    }
                    obj.alignment(data.getValueType().getAlign());
                    obj.linkage(linkage);
                    ThreadLocalMode tlm = data.getThreadLocalMode();
                    if (tlm != null) {
                        obj.threadLocal(this.map(tlm));
                    }
                    if (data.isDsoLocal()) {
                        obj.preemption(RuntimePreemption.LOCAL);
                    }
                    if (!sectionName.equals("__implicit__")) {
                        obj.section(platform.formatSectionName(segment.toString(), new String[]{segment.toString(), sectionName}));
                    }
                    if ((element = data.getOriginalElement()) != null) {
                        obj.meta("dbg", debugInfo.getDebugInfoForGlobal(data, element));
                    }
                    obj.asGlobal(data.getName());
                    continue;
                }
                throw new IllegalStateException();
            }
        }
        List<InvocationNode> statePointIds = moduleVisitor.getStatePointIds();
        LLVMInfo.get(this.context).setStatePointIds(programModule.getTypeDefinition().load(), statePointIds);
        try {
            module.writeTo(writer);
        }
        catch (IOException e) {
            this.context.error(Location.builder().setClassInternalName(programModule.getTypeDefinition().getInternalName()).build(), "Failed to emit LLVM output: %s", new Object[]{e.toString()});
        }
    }

    private void processXtors(List<GlobalXtor> xtors, String xtorName, Module module, LLVMModuleNodeVisitor moduleVisitor) {
        if (!xtors.isEmpty()) {
            TypeSystem ts = this.context.getTypeSystem();
            LiteralFactory lf = this.context.getLiteralFactory();
            int xtorSize = 0;
            UnsignedIntegerType u32 = ts.getUnsignedInteger32Type();
            CompoundType.Member priorityMember = ts.getUnalignedCompoundTypeMember("priority", (ValueType)u32, 0);
            xtorSize = (int)((long)xtorSize + u32.getSize());
            PointerType voidFnPtrType = ts.getFunctionType((ValueType)ts.getVoidType(), List.of()).getPointer();
            CompoundType.Member fnMember = ts.getUnalignedCompoundTypeMember("fn", (ValueType)voidFnPtrType, xtorSize);
            xtorSize = (int)((long)xtorSize + voidFnPtrType.getSize());
            PointerType u8ptr = ts.getUnsignedInteger8Type().getPointer();
            CompoundType.Member dataMember = ts.getUnalignedCompoundTypeMember("data", (ValueType)u8ptr, xtorSize);
            xtorSize = (int)((long)xtorSize + u8ptr.getSize());
            CompoundType xtorType = ts.getCompoundType(CompoundType.Tag.NONE, "xtor_t", (long)xtorSize, 1, () -> List.of(priorityMember, fnMember, dataMember));
            ArrayType arrayType = ts.getArrayType((ValueType)xtorType, (long)xtors.size());
            Global global_ctors = module.global(moduleVisitor.map((Type)arrayType));
            global_ctors.appending();
            global_ctors.value(moduleVisitor.map(lf.literalOf(arrayType, xtors.stream().map((? super T g) -> lf.literalOf(xtorType, Map.of(priorityMember, lf.literalOf(g.getPriority()), fnMember, lf.bitcastLiteral((Literal)lf.literalOf((ProgramObject)g.getFunction()), (WordType)voidFnPtrType), dataMember, lf.nullLiteralOfType((NullableType)u8ptr)))).toList())));
            global_ctors.asGlobal(xtorName);
        }
    }

    public int getLlvmMajor() {
        return this.config.getMajorVersion();
    }

    Linkage map(org.qbicc.object.Linkage linkage) {
        switch (linkage) {
            case COMMON: {
                return Linkage.COMMON;
            }
            case INTERNAL: {
                return Linkage.INTERNAL;
            }
            case PRIVATE: {
                return Linkage.PRIVATE;
            }
            case WEAK: {
                return Linkage.EXTERN_WEAK;
            }
            case EXTERNAL: {
                return Linkage.EXTERNAL;
            }
        }
        throw Assert.impossibleSwitchCase((Object)linkage);
    }

    ThreadLocalStorageModel map(ThreadLocalMode mode) {
        switch (mode) {
            case GENERAL_DYNAMIC: {
                return ThreadLocalStorageModel.GENERAL_DYNAMIC;
            }
            case LOCAL_DYNAMIC: {
                return ThreadLocalStorageModel.LOCAL_DYNAMIC;
            }
            case INITIAL_EXEC: {
                return ThreadLocalStorageModel.INITIAL_EXEC;
            }
            case LOCAL_EXEC: {
                return ThreadLocalStorageModel.LOCAL_EXEC;
            }
        }
        throw Assert.impossibleSwitchCase((Object)mode);
    }
}

