/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Location;
import org.qbicc.graph.Action;
import org.qbicc.graph.ActionVisitor;
import org.qbicc.graph.Add;
import org.qbicc.graph.And;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BitCast;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.Call;
import org.qbicc.graph.CallNoReturn;
import org.qbicc.graph.CallNoSideEffects;
import org.qbicc.graph.CheckCast;
import org.qbicc.graph.Cmp;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.CmpG;
import org.qbicc.graph.CmpL;
import org.qbicc.graph.Comp;
import org.qbicc.graph.Convert;
import org.qbicc.graph.DebugAddressDeclaration;
import org.qbicc.graph.DebugValueDeclaration;
import org.qbicc.graph.DecodeReference;
import org.qbicc.graph.Div;
import org.qbicc.graph.ElementOf;
import org.qbicc.graph.Extend;
import org.qbicc.graph.ExtractElement;
import org.qbicc.graph.ExtractMember;
import org.qbicc.graph.Fence;
import org.qbicc.graph.Goto;
import org.qbicc.graph.If;
import org.qbicc.graph.InsertElement;
import org.qbicc.graph.InsertMember;
import org.qbicc.graph.InvocationNode;
import org.qbicc.graph.Invoke;
import org.qbicc.graph.InvokeNoReturn;
import org.qbicc.graph.IsEq;
import org.qbicc.graph.IsGe;
import org.qbicc.graph.IsGt;
import org.qbicc.graph.IsLe;
import org.qbicc.graph.IsLt;
import org.qbicc.graph.IsNe;
import org.qbicc.graph.Load;
import org.qbicc.graph.MemberOf;
import org.qbicc.graph.MemberOfUnion;
import org.qbicc.graph.Mod;
import org.qbicc.graph.Multiply;
import org.qbicc.graph.Neg;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.NotNull;
import org.qbicc.graph.OffsetPointer;
import org.qbicc.graph.Or;
import org.qbicc.graph.Reachable;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Ret;
import org.qbicc.graph.Return;
import org.qbicc.graph.Shl;
import org.qbicc.graph.Shr;
import org.qbicc.graph.Slot;
import org.qbicc.graph.StackAllocation;
import org.qbicc.graph.Sub;
import org.qbicc.graph.Switch;
import org.qbicc.graph.TailCall;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Truncate;
import org.qbicc.graph.Unreachable;
import org.qbicc.graph.Unschedulable;
import org.qbicc.graph.VaArg;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.WordCastValue;
import org.qbicc.graph.Xor;
import org.qbicc.graph.atomic.AccessMode;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.GlobalAccessMode;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.AsmLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.graph.literal.ProgramObjectLiteral;
import org.qbicc.machine.llvm.AsmFlag;
import org.qbicc.machine.llvm.FastMathFlag;
import org.qbicc.machine.llvm.FloatCondition;
import org.qbicc.machine.llvm.Function;
import org.qbicc.machine.llvm.FunctionAttributes;
import org.qbicc.machine.llvm.FunctionDefinition;
import org.qbicc.machine.llvm.IntCondition;
import org.qbicc.machine.llvm.LLBasicBlock;
import org.qbicc.machine.llvm.LLBuilder;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.Module;
import org.qbicc.machine.llvm.ParameterAttributes;
import org.qbicc.machine.llvm.Types;
import org.qbicc.machine.llvm.Values;
import org.qbicc.machine.llvm.debuginfo.DILocalVariable;
import org.qbicc.machine.llvm.debuginfo.DIOpcode;
import org.qbicc.machine.llvm.debuginfo.MetadataNode;
import org.qbicc.machine.llvm.impl.LLVM;
import org.qbicc.machine.llvm.op.AtomicRmw;
import org.qbicc.machine.llvm.op.Call;
import org.qbicc.machine.llvm.op.CmpAndSwap;
import org.qbicc.machine.llvm.op.GetElementPtr;
import org.qbicc.machine.llvm.op.HasArguments;
import org.qbicc.machine.llvm.op.IndirectBranch;
import org.qbicc.machine.llvm.op.Instruction;
import org.qbicc.machine.llvm.op.OrderingConstraint;
import org.qbicc.machine.llvm.op.Phi;
import org.qbicc.machine.llvm.op.Select;
import org.qbicc.machine.llvm.op.Store;
import org.qbicc.machine.llvm.op.YieldingInstruction;
import org.qbicc.object.Function;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.ProgramObject;
import org.qbicc.plugin.llvm.LLVMModuleDebugInfo;
import org.qbicc.plugin.llvm.LLVMModuleNodeVisitor;
import org.qbicc.plugin.llvm.ReferenceStrategy;
import org.qbicc.plugin.methodinfo.CallSiteInfo;
import org.qbicc.plugin.unwind.UnwindExceptionStrategy;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FloatType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.Type;
import org.qbicc.type.UnionType;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.VoidType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.LocalVariableElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.ParameterElement;

final class LLVMNodeVisitor
implements NodeVisitor<Set<Value>, LLValue, Instruction, Instruction> {
    final CompilationContext ctxt;
    final Module module;
    final LLVMModuleDebugInfo debugInfo;
    final LLValue topSubprogram;
    final LLVMModuleNodeVisitor moduleVisitor;
    final Function functionObj;
    final FunctionDefinition func;
    final BasicBlock entryBlock;
    final Map<Value, LLValue> mappedValues = new HashMap<Value, LLValue>();
    final Map<Invoke, LLValue> invokeResults = new HashMap<Invoke, LLValue>();
    final Map<Slot, LLValue> entryParameters = new HashMap<Slot, LLValue>();
    final Map<BasicBlock, LLBasicBlock> mappedBlocks = new HashMap<BasicBlock, LLBasicBlock>();
    final Map<BasicBlock, LLBasicBlock> mappedCatchBlocks = new HashMap<BasicBlock, LLBasicBlock>();
    final Map<BasicBlock, LLBasicBlock> mappedSpResumeBlocks = new HashMap<BasicBlock, LLBasicBlock>();
    final MethodBody methodBody;
    final LLBuilder builder;
    final Map<Node, LLValue> inlineLocations = new HashMap<Node, LLValue>();
    final Map<LocalVariableElement, DILocalVariable> localVariables = new HashMap<LocalVariableElement, DILocalVariable>();
    final List<InvocationNode> invocationNodes = new ArrayList<InvocationNode>();
    final Map<Invoke, Set<Phi>> invokeResultsToMap = new HashMap<Invoke, Set<Phi>>();
    private final boolean opaquePointers;
    private boolean personalityAdded;
    private static final LLValue llvm_dbg_value = Values.global((String)"llvm.dbg.value");
    private static final LLValue emptyExpr = Values.diExpression().asValue();

    LLVMNodeVisitor(CompilationContext ctxt, Module module, LLVMModuleDebugInfo debugInfo, LLValue topSubprogram, LLVMModuleNodeVisitor moduleVisitor, Function functionObj, FunctionDefinition func) {
        this.ctxt = ctxt;
        this.module = module;
        this.debugInfo = debugInfo;
        this.topSubprogram = topSubprogram;
        this.moduleVisitor = moduleVisitor;
        this.functionObj = functionObj;
        this.func = func;
        this.methodBody = functionObj.getBody();
        this.entryBlock = this.methodBody.getEntryBlock();
        this.builder = LLBuilder.newBuilder((LLBasicBlock)func.getRootBlock());
        this.personalityAdded = false;
        this.opaquePointers = moduleVisitor.opaquePointers;
    }

    public void execute() {
        IntegerType it;
        FunctionType funcType = this.functionObj.getValueType();
        int cnt = this.methodBody.getParameterCount();
        if (cnt != funcType.getParameterCount()) {
            throw new IllegalStateException("Mismatch between method body and function type parameter counts");
        }
        MethodBody methodBody = this.functionObj.getBody();
        for (int i = 0; i < cnt; ++i) {
            Slot slot = methodBody.getParameterSlot(i);
            ValueType type = funcType.getParameterType(i);
            Function.Parameter param = this.func.param(this.map((Type)type)).name(slot.toString());
            if (type instanceof IntegerType && ((IntegerType)type).getMinBits() < 32) {
                if (type instanceof SignedIntegerType) {
                    param.attribute(ParameterAttributes.signext);
                } else {
                    param.attribute(ParameterAttributes.zeroext);
                }
            } else if (type instanceof BooleanType) {
                param.attribute(ParameterAttributes.zeroext);
            }
            this.entryParameters.put(slot, param.asValue());
        }
        ValueType retType = funcType.getReturnType();
        Function.Returns ret = this.func.returns(this.map((Type)retType));
        if (retType instanceof IntegerType && (it = (IntegerType)retType).getMinBits() < 32) {
            if (retType instanceof SignedIntegerType) {
                ret.attribute(ParameterAttributes.signext);
            } else {
                ret.attribute(ParameterAttributes.zeroext);
            }
        } else if (retType instanceof BooleanType) {
            ret.attribute(ParameterAttributes.zeroext);
        }
        ArrayList<BasicBlock> blockList = new ArrayList<BasicBlock>(64);
        this.findBlocks(this.entryBlock, blockList, new BitSet());
        blockList.sort(Comparator.comparingInt(BasicBlock::getIndex));
        for (BasicBlock basicBlock : blockList) {
            this.preMap(basicBlock);
        }
        for (BasicBlock basicBlock : blockList) {
            this.postMap(basicBlock, this.preMap(basicBlock));
        }
        for (Map.Entry entry : this.invokeResultsToMap.entrySet()) {
            Invoke invoke = (Invoke)entry.getKey();
            Set phis = (Set)entry.getValue();
            BasicBlock block = invoke.getTerminatedBlock();
            LLBasicBlock llBasicBlock = this.mappedSpResumeBlocks.get(block);
            if (llBasicBlock == null) {
                llBasicBlock = this.map(block);
            }
            LLValue result = this.invokeResults.get(invoke);
            for (Phi phi : phis) {
                phi.item(result, llBasicBlock);
            }
        }
    }

    private void findBlocks(BasicBlock block, List<BasicBlock> blockList, BitSet visited) {
        int index = block.getIndex();
        if (visited.get(index)) {
            return;
        }
        visited.set(index);
        blockList.add(block);
        Terminator t = block.getTerminator();
        int cnt = t.getSuccessorCount();
        for (int i = 0; i < cnt; ++i) {
            BasicBlock successor = t.getSuccessor(i);
            this.findBlocks(successor, blockList, visited);
        }
    }

    public Instruction visit(Set<Value> liveValues, BlockEntry node) {
        return null;
    }

    public Instruction visit(Set<Value> liveValues, DebugAddressDeclaration node) {
        Value address = node.getAddress();
        LLValue mappedAddress = this.map(address);
        PointerType pointerType = (PointerType)address.getType();
        LLValue mappedPointerType = this.map((Type)pointerType);
        ValueType actualType = pointerType.getPointeeType();
        LocalVariableElement variable = node.getVariable();
        MetadataNode metadataNode = this.getLocalVariableMetadataNode((Node)node, actualType, variable);
        org.qbicc.machine.llvm.op.Call call = this.builder.call(Types.void_, llvm_dbg_value);
        call.arg(Types.metadata((LLValue)mappedPointerType), mappedAddress).arg(Types.metadata, metadataNode.asRef()).arg(Types.metadata, LLVM.diExpression().arg(DIOpcode.Deref).asValue());
        call.comment("local var " + node.getVariable().getName());
        return call;
    }

    public Instruction visit(Set<Value> liveValues, DebugValueDeclaration node) {
        Value value = node.getValue();
        LLValue mappedValue = this.map(value);
        ValueType valueType = value.getType();
        LLValue mappedValueType = this.map((Type)valueType);
        LocalVariableElement variable = node.getVariable();
        MetadataNode metadataNode = this.getLocalVariableMetadataNode((Node)node, valueType, variable);
        org.qbicc.machine.llvm.op.Call call = this.builder.call(Types.void_, llvm_dbg_value);
        call.arg(Types.metadata((LLValue)mappedValueType), mappedValue).arg(Types.metadata, metadataNode.asRef()).arg(Types.metadata, emptyExpr);
        call.comment("local var " + node.getVariable().getName());
        return call;
    }

    private MetadataNode getLocalVariableMetadataNode(Node node, ValueType valueType, LocalVariableElement variable) {
        DILocalVariable metadataNode = this.localVariables.get(variable);
        if (metadataNode == null) {
            metadataNode = this.module.diLocalVariable(variable.getName(), this.debugInfo.getType((Type)variable.getType()), this.topSubprogram, this.debugInfo.createSourceFile((Element)node.getElement()), node.getSourceLine(), valueType.getAlign());
            ParameterElement param = variable.getReflectsParameter();
            if (param != null) {
                int index = ((InvokableElement)this.functionObj.getOriginalElement()).getParameters().indexOf(param);
                metadataNode.argument(index + 1);
            }
            this.localVariables.put(variable, metadataNode);
        }
        return metadataNode;
    }

    public Instruction visit(Set<Value> liveValues, org.qbicc.graph.Store node) {
        Value pointer = node.getPointer();
        LLValue ptr = this.map(pointer);
        Store storeInsn = this.builder.store(this.map((Type)pointer.getType()), this.map(node.getValue()), this.map((Type)node.getValue().getType()), ptr);
        storeInsn.align(pointer.getPointeeType().getAlign());
        WriteAccessMode accessMode = node.getAccessMode();
        if (!AccessModes.SingleUnshared.includes((AccessMode)accessMode)) {
            if (AccessModes.SinglePlain.includes((AccessMode)accessMode)) {
                storeInsn.atomic(OrderingConstraint.unordered);
            } else if (AccessModes.SingleOpaque.includes((AccessMode)accessMode)) {
                storeInsn.atomic(OrderingConstraint.monotonic);
            } else if (AccessModes.SingleRelease.includes((AccessMode)accessMode)) {
                storeInsn.atomic(OrderingConstraint.release);
            } else if (AccessModes.SingleSeqCst.includes((AccessMode)accessMode)) {
                storeInsn.atomic(OrderingConstraint.seq_cst);
            } else {
                throw new IllegalArgumentException("LLVM store does not directly support access mode " + accessMode);
            }
        }
        return storeInsn;
    }

    public Instruction visit(Set<Value> liveValues, Fence node) {
        GlobalAccessMode gam = node.getAccessMode();
        if (AccessModes.GlobalAcquire.includes((AccessMode)gam)) {
            return this.builder.fence(OrderingConstraint.acquire);
        }
        if (AccessModes.GlobalRelease.includes((AccessMode)gam)) {
            return this.builder.fence(OrderingConstraint.release);
        }
        if (AccessModes.GlobalAcqRel.includes((AccessMode)gam)) {
            return this.builder.fence(OrderingConstraint.acq_rel);
        }
        return this.builder.fence(OrderingConstraint.seq_cst);
    }

    public Instruction visit(Set<Value> liveValues, Reachable node) {
        this.map(node.getReachableValue());
        return null;
    }

    public Instruction visit(Set<Value> liveValues, Goto node) {
        return this.builder.br(this.map(node.getResumeTarget()));
    }

    public Instruction visit(Set<Value> liveValues, If node) {
        return this.builder.br(this.map(node.getCondition()), this.map(node.getTrueBranch()), this.map(node.getFalseBranch()));
    }

    public Instruction visit(Set<Value> liveValues, Ret node) {
        List successors = node.getSuccessors();
        if (successors.size() == 1) {
            return this.builder.br(this.map((BasicBlock)successors.get(0)));
        }
        IndirectBranch ibr = this.builder.indirectbr(this.map(node.getReturnAddressValue()));
        for (BasicBlock successor : successors) {
            ibr.possibleTarget(this.map(successor));
        }
        return ibr;
    }

    public Instruction visit(Set<Value> liveValues, Unreachable node) {
        return this.builder.unreachable();
    }

    public Instruction visit(Set<Value> liveValues, Switch node) {
        org.qbicc.machine.llvm.op.Switch switchInst = this.builder.switch_(Types.i32, this.map(node.getSwitchValue()), this.map(node.getDefaultTarget()));
        for (int i = 0; i < node.getNumberOfValues(); ++i) {
            switchInst.case_(Values.intConstant((int)node.getValueForIndex(i)), this.map(node.getTargetForIndex(i)));
        }
        return switchInst;
    }

    public Instruction visit(Set<Value> liveValues, Return node) {
        ValueType retType = node.getReturnValue().getType();
        if (retType instanceof VoidType) {
            return this.builder.ret();
        }
        return this.builder.ret(this.map((Type)retType), this.map(node.getReturnValue()));
    }

    boolean isFloating(Type type) {
        return type instanceof FloatType;
    }

    boolean isSigned(Type type) {
        return type instanceof SignedIntegerType;
    }

    public LLValue visit(Set<Value> liveValues, Add node) {
        ValueType type = node.getType();
        LLValue inputType = this.map((Type)type);
        LLValue llvmLeft = this.map(node.getLeftInput());
        LLValue llvmRight = this.map(node.getRightInput());
        return this.isFloating((Type)type) ? this.builder.fadd(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.add(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, And node) {
        LLValue llvmLeft = this.map(node.getLeftInput());
        LLValue llvmRight = this.map(node.getRightInput());
        return this.builder.and(this.map((Type)node.getType()), llvmLeft, llvmRight).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, AsmLiteral node) {
        return Values.asm((String)node.getInstruction(), (String)node.getConstraints(), LLVMNodeVisitor.map(node.getFlags()));
    }

    public LLValue visit(Set<Value> liveValues, BlockParameter node) {
        BasicBlock block = node.getPinnedBlock();
        Slot slot = node.getSlot();
        if (block.getIndex() == 1) {
            return this.entryParameters.get(slot);
        }
        Phi phi = this.builder.phi(this.map((Type)node.getType()));
        for (BasicBlock incoming : block.getIncoming()) {
            LLBasicBlock mappedIncoming = this.map(incoming);
            Terminator t = incoming.getTerminator();
            if (!t.isImplicitOutboundArgument(slot, block)) {
                LLValue mappedVal = this.map(t.getOutboundArgument(slot));
                int cnt = t.getSuccessorCount();
                for (int i = 0; i < cnt; ++i) {
                    if (t.getSuccessor(i) != block) continue;
                    phi.item(mappedVal, mappedIncoming);
                }
                continue;
            }
            if (slot != Slot.result() || !(t instanceof Invoke)) continue;
            Invoke inv = (Invoke)t;
            this.invokeResultsToMap.computeIfAbsent(inv, LLVMNodeVisitor::newSet).add(phi);
        }
        return phi.setLValue(this.map((Value)node));
    }

    private static <E> Set<E> newSet(Object ignored) {
        return new HashSet(4);
    }

    public LLValue visit(Set<Value> liveValues, Cmp node) {
        Value left = node.getLeftInput();
        LLValue inputType = this.map((Type)left.getType());
        LLValue llvmLeft = this.map(left);
        LLValue llvmRight = this.map(node.getRightInput());
        IntCondition lessThanCondition = this.isSigned((Type)left.getType()) ? IntCondition.slt : IntCondition.ult;
        LLValue booleanType = this.map((Type)this.ctxt.getTypeSystem().getBooleanType());
        LLValue integerType = this.map((Type)this.ctxt.getTypeSystem().getSignedInteger32Type());
        return this.builder.select(booleanType, this.builder.icmp(lessThanCondition, inputType, llvmLeft, llvmRight).asLocal(), integerType, this.map((Value)this.ctxt.getLiteralFactory().literalOf(-1)), this.builder.select(booleanType, this.builder.icmp(IntCondition.eq, inputType, llvmLeft, llvmRight).asLocal(), integerType, this.map((Value)this.ctxt.getLiteralFactory().literalOf(0)), this.map((Value)this.ctxt.getLiteralFactory().literalOf(1))).asLocal()).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, CmpG node) {
        Value left = node.getLeftInput();
        LLValue inputType = this.map((Type)left.getType());
        LLValue llvmLeft = this.map(left);
        LLValue llvmRight = this.map(node.getRightInput());
        LLValue booleanType = this.map((Type)this.ctxt.getTypeSystem().getBooleanType());
        LLValue integerType = this.map((Type)this.ctxt.getTypeSystem().getSignedInteger32Type());
        return this.builder.select(booleanType, this.builder.fcmp(FloatCondition.ugt, inputType, llvmLeft, llvmRight).asLocal(), integerType, this.map((Value)this.ctxt.getLiteralFactory().literalOf(1)), this.builder.select(booleanType, this.builder.fcmp(FloatCondition.ult, inputType, llvmLeft, llvmRight).withFlags(Set.of(FastMathFlag.nnan)).asLocal(), integerType, this.map((Value)this.ctxt.getLiteralFactory().literalOf(-1)), this.map((Value)this.ctxt.getLiteralFactory().literalOf(0))).asLocal()).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, CmpL node) {
        Value left = node.getLeftInput();
        LLValue inputType = this.map((Type)left.getType());
        LLValue llvmLeft = this.map(left);
        LLValue llvmRight = this.map(node.getRightInput());
        LLValue booleanType = this.map((Type)this.ctxt.getTypeSystem().getBooleanType());
        LLValue integerType = this.map((Type)this.ctxt.getTypeSystem().getSignedInteger32Type());
        Select select = this.builder.select(booleanType, this.builder.fcmp(FloatCondition.ult, inputType, llvmLeft, llvmRight).asLocal(), integerType, this.map((Value)this.ctxt.getLiteralFactory().literalOf(-1)), this.builder.select(booleanType, this.builder.fcmp(FloatCondition.ugt, inputType, llvmLeft, llvmRight).withFlags(Set.of(FastMathFlag.nnan)).asLocal(), integerType, this.map((Value)this.ctxt.getLiteralFactory().literalOf(1)), this.map((Value)this.ctxt.getLiteralFactory().literalOf(0))).asLocal());
        return select.setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Comp node) {
        Value input = node.getInput();
        LLValue inputType = this.map((Type)input.getType());
        LLValue llvmInput = this.map(input);
        if (input.getType() instanceof BooleanType) {
            return this.builder.xor(inputType, llvmInput, Values.TRUE).setLValue(this.map((Value)node));
        }
        ValueType valueType = input.getType();
        if (valueType instanceof IntegerType) {
            IntegerType it = (IntegerType)valueType;
            return this.builder.xor(inputType, llvmInput, Values.intConstant((long)it.asUnsigned().truncateValue(-1L))).setLValue(this.map((Value)node));
        }
        throw new IllegalStateException();
    }

    public LLValue visit(Set<Value> liveValues, IsEq node) {
        Value left = node.getLeftInput();
        LLValue inputType = this.map((Type)left.getType());
        LLValue llvmLeft = this.map(left);
        LLValue llvmRight = this.map(node.getRightInput());
        return this.isFloating((Type)node.getLeftInput().getType()) ? this.builder.fcmp(FloatCondition.oeq, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.icmp(IntCondition.eq, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, IsNe node) {
        Value left = node.getLeftInput();
        LLValue inputType = this.map((Type)left.getType());
        LLValue llvmLeft = this.map(left);
        LLValue llvmRight = this.map(node.getRightInput());
        return this.isFloating((Type)node.getLeftInput().getType()) ? this.builder.fcmp(FloatCondition.one, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.icmp(IntCondition.ne, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, IsLt node) {
        Value left = node.getLeftInput();
        LLValue inputType = this.map((Type)left.getType());
        LLValue llvmLeft = this.map(left);
        LLValue llvmRight = this.map(node.getRightInput());
        ValueType valueType = node.getLeftInput().getType();
        return this.isFloating((Type)valueType) ? this.builder.fcmp(FloatCondition.olt, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : (this.isSigned((Type)valueType) ? this.builder.icmp(IntCondition.slt, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.icmp(IntCondition.ult, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)));
    }

    public LLValue visit(Set<Value> liveValues, IsLe node) {
        Value left = node.getLeftInput();
        LLValue inputType = this.map((Type)left.getType());
        LLValue llvmLeft = this.map(left);
        LLValue llvmRight = this.map(node.getRightInput());
        ValueType valueType = node.getLeftInput().getType();
        return this.isFloating((Type)valueType) ? this.builder.fcmp(FloatCondition.ole, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : (this.isSigned((Type)valueType) ? this.builder.icmp(IntCondition.sle, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.icmp(IntCondition.ule, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)));
    }

    public LLValue visit(Set<Value> liveValues, IsGt node) {
        Value left = node.getLeftInput();
        LLValue inputType = this.map((Type)left.getType());
        LLValue llvmLeft = this.map(left);
        LLValue llvmRight = this.map(node.getRightInput());
        ValueType valueType = node.getLeftInput().getType();
        return this.isFloating((Type)valueType) ? this.builder.fcmp(FloatCondition.ogt, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : (this.isSigned((Type)valueType) ? this.builder.icmp(IntCondition.sgt, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.icmp(IntCondition.ugt, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)));
    }

    public LLValue visit(Set<Value> liveValues, IsGe node) {
        Value left = node.getLeftInput();
        LLValue inputType = this.map((Type)left.getType());
        LLValue llvmLeft = this.map(left);
        LLValue llvmRight = this.map(node.getRightInput());
        ValueType valueType = node.getLeftInput().getType();
        return this.isFloating((Type)valueType) ? this.builder.fcmp(FloatCondition.oge, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : (this.isSigned((Type)valueType) ? this.builder.icmp(IntCondition.sge, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.icmp(IntCondition.uge, inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)));
    }

    public LLValue visit(Set<Value> liveValues, Or node) {
        LLValue llvmLeft = this.map(node.getLeftInput());
        LLValue llvmRight = this.map(node.getRightInput());
        return this.builder.or(this.map((Type)node.getType()), llvmLeft, llvmRight).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Xor node) {
        LLValue llvmLeft = this.map(node.getLeftInput());
        LLValue llvmRight = this.map(node.getRightInput());
        return this.builder.xor(this.map((Type)node.getType()), llvmLeft, llvmRight).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Multiply node) {
        LLValue inputType = this.map((Type)node.getType());
        LLValue llvmLeft = this.map(node.getLeftInput());
        LLValue llvmRight = this.map(node.getRightInput());
        return this.isFloating((Type)node.getType()) ? this.builder.fmul(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.mul(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, org.qbicc.graph.Select node) {
        Value trueValue = node.getTrueValue();
        LLValue inputType = this.map((Type)trueValue.getType());
        Value falseValue = node.getFalseValue();
        return this.builder.select(this.map((Type)node.getCondition().getType()), this.map(node.getCondition()), inputType, this.map(trueValue), this.map(falseValue)).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Load node) {
        LLValue ptr = this.map(node.getPointer());
        org.qbicc.machine.llvm.op.Load loadInsn = this.builder.load(this.map((Type)node.getPointer().getType()), this.map((Type)node.getType()), ptr);
        loadInsn.align(node.getType().getAlign());
        ReadAccessMode accessMode = node.getAccessMode();
        if (!AccessModes.SingleUnshared.includes((AccessMode)accessMode)) {
            if (AccessModes.SinglePlain.includes((AccessMode)accessMode)) {
                loadInsn.atomic(OrderingConstraint.unordered);
            } else if (AccessModes.SingleOpaque.includes((AccessMode)accessMode)) {
                loadInsn.atomic(OrderingConstraint.monotonic);
            } else if (AccessModes.SingleAcquire.includes((AccessMode)accessMode)) {
                loadInsn.atomic(OrderingConstraint.acquire);
            } else if (AccessModes.SingleSeqCst.includes((AccessMode)accessMode)) {
                loadInsn.atomic(OrderingConstraint.seq_cst);
            } else {
                throw new IllegalArgumentException("LLVM load does not directly support access mode " + accessMode);
            }
        }
        return loadInsn.setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, ReadModifyWrite node) {
        Value pointer = node.getPointer();
        LLValue ptr = this.map(pointer);
        AtomicRmw insn = this.builder.atomicrmw(this.map((Type)pointer.getType()), this.map(node.getUpdateValue()), this.map((Type)node.getUpdateValue().getType()), ptr);
        switch (node.getOp()) {
            case SET: {
                insn.xchg();
                break;
            }
            case ADD: {
                insn.add();
                break;
            }
            case SUB: {
                insn.sub();
                break;
            }
            case BITWISE_AND: {
                insn.and();
                break;
            }
            case BITWISE_NAND: {
                insn.nand();
                break;
            }
            case BITWISE_OR: {
                insn.or();
                break;
            }
            case BITWISE_XOR: {
                insn.xor();
                break;
            }
            case MIN: {
                insn.min();
                break;
            }
            case MAX: {
                insn.max();
            }
        }
        insn.align(pointer.getPointeeType().getAlign());
        insn.ordering(this.getOC(node.getReadAccessMode().combinedWith((AccessMode)node.getWriteAccessMode())));
        return insn.setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Neg node) {
        ValueType javaInputType = node.getInput().getType();
        LLValue inputType = this.map((Type)javaInputType);
        LLValue llvmInput = this.map(node.getInput());
        if (this.isFloating((Type)javaInputType)) {
            return this.builder.fneg(inputType, llvmInput).setLValue(this.map((Value)node));
        }
        return this.builder.sub(inputType, Values.ZERO, llvmInput).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, NotNull node) {
        return this.map(node.getInput());
    }

    public LLValue visit(Set<Value> liveValues, OffsetPointer node) {
        ValueType pointeeType = node.getPointeeType();
        GetElementPtr gep = this.builder.getelementptr(pointeeType instanceof VoidType ? Types.i8 : this.map((Type)pointeeType), this.map((Type)node.getType()), this.map(node.getBasePointer()));
        gep.arg(false, this.map((Type)node.getOffset().getType()), this.map(node.getOffset()));
        return gep.setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Shr node) {
        LLValue inputType = this.map((Type)node.getType());
        LLValue llvmLeft = this.map(node.getLeftInput());
        LLValue llvmRight = this.map(node.getRightInput());
        return this.isSigned((Type)node.getType()) ? this.builder.ashr(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.lshr(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Shl node) {
        LLValue llvmLeft = this.map(node.getLeftInput());
        LLValue llvmRight = this.map(node.getRightInput());
        return this.builder.shl(this.map((Type)node.getType()), llvmLeft, llvmRight).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Sub node) {
        LLValue llvmLeft = this.map(node.getLeftInput());
        LLValue llvmRight = this.map(node.getRightInput());
        return this.isFloating((Type)node.getLeftInput().getType()) ? this.builder.fsub(this.map((Type)node.getType()), llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.sub(this.map((Type)node.getType()), llvmLeft, llvmRight).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Div node) {
        LLValue inputType = this.map((Type)node.getType());
        LLValue llvmLeft = this.map(node.getLeftInput());
        LLValue llvmRight = this.map(node.getRightInput());
        return this.isFloating((Type)node.getType()) ? this.builder.fdiv(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : (this.isSigned((Type)node.getType()) ? this.builder.sdiv(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.udiv(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)));
    }

    public LLValue visit(Set<Value> liveValues, Mod node) {
        LLValue inputType = this.map((Type)node.getType());
        LLValue llvmLeft = this.map(node.getLeftInput());
        LLValue llvmRight = this.map(node.getRightInput());
        return this.isFloating((Type)node.getType()) ? this.builder.frem(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : (this.isSigned((Type)node.getType()) ? this.builder.srem(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)) : this.builder.urem(inputType, llvmLeft, llvmRight).setLValue(this.map((Value)node)));
    }

    public LLValue visit(Set<Value> liveValues, BitCast node) {
        LLValue outputType;
        ValueType javaInputType = node.getInput().getType();
        WordType javaOutputType = node.getType();
        LLValue llvmInput = this.map(node.getInput());
        LLValue inputType = this.map((Type)javaInputType);
        if (inputType.equals(outputType = this.map((Type)javaOutputType))) {
            return null;
        }
        if (javaInputType instanceof IntegerType) {
            IntegerType it = (IntegerType)javaInputType;
            if (javaOutputType instanceof ReferenceType) {
                ReferenceType rt = (ReferenceType)javaOutputType;
                if (it.getSize() == rt.getSize()) {
                    switch (this.moduleVisitor.config.getReferenceStrategy()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case POINTER: 
                        case POINTER_AS1: 
                    }
                    return this.builder.inttoptr(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
                }
                throw new IllegalStateException("Size mismatch");
            }
        }
        if (javaInputType instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)javaInputType;
            if (javaOutputType instanceof IntegerType) {
                IntegerType it = (IntegerType)javaOutputType;
                if (it.getSize() == rt.getSize()) {
                    switch (this.moduleVisitor.config.getReferenceStrategy()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case POINTER: 
                        case POINTER_AS1: 
                    }
                    return this.builder.ptrtoint(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
                }
                throw new IllegalStateException("Size mismatch");
            }
        }
        return this.builder.bitcast(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Convert node) {
        ValueType javaInputType = node.getInput().getType();
        WordType javaOutputType = node.getType();
        LLValue inputType = this.map((Type)javaInputType);
        LLValue outputType = this.map((Type)javaOutputType);
        LLValue llvmInput = this.map(node.getInput());
        if (inputType.equals(outputType)) {
            return null;
        }
        if (javaInputType instanceof PointerType) {
            if (javaOutputType instanceof ReferenceType) {
                return switch (this.moduleVisitor.config.getReferenceStrategy()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ReferenceStrategy.POINTER -> null;
                    case ReferenceStrategy.POINTER_AS1 -> this.builder.addrspacecast(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
                };
            }
            if (javaOutputType instanceof IntegerType) {
                return this.builder.ptrtoint(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
            }
        } else if (javaInputType instanceof ReferenceType) {
            if (javaOutputType instanceof PointerType) {
                return switch (this.moduleVisitor.config.getReferenceStrategy()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ReferenceStrategy.POINTER -> null;
                    case ReferenceStrategy.POINTER_AS1 -> this.builder.addrspacecast(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
                };
            }
            if (javaOutputType instanceof IntegerType) {
                return this.builder.ptrtoint(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
            }
        } else if (javaInputType instanceof FloatType) {
            if (javaOutputType instanceof SignedIntegerType) {
                return this.builder.fptosi(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
            }
            if (javaOutputType instanceof UnsignedIntegerType) {
                return this.builder.fptoui(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
            }
        } else if (javaInputType instanceof IntegerType) {
            if (javaOutputType instanceof PointerType || javaOutputType instanceof ReferenceType) {
                return this.builder.inttoptr(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
            }
            if (javaInputType instanceof SignedIntegerType) {
                if (javaOutputType instanceof FloatType) {
                    return this.builder.sitofp(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
                }
            } else if (javaInputType instanceof UnsignedIntegerType && javaOutputType instanceof FloatType) {
                return this.builder.uitofp(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
            }
        }
        this.ctxt.error((Element)this.functionObj.getOriginalElement(), (Node)node, "llvm: Unhandled conversion %s -> %s", new Object[]{javaInputType.toString(), javaOutputType.toString()});
        return llvmInput;
    }

    public LLValue visit(Set<Value> liveValues, DecodeReference node) {
        Value input = node.getInput();
        return switch (this.moduleVisitor.config.getReferenceStrategy()) {
            default -> throw new IncompatibleClassChangeError();
            case ReferenceStrategy.POINTER -> null;
            case ReferenceStrategy.POINTER_AS1 -> this.builder.addrspacecast(this.map((Type)input.getType()), this.map(input), this.map((Type)node.getType())).setLValue(this.map((Value)node));
        };
    }

    public LLValue visit(Set<Value> liveValues, Extend node) {
        WordType javaInputType = (WordType)node.getInput().getType();
        WordType javaOutputType = node.getType();
        LLValue llvmInput = this.map(node.getInput());
        if (javaInputType instanceof IntegerType && javaOutputType instanceof IntegerType && javaInputType.getMinBits() == javaOutputType.getMinBits()) {
            return null;
        }
        LLValue inputType = this.map((Type)javaInputType);
        LLValue outputType = this.map((Type)javaOutputType);
        return this.isFloating((Type)javaInputType) ? this.builder.fpext(inputType, llvmInput, outputType).setLValue(this.map((Value)node)) : (this.isSigned((Type)javaInputType) ? this.builder.sext(inputType, llvmInput, outputType).setLValue(this.map((Value)node)) : this.builder.zext(inputType, llvmInput, outputType).setLValue(this.map((Value)node)));
    }

    public LLValue visit(Set<Value> liveValues, ExtractElement node) {
        LLValue arrayType = this.map((Type)node.getArrayType());
        LLValue array = this.map(node.getArrayValue());
        LLValue index = this.map(node.getIndex());
        return this.builder.extractvalue(arrayType, array).arg(index).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, ExtractMember node) {
        LLValue compType = this.map((Type)node.getCompoundType());
        LLValue comp = this.map(node.getCompoundValue());
        LLValue index = this.map(node.getCompoundType(), node.getMember());
        return this.builder.extractvalue(compType, comp).arg(index).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, InsertElement node) {
        LLValue arrayType = this.map((Type)node.getType());
        LLValue array = this.map(node.getArrayValue());
        LLValue valueType = this.map((Type)node.getInsertedValue().getType());
        LLValue value = this.map(node.getInsertedValue());
        LLValue index = this.map(node.getIndex());
        return this.builder.insertvalue(arrayType, array, valueType, value).arg(index).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, InsertMember node) {
        LLValue compType = this.map((Type)node.getType());
        LLValue comp = this.map(node.getCompoundValue());
        LLValue valueType = this.map((Type)node.getInsertedValue().getType());
        LLValue value = this.map(node.getInsertedValue());
        LLValue index = this.map(node.getType(), node.getMember());
        return this.builder.insertvalue(compType, comp, valueType, value).arg(index).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Invoke.ReturnValue node) {
        LLBasicBlock invokeBlock = this.map(node.getInvoke().getTerminatedBlock());
        LLValue llValue = this.invokeResults.get(node.getInvoke());
        if (llValue == null) {
            this.postMap(node.getInvoke().getTerminatedBlock(), invokeBlock);
            llValue = this.mappedValues.get(node);
        }
        return llValue;
    }

    public LLValue visit(Set<Value> liveValues, CheckCast node) {
        return this.map(node.getInput());
    }

    public LLValue visit(Set<Value> liveValues, ElementOf node) {
        Value arrayPointer = node.getArrayPointer();
        ArrayType arrayType = (ArrayType)arrayPointer.getPointeeType(ArrayType.class);
        PointerType pointerType = arrayType.getPointer();
        LLValue ptr = this.map(arrayPointer);
        GetElementPtr gep = this.builder.getelementptr(this.map((Type)arrayType), this.map((Type)pointerType), ptr);
        gep.arg(false, Types.i32, Values.ZERO).arg(false, this.map((Type)node.getIndex().getType()), this.map(node.getIndex()));
        return gep.setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, MemberOf node) {
        CompoundType structType = node.getStructType();
        PointerType pointerType = structType.getPointer();
        LLValue ptr = this.map(node.getStructurePointer());
        GetElementPtr gep = this.builder.getelementptr(this.map((Type)structType), this.map((Type)pointerType), ptr);
        CompoundType.Member member = node.getMember();
        gep.arg(false, Types.i32, Values.ZERO).arg(false, Types.i32, this.map(structType, member));
        gep.comment("member " + member.getName());
        return gep.setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, MemberOfUnion node) {
        UnionType unionType = node.getUnionType();
        PointerType pointerType = unionType.getPointer();
        LLValue ptr = this.map(node.getUnionPointer());
        UnionType.Member member = node.getMember();
        YieldingInstruction bc = this.builder.bitcast(this.map((Type)pointerType), ptr, this.map((Type)member.getType().getPointer()));
        bc.comment("union member " + member.getName());
        return bc.setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Truncate node) {
        ValueType javaInputType = node.getInput().getType();
        WordType javaOutputType = node.getType();
        LLValue inputType = this.map((Type)javaInputType);
        LLValue outputType = this.map((Type)javaOutputType);
        LLValue llvmInput = this.map(node.getInput());
        return this.isFloating((Type)javaInputType) ? this.builder.ftrunc(inputType, llvmInput, outputType).setLValue(this.map((Value)node)) : this.builder.trunc(inputType, llvmInput, outputType).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, VaArg node) {
        Value vaList = node.getVaList();
        return this.builder.va_arg(this.map((Type)vaList.getType()), this.map(vaList), this.map((Type)node.getType())).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, StackAllocation node) {
        LLValue pointeeType = this.map((Type)node.getType().getPointeeType());
        LLValue countType = this.map((Type)node.getCount().getType());
        LLValue count = this.map(node.getCount());
        LLValue alignment = this.map(node.getAlign());
        return this.builder.alloca(pointeeType).elements(countType, count).align(alignment).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, Call node) {
        StatepointReason sr = this.getStatepointReason(node.getTarget(), liveValues);
        if (sr.isNeeded()) {
            org.qbicc.machine.llvm.op.Call spCall = this.makeStatepointCall((InvocationNode)node, sr, (type, fn) -> this.builder.call(type, fn).noTail());
            int cnt = this.addLiveValuesToStatepoint((Node)node, spCall);
            if (node.isVoidCall()) {
                return this.makeStatepointRelocs(spCall.setLValue(this.map((Value)node)), cnt);
            }
            return this.makeStatepointResult((InvocationNode)node, this.makeStatepointRelocs(spCall.asLocal(), cnt)).setLValue(this.map((Value)node));
        }
        return this.makeNonStatepointCall((InvocationNode)node, sr, (arg_0, arg_1) -> ((LLBuilder)this.builder).call(arg_0, arg_1)).setLValue(this.map((Value)node));
    }

    public LLValue visit(Set<Value> liveValues, CallNoSideEffects node) {
        StatepointReason sr = this.getStatepointReason(node.getTarget(), liveValues);
        if (sr.isNeeded()) {
            org.qbicc.machine.llvm.op.Call spCall = this.makeStatepointCall((InvocationNode)node, sr, (type, fn) -> this.builder.call(type, fn).noTail());
            int cnt = this.addLiveValuesToStatepoint((Node)node, spCall);
            if (node.isVoidCall()) {
                return this.makeStatepointRelocs(spCall.setLValue(this.map((Value)node)), cnt);
            }
            return this.makeStatepointResult((InvocationNode)node, this.makeStatepointRelocs(spCall.asLocal(), cnt)).setLValue(this.map((Value)node));
        }
        return this.makeNonStatepointCall((InvocationNode)node, sr, (arg_0, arg_1) -> ((LLBuilder)this.builder).call(arg_0, arg_1)).setLValue(this.map((Value)node));
    }

    public Instruction visit(Set<Value> liveValues, CallNoReturn node) {
        StatepointReason sr = this.getStatepointReason(node.getTarget(), liveValues);
        BiFunction<LLValue, LLValue, org.qbicc.machine.llvm.op.Call> callMaker = (type, fn) -> this.builder.call(type, fn).attribute(FunctionAttributes.noreturn);
        if (sr.isNeeded()) {
            org.qbicc.machine.llvm.op.Call spCall = this.makeStatepointCall((InvocationNode)node, sr, callMaker);
            int cnt = this.addLiveValuesToStatepoint((Node)node, spCall);
            this.makeStatepointRelocs(spCall.asLocal(), cnt);
        } else {
            this.makeNonStatepointCall((InvocationNode)node, sr, callMaker);
        }
        return this.builder.unreachable();
    }

    public Instruction visit(Set<Value> liveValues, TailCall node) {
        LLValue result;
        StatepointReason sr = this.getStatepointReason(node.getTarget(), liveValues);
        BiFunction<LLValue, LLValue, org.qbicc.machine.llvm.op.Call> callMaker = (type, fn) -> this.builder.call(type, fn).tail();
        ValueType returnType = node.getCalleeType().getReturnType();
        if (sr.isNeeded()) {
            org.qbicc.machine.llvm.op.Call spCall = this.makeStatepointCall((InvocationNode)node, sr, callMaker);
            int cnt = this.addLiveValuesToStatepoint((Node)node, spCall);
            if (returnType instanceof VoidType) {
                this.makeStatepointRelocs(spCall.asLocal(), cnt);
                return this.builder.ret();
            }
            result = this.makeStatepointResult((InvocationNode)node, this.makeStatepointRelocs(spCall.asLocal(), cnt)).asLocal();
        } else {
            if (returnType instanceof VoidType) {
                this.makeNonStatepointCall((InvocationNode)node, sr, callMaker);
                return this.builder.ret();
            }
            result = this.makeNonStatepointCall((InvocationNode)node, sr, callMaker).asLocal();
        }
        return this.builder.ret(this.map((Type)returnType), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instruction visit(Set<Value> liveValues, Invoke node) {
        org.qbicc.machine.llvm.op.Call call;
        LLBasicBlock catch_;
        boolean postMapCatch;
        boolean postMapResume;
        if (this.invokeResults.containsKey(node)) {
            return null;
        }
        LLBasicBlock resume = this.checkMap(node.getResumeTarget());
        boolean bl = postMapResume = resume == null;
        if (postMapResume) {
            resume = this.preMap(node.getResumeTarget());
        }
        boolean bl2 = postMapCatch = (catch_ = this.checkMap(node.getCatchBlock())) == null;
        if (postMapCatch) {
            catch_ = this.preMap(node.getCatchBlock());
        }
        LLBasicBlock finalResume = resume;
        StatepointReason sr = this.getStatepointReason(node.getTarget(), liveValues);
        if (sr.isNeeded()) {
            LLBasicBlock spResume = this.mapSpResume(node.getTerminatedBlock());
            call = this.makeStatepointCall((InvocationNode)node, sr, (llType, llTarget) -> this.builder.invoke(llType, llTarget, spResume, this.mapCatch(node.getCatchBlock())).noTail());
            LLValue resultToken = call.asLocal();
            int cnt = this.addLiveValuesToStatepoint((Node)node, call);
            LLBasicBlock old = this.builder.moveToBlock(spResume);
            try {
                this.makeStatepointRelocs(resultToken, cnt);
                if (!node.isVoidCall()) {
                    org.qbicc.machine.llvm.op.Call resultCall = this.makeStatepointResult((InvocationNode)node, resultToken);
                    this.invokeResults.put(node, resultCall.setLValue(this.map((Value)node.getReturnValue())));
                }
                this.builder.br(finalResume);
            }
            finally {
                this.builder.moveToBlock(old);
            }
        } else {
            call = node.isVoidCall() ? this.makeNonStatepointCall((InvocationNode)node, sr, (llType, llTarget) -> this.builder.invoke(llType, llTarget, finalResume, this.mapCatch(node.getCatchBlock())).noTail()) : this.makeNonStatepointCall((InvocationNode)node, sr, (llType, llTarget) -> {
                org.qbicc.machine.llvm.op.Call invoke = this.builder.invoke(llType, llTarget, finalResume, this.mapCatch(node.getCatchBlock())).noTail();
                this.invokeResults.put(node, invoke.setLValue(this.map((Value)node.getReturnValue())));
                return invoke;
            });
        }
        if (postMapResume) {
            this.postMap(node.getResumeTarget(), resume);
        }
        if (postMapCatch) {
            this.postMap(node.getCatchBlock(), catch_);
        }
        this.addPersonalityIfNeeded();
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instruction visit(Set<Value> liveValues, InvokeNoReturn node) {
        org.qbicc.machine.llvm.op.Call call;
        StatepointReason sr;
        boolean postMapCatch;
        LLBasicBlock unreachableTarget = this.func.createBlock();
        LLBasicBlock catch_ = this.checkMap(node.getCatchBlock());
        boolean bl = postMapCatch = catch_ == null;
        if (postMapCatch) {
            catch_ = this.preMap(node.getCatchBlock());
        }
        if ((sr = this.getStatepointReason(node.getTarget(), liveValues)).isNeeded()) {
            call = this.makeStatepointCall((InvocationNode)node, sr, (llType, llTarget) -> this.builder.invoke(llType, llTarget, unreachableTarget, this.mapCatch(node.getCatchBlock())).noTail().attribute(FunctionAttributes.noreturn));
            LLValue token = call.asLocal();
            int cnt = this.addLiveValuesToStatepoint((Node)node, call);
            LLBasicBlock old = this.builder.moveToBlock(unreachableTarget);
            try {
                this.makeStatepointRelocs(token, cnt);
            }
            finally {
                this.builder.moveToBlock(old);
            }
        } else {
            call = this.makeNonStatepointCall((InvocationNode)node, sr, (llType, llTarget) -> this.builder.invoke(llType, llTarget, unreachableTarget, this.mapCatch(node.getCatchBlock())).noTail().attribute(FunctionAttributes.noreturn));
        }
        if (postMapCatch) {
            this.postMap(node.getCatchBlock(), catch_);
        }
        LLBasicBlock old = this.builder.moveToBlock(unreachableTarget);
        try {
            this.builder.unreachable();
        }
        finally {
            this.builder.moveToBlock(old);
        }
        this.addPersonalityIfNeeded();
        return call;
    }

    private LLBasicBlock mapSpResume(BasicBlock invokeBlock) {
        LLBasicBlock mapped = this.mappedSpResumeBlocks.get(invokeBlock);
        if (mapped != null) {
            return mapped;
        }
        mapped = this.func.createBlock();
        mapped.name(invokeBlock + ".resume");
        this.mappedSpResumeBlocks.put(invokeBlock, mapped);
        return mapped;
    }

    private StatepointReason getStatepointReason(Value target, Set<Value> liveValues) {
        FunctionDeclaration fd;
        ProgramObjectLiteral pol;
        ProgramObject programObject;
        boolean callerIsHidden;
        ExecutableElement origElement = this.functionObj.getOriginalElement();
        boolean noLive = liveValues.stream().noneMatch(v -> v.getType() instanceof ReferenceType && v != target);
        boolean bl = callerIsHidden = origElement != null && origElement.hasAllModifiersOf(262144);
        if (!this.moduleVisitor.config.isStatepointEnabled()) {
            return StatepointReason.DISABLED;
        }
        if (callerIsHidden && this.functionObj.isNoSafePoints()) {
            return StatepointReason.HIDDEN_NO_SP_CALLER;
        }
        if (callerIsHidden && target.isNoSafePoints()) {
            return StatepointReason.HIDDEN_NO_SP_CALLEE;
        }
        if (callerIsHidden && noLive) {
            return StatepointReason.HIDDEN_NO_LIVE;
        }
        if (((InvokableType)target.getPointeeType(InvokableType.class)).isVariadic()) {
            return StatepointReason.VARIADIC;
        }
        if (target instanceof ProgramObjectLiteral && (programObject = (pol = (ProgramObjectLiteral)target).getProgramObject()) instanceof FunctionDeclaration && (fd = (FunctionDeclaration)programObject).getOriginalElement() == null) {
            return StatepointReason.EXTERN;
        }
        if (target instanceof AsmLiteral) {
            return StatepointReason.ASM;
        }
        if (this.functionObj.isNoSafePoints() || target.isNoSafePoints() || noLive) {
            return StatepointReason.VISIBLE_STACK;
        }
        return StatepointReason.VISIBLE_STACK_LIVE;
    }

    private org.qbicc.machine.llvm.op.Call makeStatepointCall(InvocationNode node, StatepointReason statepointReason, BiFunction<LLValue, LLValue, org.qbicc.machine.llvm.op.Call> spCallMaker) {
        assert (statepointReason.isNeeded());
        FunctionType functionType = (FunctionType)node.getCalleeType();
        List arguments = node.getArguments();
        this.preMapArgumentList(arguments);
        Value target = node.getTarget();
        LLValue llTarget = this.map(target);
        LLValue statepointDecl = this.moduleVisitor.generateStatepointDecl(functionType);
        LLValue statepointType = this.moduleVisitor.mapStatepointType(functionType);
        org.qbicc.machine.llvm.op.Call spCall = spCallMaker.apply(statepointType, statepointDecl);
        spCall.comment(statepointReason.getReason());
        int statepointId = this.moduleVisitor.getNextStatePointId(node);
        CallSiteInfo.get((CompilationContext)this.ctxt).mapStatepointIdToNode(statepointId, (Node)node);
        this.invocationNodes.add(node);
        spCall.arg(Types.i64, Values.intConstant((int)statepointId));
        spCall.arg(Types.i32, Values.ZERO);
        HasArguments.Argument argument = spCall.arg(this.map((Type)functionType.getPointer()), llTarget);
        if (this.moduleVisitor.generator.getLlvmMajor() >= 15) {
            argument.attribute(ParameterAttributes.elementtype((LLValue)this.map((Type)functionType)));
        }
        spCall.arg(Types.i32, Values.intConstant((int)arguments.size()));
        spCall.arg(Types.i32, Values.ZERO);
        this.setCallArguments((HasArguments)spCall, arguments);
        spCall.arg(Types.i64, Values.ZERO);
        spCall.arg(Types.i64, Values.ZERO);
        return spCall;
    }

    private org.qbicc.machine.llvm.op.Call makeNonStatepointCall(InvocationNode node, StatepointReason statepointReason, BiFunction<LLValue, LLValue, org.qbicc.machine.llvm.op.Call> callMaker) {
        Value target = node.getTarget();
        LLValue llTarget = this.map(target);
        FunctionType functionType = (FunctionType)node.getCalleeType();
        org.qbicc.machine.llvm.op.Call call = callMaker.apply(this.map((Type)functionType), llTarget);
        call.comment(statepointReason.getReason());
        this.setCallArguments((HasArguments)call, node.getArguments());
        this.setCallReturnValue(call, functionType);
        return call;
    }

    private int addLiveValuesToStatepoint(Node callNode, org.qbicc.machine.llvm.op.Call spCall) {
        Set liveValues = callNode.getLiveOuts();
        int live = 0;
        Iterator iterator = liveValues.iterator();
        while (iterator.hasNext()) {
            Value liveValue = (Value)iterator.next();
            ValueType valueType = liveValue.getType();
            if (!(valueType instanceof ReferenceType)) continue;
            ReferenceType rt = (ReferenceType)valueType;
            if (liveValue == callNode) continue;
            HasArguments opBundle = spCall.operandBundle("gc-live");
            opBundle.arg(this.map((Type)rt), this.map(liveValue));
            ++live;
            while (iterator.hasNext()) {
                liveValue = (Value)iterator.next();
                ValueType valueType2 = liveValue.getType();
                if (!(valueType2 instanceof ReferenceType)) continue;
                ReferenceType rtInner = (ReferenceType)valueType2;
                if (liveValue == callNode) continue;
                opBundle.arg(this.map((Type)rtInner), this.map(liveValue));
                ++live;
            }
            break block0;
        }
        return live;
    }

    private LLValue makeStatepointRelocs(LLValue resultToken, int cnt) {
        if (cnt == 0) {
            return resultToken;
        }
        LLValue relocateDecl = this.moduleVisitor.getRelocateDecl();
        LLValue relocateDeclType = this.moduleVisitor.getRelocateDeclType();
        for (int idx = 0; idx < cnt; ++idx) {
            org.qbicc.machine.llvm.op.Call spRelocate = this.builder.call(relocateDeclType, relocateDecl);
            spRelocate.arg(Types.token, resultToken);
            LLValue idxConst = Values.intConstant((int)idx);
            spRelocate.arg(Types.i32, idxConst);
            spRelocate.arg(Types.i32, idxConst);
            spRelocate.asLocal();
        }
        return resultToken;
    }

    private org.qbicc.machine.llvm.op.Call makeStatepointResult(InvocationNode node, LLValue resultToken) {
        LLValue resultDecl = this.moduleVisitor.generateStatepointResultDecl(node.getCalleeType().getReturnType());
        LLValue resultDeclType = this.moduleVisitor.generateStatepointResultDeclType(node.getCalleeType().getReturnType());
        org.qbicc.machine.llvm.op.Call resultCall = this.builder.call(resultDeclType, resultDecl);
        resultCall.arg(Types.token, resultToken);
        return resultCall;
    }

    private void preMapArgumentList(List<Value> arguments) {
        for (Value argument : arguments) {
            this.map((Type)argument.getType());
            this.map(argument);
        }
    }

    private void setCallReturnValue(org.qbicc.machine.llvm.op.Call call, FunctionType functionType) {
        ValueType retType = functionType.getReturnType();
        Call.Returns ret = call.returns();
        if (retType instanceof IntegerType && ((IntegerType)retType).getMinBits() < 32) {
            if (retType instanceof SignedIntegerType) {
                ret.attribute(ParameterAttributes.signext);
            } else {
                ret.attribute(ParameterAttributes.zeroext);
            }
        } else if (retType instanceof BooleanType) {
            ret.attribute(ParameterAttributes.zeroext);
        }
    }

    private void setCallArguments(HasArguments call, List<Value> arguments) {
        for (Value argument : arguments) {
            ValueType type = argument.getType();
            HasArguments.Argument arg = call.arg(this.map((Type)type), this.map(argument));
            if (type instanceof IntegerType && ((IntegerType)type).getMinBits() < 32) {
                if (type instanceof SignedIntegerType) {
                    arg.attribute(ParameterAttributes.signext);
                    continue;
                }
                arg.attribute(ParameterAttributes.zeroext);
                continue;
            }
            if (!(type instanceof BooleanType)) continue;
            arg.attribute(ParameterAttributes.zeroext);
        }
    }

    private void addPersonalityIfNeeded() {
        if (!this.personalityAdded) {
            MethodElement personalityFunction = UnwindExceptionStrategy.get((CompilationContext)this.ctxt).getPersonalityMethod();
            Function personality = this.ctxt.getExactFunction((ExecutableElement)personalityFunction);
            ProgramObjectLiteral literal = this.ctxt.getLiteralFactory().literalOf((ProgramObject)personality);
            this.func.personality(this.map((Value)literal), this.map((Type)literal.getType()));
            this.personalityAdded = true;
        }
    }

    private static Set<AsmFlag> map(Set<AsmLiteral.Flag> flags) {
        EnumSet<AsmFlag> output = EnumSet.noneOf(AsmFlag.class);
        if (flags.contains(AsmLiteral.Flag.SIDE_EFFECT)) {
            output.add(AsmFlag.SIDE_EFFECT);
        }
        if (!flags.contains(AsmLiteral.Flag.NO_THROW)) {
            output.add(AsmFlag.UNWIND);
        }
        if (flags.contains(AsmLiteral.Flag.ALIGN_STACK)) {
            output.add(AsmFlag.ALIGN_STACK);
        }
        if (flags.contains(AsmLiteral.Flag.INTEL_DIALECT)) {
            output.add(AsmFlag.INTEL_DIALECT);
        }
        return output;
    }

    private OrderingConstraint getOC(AccessMode mode) {
        if (AccessModes.SinglePlain.includes(mode)) {
            return OrderingConstraint.unordered;
        }
        if (AccessModes.SingleOpaque.includes(mode)) {
            return OrderingConstraint.monotonic;
        }
        if (AccessModes.SingleAcquire.includes(mode)) {
            return OrderingConstraint.acquire;
        }
        if (AccessModes.SingleRelease.includes(mode)) {
            return OrderingConstraint.release;
        }
        if (AccessModes.SingleAcqRel.includes(mode)) {
            return OrderingConstraint.acq_rel;
        }
        if (AccessModes.SingleSeqCst.includes(mode)) {
            return OrderingConstraint.seq_cst;
        }
        throw Assert.unreachableCode();
    }

    public LLValue visit(Set<Value> liveValues, org.qbicc.graph.CmpAndSwap node) {
        Value pointerValue = node.getPointer();
        LLValue ptrType = this.map((Type)pointerValue.getType());
        LLValue type = this.map((Type)pointerValue.getPointeeType());
        LLValue ptr = this.map(pointerValue);
        LLValue expect = this.map(node.getExpectedValue());
        LLValue update = this.map(node.getUpdateValue());
        ReadAccessMode readMode = node.getReadAccessMode();
        WriteAccessMode writeMode = node.getWriteAccessMode();
        OrderingConstraint successOrdering = this.getOC(readMode.combinedWith((AccessMode)writeMode));
        OrderingConstraint failureOrdering = this.getOC((AccessMode)readMode);
        if (failureOrdering == OrderingConstraint.unordered) {
            failureOrdering = OrderingConstraint.monotonic;
        }
        CmpAndSwap cmpAndSwapBuilder = this.builder.cmpAndSwap(ptrType, type, ptr, expect, update, successOrdering, failureOrdering);
        if (node.getStrength() == CmpAndSwap.Strength.WEAK) {
            cmpAndSwapBuilder.weak();
        }
        return cmpAndSwapBuilder.setLValue(this.map((Value)node));
    }

    public LLValue visitUnknown(Set<Value> liveValues, Value node) {
        this.ctxt.error(Location.builder().setNode((Node)node).build(), "llvm: Unrecognized value %s", new Object[]{node.getClass()});
        return Values.FALSE;
    }

    public LLValue visitAny(Set<Value> liveValues, Literal literal) {
        return (LLValue)literal.accept((LiteralVisitor)this.moduleVisitor, null);
    }

    public Instruction visitUnknown(Set<Value> liveValues, Action node) {
        this.ctxt.error((Element)this.functionObj.getOriginalElement(), (Node)node, "llvm: Unrecognized action %s", new Object[]{node.getClass()});
        return null;
    }

    public Instruction visitUnknown(Set<Value> liveValues, Terminator node) {
        this.ctxt.error((Element)this.functionObj.getOriginalElement(), (Node)node, "llvm: Unrecognized terminator %s", new Object[]{node.getClass()});
        return null;
    }

    private LLValue createDbgLocation(Node node, boolean distinct) {
        LLValue scope;
        LLValue inlinedAt = this.dbgInlinedCallSite(node.getCallSite());
        if (inlinedAt == null && node.getElement() != this.functionObj.getOriginalElement()) {
            this.ctxt.error(Location.builder().setNode(node).build(), "LLVM: Node is not part of the root function, but has no call site", new Object[0]);
        }
        LLValue lLValue = scope = this.topSubprogram != null && inlinedAt == null ? this.topSubprogram : this.debugInfo.getDebugInfoForFunction(node.getElement()).getScope(node.getBytecodeIndex());
        if (distinct) {
            return this.module.diLocation(node.getSourceLine(), 0, scope, inlinedAt).distinct(true).asRef();
        }
        return this.debugInfo.createDeduplicatedLocation(node.getSourceLine(), 0, scope, inlinedAt);
    }

    private LLValue dbgInlinedCallSite(Node node) {
        if (node == null) {
            return null;
        }
        LLValue diLocation = this.inlineLocations.get(node);
        if (diLocation == null) {
            diLocation = this.createDbgLocation(node, true);
            this.inlineLocations.put(node, diLocation);
        }
        return diLocation;
    }

    private LLValue dbg(Node node) {
        if (node.getElement() == null || this.debugInfo == null) {
            return null;
        }
        return this.createDbgLocation(node, false);
    }

    private LLBasicBlock map(BasicBlock block) {
        if (block == null) {
            throw new NullPointerException();
        }
        LLBasicBlock mapped = this.checkMap(block);
        if (mapped != null) {
            return mapped;
        }
        return this.postMap(block, this.preMap(block));
    }

    private LLBasicBlock checkMap(BasicBlock block) {
        return this.mappedBlocks.get(block);
    }

    private LLBasicBlock preMap(BasicBlock block) {
        LLBasicBlock mapped = this.func.createBlock();
        mapped.name(block.toString());
        this.mappedBlocks.put(block, mapped);
        return mapped;
    }

    private LLBasicBlock postMap(BasicBlock block, LLBasicBlock mapped) {
        LLBasicBlock oldBuilderBlock = this.builder.moveToBlock(mapped);
        LLValue oldBuilderDebugLocation = this.builder.getDebugLocation();
        List insnList = block.getInstructions();
        for (Node node : insnList) {
            Instruction instruction;
            this.builder.setDebugLocation(this.dbg(node));
            if (node instanceof Terminator) {
                Terminator t = (Terminator)node;
                instruction = (Instruction)t.accept((TerminatorVisitor)this, (Object)node.getLiveOuts());
            } else if (node instanceof Value) {
                Value value = (Value)node;
                LLValue llValue = (LLValue)value.accept((ValueVisitor)this, (Object)node.getLiveOuts());
                instruction = llValue == null ? null : llValue.getInstruction();
            } else if (node instanceof Action) {
                Action action = (Action)node;
                instruction = (Instruction)action.accept((ActionVisitor)this, (Object)node.getLiveOuts());
            } else {
                throw new IllegalStateException();
            }
            if (instruction == null) continue;
            this.addLineComment(node, instruction);
        }
        this.builder.setDebugLocation(oldBuilderDebugLocation);
        this.builder.moveToBlock(oldBuilderBlock);
        return mapped;
    }

    private LLBasicBlock mapCatch(BasicBlock block) {
        LLBasicBlock mapped = this.mappedCatchBlocks.get(block);
        if (mapped != null) {
            return mapped;
        }
        mapped = this.func.createBlock();
        LLBasicBlock oldBuilderBlock = this.builder.moveToBlock(mapped);
        this.builder.landingpad(Types.token).cleanup();
        LLBasicBlock handler = this.map(block);
        mapped.name(block + ".catch");
        this.builder.br(handler);
        this.builder.moveToBlock(oldBuilderBlock);
        this.mappedCatchBlocks.put(block, mapped);
        return mapped;
    }

    private LLValue map(Type type) {
        return this.moduleVisitor.map(type);
    }

    private LLValue map(Value value) {
        String name;
        LLValue mapped;
        WordCastValue wcv;
        ValueType valueType;
        WordCastValue wcv2;
        if (value instanceof Unschedulable) {
            return (LLValue)value.accept((ValueVisitor)this, null);
        }
        if (value instanceof NotNull) {
            NotNull nn = (NotNull)value;
            return this.map(nn.getInput());
        }
        if (value instanceof WordCastValue && this.map((Type)(wcv2 = (WordCastValue)value).getType()).equals(this.map((Type)wcv2.getInput().getType()))) {
            return this.map(wcv2.getInput());
        }
        if (value instanceof WordCastValue && (valueType = (wcv = (WordCastValue)value).getType()) instanceof IntegerType) {
            IntegerType out = (IntegerType)valueType;
            valueType = wcv.getInput().getType();
            if (valueType instanceof IntegerType) {
                IntegerType in = (IntegerType)valueType;
                if (out.getMinBits() == in.getMinBits()) {
                    return this.map(wcv.getInput());
                }
            }
        }
        if (this.opaquePointers) {
            BitCast bc;
            if (value instanceof BitCast && ((bc = (BitCast)value).getType() instanceof PointerType && bc.getInput().getType() instanceof PointerType || bc.getType() instanceof ReferenceType && bc.getInput().getType() instanceof ReferenceType)) {
                return this.map(bc.getInput());
            }
            if (value instanceof MemberOfUnion) {
                MemberOfUnion mou = (MemberOfUnion)value;
                return this.map(mou.getUnionPointer());
            }
            if (this.moduleVisitor.config.getReferenceStrategy() == ReferenceStrategy.POINTER) {
                if (value instanceof DecodeReference) {
                    DecodeReference dr = (DecodeReference)value;
                    return this.map(dr.getInput());
                }
                if (value instanceof Convert) {
                    Convert conv = (Convert)value;
                    if (conv.getInput().getType() instanceof PointerType && conv.getType() instanceof ReferenceType) {
                        return this.map(conv.getInput());
                    }
                    if (conv.getInput().getType() instanceof ReferenceType && conv.getType() instanceof PointerType) {
                        return this.map(conv.getInput());
                    }
                }
            }
        } else if (this.moduleVisitor.config.getReferenceStrategy() == ReferenceStrategy.POINTER) {
            if (value instanceof DecodeReference) {
                DecodeReference dr = (DecodeReference)value;
                return this.map(dr.getInput());
            }
            if (value instanceof Convert) {
                Convert conv = (Convert)value;
                if (conv.getInput().getType() instanceof PointerType && conv.getType() instanceof ReferenceType) {
                    return this.map(conv.getInput());
                }
                if (conv.getInput().getType() instanceof ReferenceType && conv.getType() instanceof PointerType) {
                    return this.map(conv.getInput());
                }
            }
        }
        if ((mapped = this.mappedValues.get(value)) != null) {
            return mapped;
        }
        if (value instanceof Invoke.ReturnValue) {
            Invoke.ReturnValue rv = (Invoke.ReturnValue)value;
            Invoke invoke = rv.getInvoke();
            block = invoke.getTerminatedBlock();
            int scheduleIndex = invoke.getScheduleIndex();
            if (scheduleIndex == -1) {
                throw new IllegalStateException();
            }
            name = block.toString(new StringBuilder()).append('.').append(scheduleIndex).toString();
        } else {
            block = value.getScheduledBlock();
            if (value instanceof BlockParameter) {
                BlockParameter bp = (BlockParameter)value;
                if (bp.getPinnedBlock().getIndex() == 1) {
                    mapped = this.entryParameters.get(bp.getSlot());
                    this.mappedValues.put(value, mapped);
                    return mapped;
                }
                name = block.toString(new StringBuilder()).append('.').append(bp.getSlot()).toString();
            } else {
                int scheduleIndex = value.getScheduleIndex();
                if (scheduleIndex == -1) {
                    throw new IllegalStateException();
                }
                name = block.toString(new StringBuilder()).append('.').append(scheduleIndex).toString();
            }
        }
        mapped = Values.local((String)name);
        this.mappedValues.put(value, mapped);
        return mapped;
    }

    private void addLineComment(Node node, Instruction instruction) {
        if (instruction != null) {
            instruction.comment(node.getElement().getSourceFileName() + ":" + node.getSourceLine() + " bci@" + node.getBytecodeIndex());
        }
    }

    private LLValue map(CompoundType compoundType, CompoundType.Member member) {
        return this.moduleVisitor.map(compoundType, member);
    }

    static enum StatepointReason {
        DISABLED(false, "Statepoint is disabled"),
        HIDDEN_NO_SP_CALLER(false, "Caller is hidden and calling function is noSafePoints"),
        HIDDEN_NO_SP_CALLEE(false, "Caller is hidden and callee function is noSafePoints"),
        HIDDEN_NO_LIVE(false, "Caller is hidden and no live values"),
        VARIADIC(false, "Statepoint forbidden (variadic)"),
        EXTERN(false, "Statepoint forbidden (external function"),
        ASM(false, "Statepoint forbidden (inline assembly"),
        VISIBLE_STACK(true, "Visible to stack walk (no live GC values)"),
        VISIBLE_STACK_LIVE(true, "Visible to stack walk, live GC values");

        private final boolean needed;
        private final String reason;

        private StatepointReason(boolean needed, String reason) {
            this.needed = needed;
            this.reason = reason;
        }

        public boolean isNeeded() {
            return this.needed;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

