/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Location;
import org.qbicc.driver.Driver;
import org.qbicc.graph.InvocationNode;
import org.qbicc.graph.Node;
import org.qbicc.machine.llvm.CallingConvention;
import org.qbicc.machine.llvm.stackmap.LocationType;
import org.qbicc.machine.llvm.stackmap.StackMap;
import org.qbicc.machine.llvm.stackmap.StackMapVisitor;
import org.qbicc.machine.object.ObjectFile;
import org.qbicc.machine.object.ObjectFileProvider;
import org.qbicc.machine.object.Section;
import org.qbicc.object.Function;
import org.qbicc.plugin.linker.Linker;
import org.qbicc.plugin.llvm.LLVMInfo;
import org.qbicc.plugin.methodinfo.CallSiteTable;
import org.qbicc.plugin.methodinfo.valueinfo.FrameOffsetValueInfo;
import org.qbicc.plugin.methodinfo.valueinfo.RegisterRelativeValueInfo;
import org.qbicc.plugin.methodinfo.valueinfo.RegisterValueInfo;
import org.qbicc.plugin.methodinfo.valueinfo.ValueInfo;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;

public final class LLVMStackMapCollector {
    private final CompilationContext ctxt;

    public LLVMStackMapCollector(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public void collect() {
        Linker linker = Linker.get((CompilationContext)this.ctxt);
        LLVMInfo info = LLVMInfo.get(this.ctxt);
        ObjectFileProvider objFileProvider = (ObjectFileProvider)this.ctxt.getAttachment(Driver.OBJ_PROVIDER_TOOL_KEY);
        Iterator objFileIterator = linker.getObjectFilePathsWithTypeInLinkOrder().iterator();
        CallSiteTable cst = CallSiteTable.get((CompilationContext)this.ctxt);
        this.ctxt.runParallelTask(ctxt -> {
            while (true) {
                Map.Entry entry;
                Iterator iterator = objFileIterator;
                synchronized (iterator) {
                    if (!objFileIterator.hasNext()) {
                        return;
                    }
                    entry = (Map.Entry)objFileIterator.next();
                }
                LoadedTypeDefinition typeDefinition = (LoadedTypeDefinition)entry.getKey();
                List<InvocationNode> callSitesById = info.getStatePointIds(typeDefinition);
                if (callSitesById == null) {
                    throw new IllegalStateException("Missing statepoint IDs");
                }
                Path objFile = (Path)entry.getValue();
                try {
                    ObjectFile objectFile = objFileProvider.openObjectFile(objFile);
                    try {
                        Section stackMapSection = objectFile.getSection(objectFile.getStackMapSectionName());
                        if (stackMapSection == null) continue;
                        ByteBuffer stackMapData = stackMapSection.getSectionContent();
                        StackMap.parse((ByteBuffer)stackMapData, (StackMapVisitor)new StackMapVisitor(){
                            private final List<CallSiteTable.CallSiteEntry> callSites = new ArrayList<CallSiteTable.CallSiteEntry>();
                            private Function functionAddress;
                            private CallSiteTable.SourceCodeEntry sc;
                            private long stackSize;
                            private final List<CallSiteTable.CallSiteEntry> fnCallSites = new ArrayList<CallSiteTable.CallSiteEntry>();
                            private CallingConvention cconv;
                            private long offset;
                            private CallSiteTable.SubprogramEntry se;
                            private final HashSet<ValueInfo> valueInfos = new HashSet();
                            final /* synthetic */ CompilationContext val$ctxt;
                            final /* synthetic */ ObjectFile val$objectFile;
                            final /* synthetic */ LoadedTypeDefinition val$typeDefinition;
                            final /* synthetic */ List val$callSitesById;
                            final /* synthetic */ CallSiteTable val$cst;
                            {
                                this.val$ctxt = compilationContext;
                                this.val$objectFile = objectFile;
                                this.val$typeDefinition = loadedTypeDefinition;
                                this.val$callSitesById = list;
                                this.val$cst = callSiteTable;
                            }

                            public void start(int version, long fnCount, long recCount) {
                                if (version != 3) {
                                    this.val$ctxt.error(Location.builder().setSourceFilePath(this.val$objectFile.toString()).build(), "Stack map version %d not supported", new Object[]{version});
                                }
                            }

                            public void startFunction(long fnIndex, long address, long stackSize, long recordCount) {
                                this.functionAddress = this.val$ctxt.getOrAddProgramModule((DefinedTypeDefinition)this.val$typeDefinition).getFunction((int)fnIndex);
                                this.stackSize = stackSize;
                            }

                            public void startRecord(long recIndex, long patchPointId, long offset, int locCnt, int liveOutCnt) {
                                this.offset = offset;
                                Node node = (Node)this.val$callSitesById.get(Math.toIntExact(patchPointId));
                                this.se = this.val$cst.getSubprogramEntry(node.getElement());
                                this.sc = this.getSourceCodeEntry(node);
                            }

                            private CallSiteTable.SourceCodeEntry getSourceCodeEntry(Node node) {
                                Node inlinedAt = node.getCallSite();
                                return this.val$cst.intern(new CallSiteTable.SourceCodeEntry(this.val$cst.getSubprogramEntry(node.getElement()), node.getSourceLine(), node.getBytecodeIndex(), inlinedAt == null ? null : this.getSourceCodeEntry(inlinedAt)));
                            }

                            public void location(int locIndex, LocationType type, int size, int regNum, long data) {
                                block0 : switch (locIndex) {
                                    case 0: {
                                        switch (type) {
                                            case Constant: {
                                                this.cconv = CallingConvention.values()[(int)data];
                                                break block0;
                                            }
                                        }
                                        this.val$ctxt.error(Location.builder().setSourceFilePath(this.val$objectFile.toString()).build(), "Unexpected entry for calling convention", new Object[0]);
                                        break;
                                    }
                                    case 1: {
                                        switch (type) {
                                            case Constant: {
                                                break block0;
                                            }
                                        }
                                        this.val$ctxt.error(Location.builder().setSourceFilePath(this.val$objectFile.toString()).build(), "Unexpected entry for flags", new Object[0]);
                                        break;
                                    }
                                    case 2: {
                                        switch (type) {
                                            case Constant: {
                                                if (data == 0L) break block0;
                                                this.val$ctxt.error(Location.builder().setSourceFilePath(this.val$objectFile.toString()).build(), "Unexpected non-zero entry for deopt locations", new Object[0]);
                                                break;
                                            }
                                            default: {
                                                this.val$ctxt.error(Location.builder().setSourceFilePath(this.val$objectFile.toString()).build(), "Unexpected entry for deopt locations", new Object[0]);
                                                break;
                                            }
                                        }
                                        break;
                                    }
                                    default: {
                                        switch (type) {
                                            case Register: {
                                                this.valueInfos.add((ValueInfo)RegisterValueInfo.forRegisterNumber((int)regNum));
                                                break block0;
                                            }
                                            case Direct: {
                                                this.valueInfos.add((ValueInfo)new RegisterRelativeValueInfo(RegisterValueInfo.forRegisterNumber((int)regNum), (long)((int)(data / (long)this.val$ctxt.getTypeSystem().getReferenceSize()))));
                                                break block0;
                                            }
                                            case Indirect: {
                                                this.valueInfos.add((ValueInfo)new FrameOffsetValueInfo(RegisterValueInfo.forRegisterNumber((int)regNum), (int)(data / (long)this.val$ctxt.getTypeSystem().getReferenceSize())));
                                                break block0;
                                            }
                                            case Constant: {
                                                if (data == 0L) break block0;
                                                this.val$ctxt.error(Location.builder().setSourceFilePath(this.val$objectFile.toString()).build(), "Constant stack map record not supported", new Object[0]);
                                            }
                                        }
                                    }
                                }
                            }

                            public void endRecord(long recIndex) {
                                CallSiteTable.LiveValueInfo lvi = this.val$cst.intern(this.valueInfos);
                                this.valueInfos.clear();
                                this.fnCallSites.add(new CallSiteTable.CallSiteEntry(this.functionAddress, this.offset, this.sc, lvi));
                            }

                            public void endFunction(long fnIndex) {
                                this.fnCallSites.sort(Comparator.comparingLong(CallSiteTable.CallSiteEntry::offset));
                                this.callSites.addAll(this.fnCallSites);
                                this.fnCallSites.clear();
                            }

                            public void end() {
                                this.val$cst.registerEntries(this.val$typeDefinition, this.callSites);
                                this.callSites.clear();
                            }
                        });
                        continue;
                    }
                    finally {
                        if (objectFile == null) continue;
                        objectFile.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    ctxt.error(Location.builder().setSourceFilePath(String.valueOf(objFile)).build(), "Failed to read stack map information: %s", new Object[]{e});
                    continue;
                }
                break;
            }
        });
    }

    public static void execute(CompilationContext ctxt) {
        new LLVMStackMapCollector(ctxt).collect();
    }
}

