/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.lowering;

import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.Load;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Return;
import org.qbicc.graph.Store;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.type.BooleanType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;

public final class BooleanAccessCopier
implements NodeVisitor.Delegating<Node.Copier, Value, Node, BasicBlock> {
    private final CompilationContext ctxt;
    private final NodeVisitor<Node.Copier, Value, Node, BasicBlock> delegate;

    public BooleanAccessCopier(CompilationContext ctxt, NodeVisitor<Node.Copier, Value, Node, BasicBlock> delegate) {
        this.ctxt = ctxt;
        this.delegate = delegate;
    }

    public NodeVisitor<Node.Copier, Value, Node, BasicBlock> getDelegateNodeVisitor() {
        return this.delegate;
    }

    public Node visit(Node.Copier param, Store node) {
        ValueType valueType;
        param.copyNode(node.getDependency());
        Value origPointer = node.getPointer();
        Value copyPointer = param.copyValue(origPointer);
        BasicBlockBuilder b = param.getBlockBuilder();
        Value copiedValue = param.copyValue(node.getValue());
        if (origPointer.getPointeeType() instanceof BooleanType && (valueType = copyPointer.getPointeeType()) instanceof IntegerType) {
            IntegerType it = (IntegerType)valueType;
            copiedValue = b.extend(copiedValue, (WordType)it);
        }
        return b.store(copyPointer, copiedValue, node.getAccessMode());
    }

    public Value visit(Node.Copier param, Load node) {
        param.copyNode(node.getDependency());
        Value origPointer = node.getPointer();
        Value copyPointer = param.copyValue(origPointer);
        BasicBlockBuilder b = param.getBlockBuilder();
        Value loaded = b.load(copyPointer, node.getAccessMode());
        ValueType valueType = origPointer.getPointeeType();
        if (valueType instanceof BooleanType) {
            BooleanType bt = (BooleanType)valueType;
            if (copyPointer.getPointeeType() instanceof IntegerType) {
                return b.truncate(loaded, (WordType)bt);
            }
        }
        return loaded;
    }

    public Value visit(Node.Copier param, CmpAndSwap node) {
        param.copyNode(node.getDependency());
        Value origPointer = node.getPointer();
        Value copyPointer = param.copyValue(origPointer);
        Value copiedExpect = param.copyValue(node.getExpectedValue());
        Value copiedUpdate = param.copyValue(node.getUpdateValue());
        BasicBlockBuilder b = param.getBlockBuilder();
        ValueType valueType = origPointer.getPointeeType();
        if (valueType instanceof BooleanType) {
            BooleanType bt = (BooleanType)valueType;
            valueType = copyPointer.getPointeeType();
            if (valueType instanceof IntegerType) {
                IntegerType it = (IntegerType)valueType;
                Value result = b.cmpAndSwap(copyPointer, b.extend(copiedExpect, (WordType)it), b.extend(copiedUpdate, (WordType)it), node.getReadAccessMode(), node.getWriteAccessMode(), node.getStrength());
                LiteralFactory lf = this.ctxt.getLiteralFactory();
                CompoundType origType = CmpAndSwap.getResultType((CompilationContext)this.ctxt, (ValueType)it);
                CompoundType newType = CmpAndSwap.getResultType((CompilationContext)this.ctxt, (ValueType)bt);
                Value resultByteVal = b.extractMember(result, origType.getMember(0));
                Value resultFlag = b.extractMember(result, origType.getMember(1));
                result = b.insertMember((Value)lf.zeroInitializerLiteralOfType((ValueType)newType), newType.getMember(0), b.truncate(resultByteVal, (WordType)bt));
                result = b.insertMember(result, newType.getMember(1), resultFlag);
                return result;
            }
        }
        return b.cmpAndSwap(copyPointer, copiedExpect, copiedUpdate, node.getReadAccessMode(), node.getWriteAccessMode(), node.getStrength());
    }

    public Value visit(Node.Copier param, ReadModifyWrite node) {
        param.copyNode(node.getDependency());
        Value origPointer = node.getPointer();
        Value copyPointer = param.copyValue(origPointer);
        BasicBlockBuilder b = param.getBlockBuilder();
        Value copiedUpdate = param.copyValue(node.getUpdateValue());
        ReadModifyWrite.Op op = node.getOp();
        ValueType valueType = origPointer.getPointeeType();
        if (valueType instanceof BooleanType) {
            BooleanType bt = (BooleanType)valueType;
            valueType = copyPointer.getPointeeType();
            if (valueType instanceof IntegerType) {
                IntegerType it = (IntegerType)valueType;
                return b.truncate(b.readModifyWrite(copyPointer, op, b.extend(copiedUpdate, (WordType)it), node.getReadAccessMode(), node.getWriteAccessMode()), (WordType)bt);
            }
        }
        return b.readModifyWrite(copyPointer, op, copiedUpdate, node.getReadAccessMode(), node.getWriteAccessMode());
    }

    public BasicBlock visit(Node.Copier param, Return node) {
        BasicBlockBuilder b = param.getBlockBuilder();
        param.copyNode(node.getDependency());
        Value copiedReturnValue = param.copyValue(node.getReturnValue());
        ValueType valueType = node.getElement().getType().getReturnType();
        if (valueType instanceof BooleanType) {
            BooleanType bt = (BooleanType)valueType;
            if (copiedReturnValue.getType() instanceof IntegerType) {
                return b.return_(b.truncate(copiedReturnValue, (WordType)bt));
            }
        }
        return b.return_(copiedReturnValue);
    }
}

