/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.lowering;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.Slot;
import org.qbicc.object.Function;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FunctionElement;

public final class FunctionLoweringElementHandler
implements Consumer<ExecutableElement> {
    @Override
    public void accept(ExecutableElement element) {
        if (element.hasMethodBody()) {
            ClassContext classContext = element.getEnclosingType().getContext();
            CompilationContext compilationContext = classContext.getCompilationContext();
            BiFunction copier = compilationContext.getCopier();
            MethodBody original = element.getMethodBody();
            BasicBlock entryBlock = original.getEntryBlock();
            List paramSlots = original.getParameterSlots();
            if (!(element instanceof FunctionElement)) {
                if (!element.isStatic()) {
                    paramSlots = Slot.argListWithPrependedThis((List)original.getParameterSlots());
                }
                paramSlots = Slot.argListWithPrependedThread((List)paramSlots);
            }
            Function function = compilationContext.getExactFunction(element);
            BasicBlockBuilder builder = classContext.newBasicBlockBuilder(element);
            BasicBlock copyBlock = Node.Copier.execute((BasicBlock)entryBlock, (BasicBlockBuilder)builder, (CompilationContext)compilationContext, (BiFunction)copier);
            builder.finish();
            function.replaceBody(MethodBody.of((BasicBlock)copyBlock, (List)paramSlots));
            element.replaceMethodBody(function.getBody());
        }
    }
}

