/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.main_method;

import java.util.List;
import java.util.function.Consumer;
import org.qbicc.context.CompilationContext;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.plugin.apploader.AppClassLoader;
import org.qbicc.plugin.main_method.MainMethod;
import org.qbicc.plugin.main_method.UserMainIntrinsic;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public class AddMainClassHook
implements Consumer<CompilationContext> {
    private static final String MAIN_CLASS = "jdk/internal/org/qbicc/runtime/Main";

    @Override
    public void accept(CompilationContext ctxt) {
        MainMethod mainMethod = MainMethod.get(ctxt);
        String mainClassName = mainMethod.getMainClass();
        if (mainClassName != null) {
            VmClass mainClass;
            String mainClassIntName = mainClassName.replace('.', '/');
            VmClassLoader appClassLoader = AppClassLoader.get((CompilationContext)ctxt).getAppClassLoader();
            try {
                mainClass = appClassLoader.loadClass(mainClassIntName);
            }
            catch (Throwable t) {
                ctxt.error("Failed to load user main class %s: %s", new Object[]{mainClassName, t});
                return;
            }
            LoadedTypeDefinition mainClassDef = mainClass.getTypeDefinition();
            int idx = mainClassDef.findMethodIndex(e -> {
                if (!e.getName().equals("main")) {
                    return false;
                }
                if (!e.hasAllModifiersOf(9)) {
                    return false;
                }
                MethodDescriptor desc = e.getDescriptor();
                if (desc.getReturnType() != BaseTypeDescriptor.V) {
                    return false;
                }
                List paramTypes = desc.getParameterTypes();
                if (paramTypes.size() != 1) {
                    return false;
                }
                TypeDescriptor paramType = (TypeDescriptor)paramTypes.get(0);
                if (!(paramType instanceof ArrayTypeDescriptor)) {
                    return false;
                }
                ArrayTypeDescriptor atd = (ArrayTypeDescriptor)paramType;
                TypeDescriptor elementType = atd.getElementTypeDescriptor();
                if (!(elementType instanceof ClassTypeDescriptor)) {
                    return false;
                }
                ClassTypeDescriptor classTypeDescriptor = (ClassTypeDescriptor)elementType;
                return classTypeDescriptor.packageAndClassNameEquals("java/lang", "String");
            });
            if (idx == -1) {
                ctxt.error("No valid main method found on \"%s\"", new Object[]{mainClassName});
                return;
            }
            MethodElement mainMethodElement = mainClassDef.getMethod(idx);
            UserMainIntrinsic.register(ctxt, mainMethodElement);
            DefinedTypeDefinition runtimeMain = ctxt.getBootstrapClassContext().findDefinedType(MAIN_CLASS);
            if (runtimeMain == null) {
                ctxt.error("Unable to find runtime main class \"%s\"", new Object[]{MAIN_CLASS});
            } else {
                runtimeMain.load();
            }
        }
    }
}

