/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.methodinfo;

import io.smallrye.common.constraint.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ToIntFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.primitive.ObjectIntMaps;
import org.eclipse.collections.api.factory.primitive.ShortObjectMaps;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.MutableShortObjectMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.OffsetFromLiteral;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmString;
import org.qbicc.object.Data;
import org.qbicc.object.Function;
import org.qbicc.object.Linkage;
import org.qbicc.object.ModuleSection;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.ProgramObject;
import org.qbicc.plugin.methodinfo.valueinfo.ConstantValueInfo;
import org.qbicc.plugin.methodinfo.valueinfo.FrameOffsetValueInfo;
import org.qbicc.plugin.methodinfo.valueinfo.RegisterRelativeValueInfo;
import org.qbicc.plugin.methodinfo.valueinfo.RegisterValueInfo;
import org.qbicc.plugin.methodinfo.valueinfo.ValueInfo;
import org.qbicc.plugin.serialization.BuildtimeHeap;
import org.qbicc.type.CompoundType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NullableType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.TypeType;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.definition.element.NamedElement;

public final class CallSiteTable {
    private static final AttachmentKey<CallSiteTable> KEY = new AttachmentKey();
    private final Map<ExecutableElement, SubprogramEntry> subprogramEntries = new ConcurrentHashMap<ExecutableElement, SubprogramEntry>();
    private final Map<LoadedTypeDefinition, List<CallSiteEntry>> entries = new ConcurrentHashMap<LoadedTypeDefinition, List<CallSiteEntry>>();
    private final Map<ValueInfo, ValueInfo> valueInfos = new ConcurrentHashMap<ValueInfo, ValueInfo>();
    private final Map<SourceCodeEntry, SourceCodeEntry> sourceCodeEntries = new ConcurrentHashMap<SourceCodeEntry, SourceCodeEntry>();
    private final Map<Set<ValueInfo>, LiveValueInfo> liveValueInfos = new ConcurrentHashMap<Set<ValueInfo>, LiveValueInfo>();
    private final CompilationContext ctxt;
    private static final int LVI_UNSHIFTED = 32768;

    CallSiteTable(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static void computeMethodType(ExecutableElement ee) {
        Vm.requireCurrent().createMethodType(ee);
    }

    public static CallSiteTable get(CompilationContext ctxt) {
        return (CallSiteTable)ctxt.computeAttachmentIfAbsent(KEY, () -> new CallSiteTable(ctxt));
    }

    public static void writeCallSiteTable(CompilationContext ctxt) {
        CallSiteTable.get(ctxt).doWrite();
    }

    private void doWrite() {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        TypeSystem ts = this.ctxt.getTypeSystem();
        ReferenceType stringType = this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/String").load().getClassType().getReference();
        ReferenceType methodTypeType = this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/invoke/MethodType").load().getClassType().getReference();
        MutableObjectIntMap fileNamesTable = ObjectIntMaps.mutable.empty();
        MutableObjectIntMap methodNamesTable = ObjectIntMaps.mutable.empty();
        MutableObjectIntMap methodTypesTable = ObjectIntMaps.mutable.empty();
        ArrayList fileNamesList = new ArrayList();
        ArrayList methodNamesList = new ArrayList();
        ArrayList methodTypesList = new ArrayList();
        TrieNode root = new TrieNode(null, 0);
        ShortArrayList sal = new ShortArrayList();
        for (LiveValueInfo info : this.liveValueInfos.values()) {
            this.emitLiveValueInfo(info, sal);
            root.findOrAdd(sal, info, sal.size() - 1);
            sal.clear();
        }
        MutableObjectIntMap lvtOffsets = ObjectIntMaps.mutable.empty();
        root.writeAllTo(sal, (MutableObjectIntMap<LiveValueInfo>)lvtOffsets);
        Literal lviLiteral = lf.literalOf(ts.getArrayType((ValueType)ts.getUnsignedInteger16Type(), (long)sal.size()), sal.toArray());
        ArrayList<SubprogramEntry> seList = new ArrayList<SubprogramEntry>(this.subprogramEntries.values());
        ArrayList<Literal> seLiterals = new ArrayList<Literal>(seList.size());
        seList.sort(Comparator.comparingInt(SubprogramEntry::typeId).thenComparingInt(SubprogramEntry::methodIdx));
        CompoundType steType = (CompoundType)this.ctxt.getBootstrapClassContext().resolveTypeFromClassName("org/qbicc/runtime/stackwalk", "CallSiteTable$struct_subprogram");
        MutableObjectIntMap subprogramIndexes = ObjectIntMaps.mutable.empty();
        for (SubprogramEntry entry : seList) {
            subprogramIndexes.put((Object)entry, subprogramIndexes.size());
            seLiterals.add(this.emitSubprogramEntry(steType, entry, obj -> this.lookUpItem(fileNamesTable, fileNamesList, obj), obj -> this.lookUpItem(methodNamesTable, methodNamesList, obj), obj -> this.lookUpItem(methodTypesTable, methodTypesList, obj)));
        }
        Literal seLiteral = lf.literalOf(ts.getArrayType((ValueType)steType, (long)seLiterals.size()), seLiterals);
        CompoundType sceType = (CompoundType)this.ctxt.getBootstrapClassContext().resolveTypeFromClassName("org/qbicc/runtime/stackwalk", "CallSiteTable$struct_source");
        ArrayList<Literal> sceLiterals = new ArrayList<Literal>(this.sourceCodeEntries.size());
        MutableObjectIntMap sourceCodeIndexes = ObjectIntMaps.mutable.empty();
        for (SourceCodeEntry entry : this.sourceCodeEntries.values()) {
            this.getSceIndex(sceType, entry, sceLiterals, (MutableObjectIntMap<SourceCodeEntry>)sourceCodeIndexes, (ObjectIntMap<SubprogramEntry>)subprogramIndexes);
        }
        Literal sceLiteral = lf.literalOf(ts.getArrayType((ValueType)sceType, (long)sceLiterals.size()), sceLiterals);
        CompoundType csType = (CompoundType)this.ctxt.getBootstrapClassContext().resolveTypeFromClassName("org/qbicc/runtime/stackwalk", "CallSiteTable$struct_call_site");
        ArrayList<Map.Entry<LoadedTypeDefinition, List<CallSiteEntry>>> callSiteListList = new ArrayList<Map.Entry<LoadedTypeDefinition, List<CallSiteEntry>>>(this.entries.entrySet());
        ArrayList<Literal> csLiterals = new ArrayList<Literal>(callSiteListList.size() * 16);
        callSiteListList.sort(Comparator.comparingInt(e -> ((LoadedTypeDefinition)e.getKey()).getTypeId()));
        for (Map.Entry<LoadedTypeDefinition, List<CallSiteEntry>> entry : callSiteListList) {
            for (CallSiteEntry callSiteEntry : entry.getValue()) {
                csLiterals.add(this.emitCallSiteEntry(csType, callSiteEntry, arg_0 -> ((MutableObjectIntMap)sourceCodeIndexes).get(arg_0), key -> {
                    int lvo = lvtOffsets.getIfAbsent(key, -1);
                    if (lvo == -1) {
                        throw new IllegalStateException("Missing LVT entry");
                    }
                    return lvo;
                }));
            }
        }
        Literal csLiteral = lf.literalOf(ts.getArrayType((ValueType)csType, (long)csLiterals.size()), csLiterals);
        IntegerLiteral csSizeLiteral = lf.literalOf((IntegerType)ts.getUnsignedInteger64Type(), (long)csLiterals.size());
        Literal fileNamesLiteral = lf.literalOf(ts.getArrayType((ValueType)stringType, (long)fileNamesList.size()), fileNamesList);
        Literal methodNamesLiteral = lf.literalOf(ts.getArrayType((ValueType)stringType, (long)methodNamesList.size()), methodNamesList);
        Literal methodTypesLiteral = lf.literalOf(ts.getArrayType((ValueType)methodTypeType, (long)methodTypesList.size()), methodTypesList);
        LoadedTypeDefinition cstTypeDef = this.ctxt.getBootstrapClassContext().findDefinedType("org/qbicc/runtime/stackwalk/CallSiteTable").load();
        DefinedTypeDefinition defaultTypeDef = this.ctxt.getDefaultTypeDefinition();
        ProgramModule programModule = this.ctxt.getOrAddProgramModule(defaultTypeDef);
        ModuleSection moduleSection = programModule.inSection(this.ctxt.getImplicitSection());
        FieldElement callSiteTbl = cstTypeDef.findField("call_site_tbl");
        FieldElement callSiteTblSize = cstTypeDef.findField("call_site_tbl_size");
        FieldElement sourceTbl = cstTypeDef.findField("source_tbl");
        FieldElement subprogramTbl = cstTypeDef.findField("subprogram_tbl");
        FieldElement lviTbl = cstTypeDef.findField("lvi_tbl");
        FieldElement fileNameRefs = cstTypeDef.findField("file_name_refs");
        FieldElement methodNameRefs = cstTypeDef.findField("method_name_refs");
        FieldElement methodTypeRefs = cstTypeDef.findField("method_type_refs");
        Data cst = moduleSection.addData((MemberElement)callSiteTbl, callSiteTbl.getName(), (Value)csLiteral);
        cst.setLinkage(Linkage.EXTERNAL);
        cst.setConstant(true);
        Data cstEnd = moduleSection.addData((MemberElement)callSiteTblSize, callSiteTblSize.getName(), (Value)csSizeLiteral);
        cstEnd.setLinkage(Linkage.EXTERNAL);
        cstEnd.setConstant(true);
        Data sce = moduleSection.addData((MemberElement)sourceTbl, sourceTbl.getName(), (Value)sceLiteral);
        sce.setLinkage(Linkage.EXTERNAL);
        sce.setConstant(true);
        Data se = moduleSection.addData((MemberElement)subprogramTbl, subprogramTbl.getName(), (Value)seLiteral);
        se.setLinkage(Linkage.EXTERNAL);
        se.setConstant(true);
        Data lvi = moduleSection.addData((MemberElement)lviTbl, lviTbl.getName(), (Value)lviLiteral);
        lvi.setLinkage(Linkage.EXTERNAL);
        lvi.setConstant(true);
        moduleSection.addData((MemberElement)fileNameRefs, fileNameRefs.getName(), (Value)fileNamesLiteral).setLinkage(Linkage.EXTERNAL);
        moduleSection.addData((MemberElement)methodNameRefs, methodNameRefs.getName(), (Value)methodNamesLiteral).setLinkage(Linkage.EXTERNAL);
        moduleSection.addData((MemberElement)methodTypeRefs, methodTypeRefs.getName(), (Value)methodTypesLiteral).setLinkage(Linkage.EXTERNAL);
    }

    private <T extends VmObject> int lookUpItem(MutableObjectIntMap<T> table, List<Literal> literals, T obj) {
        if (obj == null) {
            return -1;
        }
        int val = table.getIfAbsent(obj, -1);
        if (val == -1) {
            val = literals.size();
            table.put(obj, val);
            BuildtimeHeap bh = BuildtimeHeap.get((CompilationContext)this.ctxt);
            literals.add(bh.referToSerializedVmObject(obj, (NullableType)obj.getObjectType().getReference(), this.ctxt.getOrAddProgramModule(this.ctxt.getDefaultTypeDefinition())));
        }
        return val;
    }

    private int getSceIndex(CompoundType sceType, SourceCodeEntry entry, List<Literal> output, MutableObjectIntMap<SourceCodeEntry> scMap, ObjectIntMap<SubprogramEntry> seMap) {
        if (entry == null) {
            return -1;
        }
        int idx = scMap.getIfAbsent((Object)entry, -1);
        if (idx == -1) {
            Literal entryLit = this.emitSourceCodeEntry(sceType, entry, arg_0 -> seMap.get(arg_0), sc -> this.getSceIndex(sceType, (SourceCodeEntry)sc, output, scMap, seMap));
            idx = output.size();
            scMap.put((Object)entry, idx);
            output.add(entryLit);
        }
        return idx;
    }

    public SubprogramEntry getSubprogramEntry(ExecutableElement executableElement) {
        SubprogramEntry entry = this.subprogramEntries.get(executableElement);
        if (entry == null) {
            VmObject methodType;
            String name;
            Vm vm = this.ctxt.getVm();
            if (executableElement instanceof NamedElement) {
                NamedElement ne = (NamedElement)executableElement;
                name = ne.getName();
            } else if (executableElement instanceof ConstructorElement) {
                name = "<init>";
            } else if (executableElement instanceof InitializerElement) {
                name = "<clinit>";
            } else {
                throw new IllegalArgumentException("Unknown element type");
            }
            String sourceFileName = executableElement.getSourceFileName();
            try {
                methodType = vm.createMethodType(executableElement.getEnclosingType().getContext(), executableElement.getDescriptor());
            }
            catch (IllegalStateException e) {
                this.ctxt.warning(executableElement.getLocation(), "No method type was created for element", new Object[0]);
                methodType = null;
            }
            entry = new SubprogramEntry(sourceFileName == null ? null : vm.intern(sourceFileName), vm.intern(name), methodType, executableElement);
            SubprogramEntry appearing = this.subprogramEntries.putIfAbsent(executableElement, entry);
            if (appearing != null) {
                entry = appearing;
            }
        }
        return entry;
    }

    public void registerEntries(LoadedTypeDefinition def, List<CallSiteEntry> entries) {
        Assert.checkNotNullParam((String)"def", (Object)def);
        Assert.checkNotNullParam((String)"entries", entries);
        List<CallSiteEntry> existing = this.entries.putIfAbsent(def, List.copyOf(entries));
        if (existing != null) {
            throw new IllegalArgumentException("Element already registered: " + def);
        }
    }

    public <V extends ValueInfo> V intern(V valueInfo) {
        ValueInfo existing = this.valueInfos.putIfAbsent(valueInfo, valueInfo);
        return (V)(existing == null ? valueInfo : existing);
    }

    public SourceCodeEntry intern(SourceCodeEntry sourceCodeEntry) {
        SourceCodeEntry existing = this.sourceCodeEntries.putIfAbsent(sourceCodeEntry, sourceCodeEntry);
        return existing == null ? sourceCodeEntry : existing;
    }

    public LiveValueInfo intern(Set<ValueInfo> liveValues) {
        LiveValueInfo interned = this.liveValueInfos.get(liveValues);
        if (interned != null) {
            return interned;
        }
        LiveValueInfo newInfo = new LiveValueInfo(Set.copyOf(liveValues));
        interned = this.liveValueInfos.putIfAbsent(newInfo.liveValues(), newInfo);
        return interned != null ? interned : newInfo;
    }

    public Literal emitCallSiteEntry(CompoundType callSiteType, CallSiteEntry entry, ToIntFunction<SourceCodeEntry> sceLookup, ToIntFunction<LiveValueInfo> lviLookup) {
        List members = callSiteType.getMembers();
        CompoundType.Member ipMember = (CompoundType.Member)members.get(0);
        CompoundType.Member srcIndexMember = (CompoundType.Member)members.get(1);
        CompoundType.Member lviIndexMember = (CompoundType.Member)members.get(2);
        assert (ipMember.getName().equals("ip") && ipMember.getType() instanceof PointerType);
        assert (srcIndexMember.getName().equals("source_idx") && srcIndexMember.getType() instanceof UnsignedIntegerType);
        assert (lviIndexMember.getName().equals("lvi_idx") && lviIndexMember.getType() instanceof UnsignedIntegerType);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        UnsignedIntegerType uintptr_t = ((PointerType)ipMember.getType(PointerType.class)).getSameSizedUnsignedInteger();
        Function function = entry.fnAddress();
        this.ctxt.getOrAddProgramModule(this.ctxt.getDefaultTypeDefinition()).declareFunction(function);
        TypeSystem ts = this.ctxt.getTypeSystem();
        UnsignedIntegerType u8 = ts.getUnsignedInteger8Type();
        OffsetFromLiteral ipLiteral = lf.offsetFromLiteral(lf.bitcastLiteral((Literal)lf.literalOf((ProgramObject)function), (WordType)u8.getPointer()), (Literal)lf.literalOf((IntegerType)uintptr_t, entry.offset));
        IntegerLiteral srcIndexLiteral = lf.literalOf((IntegerType)srcIndexMember.getType(IntegerType.class), (long)sceLookup.applyAsInt(entry.sci()));
        IntegerLiteral lviIndexLiteral = lf.literalOf((IntegerType)lviIndexMember.getType(IntegerType.class), (long)lviLookup.applyAsInt(entry.lvi()));
        return lf.literalOf(callSiteType, Map.of(ipMember, ipLiteral, srcIndexMember, srcIndexLiteral, lviIndexMember, lviIndexLiteral));
    }

    public Literal emitSubprogramEntry(CompoundType subprogramType, SubprogramEntry entry, ToIntFunction<VmString> fileNameLookup, ToIntFunction<VmString> methodNameLookup, ToIntFunction<VmObject> methodTypeLookup) {
        List members = subprogramType.getMembers();
        CompoundType.Member fileNameMember = (CompoundType.Member)members.get(0);
        CompoundType.Member methodNameMember = (CompoundType.Member)members.get(1);
        CompoundType.Member methodTypeMember = (CompoundType.Member)members.get(2);
        CompoundType.Member typeIdMember = (CompoundType.Member)members.get(3);
        CompoundType.Member modifiersMember = (CompoundType.Member)members.get(4);
        assert (fileNameMember.getName().equals("file_name_idx") && fileNameMember.getType() instanceof UnsignedIntegerType);
        assert (methodNameMember.getName().equals("method_name_idx") && methodNameMember.getType() instanceof UnsignedIntegerType);
        assert (methodTypeMember.getName().equals("method_type_idx") && methodTypeMember.getType() instanceof UnsignedIntegerType);
        assert (typeIdMember.getName().equals("type_id") && typeIdMember.getType() instanceof TypeType);
        assert (modifiersMember.getName().equals("modifiers") && modifiersMember.getType() instanceof IntegerType);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        IntegerLiteral fileNameIdx = lf.literalOf((IntegerType)fileNameMember.getType(UnsignedIntegerType.class), (long)fileNameLookup.applyAsInt(entry.fileName()));
        IntegerLiteral methodNameIdx = lf.literalOf((IntegerType)methodNameMember.getType(UnsignedIntegerType.class), (long)methodNameLookup.applyAsInt(entry.name()));
        IntegerLiteral methodTypeIdx = lf.literalOf((IntegerType)methodTypeMember.getType(UnsignedIntegerType.class), (long)methodTypeLookup.applyAsInt(entry.methodTypeObj()));
        return lf.literalOf(subprogramType, Map.of(fileNameMember, fileNameIdx, methodNameMember, methodNameIdx, methodTypeMember, methodTypeIdx, typeIdMember, lf.literalOfType(entry.enclosing().load().getType()), modifiersMember, lf.literalOf((IntegerType)modifiersMember.getType(IntegerType.class), (long)entry.modifiers())));
    }

    public Literal emitSourceCodeEntry(CompoundType sourceCodeType, SourceCodeEntry entry, ToIntFunction<SubprogramEntry> seLookup, ToIntFunction<SourceCodeEntry> sceLookup) {
        List members = sourceCodeType.getMembers();
        CompoundType.Member subprogramIdxMember = (CompoundType.Member)members.get(0);
        CompoundType.Member lineMember = (CompoundType.Member)members.get(1);
        CompoundType.Member bciMember = (CompoundType.Member)members.get(2);
        CompoundType.Member inlinedAtSourceIdxMember = (CompoundType.Member)members.get(3);
        assert (subprogramIdxMember.getName().equals("subprogram_idx") && subprogramIdxMember.getType() instanceof UnsignedIntegerType);
        assert (lineMember.getName().equals("line") && lineMember.getType() instanceof UnsignedIntegerType);
        assert (bciMember.getName().equals("bci") && bciMember.getType() instanceof UnsignedIntegerType);
        assert (inlinedAtSourceIdxMember.getName().equals("inlined_at_source_idx") && inlinedAtSourceIdxMember.getType() instanceof UnsignedIntegerType);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        return lf.literalOf(sourceCodeType, Map.of(subprogramIdxMember, lf.literalOf((IntegerType)subprogramIdxMember.getType(IntegerType.class), (long)seLookup.applyAsInt(entry.se())), lineMember, lf.literalOf((IntegerType)lineMember.getType(IntegerType.class), (long)entry.line()), bciMember, lf.literalOf((IntegerType)bciMember.getType(IntegerType.class), (long)entry.bci()), inlinedAtSourceIdxMember, lf.literalOf((IntegerType)inlinedAtSourceIdxMember.getType(IntegerType.class), (long)sceLookup.applyAsInt(entry.inlinedAt()))));
    }

    public static short makeLviBaseOffset(int baseReg, int offset) {
        Assert.checkMinimumParameter((String)"baseReg", (int)0, (int)baseReg);
        Assert.checkMaximumParameter((String)"baseReg", (int)31, (int)baseReg);
        Assert.checkMinimumParameter((String)"offset", (int)-512, (int)offset);
        Assert.checkMaximumParameter((String)"offset", (int)511, (int)offset);
        return (short)(0x8000 | baseReg << 10 | offset & 0x3FF);
    }

    public static short makeLviInMemory(BitSet bits, int offset) {
        return (short)(0x4000L | bits.get(offset, offset + 14).toLongArray()[0]);
    }

    public static short makeLviAddOffset(int offset) {
        Assert.checkMinimumParameter((String)"offset", (int)-8192, (int)offset);
        Assert.checkMaximumParameter((String)"offset", (int)8192, (int)offset);
        return (short)(0x2000 | offset & 0x1FFF);
    }

    public static short makeLviInRegister(int bank, int registers) {
        Assert.checkMinimumParameter((String)"bank", (int)0, (int)bank);
        Assert.checkMaximumParameter((String)"bank", (int)3, (int)bank);
        return (short)(0x400 | bank << 8 | registers >>> (bank << 3) & 0xFF);
    }

    public static short makeLviCurrentAddress() {
        return 1;
    }

    public static short makeLviEndOfList() {
        return 0;
    }

    public void emitLiveValueInfo(LiveValueInfo entry, ShortArrayList sal) {
        RegisterValueInfo baseRegister = null;
        BitSet memSlots = null;
        IntArrayList stackAllocations = null;
        int memShift = 0;
        int registers = 0;
        for (ValueInfo liveValue : entry.liveValues()) {
            int offset;
            RegisterValueInfo base;
            if (liveValue instanceof RegisterValueInfo) {
                RegisterValueInfo rvi = (RegisterValueInfo)liveValue;
                registers |= 1 << rvi.getRegisterNumber();
                continue;
            }
            if (liveValue instanceof ConstantValueInfo) {
                ConstantValueInfo cvi = (ConstantValueInfo)liveValue;
                if (cvi.getValue().isZero()) continue;
                throw new UnsupportedOperationException("Constant reference values");
            }
            if (liveValue instanceof FrameOffsetValueInfo) {
                FrameOffsetValueInfo fvi = (FrameOffsetValueInfo)liveValue;
                base = fvi.getBase();
                if (baseRegister == null) {
                    baseRegister = base;
                } else if (baseRegister != base) {
                    throw new UnsupportedOperationException("Multiple base registers");
                }
                offset = fvi.getOffset();
                if (offset < memShift) {
                    int moreShift = memShift - offset;
                    if (memSlots != null) {
                        int last;
                        for (int i = last = memSlots.size() - 1; i >= 0; --i) {
                            memSlots.set(i + moreShift, memSlots.get(i));
                        }
                        memSlots.clear(0, moreShift);
                    }
                    memShift = offset;
                }
                if (memSlots == null) {
                    memSlots = new BitSet();
                }
                memSlots.set(offset - memShift);
                continue;
            }
            if (liveValue instanceof RegisterRelativeValueInfo) {
                int ip;
                RegisterRelativeValueInfo rvi = (RegisterRelativeValueInfo)liveValue;
                base = rvi.getBase();
                if (baseRegister == null) {
                    baseRegister = base;
                } else if (baseRegister != base) {
                    throw new UnsupportedOperationException("Multiple base registers");
                }
                if (stackAllocations == null) {
                    stackAllocations = new IntArrayList();
                }
                if ((ip = stackAllocations.binarySearch(offset = Math.toIntExact(rvi.getOffset()))) > 0) continue;
                stackAllocations.addAtIndex(-ip - 1, offset);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        if ((registers & 0xFF) != 0) {
            sal.add(CallSiteTable.makeLviInRegister(0, registers));
        }
        if ((registers & 0xFF00) != 0) {
            sal.add(CallSiteTable.makeLviInRegister(1, registers));
        }
        if ((registers & 0xFF0000) != 0) {
            sal.add(CallSiteTable.makeLviInRegister(2, registers));
        }
        if ((registers & 0xFF000000) != 0) {
            sal.add(CallSiteTable.makeLviInRegister(3, registers));
        }
        if (memSlots != null && !memSlots.isEmpty()) {
            int regNum = baseRegister.getRegisterNumber();
            int idx = memSlots.nextSetBit(0);
            int remaining = memShift + idx;
            if (remaining < -512) {
                sal.add(CallSiteTable.makeLviBaseOffset(regNum, -512));
                remaining += 512;
            } else if (remaining <= 511) {
                sal.add(CallSiteTable.makeLviBaseOffset(regNum, remaining));
                remaining = 0;
            } else {
                sal.add(CallSiteTable.makeLviBaseOffset(regNum, 511));
                remaining -= 511;
            }
            while (idx != -1) {
                if (remaining < -8192) {
                    sal.add(CallSiteTable.makeLviAddOffset(-8192));
                    remaining += 8192;
                    continue;
                }
                if (remaining < 0) {
                    sal.add(CallSiteTable.makeLviAddOffset(remaining));
                    remaining = 0;
                    continue;
                }
                if (remaining < 14) {
                    int startBit = idx - remaining;
                    sal.add(CallSiteTable.makeLviInMemory(memSlots, startBit));
                    idx = memSlots.nextSetBit(startBit + 14);
                    remaining = idx - startBit - 14;
                    continue;
                }
                if (remaining <= 8192) {
                    sal.add(CallSiteTable.makeLviAddOffset(remaining));
                    remaining = 0;
                    continue;
                }
                sal.add(CallSiteTable.makeLviAddOffset(8192));
                remaining -= 8192;
            }
        }
        if (stackAllocations != null && !stackAllocations.isEmpty()) {
            int regNum = baseRegister.getRegisterNumber();
            int size = stackAllocations.size();
            int offset = stackAllocations.get(0);
            int remaining = offset;
            if (remaining < -512) {
                sal.add(CallSiteTable.makeLviBaseOffset(regNum, -512));
                remaining += 512;
            } else if (remaining <= 511) {
                sal.add(CallSiteTable.makeLviBaseOffset(regNum, remaining));
                remaining = 0;
            } else {
                sal.add(CallSiteTable.makeLviBaseOffset(regNum, 511));
                remaining -= 511;
            }
            while (remaining != 0) {
                if (remaining < -8192) {
                    sal.add(CallSiteTable.makeLviAddOffset(-8192));
                    remaining += 8192;
                    continue;
                }
                if (remaining < 0) {
                    sal.add(CallSiteTable.makeLviAddOffset(remaining));
                    remaining = 0;
                    continue;
                }
                if (remaining <= 8192) {
                    sal.add(CallSiteTable.makeLviAddOffset(remaining));
                    remaining = 0;
                    continue;
                }
                sal.add(CallSiteTable.makeLviAddOffset(8192));
                remaining -= 8192;
            }
            sal.add(CallSiteTable.makeLviCurrentAddress());
            for (int i = 1; i < size; ++i) {
                int newOffset = stackAllocations.get(i);
                remaining = newOffset - offset;
                offset = newOffset;
                while (remaining != 0) {
                    if (remaining < -8192) {
                        sal.add(CallSiteTable.makeLviAddOffset(-8192));
                        remaining += 8192;
                        continue;
                    }
                    if (remaining < 0) {
                        sal.add(CallSiteTable.makeLviAddOffset(remaining));
                        remaining = 0;
                        continue;
                    }
                    if (remaining <= 8192) {
                        sal.add(CallSiteTable.makeLviAddOffset(remaining));
                        remaining = 0;
                        continue;
                    }
                    sal.add(CallSiteTable.makeLviAddOffset(8192));
                    remaining -= 8192;
                }
                sal.add(CallSiteTable.makeLviCurrentAddress());
            }
        }
        sal.add(CallSiteTable.makeLviEndOfList());
    }

    private static final class TrieNode {
        private final TrieNode successor;
        private final short value;
        private Set<LiveValueInfo> infos;
        private MutableShortObjectMap<TrieNode> predecessors;

        private TrieNode(TrieNode successor, short value) {
            this.successor = successor;
            this.value = value;
        }

        void writeTo(ShortArrayList output, MutableObjectIntMap<LiveValueInfo> offsetMap) {
            if (this.infos != null) {
                for (LiveValueInfo info : this.infos) {
                    offsetMap.getIfAbsentPut((Object)info, output.size());
                }
            }
            output.add(this.value);
            TrieNode successor = this.successor;
            if (successor != null) {
                successor.writeTo(output, offsetMap);
            }
        }

        void writeAllTo(ShortArrayList output, MutableObjectIntMap<LiveValueInfo> offsetMap) {
            MutableShortObjectMap<TrieNode> predecessors = this.predecessors;
            if (predecessors != null) {
                predecessors.forEach((Procedure & Serializable)v -> v.writeAllTo(output, offsetMap));
            } else {
                this.writeTo(output, offsetMap);
            }
        }

        TrieNode findOrAdd(ShortArrayList list, LiveValueInfo info, int idx) {
            TrieNode predNode;
            if (idx == 0) {
                Set<LiveValueInfo> infos = this.infos;
                if (infos == null) {
                    infos = this.infos = new HashSet<LiveValueInfo>();
                }
                infos.add(info);
                return this;
            }
            short iv = list.get(--idx);
            MutableShortObjectMap predecessors = this.predecessors;
            if (predecessors == null) {
                predecessors = this.predecessors = ShortObjectMaps.mutable.empty();
            }
            if ((predNode = (TrieNode)predecessors.get(iv)) == null) {
                predNode = new TrieNode(this, iv);
                predecessors.put(iv, (Object)predNode);
            }
            return predNode.findOrAdd(list, info, idx);
        }
    }

    public record LiveValueInfo(Set<ValueInfo> liveValues) {
    }

    public record SubprogramEntry(VmString fileName, VmString name, VmObject methodTypeObj, ExecutableElement element) {
        public DefinedTypeDefinition enclosing() {
            return this.element.getEnclosingType();
        }

        public int typeId() {
            return this.enclosing().load().getTypeId();
        }

        public int modifiers() {
            return this.element.getModifiers();
        }

        public int methodIdx() {
            return this.element.getIndex();
        }
    }

    public record SourceCodeEntry(SubprogramEntry se, int line, int bci, SourceCodeEntry inlinedAt) {
    }

    public record CallSiteEntry(Function fnAddress, long offset, SourceCodeEntry sci, LiveValueInfo lvi) {
    }
}

