/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.methodinfo;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.qbicc.plugin.methodinfo.InstructionMap;
import org.qbicc.plugin.methodinfo.MethodInfo;
import org.qbicc.plugin.methodinfo.SourceCodeInfo;

final class MethodData {
    private final IndexableSet<MethodInfo> methodInfoSet = new IndexableSet();
    private final IndexableSet<SourceCodeInfo> sourceCodeInfoSet = new IndexableSet();
    private InstructionMap[] instructionMapList;

    MethodData(int instructionsCount) {
        this.instructionMapList = new InstructionMap[instructionsCount];
    }

    int add(SourceCodeInfo sourceCodeInfo) {
        return this.sourceCodeInfoSet.addIfAbsent(sourceCodeInfo);
    }

    int add(MethodInfo methodInfo) {
        return this.methodInfoSet.addIfAbsent(methodInfo);
    }

    void add(int index, InstructionMap instructionMap) {
        this.instructionMapList[index] = instructionMap;
    }

    MethodInfo[] getMethodInfoTable() {
        return this.methodInfoSet.toArray((MethodInfo[])new MethodInfo[0]);
    }

    SourceCodeInfo[] getSourceCodeInfoTable() {
        return this.sourceCodeInfoSet.toArray((SourceCodeInfo[])new SourceCodeInfo[0]);
    }

    InstructionMap[] getInstructionMapList() {
        InstructionMap[] map = new InstructionMap[this.instructionMapList.length];
        System.arraycopy(this.instructionMapList, 0, map, 0, map.length);
        return map;
    }

    private static final class IndexableSet<T>
    extends AbstractSet<T>
    implements Set<T> {
        final Map<T, Integer> map = new LinkedHashMap<T, Integer>();
        int lastIndex = -1;

        IndexableSet() {
        }

        @Override
        public synchronized int size() {
            return this.map.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.lastIndex == -1;
        }

        @Override
        public synchronized Iterator iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public synchronized Object[] toArray() {
            return this.map.keySet().toArray();
        }

        @Override
        public synchronized <T> T[] toArray(T[] t) {
            return super.toArray(t);
        }

        @Override
        public synchronized boolean contains(Object o) {
            return super.contains(o);
        }

        @Override
        public synchronized boolean containsAll(Collection<?> c) {
            return super.containsAll(c);
        }

        @Override
        public synchronized boolean add(T t) {
            if (this.map.containsKey(t)) {
                return false;
            }
            this.map.put(t, this.lastIndex++);
            return true;
        }

        public synchronized int addIfAbsent(T t) {
            return this.map.computeIfAbsent(t, k -> ++this.lastIndex);
        }

        @Override
        public boolean remove(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void clear() {
            this.map.clear();
            this.lastIndex = 0;
        }

        @Override
        public synchronized String toString() {
            return super.toString();
        }
    }
}

