/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.methodinfo.valueinfo;

import io.smallrye.common.constraint.Assert;
import java.util.Arrays;
import org.qbicc.plugin.methodinfo.valueinfo.ValueInfo;

public final class RegisterValueInfo
extends ValueInfo {
    private static volatile RegisterValueInfo[] cache;
    private final int registerNumber;

    RegisterValueInfo(int registerNumber) {
        super(Integer.hashCode(registerNumber));
        this.registerNumber = registerNumber;
    }

    public int getRegisterNumber() {
        return this.registerNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegisterValueInfo forRegisterNumber(int dwarfRegNum) {
        Assert.checkMinimumParameter((String)"dwarfRegNum", (int)0, (int)dwarfRegNum);
        Assert.checkMaximumParameter((String)"dwarfRegNum", (int)63, (int)dwarfRegNum);
        RegisterValueInfo[] cache = RegisterValueInfo.cache;
        if (cache != null && cache.length > dwarfRegNum) return cache[dwarfRegNum];
        Class<RegisterValueInfo> clazz = RegisterValueInfo.class;
        synchronized (RegisterValueInfo.class) {
            RegisterValueInfo[] newArray;
            cache = RegisterValueInfo.cache;
            if (cache != null && cache.length > dwarfRegNum) return cache[dwarfRegNum];
            if (cache != null) {
                newArray = Arrays.copyOf(cache, dwarfRegNum + 1);
                start = cache.length;
            } else {
                newArray = new RegisterValueInfo[dwarfRegNum + 1];
                start = 0;
            }
            for (int i = start; i < newArray.length; ++i) {
                newArray[i] = new RegisterValueInfo(i);
            }
            RegisterValueInfo.cache = cache = newArray;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cache[dwarfRegNum];
        }
    }

    public String toString() {
        return "reg[" + this.registerNumber + "]";
    }

    @Override
    public boolean equals(ValueInfo other) {
        RegisterValueInfo rvi;
        return other instanceof RegisterValueInfo && this.equals(rvi = (RegisterValueInfo)other);
    }

    public boolean equals(RegisterValueInfo other) {
        return super.equals(other) && this.registerNumber == other.registerNumber;
    }
}

