/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.metrics;

import java.time.Duration;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.qbicc.plugin.metrics.Metric;

public final class Timer
extends Metric<Timer> {
    private final ThreadLocal<State> currentState;

    Timer(String name, Timer parent) {
        super(name, parent);
        this.currentState = parent == null ? ThreadLocal.withInitial(State::new) : parent.currentState;
    }

    @Override
    Timer constructChild(String name) {
        return new Timer(name, this);
    }

    @Override
    public long getRawValue() {
        return super.getRawValue();
    }

    public Duration getTotal() {
        long unsignedValue = this.getRawValue();
        long seconds = Long.divideUnsigned(unsignedValue, 1000000000L);
        int nanos = (int)Long.remainderUnsigned(unsignedValue, 1000000000L);
        return Duration.ofSeconds(seconds, nanos);
    }

    @Override
    public StringBuilder getFormattedValue(StringBuilder target) {
        String totalStr = this.getTotal().toString();
        if (totalStr.startsWith("PT")) {
            totalStr = totalStr.substring(2);
        }
        totalStr = totalStr.toLowerCase(Locale.ROOT);
        return target.append(totalStr);
    }

    void addDuration(long start, long end) {
        this.addRawValue(Math.max(0L, end - start));
    }

    public StopWatch startTimedTryBlock() {
        Timer oldTimer = this.start();
        if (this != oldTimer) {
            return new ActiveStopWatch(oldTimer);
        }
        return NullStopWatch.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runTimed(Runnable task) {
        State state = this.currentState.get();
        Timer oldTimer = state.current;
        long start = System.nanoTime();
        if (oldTimer != null) {
            if (oldTimer == this) {
                task.run();
                return;
            }
            oldTimer.addDuration(state.start, start);
        }
        state.current = this;
        state.start = start;
        try {
            task.run();
        }
        finally {
            this.end(oldTimer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R getTimed(Supplier<R> task) {
        State state = this.currentState.get();
        Timer oldTimer = state.current;
        long start = System.nanoTime();
        if (oldTimer != null) {
            if (oldTimer == this) {
                return task.get();
            }
            oldTimer.addDuration(state.start, start);
        }
        state.current = this;
        state.start = start;
        try {
            R r = task.get();
            return r;
        }
        finally {
            this.end(oldTimer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T, R> R applyTimed(Function<T, R> task, T arg) {
        State state = this.currentState.get();
        Timer oldTimer = state.current;
        long start = System.nanoTime();
        if (oldTimer != null) {
            if (oldTimer == this) {
                return task.apply(arg);
            }
            oldTimer.addDuration(state.start, start);
        }
        state.current = this;
        state.start = start;
        try {
            R r = task.apply(arg);
            return r;
        }
        finally {
            this.end(oldTimer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T, U, R> R applyTimed(BiFunction<T, U, R> task, T arg1, U arg2) {
        State state = this.currentState.get();
        Timer oldTimer = state.current;
        long start = System.nanoTime();
        if (oldTimer != null) {
            if (oldTimer == this) {
                return task.apply(arg1, arg2);
            }
            oldTimer.addDuration(state.start, start);
        }
        state.current = this;
        state.start = start;
        try {
            R r = task.apply(arg1, arg2);
            return r;
        }
        finally {
            this.end(oldTimer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void acceptTimed(Consumer<T> task, T arg) {
        Timer oldTimer = this.start();
        if (oldTimer != this) {
            try {
                task.accept(arg);
                return;
            }
            finally {
                this.end(oldTimer);
            }
        }
        task.accept(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T, U> void acceptTimed(BiConsumer<T, U> task, T arg1, U arg2) {
        Timer oldTimer = this.start();
        if (oldTimer != this) {
            try {
                task.accept(arg1, arg2);
                return;
            }
            finally {
                this.end(oldTimer);
            }
        }
        task.accept(arg1, arg2);
    }

    private Timer start() {
        State state = this.currentState.get();
        Timer oldTimer = state.current;
        long start = System.nanoTime();
        if (oldTimer != null) {
            if (oldTimer == this) {
                return oldTimer;
            }
            oldTimer.addDuration(state.start, start);
        }
        state.current = this;
        state.start = start;
        return oldTimer;
    }

    private void end(Timer oldTimer) {
        State state = this.currentState.get();
        long end = System.nanoTime();
        this.addDuration(state.start, end);
        state.current = oldTimer;
        state.start = end;
    }

    @Override
    String getDescription() {
        return "Timer";
    }

    final class ActiveStopWatch
    extends StopWatch {
        private final Thread thread;
        private boolean active = true;
        private final Timer oldTimer;

        ActiveStopWatch(Timer oldTimer) {
            this.oldTimer = oldTimer;
            this.thread = Thread.currentThread();
        }

        @Override
        public void close() {
            if (Thread.currentThread() != this.thread || !this.active) {
                throw new IllegalStateException("Mismatched stop watch");
            }
            State state = Timer.this.currentState.get();
            if (state.current != Timer.this) {
                throw new IllegalStateException("Mismatched stop watch");
            }
            this.active = false;
            Timer.this.end(this.oldTimer);
        }
    }

    static class NullStopWatch
    extends StopWatch {
        static final NullStopWatch INSTANCE = new NullStopWatch();

        private NullStopWatch() {
        }

        @Override
        public void close() {
        }
    }

    static final class State {
        Timer current;
        long start;

        State() {
        }
    }

    public static abstract class StopWatch
    implements AutoCloseable {
        @Override
        public abstract void close();
    }
}

