/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import java.io.IOException;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Locatable;
import org.qbicc.context.Location;
import org.qbicc.driver.Driver;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.CastValue;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.ConstantLiteral;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.StaticFieldLiteral;
import org.qbicc.machine.object.ObjectFileProvider;
import org.qbicc.machine.probe.CProbe;
import org.qbicc.machine.tool.CToolChain;
import org.qbicc.plugin.constants.Constants;
import org.qbicc.plugin.core.ConditionEvaluation;
import org.qbicc.plugin.native_.Native;
import org.qbicc.plugin.native_.NativeInfo;
import org.qbicc.plugin.native_.ProbeUtils;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.ArrayAnnotationValue;
import org.qbicc.type.annotation.StringAnnotationValue;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;

public class ConstantDefiningBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt;

    private ConstantDefiningBasicBlockBuilder(BasicBlockBuilder delegate) {
        super(delegate);
        ExecutableElement element = this.getCurrentElement();
        if (element instanceof InitializerElement) {
            NativeInfo.get(this.getContext()).registerInitializer((InitializerElement)element);
        }
        this.ctxt = this.getContext();
    }

    public static BasicBlockBuilder createIfNeeded(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        if (delegate.getCurrentElement() instanceof InitializerElement) {
            return new ConstantDefiningBasicBlockBuilder(delegate);
        }
        return delegate;
    }

    public Node store(Value pointer, Value value, WriteAccessMode accessMode) {
        Value test = value;
        while (test instanceof CastValue) {
            test = ((CastValue)test).getInput();
        }
        if (test instanceof ConstantLiteral) {
            StaticFieldLiteral sfl;
            StaticFieldElement fieldElement;
            if (pointer instanceof StaticFieldLiteral && (fieldElement = (sfl = (StaticFieldLiteral)pointer).getVariableElement()).isReallyFinal()) {
                this.processConstant((FieldElement)fieldElement);
                return this.nop();
            }
            this.ctxt.error(this.getLocation(), "Compilation constants must be static final fields", new Object[0]);
            return this.nop();
        }
        return super.store(pointer, value, accessMode);
    }

    private void processConstant(FieldElement fieldElement) {
        Constants constants = Constants.get((CompilationContext)this.ctxt);
        ConditionEvaluation conditionEvaluation = ConditionEvaluation.get((CompilationContext)this.ctxt);
        ClassContext classContext = fieldElement.getEnclosingType().getContext();
        Location location = this.getLocation();
        constants.registerConstant(fieldElement, () -> {
            CProbe.Result result;
            CProbe.Builder builder = CProbe.builder();
            String name2 = fieldElement.getName();
            boolean nameOverridden = false;
            ProbeUtils.ProbeProcessor pp = new ProbeUtils.ProbeProcessor(classContext, (Locatable)fieldElement.getEnclosingType());
            for (Annotation annotation : fieldElement.getEnclosingType().getInvisibleAnnotations()) {
                pp.processAnnotation(annotation);
            }
            pp.accept(builder);
            pp = new ProbeUtils.ProbeProcessor(classContext, (Locatable)fieldElement);
            block3: for (Annotation annotation : fieldElement.getInvisibleAnnotations()) {
                AnnotationValue patt4985$temp;
                ClassTypeDescriptor desc = annotation.getDescriptor();
                if (pp.processAnnotation(annotation) || !desc.getPackageName().equals(Native.NATIVE_PKG)) continue;
                if (desc.getClassName().equals(Native.ANN_NAME) && !nameOverridden) {
                    if (!conditionEvaluation.evaluateConditions(classContext, () -> location, annotation)) continue;
                    name2 = ((StringAnnotationValue)annotation.getValue("value")).getString();
                    nameOverridden = true;
                    continue;
                }
                if (!desc.getClassName().equals(Native.ANN_NAME_LIST) || nameOverridden || !((patt4985$temp = annotation.getValue("value")) instanceof ArrayAnnotationValue)) continue;
                ArrayAnnotationValue aav = (ArrayAnnotationValue)patt4985$temp;
                int cnt = aav.getElementCount();
                for (int j = 0; j < cnt; ++j) {
                    Annotation nested;
                    ClassTypeDescriptor nestedDesc;
                    AnnotationValue patt5198$temp = aav.getValue(j);
                    if (!(patt5198$temp instanceof Annotation) || !(nestedDesc = (nested = (Annotation)patt5198$temp).getDescriptor()).getPackageName().equals(Native.NATIVE_PKG) || !nestedDesc.getClassName().equals(Native.ANN_NAME) || !conditionEvaluation.evaluateConditions(classContext, () -> location, nested)) continue;
                    name2 = ((StringAnnotationValue)nested.getValue("value")).getString();
                    nameOverridden = true;
                    continue block3;
                }
            }
            pp.accept(builder);
            builder.probeConstant(name2, location.getSourceFilePath(), location.getLineNumber());
            CProbe probe = builder.build();
            LiteralFactory lf = this.ctxt.getLiteralFactory();
            try {
                result = probe.run((CToolChain)this.ctxt.getAttachment(Driver.C_TOOL_CHAIN_KEY), (ObjectFileProvider)this.ctxt.getAttachment(Driver.OBJ_PROVIDER_TOOL_KEY), null);
                if (result == null) {
                    return lf.undefinedLiteralOfType(fieldElement.getType());
                }
            }
            catch (IOException e) {
                return lf.undefinedLiteralOfType(fieldElement.getType());
            }
            CProbe.ConstantInfo constantInfo = result.getConstantInfo(name2);
            return constantInfo.getValueAsLiteralOfType(this.ctxt.getTypeSystem(), lf, fieldElement.getType());
        });
    }
}

