/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import java.io.IOException;
import java.util.List;
import org.jboss.logging.Logger;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Locatable;
import org.qbicc.driver.Driver;
import org.qbicc.graph.Value;
import org.qbicc.machine.object.ObjectFileProvider;
import org.qbicc.machine.probe.CProbe;
import org.qbicc.machine.tool.CToolChain;
import org.qbicc.object.Data;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.Linkage;
import org.qbicc.object.ModuleSection;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.ProgramObject;
import org.qbicc.object.ThreadLocalMode;
import org.qbicc.plugin.core.ConditionEvaluation;
import org.qbicc.plugin.native_.ExportedFunctionInfo;
import org.qbicc.plugin.native_.ExternalFunctionInfo;
import org.qbicc.plugin.native_.Native;
import org.qbicc.plugin.native_.NativeDataInfo;
import org.qbicc.plugin.native_.NativeInfo;
import org.qbicc.plugin.native_.ProbeUtils;
import org.qbicc.type.FunctionType;
import org.qbicc.type.MethodType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.ArrayAnnotationValue;
import org.qbicc.type.annotation.IntAnnotationValue;
import org.qbicc.type.annotation.StringAnnotationValue;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.MethodResolver;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.FunctionElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public class ExternExportTypeBuilder
implements DefinedTypeDefinition.Builder.Delegating {
    private static final Logger log = Logger.getLogger((String)"org.qbicc.plugin.native_");
    private final ClassContext classCtxt;
    private final CompilationContext ctxt;
    private final DefinedTypeDefinition.Builder delegate;
    private boolean hasInclude;

    public ExternExportTypeBuilder(ClassContext classCtxt, DefinedTypeDefinition.Builder delegate) {
        this.classCtxt = classCtxt;
        this.ctxt = classCtxt.getCompilationContext();
        this.delegate = delegate;
    }

    public DefinedTypeDefinition.Builder getDelegate() {
        return this.delegate;
    }

    public void setInvisibleAnnotations(List<Annotation> annotations) {
        NativeInfo nativeInfo = NativeInfo.get(this.ctxt);
        ConditionEvaluation conditionEvaluation = ConditionEvaluation.get((CompilationContext)this.ctxt);
        for (Annotation annotation : annotations) {
            ClassTypeDescriptor desc = annotation.getDescriptor();
            if (!desc.getPackageName().equals(Native.NATIVE_PKG)) continue;
            String annClassName = desc.getClassName();
            if (annClassName.equals(Native.ANN_INCLUDE) || annClassName.equals(Native.ANN_INCLUDE_LIST)) {
                this.hasInclude = true;
            }
            if (annClassName.equals(Native.ANN_LIB)) {
                if (!conditionEvaluation.evaluateConditions(this.classCtxt, (Locatable)this, annotation)) continue;
                nativeInfo.registerLibrary(((StringAnnotationValue)annotation.getValue("value")).getString());
                continue;
            }
            if (!annClassName.equals(Native.ANN_LIB_LIST)) continue;
            ArrayAnnotationValue array = (ArrayAnnotationValue)annotation.getValue("value");
            int cnt = array.getElementCount();
            for (int j = 0; j < cnt; ++j) {
                Annotation element = (Annotation)array.getValue(j);
                if (!conditionEvaluation.evaluateConditions(this.classCtxt, (Locatable)this, element)) continue;
                nativeInfo.registerLibrary(((StringAnnotationValue)element.getValue("value")).getString());
            }
        }
        this.getDelegate().setInvisibleAnnotations(annotations);
    }

    public void addField(final FieldResolver resolver, int index, String name2, TypeDescriptor descriptor) {
        this.delegate.addField(new FieldResolver(){

            public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
                NativeInfo nativeInfo = NativeInfo.get(ExternExportTypeBuilder.this.ctxt);
                ConditionEvaluation conditionEvaluation = ConditionEvaluation.get((CompilationContext)ExternExportTypeBuilder.this.ctxt);
                FieldElement resolved = resolver.resolveField(index, enclosing, builder);
                String name2 = resolved.getName();
                boolean nameOverridden = false;
                boolean isExtern = false;
                boolean isExport = false;
                for (Annotation annotation : resolved.getInvisibleAnnotations()) {
                    AnnotationValue annotationValue;
                    ClassTypeDescriptor desc = annotation.getDescriptor();
                    if (!desc.getPackageName().equals(Native.NATIVE_PKG)) continue;
                    if (desc.getClassName().equals(Native.ANN_NAME) && !nameOverridden) {
                        annotationValue = annotation.getValue("value");
                        if (!(annotationValue instanceof StringAnnotationValue)) continue;
                        StringAnnotationValue sav = (StringAnnotationValue)annotationValue;
                        if (!conditionEvaluation.evaluateConditions(ExternExportTypeBuilder.this.classCtxt, (Locatable)resolved, annotation)) continue;
                        name2 = sav.getString();
                        nameOverridden = true;
                        continue;
                    }
                    if (desc.getClassName().equals(Native.ANN_NAME_LIST) && !nameOverridden) {
                        annotationValue = annotation.getValue("value");
                        if (!(annotationValue instanceof ArrayAnnotationValue)) continue;
                        ArrayAnnotationValue aav = (ArrayAnnotationValue)annotationValue;
                        int cnt = aav.getElementCount();
                        for (int i = 0; i < cnt; ++i) {
                            AnnotationValue annotationValue2;
                            Annotation nested;
                            ClassTypeDescriptor nestedDesc;
                            AnnotationValue annotationValue3 = aav.getValue(i);
                            if (!(annotationValue3 instanceof Annotation) || !(nestedDesc = (nested = (Annotation)annotationValue3).getDescriptor()).packageAndClassNameEquals(Native.NATIVE_PKG, Native.ANN_NAME) || !((annotationValue2 = nested.getValue("value")) instanceof StringAnnotationValue)) continue;
                            StringAnnotationValue sav = (StringAnnotationValue)annotationValue2;
                            if (!conditionEvaluation.evaluateConditions(ExternExportTypeBuilder.this.classCtxt, (Locatable)resolved, annotation)) continue;
                            name2 = sav.getString();
                            nameOverridden = true;
                        }
                        continue;
                    }
                    if (desc.getClassName().equals(Native.ANN_EXTERN)) {
                        if (isExport) {
                            ExternExportTypeBuilder.this.ctxt.error((Element)resolved, "Field cannot have both `@extern` and `@export", new Object[0]);
                            return resolved;
                        }
                        isExtern = true;
                        continue;
                    }
                    if (!desc.getClassName().equals(Native.ANN_EXPORT)) continue;
                    if (isExtern) {
                        ExternExportTypeBuilder.this.ctxt.error((Element)resolved, "Field cannot have both `@extern` and `@export", new Object[0]);
                        return resolved;
                    }
                    isExport = true;
                }
                if (isExtern) {
                    if (!resolved.isStatic()) {
                        ExternExportTypeBuilder.this.ctxt.error((Element)resolved, "External (imported) fields must be `static`", new Object[0]);
                    }
                    ProgramModule programModule = ExternExportTypeBuilder.this.ctxt.getOrAddProgramModule(enclosing);
                    fieldType = resolved.getType();
                    DataDeclaration decl = programModule.declareData((MemberElement)resolved, name2, fieldType);
                    if (resolved.hasAllModifiersOf(524288)) {
                        decl.setThreadLocalMode(ThreadLocalMode.GENERAL_DYNAMIC);
                    }
                    decl.setLinkage(Linkage.EXTERNAL);
                    this.addExtern(nativeInfo, resolved, decl);
                } else if (isExport) {
                    if (!resolved.isStatic()) {
                        ExternExportTypeBuilder.this.ctxt.error((Element)resolved, "Exported fields must be `static`", new Object[0]);
                    }
                    ModuleSection section = ExternExportTypeBuilder.this.ctxt.getImplicitSection(enclosing);
                    fieldType = resolved.getType();
                    Data data = section.addData((MemberElement)resolved, name2, (Value)ExternExportTypeBuilder.this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(fieldType));
                    if (resolved.hasAllModifiersOf(524288)) {
                        data.setThreadLocalMode(ThreadLocalMode.GENERAL_DYNAMIC);
                    }
                    data.setLinkage(Linkage.EXTERNAL);
                    this.addExport(nativeInfo, resolved, data);
                }
                return resolved;
            }

            private void addExtern(NativeInfo nativeInfo, FieldElement resolved, DataDeclaration decl) {
                ValueType fieldType = resolved.getType();
                nativeInfo.registerFieldInfo(resolved.getEnclosingType().getDescriptor(), resolved.getName(), new NativeDataInfo(resolved, fieldType, ExternExportTypeBuilder.this.ctxt.getLiteralFactory().literalOf((ProgramObject)decl)));
            }

            private void addExport(NativeInfo nativeInfo, FieldElement resolved, Data data) {
                ValueType fieldType = resolved.getType();
                nativeInfo.registerFieldInfo(resolved.getEnclosingType().getDescriptor(), resolved.getName(), new NativeDataInfo(resolved, fieldType, ExternExportTypeBuilder.this.ctxt.getLiteralFactory().literalOf((ProgramObject)data)));
            }
        }, index, name2, descriptor);
    }

    public void addMethod(final MethodResolver resolver, int index, String name2, MethodDescriptor descriptor) {
        this.delegate.addMethod(new MethodResolver(){

            public MethodElement resolveMethod(int index, DefinedTypeDefinition enclosing, MethodElement.Builder builder) {
                NativeInfo nativeInfo = NativeInfo.get(ExternExportTypeBuilder.this.ctxt);
                ConditionEvaluation conditionEvaluation = ConditionEvaluation.get((CompilationContext)ExternExportTypeBuilder.this.ctxt);
                MethodElement origMethod = resolver.resolveMethod(index, enclosing, builder);
                String name2 = origMethod.getName();
                boolean nameOverridden = false;
                boolean isExtern = false;
                boolean isExport = false;
                for (Annotation annotation : origMethod.getInvisibleAnnotations()) {
                    AnnotationValue annotationValue;
                    ClassTypeDescriptor desc = annotation.getDescriptor();
                    if (!desc.getPackageName().equals(Native.NATIVE_PKG)) continue;
                    if (desc.getClassName().equals(Native.ANN_NAME) && !nameOverridden) {
                        annotationValue = annotation.getValue("value");
                        if (!(annotationValue instanceof StringAnnotationValue)) continue;
                        StringAnnotationValue sav = (StringAnnotationValue)annotationValue;
                        if (!conditionEvaluation.evaluateConditions(ExternExportTypeBuilder.this.classCtxt, (Locatable)origMethod, annotation)) continue;
                        name2 = sav.getString();
                        nameOverridden = true;
                        continue;
                    }
                    if (desc.getClassName().equals(Native.ANN_NAME_LIST) && !nameOverridden) {
                        annotationValue = annotation.getValue("value");
                        if (!(annotationValue instanceof ArrayAnnotationValue)) continue;
                        ArrayAnnotationValue aav = (ArrayAnnotationValue)annotationValue;
                        int cnt = aav.getElementCount();
                        for (int i = 0; i < cnt; ++i) {
                            AnnotationValue annotationValue2;
                            Annotation nested;
                            ClassTypeDescriptor nestedDesc;
                            AnnotationValue annotationValue3 = aav.getValue(i);
                            if (!(annotationValue3 instanceof Annotation) || !(nestedDesc = (nested = (Annotation)annotationValue3).getDescriptor()).packageAndClassNameEquals(Native.NATIVE_PKG, Native.ANN_NAME) || !((annotationValue2 = nested.getValue("value")) instanceof StringAnnotationValue)) continue;
                            StringAnnotationValue sav = (StringAnnotationValue)annotationValue2;
                            if (!conditionEvaluation.evaluateConditions(ExternExportTypeBuilder.this.classCtxt, (Locatable)origMethod, annotation)) continue;
                            name2 = sav.getString();
                            nameOverridden = true;
                        }
                        continue;
                    }
                    if (desc.getClassName().equals(Native.ANN_EXTERN)) {
                        if (isExport) {
                            ExternExportTypeBuilder.this.ctxt.error((Element)origMethod, "Method cannot have both `@extern` and `@export", new Object[0]);
                            return origMethod;
                        }
                        isExtern = true;
                        continue;
                    }
                    if (desc.getClassName().equals(Native.ANN_EXPORT)) {
                        if (isExtern) {
                            ExternExportTypeBuilder.this.ctxt.error((Element)origMethod, "Method cannot have both `@extern` and `@export", new Object[0]);
                            return origMethod;
                        }
                        isExport = true;
                        continue;
                    }
                    if (!desc.getClassName().equals(Native.ANN_MACRO)) continue;
                    name2 = this.getFunctionNameFromMacro(origMethod);
                }
                if (!isExtern && !isExport && origMethod.hasAllModifiersOf(256) && ExternExportTypeBuilder.this.hasInclude) {
                    isExtern = true;
                }
                if (name2 != null) {
                    if (isExtern) {
                        this.addExtern(nativeInfo, origMethod, name2);
                    } else if (isExport) {
                        this.addExport(nativeInfo, origMethod, name2);
                    }
                }
                return origMethod;
            }

            private void addExtern(NativeInfo nativeInfo, MethodElement origMethod, String name2) {
                FunctionType type;
                MethodType origType = origMethod.getType();
                TypeSystem ts = ExternExportTypeBuilder.this.classCtxt.getTypeSystem();
                int pc = origType.getParameterCount();
                if (origMethod.isVarargs() && pc > 1) {
                    ValueType[] argTypes = new ValueType[pc];
                    for (int i = 0; i < pc - 1; ++i) {
                        argTypes[i] = origType.getParameterType(i);
                    }
                    argTypes[pc - 1] = ts.getVariadicType();
                    type = ts.getFunctionType(origType.getReturnType(), List.of(argTypes));
                } else {
                    type = ts.getFunctionType(origType.getReturnType(), origType.getParameterTypes());
                }
                origMethod.setModifierFlags(131072);
                nativeInfo.registerFunctionInfo(origMethod.getEnclosingType().getDescriptor(), origMethod.getName(), origMethod.getDescriptor(), new ExternalFunctionInfo(origMethod.getEnclosingType(), name2, type));
            }

            private void addExport(NativeInfo nativeInfo, MethodElement origMethod, String name2) {
                FunctionType fnType;
                boolean constructor2 = false;
                int constructorPriority = 0;
                boolean destructor2 = false;
                int destructorPriority = 0;
                for (Annotation annotation : origMethod.getInvisibleAnnotations()) {
                    ClassTypeDescriptor desc = annotation.getDescriptor();
                    if (!desc.getPackageName().equals(Native.NATIVE_PKG)) continue;
                    IntAnnotationValue priority = (IntAnnotationValue)annotation.getValue("priority");
                    if (desc.getClassName().equals(Native.ANN_CONSTRUCTOR)) {
                        constructor2 = true;
                        constructorPriority = priority == null ? 1000 : priority.intValue();
                        continue;
                    }
                    if (!desc.getClassName().equals(Native.ANN_DESTRUCTOR)) continue;
                    destructor2 = true;
                    destructorPriority = priority == null ? 1000 : priority.intValue();
                }
                FunctionElement.Builder builder = FunctionElement.builder((String)name2, (MethodDescriptor)origMethod.getDescriptor(), (int)origMethod.getIndex());
                builder.setModifiers(origMethod.getModifiers());
                builder.setEnclosingType(origMethod.getEnclosingType());
                builder.setSignature(origMethod.getSignature());
                TypeSystem ts = ExternExportTypeBuilder.this.ctxt.getTypeSystem();
                MethodType origType = origMethod.getType();
                int parameterCount = origType.getParameterCount();
                if (origMethod.isVarargs() && parameterCount > 0 && origType.getParameterType(parameterCount - 1) instanceof ReferenceArrayObjectType) {
                    ValueType[] newParamTypes = new ValueType[parameterCount];
                    for (int i = 0; i < parameterCount - 1; ++i) {
                        newParamTypes[i] = origType.getParameterType(i);
                    }
                    newParamTypes[parameterCount - 1] = ts.getVariadicType();
                    fnType = ts.getFunctionType(origType.getReturnType(), List.of(newParamTypes));
                } else {
                    fnType = ts.getFunctionType(origType.getReturnType(), origType.getParameterTypes());
                }
                builder.setType(fnType);
                builder.setSourceFileName(origMethod.getSourceFileName());
                builder.setParameters(origMethod.getParameters());
                builder.setMinimumLineNumber(origMethod.getMinimumLineNumber());
                builder.setMaximumLineNumber(origMethod.getMaximumLineNumber());
                builder.setMethodBodyFactory(origMethod.getMethodBodyFactory(), origMethod.getMethodBodyFactoryIndex());
                FunctionElement function2 = builder.build();
                nativeInfo.registerFunctionInfo(origMethod.getEnclosingType().getDescriptor(), name2, origMethod.getDescriptor(), new ExportedFunctionInfo(function2));
                ExternExportTypeBuilder.this.ctxt.establishExactFunction((ExecutableElement)origMethod, function2);
                ExternExportTypeBuilder.this.ctxt.registerEntryPoint((ExecutableElement)function2);
                if (constructor2) {
                    nativeInfo.registerGlobalConstructor(function2, constructorPriority);
                }
                if (destructor2) {
                    nativeInfo.registerGlobalDestructor(function2, destructorPriority);
                }
            }

            private String getFunctionNameFromMacro(MethodElement origMethod) {
                CProbe.Result result;
                CProbe.Builder builder = CProbe.builder();
                ProbeUtils.ProbeProcessor pp = new ProbeUtils.ProbeProcessor(ExternExportTypeBuilder.this.classCtxt, (Locatable)origMethod.getEnclosingType());
                for (Annotation annotation : origMethod.getEnclosingType().getInvisibleAnnotations()) {
                    pp.processAnnotation(annotation);
                }
                pp.accept(builder);
                pp = new ProbeUtils.ProbeProcessor(ExternExportTypeBuilder.this.classCtxt, (Locatable)origMethod);
                for (Annotation annotation : origMethod.getInvisibleAnnotations()) {
                    pp.processAnnotation(annotation);
                }
                pp.accept(builder);
                builder.probeMacroFunctionName(origMethod.getName(), origMethod.getSourceFileName(), 0);
                CProbe probe = builder.build();
                try {
                    result = probe.run((CToolChain)ExternExportTypeBuilder.this.ctxt.getAttachment(Driver.C_TOOL_CHAIN_KEY), (ObjectFileProvider)ExternExportTypeBuilder.this.ctxt.getAttachment(Driver.OBJ_PROVIDER_TOOL_KEY), null);
                    if (result == null) {
                        return null;
                    }
                }
                catch (IOException e) {
                    return null;
                }
                CProbe.FunctionInfo functionInfo = result.getFunctionInfo(origMethod.getName());
                String resolvedName = functionInfo.getResolvedName();
                return resolvedName == null || resolvedName.isBlank() ? origMethod.getName() : resolvedName;
            }
        }, index, name2, descriptor);
    }
}

