/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Auto;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.DecodeReference;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Dereference;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.MethodHandleLiteral;
import org.qbicc.graph.literal.ProgramObjectLiteral;
import org.qbicc.object.ProgramObject;
import org.qbicc.plugin.native_.ExportedFunctionInfo;
import org.qbicc.plugin.native_.Native;
import org.qbicc.plugin.native_.NativeDataInfo;
import org.qbicc.plugin.native_.NativeFunctionInfo;
import org.qbicc.plugin.native_.NativeInfo;
import org.qbicc.pointer.Pointer;
import org.qbicc.type.ArrayType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.ValueType;
import org.qbicc.type.VariadicType;
import org.qbicc.type.VoidType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.methodhandle.MethodHandleConstant;
import org.qbicc.type.methodhandle.MethodHandleKind;
import org.qbicc.type.methodhandle.MethodMethodHandleConstant;

public class NativeBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();
    private final ClassTypeDescriptor lambdaMetafactoryDesc;
    private final MethodDescriptor metafactoryDesc;

    public NativeBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
        ClassContext bcc = this.getContext().getBootstrapClassContext();
        this.lambdaMetafactoryDesc = ClassTypeDescriptor.synthesize((ClassContext)bcc, (String)"java/lang/invoke/LambdaMetafactory");
        ClassTypeDescriptor methodHandleDesc = ClassTypeDescriptor.synthesize((ClassContext)bcc, (String)"java/lang/invoke/MethodHandle");
        ClassTypeDescriptor methodTypeDesc = ClassTypeDescriptor.synthesize((ClassContext)bcc, (String)"java/lang/invoke/MethodType");
        ClassTypeDescriptor stringDesc = ClassTypeDescriptor.synthesize((ClassContext)bcc, (String)"java/lang/String");
        ClassTypeDescriptor lookupDesc = ClassTypeDescriptor.synthesize((ClassContext)bcc, (String)"java/lang/invoke/MethodHandles$Lookup");
        ClassTypeDescriptor callSiteDesc = ClassTypeDescriptor.synthesize((ClassContext)bcc, (String)"java/lang/invoke/CallSite");
        this.metafactoryDesc = MethodDescriptor.synthesize((ClassContext)bcc, (TypeDescriptor)callSiteDesc, List.of(lookupDesc, stringDesc, methodTypeDesc, methodTypeDesc, methodHandleDesc, methodTypeDesc));
    }

    public Value loadTypeId(Value objectPointer) {
        if (objectPointer instanceof DecodeReference) {
            return super.loadTypeId(objectPointer);
        }
        return this.getLiteralFactory().literalOfType(objectPointer.getType());
    }

    public Value decodeReference(Value refVal, PointerType pointerType) {
        if (refVal.getType() instanceof ReferenceType) {
            return super.decodeReference(refVal, pointerType);
        }
        ValueType valueType = refVal.getType();
        if (valueType instanceof PointerType) {
            PointerType rpt = (PointerType)valueType;
            if (pointerType.getPointeeType() instanceof VoidType || pointerType.equals(rpt)) {
                return refVal;
            }
            return this.getFirstBuilder().bitCast(refVal, (WordType)pointerType);
        }
        return refVal;
    }

    public Value new_(ClassTypeDescriptor desc) {
        ClassContext classContext = this.getCurrentClassContext();
        DefinedTypeDefinition def = classContext.findDefinedType(desc.getPackageName() + "/" + desc.getClassName());
        if (def != null) {
            ValueType nativeType = NativeInfo.get(this.ctxt).getNativeType(def);
            if (nativeType instanceof VariadicType) {
                return super.new_(desc);
            }
            if (nativeType != null) {
                return this.getFirstBuilder().auto((Value)this.getLiteralFactory().zeroInitializerLiteralOfType(nativeType));
            }
        }
        return super.new_(desc);
    }

    public Value newArray(ArrayTypeDescriptor atd, Value size2) {
        ValueType nativeType;
        ClassTypeDescriptor desc;
        DefinedTypeDefinition def;
        ClassContext classContext = this.getCurrentClassContext();
        TypeDescriptor etd = atd.getElementTypeDescriptor();
        if (etd instanceof ClassTypeDescriptor && (def = classContext.findDefinedType((desc = (ClassTypeDescriptor)etd).getPackageName() + "/" + desc.getClassName())) != null && (nativeType = NativeInfo.get(this.ctxt).getNativeType(def)) != null) {
            if (size2 instanceof IntegerLiteral) {
                IntegerLiteral lit = (IntegerLiteral)size2;
                return this.getFirstBuilder().auto((Value)this.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)this.getTypeSystem().getArrayType(nativeType, lit.longValue())));
            }
            this.ctxt.error(this.getLocation(), "Non-constant array length for native types not supported", new Object[0]);
            throw new BlockEarlyTermination(this.unreachable());
        }
        return super.newArray(atd, size2);
    }

    public Value loadLength(Value arrayPointer) {
        ValueType valueType = arrayPointer.getType();
        if (valueType instanceof ArrayType) {
            ArrayType at = (ArrayType)valueType;
            return this.getLiteralFactory().literalOf((IntegerType)this.getTypeSystem().getSignedInteger32Type(), at.getElementCount());
        }
        return super.loadLength(arrayPointer);
    }

    public Value checkcast(Value value, TypeDescriptor desc) {
        if (value instanceof Auto) {
            Auto auto = (Auto)value;
            return auto;
        }
        if (desc instanceof ClassTypeDescriptor) {
            ClassTypeDescriptor ctd = (ClassTypeDescriptor)desc;
            if (ctd.packageAndClassNameEquals(Native.NATIVE_PKG, Native.WORD)) {
                if (!(value.getType() instanceof WordType)) {
                    this.ctxt.error(this.getLocation(), "Invalid cast of non-word type %s to word type", new Object[]{value.getType()});
                }
                return value;
            }
            if (ctd.packageAndClassNameEquals(Native.NATIVE_PKG, Native.OBJECT)) {
                return value;
            }
            return super.checkcast(value, (TypeDescriptor)this.deNative(ctd));
        }
        return super.checkcast(value, desc);
    }

    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.call(targetPtr, receiver, this.mapArguments(targetPtr, arguments));
    }

    public Value callNoSideEffects(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.callNoSideEffects(targetPtr, receiver, this.mapArguments(targetPtr, arguments));
    }

    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.callNoReturn(targetPtr, receiver, this.mapArguments(targetPtr, arguments));
    }

    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        return super.invokeNoReturn(targetPtr, receiver, this.mapArguments(targetPtr, arguments), catchLabel, targetArguments);
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.tailCall(targetPtr, receiver, this.mapArguments(targetPtr, arguments));
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        return super.invoke(targetPtr, receiver, this.mapArguments(targetPtr, arguments), catchLabel, resumeLabel, targetArguments);
    }

    private List<Value> mapArguments(Value targetPtr, List<Value> arguments) {
        FunctionType fnType;
        ValueType valueType = targetPtr.getPointeeType();
        if (valueType instanceof FunctionType && (fnType = (FunctionType)valueType).isVariadic()) {
            ArrayType at;
            int size2 = arguments.size();
            if (size2 < 1) {
                throw new IllegalStateException("Unexpected argument list size");
            }
            int pc = fnType.getParameterCount();
            if (size2 != pc) {
                throw new IllegalStateException("Argument list size does not match function prototype size");
            }
            Value varArgArray = arguments.get(size2 - 1);
            ValueType valueType2 = varArgArray.getType();
            if (valueType2 instanceof ArrayType && (at = (ArrayType)valueType2).getElementType() instanceof VariadicType) {
                long varCnt = at.getElementCount();
                ArrayList<Value> realArgs = new ArrayList<Value>((int)((long)(pc - 1) + varCnt));
                for (int i = 0; i < size2 - 1; ++i) {
                    realArgs.add(arguments.get(i));
                }
                LiteralFactory lf = this.ctxt.getLiteralFactory();
                int i = 0;
                while ((long)i < varCnt) {
                    realArgs.add(varArgArray.extractElement(lf, (Value)lf.literalOf(i)));
                    ++i;
                }
                return realArgs;
            }
            this.ctxt.error(this.getLocation(), "Variadic function argument type must be `CNative.object...`", new Object[0]);
        }
        return arguments;
    }

    public Value resolveStaticMethod(TypeDescriptor owner, String name2, MethodDescriptor descriptor) {
        NativeInfo nativeInfo = NativeInfo.get(this.ctxt);
        NativeFunctionInfo functionInfo = nativeInfo.getFunctionInfo(owner, name2, descriptor);
        if (functionInfo != null) {
            if (functionInfo instanceof ExportedFunctionInfo) {
                ExportedFunctionInfo efi = (ExportedFunctionInfo)functionInfo;
                DefinedTypeDefinition declaringClass = efi.getDeclaringClass();
                if (this.getRootElement().getEnclosingType() == declaringClass) {
                    return this.getLiteralFactory().literalOf(efi.getFunctionElement());
                }
            }
            return this.ctxt.getLiteralFactory().literalOf((ProgramObject)this.ctxt.getOrAddProgramModule((MemberElement)this.getRootElement()).declareFunction(null, functionInfo.getName(), functionInfo.getType(), 4));
        }
        return super.resolveStaticMethod(owner, name2, this.deNative(descriptor));
    }

    public Value resolveInstanceMethod(TypeDescriptor owner, String name2, MethodDescriptor descriptor) {
        return super.resolveInstanceMethod(this.deNative(owner), name2, this.deNative(descriptor));
    }

    public Value lookupVirtualMethod(Value reference2, TypeDescriptor owner, String name2, MethodDescriptor descriptor) {
        Dereference d;
        if (reference2 instanceof Dereference && (d = (Dereference)reference2).getType() instanceof FunctionType) {
            return d.getPointer();
        }
        return super.lookupVirtualMethod(reference2, this.deNative(owner), name2, this.deNative(descriptor));
    }

    public Value lookupVirtualMethod(Value reference2, InstanceMethodElement method) {
        Dereference d;
        if (reference2 instanceof Dereference && (d = (Dereference)reference2).getType() instanceof FunctionType) {
            return d.getPointer();
        }
        if (NativeInfo.get(this.ctxt).isNativeType(method.getEnclosingType())) {
            return this.getLiteralFactory().literalOf(method);
        }
        return super.lookupVirtualMethod(reference2, method);
    }

    public Value lookupInterfaceMethod(Value reference2, TypeDescriptor owner, String name2, MethodDescriptor descriptor) {
        Dereference d;
        if (reference2 instanceof Dereference && (d = (Dereference)reference2).getType() instanceof FunctionType) {
            return d.getPointer();
        }
        return super.lookupInterfaceMethod(reference2, this.deNative(owner), name2, this.deNative(descriptor));
    }

    public Value lookupInterfaceMethod(Value reference2, InstanceMethodElement method) {
        Dereference d;
        if (reference2 instanceof Dereference && (d = (Dereference)reference2).getType() instanceof FunctionType) {
            return d.getPointer();
        }
        if (NativeInfo.get(this.ctxt).isNativeType(method.getEnclosingType())) {
            return this.getLiteralFactory().literalOf(method);
        }
        return super.lookupInterfaceMethod(reference2, method);
    }

    public Value resolveConstructor(TypeDescriptor owner, MethodDescriptor descriptor) {
        return super.resolveConstructor(this.deNative(owner), this.deNative(descriptor));
    }

    public Value resolveStaticField(TypeDescriptor owner, String name2, TypeDescriptor type) {
        NativeInfo nativeInfo = NativeInfo.get(this.ctxt);
        NativeDataInfo fieldInfo = nativeInfo.getFieldInfo(owner, name2);
        if (fieldInfo != null) {
            return this.getAndDeclareSymbolLiteral(fieldInfo);
        }
        return super.resolveStaticField(this.deNative(owner), name2, this.deNative(type));
    }

    public Value instanceFieldOf(Value instancePointer, TypeDescriptor owner, String name2, TypeDescriptor type) {
        return super.instanceFieldOf(instancePointer, this.deNative(owner), name2, this.deNative(type));
    }

    public Value invokeDynamic(MethodMethodHandleConstant bootstrapHandle, List<Literal> bootstrapArgs, String name2, MethodDescriptor descriptor, List<Value> arguments) {
        MethodMethodHandleConstant mhc;
        MethodHandleLiteral mhl;
        MethodHandleConstant methodHandleConstant;
        Literal literal;
        if (bootstrapHandle.getOwnerDescriptor().equals(this.lambdaMetafactoryDesc) && bootstrapHandle.getMethodName().equals("metafactory") && bootstrapHandle.getDescriptor().equals(this.metafactoryDesc) && (literal = bootstrapArgs.get(bootstrapArgs.size() - 2)) instanceof MethodHandleLiteral && (methodHandleConstant = (mhl = (MethodHandleLiteral)literal).getMethodHandleConstant()) instanceof MethodMethodHandleConstant && (mhc = (MethodMethodHandleConstant)methodHandleConstant).getKind() == MethodHandleKind.INVOKE_STATIC) {
            ClassTypeDescriptor owner = mhc.getOwnerDescriptor();
            String packageName = owner.getPackageName();
            Object intName = packageName.isEmpty() ? owner.getClassName() : packageName + "/" + owner.getClassName();
            this.getCurrentClassContext().findDefinedType((String)intName).load();
            String targetMethodName = mhc.getMethodName();
            NativeInfo nativeInfo = NativeInfo.get(this.ctxt);
            NativeFunctionInfo functionInfo = nativeInfo.getFunctionInfo((TypeDescriptor)owner, targetMethodName, mhc.getDescriptor());
            if (functionInfo != null) {
                ExecutableElement currentElement = this.getCurrentElement();
                return this.deref((Value)this.getLiteralFactory().literalOf((ProgramObject)this.ctxt.getOrAddProgramModule((MemberElement)currentElement).declareFunction(currentElement, functionInfo.getName(), functionInfo.getType())));
            }
        }
        return super.invokeDynamic(bootstrapHandle, bootstrapArgs, name2, descriptor, arguments);
    }

    MethodDescriptor deNative(MethodDescriptor md) {
        int cnt;
        TypeDescriptor fixedReturnType;
        block3: {
            TypeDescriptor returnType = md.getReturnType();
            if (returnType == (fixedReturnType = this.deNative(returnType))) {
                for (TypeDescriptor parameterType : md.getParameterTypes()) {
                    if (parameterType == this.deNative(parameterType)) continue;
                    break block3;
                }
                return md;
            }
        }
        List<TypeDescriptor> newParamTypes = (cnt = md.getParameterTypes().size()) == 0 ? List.of() : Arrays.asList(new TypeDescriptor[cnt]);
        for (TypeDescriptor parameterType : md.getParameterTypes()) {
            newParamTypes.add(this.deNative(parameterType));
        }
        ClassContext cc = this.getRootElement().getEnclosingType().getContext();
        return MethodDescriptor.synthesize((ClassContext)cc, (TypeDescriptor)fixedReturnType, newParamTypes);
    }

    TypeDescriptor deNative(TypeDescriptor td) {
        TypeDescriptor typeDescriptor;
        if (td instanceof ClassTypeDescriptor) {
            ClassTypeDescriptor ctd = (ClassTypeDescriptor)td;
            typeDescriptor = this.deNative(ctd);
        } else {
            typeDescriptor = td;
        }
        return typeDescriptor;
    }

    ClassTypeDescriptor deNative(ClassTypeDescriptor ctd) {
        ClassContext cc = this.getRootElement().getEnclosingType().getContext();
        String className = ctd.getClassName();
        if (className.endsWith("$_native")) {
            String packageName = ctd.getPackageName();
            String newClassName = className.substring(0, className.length() - 8);
            return ClassTypeDescriptor.synthesize((ClassContext)cc, (String)(packageName.isEmpty() ? newClassName : packageName + "/" + newClassName));
        }
        return ctd;
    }

    private Literal getAndDeclareSymbolLiteral(NativeDataInfo fieldInfo) {
        ProgramObjectLiteral sym = fieldInfo.symbolLiteral;
        DefinedTypeDefinition ourType = this.getRootElement().getEnclosingType();
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        return lf.literalOf((Pointer)this.ctxt.getOrAddProgramModule(ourType).declareData(sym.getProgramObject()).getPointer());
    }
}

