/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import java.util.List;
import org.qbicc.context.CompilationContext;
import org.qbicc.object.Function;
import org.qbicc.object.GlobalXtor;
import org.qbicc.object.ProgramModule;
import org.qbicc.plugin.native_.NativeInfo;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FunctionElement;

public final class NativeXtorLoweringHook {
    private NativeXtorLoweringHook() {
    }

    public static void process(CompilationContext ctxt) {
        NativeInfo nativeInfo = NativeInfo.get(ctxt);
        NativeXtorLoweringHook.processOneList(ctxt, nativeInfo.getGlobalConstructors(), ProgramModule::addConstructor);
        NativeXtorLoweringHook.processOneList(ctxt, nativeInfo.getGlobalDestructors(), ProgramModule::addDestructor);
    }

    private static void processOneList(CompilationContext ctxt, List<NativeInfo.FunctionAndPriority> xtors, AddMethod method) {
        for (NativeInfo.FunctionAndPriority xtor : xtors) {
            FunctionElement functionElement = xtor.function();
            DefinedTypeDefinition enclosingType = functionElement.getEnclosingType();
            Function fn = ctxt.getExactFunctionIfExists((ExecutableElement)functionElement);
            if (fn == null) {
                ctxt.error((Element)functionElement, "No lowered function for entry point element", new Object[0]);
                continue;
            }
            ProgramModule programModule = ctxt.getOrAddProgramModule(enclosingType);
            if (programModule == null) {
                ctxt.error((Element)functionElement, "No program module for reachable element", new Object[0]);
                continue;
            }
            method.add(programModule, fn, xtor.priority());
        }
    }

    @FunctionalInterface
    static interface AddMethod {
        public GlobalXtor add(ProgramModule var1, Function var2, int var3);
    }
}

