/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.type.ArrayType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.PointerType;
import org.qbicc.type.Type;
import org.qbicc.type.ValueType;
import org.qbicc.type.VariadicType;
import org.qbicc.type.VoidType;
import org.qbicc.type.WordType;

public class PointerBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();

    public PointerBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value decodeReference(Value reference, PointerType pointerType) {
        ValueType valueType = reference.getType();
        if (valueType instanceof PointerType) {
            PointerType pt = (PointerType)valueType;
            return pt.equals(pointerType) ? reference : this.getFirstBuilder().bitCast(reference, (WordType)pointerType);
        }
        if (reference.getType() instanceof ArrayType) {
            this.ctxt.error(this.getLocation(), "Cannot directly reference an array", new Object[0]);
            throw new BlockEarlyTermination(this.unreachable());
        }
        return super.decodeReference(reference, pointerType);
    }

    private Value castVoidPointer(Value value, ValueType toType) {
        if (toType instanceof PointerType) {
            PointerType outputPtr = (PointerType)toType;
            ValueType valueType = value.getType();
            if (valueType instanceof PointerType) {
                PointerType inputPtr = (PointerType)valueType;
                if (inputPtr.getPointeeType() instanceof VoidType || outputPtr.getPointeeType() instanceof VoidType) {
                    return this.getFirstBuilder().bitCast(value, (WordType)outputPtr);
                }
                if (!outputPtr.getPointeeType().isImplicitlyConvertibleFrom((Type)inputPtr.getPointeeType())) {
                    this.ctxt.error(this.getLocation(), "Invalid pointer conversion from %s to %s", new Object[]{inputPtr, outputPtr});
                }
            }
        }
        return value;
    }

    private List<Value> castVoidPointers(List<Value> arguments, Value target) {
        int sz = arguments.size();
        InvokableType callSiteType = (InvokableType)target.getPointeeType(InvokableType.class);
        int parameterCount = callSiteType.getParameterCount();
        int actualCnt = parameterCount > 0 && callSiteType.getLastParameterType(0) instanceof VariadicType ? parameterCount - 1 : sz;
        for (int i = 0; i < actualCnt; ++i) {
            int j;
            Value arg = arguments.get(i);
            if (arg == this.castVoidPointer(arg, callSiteType.getParameterType(i))) continue;
            ArrayList<Value> newArgs = new ArrayList<Value>(sz);
            for (j = 0; j < actualCnt; ++j) {
                newArgs.add(this.castVoidPointer(arguments.get(j), callSiteType.getParameterType(j)));
            }
            while (j < sz) {
                newArgs.add(arguments.get(j));
                ++j;
            }
            return newArgs;
        }
        return arguments;
    }

    public Node store(Value pointer, Value value, WriteAccessMode accessMode) {
        return super.store(pointer, this.castVoidPointer(value, pointer.getPointeeType()), accessMode);
    }

    public Value cmpAndSwap(Value pointer, Value expect, Value update, ReadAccessMode readMode, WriteAccessMode writeMode, CmpAndSwap.Strength strength) {
        return super.cmpAndSwap(pointer, this.castVoidPointer(expect, pointer.getPointeeType()), this.castVoidPointer(update, pointer.getPointeeType()), readMode, writeMode, strength);
    }

    public Value readModifyWrite(Value pointer, ReadModifyWrite.Op op, Value update, ReadAccessMode readMode, WriteAccessMode writeMode) {
        return super.readModifyWrite(pointer, op, this.castVoidPointer(update, pointer.getPointeeType()), readMode, writeMode);
    }

    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.call(targetPtr, receiver, this.castVoidPointers(arguments, targetPtr));
    }

    public Value callNoSideEffects(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.callNoSideEffects(targetPtr, receiver, this.castVoidPointers(arguments, targetPtr));
    }

    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.callNoReturn(targetPtr, receiver, this.castVoidPointers(arguments, targetPtr));
    }

    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        return super.invokeNoReturn(targetPtr, receiver, this.castVoidPointers(arguments, targetPtr), catchLabel, targetArguments);
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        return super.invoke(targetPtr, receiver, this.castVoidPointers(arguments, targetPtr), catchLabel, resumeLabel, targetArguments);
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.tailCall(targetPtr, receiver, this.castVoidPointers(arguments, targetPtr));
    }
}

