/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.native_.Native;
import org.qbicc.runtime.CNative;
import org.qbicc.type.ArrayType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.IntAnnotationValue;
import org.qbicc.type.definition.DescriptorTypeResolver;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.AnyTypeArgument;
import org.qbicc.type.generic.ArrayTypeSignature;
import org.qbicc.type.generic.BaseTypeSignature;
import org.qbicc.type.generic.BoundTypeArgument;
import org.qbicc.type.generic.ClassTypeSignature;
import org.qbicc.type.generic.ReferenceTypeSignature;
import org.qbicc.type.generic.TopLevelClassTypeSignature;
import org.qbicc.type.generic.TypeArgument;
import org.qbicc.type.generic.TypeParameter;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;
import org.qbicc.type.generic.TypeVariableSignature;
import org.qbicc.type.generic.Variance;

public class PointerTypeResolver
implements DescriptorTypeResolver.Delegating {
    private final ClassTypeDescriptor restrictAnnotation;
    private final ClassTypeDescriptor arraySizeAnnotation;
    private final ClassContext classCtxt;
    private final CompilationContext ctxt;
    private final DescriptorTypeResolver delegate;

    public PointerTypeResolver(ClassContext classCtxt, DescriptorTypeResolver delegate) {
        this.classCtxt = classCtxt;
        this.ctxt = classCtxt.getCompilationContext();
        this.delegate = delegate;
        this.restrictAnnotation = ClassTypeDescriptor.synthesize((ClassContext)classCtxt, (String)Native.ANN_RESTRICT);
        this.arraySizeAnnotation = ClassTypeDescriptor.synthesize((ClassContext)classCtxt, (String)Native.ANN_ARRAY_SIZE);
    }

    public DescriptorTypeResolver getDelegate() {
        return this.delegate;
    }

    public ValueType resolveTypeFromClassName(String packageName, String internalName) {
        if (packageName.equals(Native.NATIVE_PKG) && internalName.equals(Native.PTR)) {
            return this.ctxt.getTypeSystem().getVoidType().getPointer();
        }
        return this.getDelegate().resolveTypeFromClassName(packageName, internalName);
    }

    public ValueType resolveTypeFromDescriptor(TypeDescriptor descriptor, TypeParameterContext paramCtxt, TypeSignature signature) {
        boolean restrict2;
        block14: {
            block13: {
                PointerType pointerType;
                block18: {
                    block15: {
                        ValueType pointeeType;
                        List args;
                        ClassTypeSignature sig;
                        block19: {
                            block17: {
                                block16: {
                                    restrict2 = signature.hasAnnotation(this.restrictAnnotation);
                                    if (!(descriptor instanceof ClassTypeDescriptor)) break block13;
                                    ClassTypeDescriptor ctd = (ClassTypeDescriptor)descriptor;
                                    if (!ctd.getPackageName().equals(Native.NATIVE_PKG) || !ctd.getClassName().equals(Native.PTR)) break block14;
                                    if (!(signature instanceof ClassTypeSignature)) break block15;
                                    sig = (ClassTypeSignature)signature;
                                    if (sig.getIdentifier().equals(Native.PTR)) break block16;
                                    this.ctxt.warning("Incorrect generic signature (expected a %s but got \"%s\")", new Object[]{CNative.ptr.class, sig});
                                    break block14;
                                }
                                args = sig.getTypeArguments();
                                if (args.size() != 0) break block17;
                                pointerType = this.ctxt.getTypeSystem().getVoidType().getPointer();
                                break block18;
                            }
                            if (args.size() == 1) break block19;
                            this.ctxt.warning("Incorrect number of generic signature arguments (expected a %s but got \"%s\")", new Object[]{CNative.ptr.class, sig});
                            break block14;
                        }
                        TypeArgument typeArgument = (TypeArgument)args.get(0);
                        if (typeArgument instanceof AnyTypeArgument) {
                            pointeeType = this.classCtxt.resolveTypeFromDescriptor((TypeDescriptor)BaseTypeDescriptor.V, paramCtxt, (TypeSignature)BaseTypeSignature.V);
                        } else {
                            assert (typeArgument instanceof BoundTypeArgument);
                            BoundTypeArgument bound = (BoundTypeArgument)typeArgument;
                            if (bound.getVariance() == Variance.INVARIANT) {
                                ReferenceTypeSignature pointeeSig = bound.getBound();
                                TypeDescriptor pointeeDesc = pointeeSig.asDescriptor(this.classCtxt);
                                pointeeType = this.classCtxt.resolveTypeFromDescriptor(pointeeDesc, paramCtxt, (TypeSignature)pointeeSig);
                            } else {
                                this.ctxt.warning("Incorrect number of generic signature arguments (expected a %s but got \"%s\")", new Object[]{CNative.ptr.class, sig});
                                pointeeType = this.classCtxt.resolveTypeFromDescriptor((TypeDescriptor)BaseTypeDescriptor.V, paramCtxt, (TypeSignature)BaseTypeSignature.V);
                            }
                        }
                        pointerType = pointeeType.getPointer();
                        break block18;
                    }
                    if (signature instanceof TypeVariableSignature) {
                        TopLevelClassTypeSignature sig;
                        TypeVariableSignature tvs = (TypeVariableSignature)signature;
                        TypeParameter resolved = paramCtxt.resolveTypeParameter(tvs.getIdentifier());
                        ReferenceTypeSignature classBound = resolved.getClassBound();
                        if (classBound instanceof TopLevelClassTypeSignature && (sig = (TopLevelClassTypeSignature)classBound).getIdentifier().equals(Native.PTR)) {
                            return this.resolveTypeFromMethodDescriptor(descriptor, paramCtxt, (TypeSignature)sig);
                        }
                        pointerType = this.ctxt.getTypeSystem().getVoidType().getPointer();
                    } else {
                        this.ctxt.warning("Generic signature type mismatch (expected a %s but got a %s)", new Object[]{ClassTypeSignature.class, signature.getClass()});
                        pointerType = this.ctxt.getTypeSystem().getVoidType().getPointer();
                    }
                }
                return restrict2 ? pointerType.asRestrict() : pointerType;
            }
            if (descriptor instanceof ArrayTypeDescriptor) {
                ClassTypeDescriptor ctd;
                TypeSignature elemSig;
                TypeDescriptor elemDesc = ((ArrayTypeDescriptor)descriptor).getElementTypeDescriptor();
                ValueType elemType = this.classCtxt.resolveTypeFromDescriptor(elemDesc, paramCtxt, elemSig = signature instanceof ArrayTypeSignature ? ((ArrayTypeSignature)signature).getElementTypeSignature() : TypeSignature.synthesize((ClassContext)this.classCtxt, (TypeDescriptor)elemDesc));
                if (elemType instanceof ArrayType) {
                    return this.ctxt.getTypeSystem().getArrayType(elemType, (long)this.detectArraySize(signature));
                }
                if (!(elemType instanceof ObjectType) && elemDesc instanceof ClassTypeDescriptor) {
                    return this.ctxt.getTypeSystem().getArrayType(elemType, (long)this.detectArraySize(signature));
                }
                if (elemDesc instanceof ClassTypeDescriptor && (ctd = (ClassTypeDescriptor)elemDesc).packageAndClassNameEquals(Native.NATIVE_PKG, Native.REFERENCE)) {
                    return this.ctxt.getTypeSystem().getArrayType((ValueType)((ObjectType)elemType).getReference(), (long)this.detectArraySize(signature));
                }
            }
        }
        if (restrict2) {
            this.ctxt.error("Only pointers can have `restrict` qualifier (\"%s\" \"%s\")", new Object[]{descriptor, signature});
        }
        return this.getDelegate().resolveTypeFromDescriptor(descriptor, paramCtxt, signature);
    }

    private int detectArraySize(TypeSignature visibleAnnotations) {
        Annotation annotation = visibleAnnotations.getAnnotation(this.arraySizeAnnotation);
        if (annotation == null) {
            return 0;
        }
        AnnotationValue value = annotation.getValue("value");
        if (value instanceof IntAnnotationValue) {
            IntAnnotationValue iav = (IntAnnotationValue)value;
            return iav.intValue();
        }
        return 0;
    }

    public ValueType resolveTypeFromMethodDescriptor(TypeDescriptor descriptor, TypeParameterContext paramCtxt, TypeSignature signature) {
        return this.deArray(this.getDelegate().resolveTypeFromMethodDescriptor(descriptor, paramCtxt, signature));
    }

    private ValueType deArray(ValueType orig) {
        return orig instanceof ArrayType ? this.deArray(((ArrayType)orig).getElementType()).getPointer() : orig;
    }
}

