/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.native_;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Locatable;
import org.qbicc.machine.probe.CProbe;
import org.qbicc.plugin.core.ConditionEvaluation;
import org.qbicc.plugin.native_.Native;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.ArrayAnnotationValue;
import org.qbicc.type.annotation.StringAnnotationValue;
import org.qbicc.type.descriptor.ClassTypeDescriptor;

final class ProbeUtils {
    private ProbeUtils() {
    }

    static final class ProbeProcessor
    implements Consumer<CProbe.Builder> {
        private final ClassContext classContext;
        private final Locatable locatable;
        private List<Annotation> defines = List.of();
        private List<Annotation> undefs = List.of();
        private List<Annotation> includes = List.of();

        ProbeProcessor(ClassContext classContext, Locatable locatable) {
            this.classContext = classContext;
            this.locatable = locatable;
        }

        public boolean processAnnotation(Annotation annotation) {
            ClassTypeDescriptor annDesc = annotation.getDescriptor();
            if (annDesc.getPackageName().equals(Native.NATIVE_PKG)) {
                if (annDesc.getClassName().equals(Native.ANN_INCLUDE)) {
                    this.processInclude(annotation);
                    return true;
                }
                if (annDesc.getClassName().equals(Native.ANN_INCLUDE_LIST)) {
                    ArrayAnnotationValue array = (ArrayAnnotationValue)annotation.getValue("value");
                    int cnt = array.getElementCount();
                    for (int j = 0; j < cnt; ++j) {
                        this.processInclude((Annotation)array.getValue(j));
                    }
                    return true;
                }
                if (annDesc.getClassName().equals(Native.ANN_DEFINE)) {
                    this.processDefine(annotation);
                    return true;
                }
                if (annDesc.getClassName().equals(Native.ANN_DEFINE_LIST)) {
                    ArrayAnnotationValue array = (ArrayAnnotationValue)annotation.getValue("value");
                    int cnt = array.getElementCount();
                    for (int j = 0; j < cnt; ++j) {
                        this.processDefine((Annotation)array.getValue(j));
                    }
                    return true;
                }
                if (annDesc.getClassName().equals(Native.ANN_UNDEF)) {
                    this.processUndef(annotation);
                    return true;
                }
                if (annDesc.getClassName().equals(Native.ANN_UNDEF_LIST)) {
                    ArrayAnnotationValue array = (ArrayAnnotationValue)annotation.getValue("value");
                    int cnt = array.getElementCount();
                    for (int j = 0; j < cnt; ++j) {
                        this.processUndef((Annotation)array.getValue(j));
                    }
                    return true;
                }
            }
            return false;
        }

        private void processInclude(Annotation annotation) {
            if (this.includes.isEmpty()) {
                this.includes = List.of(annotation);
            } else if (this.includes.size() == 1) {
                this.includes = List.of(this.includes.get(0), annotation);
            } else if (this.includes.size() == 2) {
                this.includes = new ArrayList<Annotation>(this.includes);
                this.includes.add(annotation);
            } else {
                this.includes.add(annotation);
            }
        }

        private void processDefine(Annotation annotation) {
            if (this.defines.isEmpty()) {
                this.defines = List.of(annotation);
            } else if (this.defines.size() == 1) {
                this.defines = List.of(this.defines.get(0), annotation);
            } else if (this.defines.size() == 2) {
                this.defines = new ArrayList<Annotation>(this.defines);
                this.defines.add(annotation);
            } else {
                this.defines.add(annotation);
            }
        }

        private void processUndef(Annotation annotation) {
            if (this.undefs.isEmpty()) {
                this.undefs = List.of(annotation);
            } else if (this.undefs.size() == 1) {
                this.undefs = List.of(this.undefs.get(0), annotation);
            } else if (this.undefs.size() == 2) {
                this.undefs = new ArrayList<Annotation>(this.undefs);
                this.undefs.add(annotation);
            } else {
                this.undefs.add(annotation);
            }
        }

        @Override
        public void accept(CProbe.Builder builder) {
            String str;
            for (Annotation define2 : this.defines) {
                str = ((StringAnnotationValue)define2.getValue("value")).getString();
                if (!ConditionEvaluation.get((CompilationContext)this.classContext.getCompilationContext()).evaluateConditions(this.classContext, this.locatable, define2)) continue;
                AnnotationValue annotationValue = define2.getValue("as");
                if (annotationValue instanceof StringAnnotationValue) {
                    StringAnnotationValue asStr = (StringAnnotationValue)annotationValue;
                    builder.define(str, asStr.getString());
                    continue;
                }
                builder.define(str);
            }
            for (Annotation undef2 : this.undefs) {
                str = ((StringAnnotationValue)undef2.getValue("value")).getString();
                if (!ConditionEvaluation.get((CompilationContext)this.classContext.getCompilationContext()).evaluateConditions(this.classContext, this.locatable, undef2)) continue;
                builder.undef(str);
            }
            for (Annotation include2 : this.includes) {
                str = ((StringAnnotationValue)include2.getValue("value")).getString();
                if (!ConditionEvaluation.get((CompilationContext)this.classContext.getCompilationContext()).evaluateConditions(this.classContext, this.locatable, include2)) continue;
                builder.include(str);
            }
        }
    }
}

