/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.patcher;

import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Locatable;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmThread;
import org.qbicc.plugin.core.ConditionEvaluation;
import org.qbicc.plugin.patcher.Patcher;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.ValueType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.ArrayAnnotationValue;
import org.qbicc.type.annotation.ClassAnnotationValue;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;

public final class AccessorTypeBuilder
implements DefinedTypeDefinition.Builder.Delegating {
    private final DefinedTypeDefinition.Builder delegate;
    private final ClassContext classContext;

    public AccessorTypeBuilder(ClassContext classContext, DefinedTypeDefinition.Builder delegate) {
        this.classContext = classContext;
        this.delegate = delegate;
    }

    public DefinedTypeDefinition.Builder getDelegate() {
        return this.delegate;
    }

    public void addField(final FieldResolver resolver, int index, String name, TypeDescriptor descriptor) {
        this.getDelegate().addField(new FieldResolver(){

            public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
                CompilationContext ctxt = AccessorTypeBuilder.this.classContext.getCompilationContext();
                ConditionEvaluation ce = ConditionEvaluation.get((CompilationContext)ctxt);
                FieldElement fieldElement = resolver.resolveField(index, enclosing, builder);
                if (fieldElement.isStatic()) {
                    VmObject accessor = null;
                    for (Annotation annotation : fieldElement.getInvisibleAnnotations()) {
                        AnnotationValue annotationValue;
                        ClassTypeDescriptor annDesc = annotation.getDescriptor();
                        if (annDesc.packageAndClassNameEquals("org/qbicc/runtime/patcher", "AccessWith$List") && (annotationValue = annotation.getValue("value")) instanceof ArrayAnnotationValue) {
                            ArrayAnnotationValue array = (ArrayAnnotationValue)annotationValue;
                            int cnt = array.getElementCount();
                            for (int i = 0; i < cnt; ++i) {
                                Annotation nested;
                                AnnotationValue annotationValue2 = array.getValue(i);
                                if (!(annotationValue2 instanceof Annotation) || !(nested = (Annotation)annotationValue2).getDescriptor().packageAndClassNameEquals("org/qbicc/runtime/patcher", "AccessWith") || !ce.evaluateConditions(AccessorTypeBuilder.this.classContext, (Locatable)fieldElement, nested)) continue;
                                if (accessor != null) {
                                    ctxt.error((Element)fieldElement, "Only one accessor may be active on a field at a time", new Object[0]);
                                    continue;
                                }
                                accessor = this.createAccessor(fieldElement, nested);
                            }
                            continue;
                        }
                        if (!annDesc.packageAndClassNameEquals("org/qbicc/runtime/patcher", "AccessWith")) continue;
                        if (accessor != null) {
                            ctxt.error((Element)fieldElement, "Only one accessor may be active on a field at a time", new Object[0]);
                            continue;
                        }
                        accessor = this.createAccessor(fieldElement, annotation);
                    }
                    if (accessor != null) {
                        Patcher.get(ctxt).registerAccessor(fieldElement, accessor);
                    }
                }
                return fieldElement;
            }

            private VmObject createAccessor(FieldElement fieldElement, Annotation annotation) {
                ClassAnnotationValue value = (ClassAnnotationValue)annotation.getValue("value");
                TypeDescriptor desc = value.getDescriptor();
                ValueType valueType = AccessorTypeBuilder.this.classContext.resolveTypeFromDescriptor(desc, TypeParameterContext.EMPTY, TypeSignature.synthesize((ClassContext)AccessorTypeBuilder.this.classContext, (TypeDescriptor)desc));
                if (valueType instanceof ClassObjectType) {
                    ClassObjectType cot = (ClassObjectType)valueType;
                    VmThread vmThread = Vm.requireCurrentThread();
                    LoadedTypeDefinition definition = cot.getDefinition().load();
                    ObjectType accessorInterface = AccessorTypeBuilder.this.classContext.getCompilationContext().getBootstrapClassContext().findDefinedType("org/qbicc/runtime/patcher/Accessor").load().getObjectType();
                    if (!definition.getObjectType().isSubtypeOf(accessorInterface)) {
                        AccessorTypeBuilder.this.classContext.getCompilationContext().error((Element)fieldElement, "Accessor class must extend %s", new Object[]{accessorInterface});
                        return null;
                    }
                    int idx = definition.findConstructorIndex(MethodDescriptor.VOID_METHOD_DESCRIPTOR);
                    if (idx == -1) {
                        AccessorTypeBuilder.this.classContext.getCompilationContext().error((Element)fieldElement, "Accessor class must declare a no-argument constructor", new Object[0]);
                        return null;
                    }
                    ConstructorElement constructor = definition.getConstructor(idx);
                    return vmThread.getVM().newInstance(definition.getVmClass(), constructor, List.of());
                }
                AccessorTypeBuilder.this.classContext.getCompilationContext().error((Element)fieldElement, "Accessor must be a class", new Object[0]);
                return null;
            }
        }, index, name, descriptor);
    }
}

