/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.patcher;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.ClassContext;
import org.qbicc.context.Diagnostic;
import org.qbicc.context.Location;
import org.qbicc.plugin.patcher.ClassPatchInfo;
import org.qbicc.plugin.patcher.ConstructorPatchInfo;
import org.qbicc.plugin.patcher.FieldPatchInfo;
import org.qbicc.plugin.patcher.InitializerPatchInfo;
import org.qbicc.plugin.patcher.MethodPatchInfo;
import org.qbicc.plugin.patcher.OnceRunTimeInitializerResolver;
import org.qbicc.plugin.patcher.RuntimeInitializerPatchInfo;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.ClassAnnotationValue;
import org.qbicc.type.annotation.StringAnnotationValue;
import org.qbicc.type.definition.ConstructorResolver;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.InitializerResolver;
import org.qbicc.type.definition.MethodResolver;
import org.qbicc.type.definition.classfile.ClassFile;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

final class ClassContextPatchInfo {
    private final Map<String, ClassPatchInfo> classPatchInfoMap;
    private final Map<String, String> patchClassMapping;
    private final ClassContext classContext;
    private static final int K_ALIAS = 0;
    private static final int K_ADD = 1;
    private static final int K_REMOVE = 2;
    private static final int K_REPLACE = 3;
    private static final int K_ANNOTATE = 4;

    ClassContextPatchInfo(ClassContext classContext) {
        this.classContext = classContext;
        this.classPatchInfoMap = new ConcurrentHashMap<String, ClassPatchInfo>();
        this.patchClassMapping = new ConcurrentHashMap<String, String>();
    }

    boolean isPatchClass(String internalName) {
        return this.patchClassMapping.containsKey(internalName);
    }

    String getTargetForPatchClass(String patchClassName) {
        return this.patchClassMapping.get(patchClassName);
    }

    TypeDescriptor transform(TypeDescriptor desc) {
        if (desc instanceof ClassTypeDescriptor) {
            ClassTypeDescriptor ctd = (ClassTypeDescriptor)desc;
            return this.transform(ctd);
        }
        if (desc instanceof ArrayTypeDescriptor) {
            ArrayTypeDescriptor atd = (ArrayTypeDescriptor)desc;
            TypeDescriptor etd = atd.getElementTypeDescriptor();
            TypeDescriptor transformed = this.transform(etd);
            return transformed.equals(etd) ? desc : ArrayTypeDescriptor.of((ClassContext)this.classContext, (TypeDescriptor)transformed);
        }
        return desc;
    }

    ArrayTypeDescriptor transform(ArrayTypeDescriptor desc) {
        return ArrayTypeDescriptor.of((ClassContext)this.classContext, (TypeDescriptor)this.transform(desc.getElementTypeDescriptor()));
    }

    ClassTypeDescriptor transform(ClassTypeDescriptor ctd) {
        String target = this.getTargetForPatchClass(ctd.getPackageName() + "/" + ctd.getClassName());
        return target == null ? ctd : ClassTypeDescriptor.synthesize((ClassContext)this.classContext, (String)target);
    }

    MethodDescriptor transform(MethodDescriptor desc) {
        TypeDescriptor newReturnType;
        TypeDescriptor returnType = desc.getReturnType();
        boolean changed = !returnType.equals(newReturnType = this.transform(returnType));
        List parameterTypes = desc.getParameterTypes();
        int cnt = parameterTypes.size();
        TypeDescriptor[] newParamTypes = new TypeDescriptor[cnt];
        for (int i = 0; i < cnt; ++i) {
            TypeDescriptor origDesc = (TypeDescriptor)parameterTypes.get(i);
            newParamTypes[i] = this.transform(origDesc);
            if (changed || origDesc.equals(newParamTypes[i])) continue;
            changed = true;
        }
        return changed ? MethodDescriptor.synthesize((ClassContext)this.classContext, (TypeDescriptor)newReturnType, List.of(newParamTypes)) : desc;
    }

    ClassPatchInfo get(String internalName) {
        return this.classPatchInfoMap.getOrDefault(internalName, ClassPatchInfo.EMPTY);
    }

    ClassPatchInfo getOrAdd(String internalName) {
        return this.classPatchInfoMap.computeIfAbsent(internalName, ClassPatchInfo::new);
    }

    void processClasses(ClassContext classContext, Iterator<String> iterator) {
        while (iterator.hasNext()) {
            this.processClass(classContext, iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processClass(ClassContext classContext, String className) {
        boolean foundInit;
        ClassPatchInfo classPatchInfo;
        String internalName = className.replace('.', '/');
        byte[] classBytes = classContext.getResource(internalName + ".class");
        if (classBytes == null) {
            classContext.getCompilationContext().error("Patch class %s was not found", new Object[]{className});
            return;
        }
        ClassFile classFile = ClassFile.of((ClassContext)classContext, (ByteBuffer)ByteBuffer.wrap(classBytes));
        Annotation replaceInit = null;
        Object initResolver = null;
        int initIndex = 0;
        int cnt = classFile.getAttributeCount();
        boolean runTimeAspect = false;
        String patchedClassPackage = null;
        Object patchedClassName = null;
        ArrayList<Object> transferredAnnotations = null;
        boolean shouldTransferAnnotations = false;
        int i = 0;
        while (true) {
            block82: {
                int ac;
                ByteBuffer buf;
                block83: {
                    block81: {
                        if (i >= cnt) break block81;
                        if (!classFile.attributeNameEquals(i, "RuntimeInvisibleAnnotations")) break block82;
                        buf = classFile.getRawAttributeContent(i);
                        ac = buf.getShort() & 0xFFFF;
                        break block83;
                    }
                    if (patchedClassName == null) {
                        classContext.getCompilationContext().error("Patch class \"%s\" does not designate a class to patch", new Object[]{className});
                        return;
                    }
                    String patchedClassInternalName = patchedClassPackage.isEmpty() ? patchedClassName : patchedClassPackage + "/" + patchedClassName;
                    this.patchClassMapping.put(internalName, patchedClassInternalName);
                    classPatchInfo = this.getOrAdd(patchedClassInternalName);
                    foundInit = false;
                    ClassPatchInfo classPatchInfo2 = classPatchInfo;
                    synchronized (classPatchInfo2) {
                        if (shouldTransferAnnotations) {
                            for (Annotation annotation : transferredAnnotations) {
                                classPatchInfo.addClassAnnotation(annotation);
                            }
                        }
                        break;
                    }
                }
                for (int j = 0; j < ac; ++j) {
                    Object string;
                    AnnotationValue annotationValue;
                    Annotation annotation = Annotation.parse((ClassFile)classFile, (ClassContext)classContext, (ByteBuffer)buf);
                    ClassTypeDescriptor classTypeDescriptor = annotation.getDescriptor();
                    if (classTypeDescriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "RunTimeAspect")) {
                        if (replaceInit != null) {
                            classContext.getCompilationContext().error("Patch class \"%s\" cannot both replace the initializer and provide a run time aspect", new Object[]{className});
                            return;
                        }
                        runTimeAspect = true;
                        continue;
                    }
                    if (classTypeDescriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Patch") && (annotationValue = annotation.getValue("value")) instanceof StringAnnotationValue) {
                        StringAnnotationValue sav = (StringAnnotationValue)annotationValue;
                        if (patchedClassName != null) {
                            classContext.getCompilationContext().warning("Patch class \"%s\" has more than one annotation designating the class to patch", new Object[]{className});
                            continue;
                        }
                        string = sav.getString().replace('.', '/');
                        int idx = ((String)string).lastIndexOf(47);
                        if (idx == -1) {
                            patchedClassPackage = "";
                            patchedClassName = string;
                            continue;
                        }
                        patchedClassPackage = ((String)string).substring(0, idx);
                        patchedClassName = ((String)string).substring(idx + 1);
                        continue;
                    }
                    if (classTypeDescriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "PatchClass") && (string = annotation.getValue("value")) instanceof ClassAnnotationValue) {
                        ClassAnnotationValue cav = (ClassAnnotationValue)string;
                        if (patchedClassName != null) {
                            classContext.getCompilationContext().warning("Patch class \"%s\" has more than one annotation designating the class to patch", new Object[]{className});
                            continue;
                        }
                        TypeDescriptor idx = cav.getDescriptor();
                        if (!(idx instanceof ClassTypeDescriptor)) {
                            classContext.getCompilationContext().error("Patch class \"%s\" designates a non-class to patch", new Object[]{className});
                            return;
                        }
                        ClassTypeDescriptor ctd = (ClassTypeDescriptor)idx;
                        patchedClassName = ctd.getClassName();
                        patchedClassPackage = ctd.getPackageName();
                        continue;
                    }
                    if (classTypeDescriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "ReplaceInit")) {
                        if (runTimeAspect) {
                            classContext.getCompilationContext().error("Patch class \"%s\" cannot both replace the initializer and provide a run time aspect", new Object[]{className});
                            return;
                        }
                        replaceInit = annotation;
                        continue;
                    }
                    if (classTypeDescriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Annotate")) {
                        shouldTransferAnnotations = true;
                        continue;
                    }
                    if (transferredAnnotations == null) {
                        transferredAnnotations = new ArrayList<Object>();
                    }
                    transferredAnnotations.add(annotation);
                }
            }
            ++i;
        }
        {
            void var20_29;
            StringAnnotationValue sav;
            AnnotationValue annotationValue;
            ClassTypeDescriptor descriptor;
            Annotation annotation;
            int k;
            int ac;
            Annotation controllingAnnotation;
            int kind;
            int attrCnt;
            cnt = classFile.getMethodCount();
            int addModifiers = runTimeAspect ? 0x10000000 : 0;
            boolean bl = false;
            while (true) {
                void var20_27;
                block79: {
                    ArrayList<Annotation> additionalAnnotations;
                    boolean ctor;
                    String methodName;
                    String patchMethodName;
                    block87: {
                        block84: {
                            block85: {
                                block86: {
                                    if (var20_27 >= cnt) break block84;
                                    methodName = patchMethodName = classFile.getMethodName((int)var20_27);
                                    if (!patchMethodName.equals("<clinit>")) break block85;
                                    initResolver = classFile;
                                    foundInit = true;
                                    if (!runTimeAspect) break block86;
                                    initResolver = new OnceRunTimeInitializerResolver((InitializerResolver)initResolver);
                                    initIndex = var20_27;
                                    break block79;
                                }
                                if (replaceInit != null) {
                                    classPatchInfo.replaceInitializer(new InitializerPatchInfo((int)var20_27, (InitializerResolver)initResolver, internalName, replaceInit));
                                } else {
                                    classContext.getCompilationContext().warning(ClassContextPatchInfo.getMethodLocation(internalName, patchMethodName), "Patch class initializer will be ignored", new Object[0]);
                                }
                            }
                            ctor = patchMethodName.equals("<init>");
                            attrCnt = classFile.getMethodAttributeCount((int)var20_27);
                            kind = 0;
                            controllingAnnotation = null;
                            additionalAnnotations = null;
                            break block87;
                        }
                        if (!foundInit && replaceInit != null) {
                            classPatchInfo.deleteInitializer();
                        }
                        break;
                    }
                    for (int j = 0; j < attrCnt; ++j) {
                        if (!classFile.methodAttributeNameEquals((int)var20_27, j, "RuntimeInvisibleAnnotations")) continue;
                        ByteBuffer buf = classFile.getMethodRawAttributeContent((int)var20_27, j);
                        ac = buf.getShort() & 0xFFFF;
                        for (k = 0; k < ac; ++k) {
                            annotation = Annotation.parse((ClassFile)classFile, (ClassContext)classContext, (ByteBuffer)buf);
                            descriptor = annotation.getDescriptor();
                            if (descriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Add")) {
                                if (kind == 0) {
                                    kind = 1;
                                    controllingAnnotation = annotation;
                                    continue;
                                }
                                ClassContextPatchInfo.wrongAnnotationWarning(classContext, ClassContextPatchInfo.getMethodLocation(internalName, patchMethodName));
                                break block79;
                            }
                            if (descriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Remove")) {
                                if (kind == 0) {
                                    kind = 2;
                                    controllingAnnotation = annotation;
                                    continue;
                                }
                                ClassContextPatchInfo.wrongAnnotationWarning(classContext, ClassContextPatchInfo.getMethodLocation(internalName, patchMethodName));
                                break block79;
                            }
                            if (descriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Replace")) {
                                if (kind == 0) {
                                    kind = 3;
                                    controllingAnnotation = annotation;
                                    continue;
                                }
                                ClassContextPatchInfo.wrongAnnotationWarning(classContext, ClassContextPatchInfo.getMethodLocation(internalName, patchMethodName));
                                break block79;
                            }
                            if (descriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Patch") && (annotationValue = annotation.getValue("value")) instanceof StringAnnotationValue) {
                                sav = (StringAnnotationValue)annotationValue;
                                if (ctor) {
                                    classContext.getCompilationContext().warning(ClassContextPatchInfo.getMethodLocation(internalName, patchMethodName), "Constructors cannot have specified names", new Object[0]);
                                    continue;
                                }
                                methodName = sav.getString();
                                continue;
                            }
                            if (descriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Annotate")) {
                                if (kind == 0) {
                                    kind = 4;
                                    controllingAnnotation = annotation;
                                    continue;
                                }
                                ClassContextPatchInfo.wrongAnnotationWarning(classContext, ClassContextPatchInfo.getMethodLocation(internalName, patchMethodName));
                                break block79;
                            }
                            if (additionalAnnotations == null) {
                                additionalAnnotations = new ArrayList<Annotation>();
                            }
                            additionalAnnotations.add(annotation);
                        }
                    }
                    MethodDescriptor methodDesc = this.transform(classFile.getMethodDescriptor((int)var20_27));
                    if (kind == 1) {
                        if (ctor) {
                            classPatchInfo.addConstructor(new ConstructorPatchInfo((int)var20_27, addModifiers, (ConstructorResolver)classFile, methodDesc, internalName, controllingAnnotation, null));
                        } else {
                            classPatchInfo.addMethod(new MethodPatchInfo((int)var20_27, addModifiers, (MethodResolver)classFile, methodDesc, methodName, internalName, controllingAnnotation, null));
                        }
                    } else if (kind == 2) {
                        if (ctor) {
                            classPatchInfo.deleteConstructor(methodDesc, internalName, controllingAnnotation);
                        } else {
                            classPatchInfo.deleteMethod(methodName, methodDesc, internalName, controllingAnnotation);
                        }
                    } else if (kind == 3) {
                        if (ctor) {
                            classPatchInfo.replaceConstructor(new ConstructorPatchInfo((int)var20_27, 0, (ConstructorResolver)classFile, methodDesc, internalName, controllingAnnotation, null));
                        } else {
                            classPatchInfo.replaceMethod(new MethodPatchInfo((int)var20_27, 0, (MethodResolver)classFile, methodDesc, methodName, internalName, controllingAnnotation, null));
                        }
                    } else if (kind == 4) {
                        if (ctor) {
                            classPatchInfo.annotateConstructor(new ConstructorPatchInfo((int)var20_27, 0, (ConstructorResolver)classFile, methodDesc, internalName, controllingAnnotation, additionalAnnotations));
                        } else {
                            classPatchInfo.annotateMethod(new MethodPatchInfo((int)var20_27, 0, (MethodResolver)classFile, methodDesc, methodName, internalName, controllingAnnotation, additionalAnnotations));
                        }
                    } else assert (kind == 0);
                }
                ++var20_27;
            }
            cnt = classFile.getFieldCount();
            boolean bl2 = false;
            while (var20_29 < cnt) {
                block80: {
                    boolean isStatic;
                    String patchFieldName;
                    String fieldName = patchFieldName = classFile.getFieldName((int)var20_29);
                    int fieldMods = classFile.getFieldModifiers((int)var20_29);
                    attrCnt = classFile.getFieldAttributeCount((int)var20_29);
                    kind = 0;
                    controllingAnnotation = null;
                    ArrayList<Annotation> addedAnnotations = null;
                    for (int j = 0; j < attrCnt; ++j) {
                        if (!classFile.fieldAttributeNameEquals((int)var20_29, j, "RuntimeInvisibleAnnotations")) continue;
                        ByteBuffer buf = classFile.getFieldRawAttributeContent((int)var20_29, j);
                        ac = buf.getShort() & 0xFFFF;
                        for (k = 0; k < ac; ++k) {
                            annotation = Annotation.parse((ClassFile)classFile, (ClassContext)classContext, (ByteBuffer)buf);
                            descriptor = annotation.getDescriptor();
                            if (descriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Add")) {
                                if (kind == 0) {
                                    kind = 1;
                                    controllingAnnotation = annotation;
                                    continue;
                                }
                                ClassContextPatchInfo.wrongAnnotationWarning(classContext, ClassContextPatchInfo.getFieldLocation(internalName, patchFieldName));
                                break block80;
                            }
                            if (descriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Remove")) {
                                if (kind == 0) {
                                    kind = 2;
                                    controllingAnnotation = annotation;
                                    continue;
                                }
                                ClassContextPatchInfo.wrongAnnotationWarning(classContext, ClassContextPatchInfo.getFieldLocation(internalName, patchFieldName));
                                break block80;
                            }
                            if (descriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Replace")) {
                                if (kind == 0) {
                                    kind = 3;
                                    controllingAnnotation = annotation;
                                    continue;
                                }
                                ClassContextPatchInfo.wrongAnnotationWarning(classContext, ClassContextPatchInfo.getFieldLocation(internalName, patchFieldName));
                                break block80;
                            }
                            if (descriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Patch") && (annotationValue = annotation.getValue("value")) instanceof StringAnnotationValue) {
                                sav = (StringAnnotationValue)annotationValue;
                                patchFieldName = sav.getString();
                                continue;
                            }
                            if (descriptor.packageAndClassNameEquals("org/qbicc/runtime/patcher", "Annotate")) {
                                if (kind == 0) {
                                    kind = 4;
                                    controllingAnnotation = annotation;
                                    continue;
                                }
                                ClassContextPatchInfo.wrongAnnotationWarning(classContext, ClassContextPatchInfo.getFieldLocation(internalName, patchFieldName));
                                break block80;
                            }
                            if (addedAnnotations == null) {
                                addedAnnotations = new ArrayList<Annotation>();
                            }
                            addedAnnotations.add(annotation);
                        }
                    }
                    TypeDescriptor fieldDesc = this.transform(classFile.getFieldDescriptor((int)var20_29));
                    boolean bl3 = isStatic = (fieldMods & 8) != 0;
                    if (kind == 1) {
                        if (isStatic && runTimeAspect) {
                            classPatchInfo.runtimeInitField(new RuntimeInitializerPatchInfo(internalName, (int)var20_29, (InitializerResolver)initResolver, initIndex, fieldDesc, fieldName, controllingAnnotation));
                        }
                        classPatchInfo.addField(new FieldPatchInfo(internalName, (int)var20_29, 0, (FieldResolver)classFile, fieldDesc, fieldName, controllingAnnotation, null));
                    } else if (kind == 2) {
                        classPatchInfo.deleteField(fieldName, fieldDesc, internalName, controllingAnnotation);
                    } else if (kind == 3) {
                        if (isStatic && runTimeAspect) {
                            classPatchInfo.runtimeInitField(new RuntimeInitializerPatchInfo(internalName, (int)var20_29, (InitializerResolver)initResolver, initIndex, fieldDesc, fieldName, controllingAnnotation));
                        }
                        classPatchInfo.replaceField(new FieldPatchInfo(internalName, (int)var20_29, 0, (FieldResolver)classFile, fieldDesc, fieldName, controllingAnnotation, null));
                    } else if (kind == 4) {
                        classPatchInfo.annotateField(new FieldPatchInfo(internalName, (int)var20_29, 0, (FieldResolver)classFile, fieldDesc, fieldName, controllingAnnotation, addedAnnotations));
                    } else {
                        assert (kind == 0);
                        if (isStatic && runTimeAspect) {
                            classPatchInfo.runtimeInitField(new RuntimeInitializerPatchInfo(internalName, (int)var20_29, (InitializerResolver)initResolver, initIndex, fieldDesc, fieldName, controllingAnnotation));
                        }
                    }
                }
                ++var20_29;
            }
            return;
        }
    }

    private static Diagnostic wrongAnnotationWarning(ClassContext classContext, Location loc) {
        return classContext.getCompilationContext().warning(loc, "Patch field must be annotated with no more than one of `@Add`, `@Remove`, or `@Replace`", new Object[0]);
    }

    static Location getFieldLocation(String internalName, String fieldName) {
        return Location.builder().setMemberKind(Location.MemberKind.FIELD).setMemberName(fieldName).setClassInternalName(internalName).build();
    }

    static Location getMethodLocation(String internalName, String methodName) {
        return Location.builder().setMemberKind(methodName.equals("<init>") ? Location.MemberKind.CONSTRUCTOR : Location.MemberKind.METHOD).setMemberName(methodName).setClassInternalName(internalName).build();
    }
}

