/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.patcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Locatable;
import org.qbicc.plugin.core.ConditionEvaluation;
import org.qbicc.plugin.patcher.ClassContextPatchInfo;
import org.qbicc.plugin.patcher.ClassPatchInfo;
import org.qbicc.plugin.patcher.ConstructorDeleteInfo;
import org.qbicc.plugin.patcher.ConstructorPatchInfo;
import org.qbicc.plugin.patcher.FieldDeleteInfo;
import org.qbicc.plugin.patcher.FieldPatchInfo;
import org.qbicc.plugin.patcher.InitializerPatchInfo;
import org.qbicc.plugin.patcher.MethodBodyPatchInfo;
import org.qbicc.plugin.patcher.MethodDeleteInfo;
import org.qbicc.plugin.patcher.MethodPatchInfo;
import org.qbicc.plugin.patcher.RuntimeInitializerPatchInfo;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.definition.ConstructorResolver;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.InitializerResolver;
import org.qbicc.type.definition.MethodBodyFactory;
import org.qbicc.type.definition.MethodResolver;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

final class PatchedTypeBuilder
implements DefinedTypeDefinition.Builder.Delegating {
    private final ClassContext classContext;
    private final ClassContextPatchInfo contextInfo;
    private final DefinedTypeDefinition.Builder delegate;
    private String internalName;
    private Map<String, FieldPatchInfo> addedFields;
    private Map<String, Map<MethodDescriptor, MethodPatchInfo>> addedMethods;
    private Map<MethodDescriptor, ConstructorPatchInfo> addedConstructors;
    private ClassPatchInfo classPatchInfo;

    PatchedTypeBuilder(ClassContext classContext, ClassContextPatchInfo contextInfo, DefinedTypeDefinition.Builder delegate) {
        this.classContext = classContext;
        this.contextInfo = contextInfo;
        this.delegate = delegate;
    }

    public DefinedTypeDefinition.Builder getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String internalName) {
        if (this.contextInfo.isPatchClass(internalName)) {
            throw new IllegalStateException("A patch class was found for loading: " + internalName);
        }
        this.classPatchInfo = this.contextInfo.get(internalName);
        this.internalName = internalName;
        if (this.classPatchInfo != null) {
            ClassPatchInfo classPatchInfo = this.classPatchInfo;
            synchronized (classPatchInfo) {
                this.classPatchInfo.commit();
                List<FieldPatchInfo> injectedFields = this.classPatchInfo.getInjectedFields();
                this.addedFields = PatchedTypeBuilder.mapOf(injectedFields, FieldPatchInfo::getName);
                List<ConstructorPatchInfo> injectedConstructors = this.classPatchInfo.getInjectedConstructors();
                this.addedConstructors = PatchedTypeBuilder.mapOf(injectedConstructors, ConstructorPatchInfo::getDescriptor);
                List<MethodPatchInfo> injectedMethods = this.classPatchInfo.getInjectedMethods();
                this.addedMethods = PatchedTypeBuilder.mapOf(injectedMethods, MethodPatchInfo::getName, MethodPatchInfo::getDescriptor);
            }
        }
        this.getDelegate().setName(internalName);
    }

    public void setNestHost(String nestHost) {
        if (this.contextInfo.isPatchClass(nestHost)) {
            return;
        }
        this.getDelegate().setNestHost(nestHost);
    }

    public void addNestMember(String nestMember) {
        if (this.contextInfo.isPatchClass(nestMember)) {
            return;
        }
        this.getDelegate().addNestMember(nestMember);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitializer(InitializerResolver resolver, int index) {
        ClassPatchInfo classPatchInfo = this.classPatchInfo;
        if (classPatchInfo != null) {
            InitializerPatchInfo patchInfo;
            ClassPatchInfo classPatchInfo2 = classPatchInfo;
            synchronized (classPatchInfo2) {
                if (classPatchInfo.isDeletedInitializer()) {
                    this.getDelegate().setInitializer(resolver, -1);
                    return;
                }
                patchInfo = classPatchInfo.getReplacementInitializerInfo();
            }
            ConditionEvaluation ce = ConditionEvaluation.get((CompilationContext)this.classContext.getCompilationContext());
            if (patchInfo == null || !ce.evaluateConditions(this.classContext, (Locatable)patchInfo, patchInfo.getAnnotation())) {
                this.getDelegate().setInitializer(resolver, index);
            } else {
                this.getDelegate().setInitializer(patchInfo.getInitializerResolver(), patchInfo.getIndex());
            }
        } else {
            this.getDelegate().setInitializer(resolver, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInvisibleAnnotations(List<Annotation> annotations) {
        ClassPatchInfo classPatchInfo = this.classPatchInfo;
        if (classPatchInfo != null) {
            ClassPatchInfo classPatchInfo2 = classPatchInfo;
            synchronized (classPatchInfo2) {
                List<Annotation> added = classPatchInfo.getAddedClassAnnotations();
                if (!added.isEmpty()) {
                    ArrayList<Annotation> tmp = new ArrayList<Annotation>();
                    tmp.addAll(annotations);
                    tmp.addAll(added);
                    annotations = tmp;
                }
            }
        }
        this.getDelegate().setInvisibleAnnotations(annotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(FieldResolver resolver, int index, String name, TypeDescriptor descriptor) {
        ClassPatchInfo classPatchInfo = this.classPatchInfo;
        if (classPatchInfo != null) {
            RuntimeInitializerPatchInfo initInfo;
            FieldPatchInfo annotateInfo;
            FieldPatchInfo injectedInfo;
            FieldPatchInfo patchInfo;
            ConditionEvaluation ce = ConditionEvaluation.get((CompilationContext)this.classContext.getCompilationContext());
            ClassPatchInfo classPatchInfo2 = classPatchInfo;
            synchronized (classPatchInfo2) {
                FieldDeleteInfo delInfo = classPatchInfo.getDeletedFieldInfo(name, descriptor);
                if (delInfo != null && ce.evaluateConditions(this.classContext, (Locatable)delInfo, delInfo.getAnnotation())) {
                    return;
                }
                patchInfo = classPatchInfo.getReplacementFieldInfo(name, descriptor);
                injectedInfo = this.addedFields.get(name);
                annotateInfo = classPatchInfo.getAnnotatedFieldInfo(name, descriptor);
                initInfo = classPatchInfo.getRuntimeInitFieldInfo(name, descriptor);
            }
            if (patchInfo != null && ce.evaluateConditions(this.classContext, (Locatable)patchInfo, patchInfo.getAnnotation())) {
                resolver = new PatcherFieldResolver(patchInfo);
                index = patchInfo.getIndex();
            } else if (injectedInfo != null && ce.evaluateConditions(this.classContext, (Locatable)injectedInfo, injectedInfo.getAnnotation())) {
                this.classContext.getCompilationContext().warning("Injected field %s was already present on %s (replacing)", new Object[]{name, this.internalName});
                return;
            }
            if (annotateInfo != null && ce.evaluateConditions(this.classContext, (Locatable)annotateInfo, annotateInfo.getAnnotation())) {
                resolver = new AnnotationAddingResolver(annotateInfo.getAddedAnnotations(), resolver);
            }
            if (initInfo != null && ce.evaluateConditions(this.classContext, (Locatable)initInfo, initInfo.getAnnotation())) {
                resolver = new PatcherFieldRuntimeInitResolver(initInfo, resolver);
            }
            this.getDelegate().addField(resolver, index, name, descriptor);
        } else {
            this.getDelegate().addField(resolver, index, name, descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConstructor(ConstructorResolver resolver, int index, MethodDescriptor descriptor) {
        ClassPatchInfo classPatchInfo = this.classPatchInfo;
        if (classPatchInfo != null) {
            ConstructorPatchInfo annotateInfo;
            ConstructorPatchInfo injectedInfo;
            ConstructorPatchInfo constructorInfo;
            ConditionEvaluation ce = ConditionEvaluation.get((CompilationContext)this.classContext.getCompilationContext());
            ClassPatchInfo classPatchInfo2 = classPatchInfo;
            synchronized (classPatchInfo2) {
                ConstructorDeleteInfo delInfo = classPatchInfo.getDeletedConstructorInfo(descriptor);
                if (delInfo != null && ce.evaluateConditions(this.classContext, (Locatable)delInfo, delInfo.getAnnotation())) {
                    return;
                }
                constructorInfo = classPatchInfo.getReplacementConstructorInfo(descriptor);
                injectedInfo = this.addedConstructors.get(descriptor);
                annotateInfo = classPatchInfo.getAnnotatedConstructorInfo(descriptor);
            }
            if (constructorInfo != null && ce.evaluateConditions(this.classContext, (Locatable)constructorInfo, constructorInfo.getAnnotation())) {
                resolver = new PatcherConstructorResolver(constructorInfo);
                index = constructorInfo.getIndex();
            } else if (injectedInfo != null && ce.evaluateConditions(this.classContext, (Locatable)injectedInfo, injectedInfo.getAnnotation())) {
                this.classContext.getCompilationContext().warning("Injected constructor %s was already present on %s (replacing)", new Object[]{descriptor, this.internalName});
                return;
            }
            if (annotateInfo != null && ce.evaluateConditions(this.classContext, (Locatable)annotateInfo, annotateInfo.getAnnotation())) {
                resolver = new AnnotationAddingResolver(annotateInfo.getAddedAnnotations(), resolver);
            }
            this.getDelegate().addConstructor(resolver, index, descriptor);
        } else {
            this.getDelegate().addConstructor(resolver, index, descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethod(MethodResolver resolver, int index, String name, MethodDescriptor descriptor) {
        ClassPatchInfo classPatchInfo = this.classPatchInfo;
        if (classPatchInfo != null) {
            MethodBodyPatchInfo bodyPatchInfo;
            MethodPatchInfo annotateInfo;
            MethodPatchInfo injectedInfo;
            MethodPatchInfo methodInfo;
            ConditionEvaluation ce = ConditionEvaluation.get((CompilationContext)this.classContext.getCompilationContext());
            ClassPatchInfo classPatchInfo2 = classPatchInfo;
            synchronized (classPatchInfo2) {
                MethodDeleteInfo delInfo = classPatchInfo.getDeletedMethodInfo(name, descriptor);
                if (delInfo != null && ce.evaluateConditions(this.classContext, (Locatable)delInfo, delInfo.getAnnotation())) {
                    return;
                }
                methodInfo = classPatchInfo.getReplacementMethodInfo(name, descriptor);
                injectedInfo = (MethodPatchInfo)this.addedMethods.getOrDefault(name, Map.of()).get(descriptor);
                annotateInfo = classPatchInfo.getAnnotatedMethodInfo(name, descriptor);
                bodyPatchInfo = classPatchInfo.getReplacementMethodBodyInfo(name, descriptor);
            }
            if (methodInfo != null && ce.evaluateConditions(this.classContext, (Locatable)methodInfo, methodInfo.getAnnotation())) {
                resolver = methodInfo.getMethodResolver();
                index = methodInfo.getIndex();
            } else if (injectedInfo != null) {
                this.classContext.getCompilationContext().warning("Injected method %s%s was already present on %s (replacing)", new Object[]{name, descriptor, this.internalName});
                return;
            }
            if (annotateInfo != null && ce.evaluateConditions(this.classContext, (Locatable)annotateInfo, annotateInfo.getAnnotation())) {
                resolver = new AnnotationAddingResolver(annotateInfo.getAddedAnnotations(), resolver);
            }
            if (bodyPatchInfo != null) {
                resolver = new MethodBodyReplacingResolver(bodyPatchInfo.getMethodBodyFactory(), bodyPatchInfo.getIndex(), resolver);
            }
            this.getDelegate().addMethod(resolver, index, name, descriptor);
        } else {
            this.getDelegate().addMethod(resolver, index, name, descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefinedTypeDefinition build() {
        ClassPatchInfo classPatchInfo = this.classPatchInfo;
        if (classPatchInfo != null) {
            ConditionEvaluation ce = ConditionEvaluation.get((CompilationContext)this.classContext.getCompilationContext());
            ClassPatchInfo classPatchInfo2 = classPatchInfo;
            synchronized (classPatchInfo2) {
                for (FieldPatchInfo fieldInfo : classPatchInfo.getInjectedFields()) {
                    Object resolver = new PatcherFieldResolver(fieldInfo);
                    RuntimeInitializerPatchInfo initInfo = classPatchInfo.getRuntimeInitFieldInfo(fieldInfo.getName(), fieldInfo.getDescriptor());
                    if (initInfo != null) {
                        resolver = new PatcherFieldRuntimeInitResolver(initInfo, (FieldResolver)resolver);
                    }
                    if (!ce.evaluateConditions(this.classContext, (Locatable)fieldInfo, fieldInfo.getAnnotation())) continue;
                    this.getDelegate().addField((FieldResolver)resolver, fieldInfo.getIndex(), fieldInfo.getName(), fieldInfo.getDescriptor());
                }
                for (ConstructorPatchInfo ctorInfo : classPatchInfo.getInjectedConstructors()) {
                    if (!ce.evaluateConditions(this.classContext, (Locatable)ctorInfo, ctorInfo.getAnnotation())) continue;
                    this.getDelegate().addConstructor((ConstructorResolver)new PatcherConstructorResolver(ctorInfo), ctorInfo.getIndex(), ctorInfo.getDescriptor());
                }
                for (MethodPatchInfo methodInfo : classPatchInfo.getInjectedMethods()) {
                    if (!ce.evaluateConditions(this.classContext, (Locatable)methodInfo, methodInfo.getAnnotation())) continue;
                    this.getDelegate().addMethod((MethodResolver)new PatcherMethodResolver(methodInfo), methodInfo.getIndex(), methodInfo.getName(), methodInfo.getDescriptor());
                }
            }
        }
        return this.getDelegate().build();
    }

    static <K, V> Map<K, V> mapOf(List<V> list, Function<V, K> mapper) {
        Iterator<V> iterator = list.iterator();
        if (!iterator.hasNext()) {
            return Map.of();
        }
        V v1 = iterator.next();
        K k1 = mapper.apply(v1);
        if (!iterator.hasNext()) {
            return Map.of(k1, v1);
        }
        V v2 = iterator.next();
        K k2 = mapper.apply(v2);
        if (!iterator.hasNext()) {
            return Map.of(k1, v1, k2, v2);
        }
        V v3 = iterator.next();
        K k3 = mapper.apply(v3);
        if (!iterator.hasNext()) {
            return Map.of(k1, v1, k2, v2, k3, v3);
        }
        V v4 = iterator.next();
        K k4 = mapper.apply(v4);
        if (!iterator.hasNext()) {
            return Map.of(k1, v1, k2, v2, k3, v3, k4, v4);
        }
        V v5 = iterator.next();
        K k5 = mapper.apply(v5);
        if (!iterator.hasNext()) {
            return Map.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        }
        HashMap<K, V> map = new HashMap<K, V>(list.size());
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        while (iterator.hasNext()) {
            V v = iterator.next();
            map.put(mapper.apply(v), v);
        }
        return map;
    }

    static <K, L, V> Map<K, Map<L, V>> mapOf(List<V> list, Function<V, K> outerMapper, Function<V, L> innerMapper) {
        Iterator<V> iterator = list.iterator();
        if (!iterator.hasNext()) {
            return Map.of();
        }
        V v1 = iterator.next();
        K k1 = outerMapper.apply(v1);
        L l1 = innerMapper.apply(v1);
        if (!iterator.hasNext()) {
            return Map.of(k1, Map.of(l1, v1));
        }
        V v2 = iterator.next();
        K k2 = outerMapper.apply(v2);
        L l2 = innerMapper.apply(v2);
        if (!iterator.hasNext()) {
            if (k2.equals(k1)) {
                return Map.of(k1, Map.of(l1, v1, l2, v2));
            }
            return Map.of(k1, Map.of(l1, v1), k2, Map.of(l2, v2));
        }
        V v3 = iterator.next();
        K k3 = outerMapper.apply(v3);
        L l3 = innerMapper.apply(v3);
        if (!iterator.hasNext()) {
            if (k3.equals(k2) && k2.equals(k1)) {
                return Map.of(k1, Map.of(l1, v1, l2, v2, l3, v3));
            }
            if (k3.equals(k2)) {
                return Map.of(k1, Map.of(l1, v1), k2, Map.of(l2, v2, l3, v3));
            }
            if (k2.equals(k1)) {
                return Map.of(k1, Map.of(l1, v1, l2, v2), k3, Map.of(l3, v3));
            }
            return Map.of(k1, Map.of(l1, v1), k2, Map.of(l2, v2), k3, Map.of(l3, v3));
        }
        HashMap<Object, Map> map = new HashMap<Object, Map>(list.size());
        map.computeIfAbsent(k1, PatchedTypeBuilder::newMap).put(l1, v1);
        map.computeIfAbsent(k2, PatchedTypeBuilder::newMap).put(l2, v2);
        map.computeIfAbsent(k3, PatchedTypeBuilder::newMap).put(l3, v3);
        while (iterator.hasNext()) {
            V v = iterator.next();
            map.computeIfAbsent(outerMapper.apply(v), PatchedTypeBuilder::newMap).put(innerMapper.apply(v), v);
        }
        return map;
    }

    private static <K, V> Map<K, V> newMap(Object ignored) {
        return new HashMap();
    }

    static class PatcherFieldResolver
    implements FieldResolver {
        private final FieldPatchInfo fieldInfo;

        PatcherFieldResolver(FieldPatchInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
        }

        public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
            FieldElement fieldElement = this.fieldInfo.getFieldResolver().resolveField(index, enclosing, builder);
            fieldElement.setModifierFlags(this.fieldInfo.getAdditionalModifiers());
            return fieldElement;
        }
    }

    static class AnnotationAddingResolver
    implements FieldResolver,
    MethodResolver,
    ConstructorResolver {
        private final List<Annotation> additions;
        private final ConstructorResolver constructorResolver;
        private final FieldResolver fieldResolver;
        private final MethodResolver methodResolver;

        AnnotationAddingResolver(List<Annotation> additions, ConstructorResolver constructorResolver, FieldResolver fieldResolver, MethodResolver methodResolver) {
            this.additions = additions;
            this.constructorResolver = constructorResolver;
            this.fieldResolver = fieldResolver;
            this.methodResolver = methodResolver;
        }

        AnnotationAddingResolver(List<Annotation> additions, ConstructorResolver constructorResolver) {
            this(additions, constructorResolver, null, null);
        }

        AnnotationAddingResolver(List<Annotation> additions, FieldResolver fieldResolver) {
            this(additions, null, fieldResolver, null);
        }

        AnnotationAddingResolver(List<Annotation> additions, MethodResolver methodResolver) {
            this(additions, null, null, methodResolver);
        }

        public ConstructorElement resolveConstructor(int index, DefinedTypeDefinition enclosing, ConstructorElement.Builder builder) {
            builder.addInvisibleAnnotations(this.additions);
            return this.constructorResolver.resolveConstructor(index, enclosing, builder);
        }

        public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
            builder.addInvisibleAnnotations(this.additions);
            return this.fieldResolver.resolveField(index, enclosing, builder);
        }

        public MethodElement resolveMethod(int index, DefinedTypeDefinition enclosing, MethodElement.Builder builder) {
            builder.addInvisibleAnnotations(this.additions);
            return this.methodResolver.resolveMethod(index, enclosing, builder);
        }
    }

    static class PatcherFieldRuntimeInitResolver
    implements FieldResolver {
        private final RuntimeInitializerPatchInfo initInfo;
        private final FieldResolver fieldResolver;

        PatcherFieldRuntimeInitResolver(RuntimeInitializerPatchInfo initInfo, FieldResolver fieldResolver) {
            this.initInfo = initInfo;
            this.fieldResolver = fieldResolver;
        }

        public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
            InitializerElement rtInit = this.initInfo.getInitializerResolver().resolveInitializer(this.initInfo.getInitializerResolverIndex(), enclosing, InitializerElement.builder());
            builder.setRunTimeInitializer(rtInit);
            FieldElement fieldElement = this.fieldResolver.resolveField(index, enclosing, builder);
            if (fieldElement.isStatic()) {
                fieldElement.setModifierFlags(0x10000000);
            }
            return fieldElement;
        }
    }

    static class PatcherConstructorResolver
    implements ConstructorResolver {
        private final ConstructorPatchInfo constructorInfo;

        PatcherConstructorResolver(ConstructorPatchInfo constructorInfo) {
            this.constructorInfo = constructorInfo;
        }

        public ConstructorElement resolveConstructor(int index, DefinedTypeDefinition enclosing, ConstructorElement.Builder builder) {
            ConstructorElement constructorElement = this.constructorInfo.getConstructorResolver().resolveConstructor(index, enclosing, builder);
            constructorElement.setModifierFlags(this.constructorInfo.getAdditionalModifiers());
            return constructorElement;
        }
    }

    static class MethodBodyReplacingResolver
    implements MethodResolver {
        private final MethodBodyFactory methodBodyFactory;
        private final int index;
        private final MethodResolver resolver;

        MethodBodyReplacingResolver(MethodBodyFactory methodBodyFactory, int index, MethodResolver resolver) {
            this.methodBodyFactory = methodBodyFactory;
            this.index = index;
            this.resolver = resolver;
        }

        public MethodElement resolveMethod(int index, DefinedTypeDefinition enclosing, final MethodElement.Builder builder) {
            return this.resolver.resolveMethod(index, enclosing, (MethodElement.Builder)new MethodElement.Builder.Delegating(){

                public MethodElement.Builder getDelegate() {
                    return builder;
                }

                public MethodElement build() {
                    MethodElement.Builder delegate = this.getDelegate();
                    delegate.setMethodBodyFactory(methodBodyFactory, index);
                    return delegate.build();
                }
            });
        }
    }

    static class PatcherMethodResolver
    implements MethodResolver {
        private final MethodPatchInfo methodInfo;

        PatcherMethodResolver(MethodPatchInfo methodInfo) {
            this.methodInfo = methodInfo;
        }

        public MethodElement resolveMethod(int index, DefinedTypeDefinition enclosing, MethodElement.Builder builder) {
            MethodElement methodElement = this.methodInfo.getMethodResolver().resolveMethod(index, enclosing, builder);
            methodElement.setModifierFlags(this.methodInfo.getAdditionalModifiers());
            return methodElement;
        }
    }
}

