/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.patcher;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.interpreter.VmObject;
import org.qbicc.plugin.patcher.ClassContextPatchInfo;
import org.qbicc.plugin.patcher.ClassPatchInfo;
import org.qbicc.plugin.patcher.ConstructorPatchInfo;
import org.qbicc.plugin.patcher.FieldPatchInfo;
import org.qbicc.plugin.patcher.MethodPatchInfo;
import org.qbicc.plugin.patcher.PatchedTypeBuilder;
import org.qbicc.type.definition.ConstructorResolver;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.MethodBodyFactory;
import org.qbicc.type.definition.MethodResolver;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public class Patcher {
    static final String PATCHER_PKG = "org/qbicc/runtime/patcher";
    private static final AttachmentKey<Patcher> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Map<ClassContext, ClassContextPatchInfo> patchInfoMap = new ConcurrentHashMap<ClassContext, ClassContextPatchInfo>();
    private final Map<FieldElement, VmObject> accessors = new ConcurrentHashMap<FieldElement, VmObject>();

    private Patcher(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static Patcher get(CompilationContext ctxt) {
        Patcher appearing;
        Patcher patcher = (Patcher)ctxt.getAttachment(KEY);
        if (patcher == null && (appearing = (Patcher)ctxt.putAttachmentIfAbsent(KEY, (Object)(patcher = new Patcher(ctxt)))) != null) {
            patcher = appearing;
        }
        return patcher;
    }

    public static void initialize(ClassContext classContext) {
        Patcher patcher = Patcher.get(classContext.getCompilationContext());
        ClassContextPatchInfo contextInfo = patcher.getOrAdd(classContext);
        List resources = classContext.getResources("META-INF/qbicc/qbicc-patch-info");
        for (byte[] patchInfo : resources) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(patchInfo);
                 InputStreamReader isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
                 final BufferedReader reader = new BufferedReader(isr);){
                Iterator<String> iterator = new Iterator<String>(){
                    String next;

                    @Override
                    public boolean hasNext() {
                        while (this.next == null) {
                            String line;
                            try {
                                line = reader.readLine();
                            }
                            catch (IOException e) {
                                throw new IOError(e);
                            }
                            if (line == null) {
                                return false;
                            }
                            int commentIdx = line.indexOf(35);
                            if (commentIdx != -1) {
                                line = line.substring(0, commentIdx);
                            }
                            if ((line = line.trim()).isEmpty()) continue;
                            this.next = line;
                            break;
                        }
                        return true;
                    }

                    @Override
                    public String next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        try {
                            String string = this.next;
                            return string;
                        }
                        finally {
                            this.next = null;
                        }
                    }
                };
                contextInfo.processClasses(classContext, iterator);
            }
            catch (IOException e) {
                classContext.getCompilationContext().error((Throwable)e, "Unexpected exception while trying to process patch info resource", new Object[0]);
                return;
            }
        }
    }

    public static DefinedTypeDefinition.Builder getTypeBuilder(ClassContext classContext, DefinedTypeDefinition.Builder delegate) {
        Patcher patcher = Patcher.get(classContext.getCompilationContext());
        ClassContextPatchInfo contextInfo = patcher.get(classContext);
        return contextInfo != null ? new PatchedTypeBuilder(classContext, contextInfo, delegate) : delegate;
    }

    ClassContextPatchInfo get(ClassContext classContext) {
        return this.patchInfoMap.get(classContext);
    }

    ClassContextPatchInfo getOrAdd(ClassContext classContext) {
        ClassContextPatchInfo appearing;
        ClassContextPatchInfo info = this.get(classContext);
        if (info == null) {
            info = new ClassContextPatchInfo(classContext);
        }
        if ((appearing = this.patchInfoMap.putIfAbsent(classContext, info)) != null) {
            info = appearing;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(ClassContext classContext, String internalName, String fieldName, TypeDescriptor descriptor, FieldResolver resolver, int index, int addModifiers) {
        ClassPatchInfo classInfo;
        ClassPatchInfo classPatchInfo = classInfo = this.getOrAdd(classContext).getOrAdd(internalName);
        synchronized (classPatchInfo) {
            classInfo.addField(new FieldPatchInfo(internalName, index, addModifiers, resolver, descriptor, fieldName, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteField(ClassContext classContext, String internalName, String fieldName, TypeDescriptor descriptor) {
        ClassPatchInfo classInfo;
        ClassPatchInfo classPatchInfo = classInfo = this.getOrAdd(classContext).getOrAdd(internalName);
        synchronized (classPatchInfo) {
            classInfo.deleteField(fieldName, descriptor, internalName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceField(ClassContext classContext, String internalName, String fieldName, TypeDescriptor descriptor, FieldResolver resolver, int index, int addModifiers) {
        ClassPatchInfo classInfo;
        ClassPatchInfo classPatchInfo = classInfo = this.getOrAdd(classContext).getOrAdd(internalName);
        synchronized (classPatchInfo) {
            classInfo.replaceField(new FieldPatchInfo(internalName, index, addModifiers, resolver, descriptor, fieldName, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConstructor(ClassContext classContext, String internalName, MethodDescriptor descriptor, ConstructorResolver resolver, int index, int addModifiers) {
        ClassPatchInfo classInfo;
        ClassPatchInfo classPatchInfo = classInfo = this.getOrAdd(classContext).getOrAdd(internalName);
        synchronized (classPatchInfo) {
            classInfo.addConstructor(new ConstructorPatchInfo(index, addModifiers, resolver, descriptor, internalName, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConstructor(ClassContext classContext, String internalName, MethodDescriptor descriptor) {
        ClassPatchInfo classInfo;
        ClassPatchInfo classPatchInfo = classInfo = this.getOrAdd(classContext).getOrAdd(internalName);
        synchronized (classPatchInfo) {
            classInfo.deleteConstructor(descriptor, internalName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceConstructor(ClassContext classContext, String internalName, MethodDescriptor descriptor, ConstructorResolver resolver, int index, int addModifiers) {
        ClassPatchInfo classInfo;
        ClassPatchInfo classPatchInfo = classInfo = this.getOrAdd(classContext).getOrAdd(internalName);
        synchronized (classPatchInfo) {
            classInfo.replaceConstructor(new ConstructorPatchInfo(index, addModifiers, resolver, descriptor, internalName, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethod(ClassContext classContext, String internalName, String methodName, MethodDescriptor descriptor, MethodResolver resolver, int index, int addModifiers) {
        ClassPatchInfo classInfo;
        ClassPatchInfo classPatchInfo = classInfo = this.getOrAdd(classContext).getOrAdd(internalName);
        synchronized (classPatchInfo) {
            classInfo.addMethod(new MethodPatchInfo(index, addModifiers, resolver, descriptor, methodName, internalName, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMethod(ClassContext classContext, String internalName, String methodName, MethodDescriptor descriptor) {
        ClassPatchInfo classInfo;
        ClassPatchInfo classPatchInfo = classInfo = this.getOrAdd(classContext).getOrAdd(internalName);
        synchronized (classPatchInfo) {
            classInfo.deleteMethod(methodName, descriptor, internalName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceMethod(ClassContext classContext, String internalName, String methodName, MethodDescriptor descriptor, MethodResolver resolver, int index, int addModifiers) {
        ClassPatchInfo classInfo;
        ClassPatchInfo classPatchInfo = classInfo = this.getOrAdd(classContext).getOrAdd(internalName);
        synchronized (classPatchInfo) {
            classInfo.replaceMethod(new MethodPatchInfo(index, addModifiers, resolver, descriptor, methodName, internalName, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceMethodBody(ClassContext classContext, String internalName, String methodName, MethodDescriptor descriptor, MethodBodyFactory methodBodyFactory, int index) {
        ClassPatchInfo classInfo;
        ClassPatchInfo classPatchInfo = classInfo = this.getOrAdd(classContext).getOrAdd(internalName);
        synchronized (classPatchInfo) {
            classInfo.replaceMethodBody(methodName, descriptor, methodBodyFactory, index);
        }
    }

    void registerAccessor(FieldElement element, VmObject accessor) {
        this.accessors.putIfAbsent(element, accessor);
    }

    VmObject lookUpAccessor(FieldElement element) {
        return this.accessors.get(element);
    }
}

