/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.patcher;

import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Value;
import org.qbicc.plugin.patcher.ClassContextPatchInfo;
import org.qbicc.plugin.patcher.Patcher;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class PatcherResolverBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final ClassContextPatchInfo info;

    private PatcherResolverBasicBlockBuilder(ClassContextPatchInfo info, BasicBlockBuilder delegate) {
        super(delegate);
        this.info = info;
    }

    public static BasicBlockBuilder createIfNeeded(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        ClassContext classContext = delegate.getCurrentClassContext();
        ClassContextPatchInfo info = Patcher.get(classContext.getCompilationContext()).get(classContext);
        if (info == null) {
            return delegate;
        }
        return new PatcherResolverBasicBlockBuilder(info, delegate);
    }

    public Value new_(ClassTypeDescriptor desc) {
        return super.new_(this.info.transform(desc));
    }

    public Value newArray(ArrayTypeDescriptor desc, Value size) {
        return super.newArray(this.info.transform(desc), size);
    }

    public Value multiNewArray(ArrayTypeDescriptor desc, List<Value> dimensions) {
        return super.multiNewArray(this.info.transform(desc), dimensions);
    }

    public Value checkcast(Value value, TypeDescriptor desc) {
        return super.checkcast(value, this.info.transform(desc));
    }

    public Value resolveStaticField(TypeDescriptor owner, String name, TypeDescriptor type) {
        return super.resolveStaticField(this.info.transform(owner), name, this.info.transform(type));
    }

    public Value resolveStaticMethod(TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        return super.resolveStaticMethod(this.info.transform(owner), name, this.info.transform(descriptor));
    }

    public Value instanceFieldOf(Value instancePointer, TypeDescriptor owner, String name, TypeDescriptor type) {
        return super.instanceFieldOf(instancePointer, this.info.transform(owner), name, this.info.transform(type));
    }

    public Value resolveInstanceMethod(TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        return super.resolveInstanceMethod(this.info.transform(owner), name, this.info.transform(descriptor));
    }

    public Value lookupVirtualMethod(Value reference, TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        return super.lookupVirtualMethod(reference, this.info.transform(owner), name, this.info.transform(descriptor));
    }

    public Value lookupInterfaceMethod(Value reference, TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        return super.lookupInterfaceMethod(reference, this.info.transform(owner), name, this.info.transform(descriptor));
    }

    public Value resolveConstructor(TypeDescriptor owner, MethodDescriptor descriptor) {
        return super.resolveConstructor(this.info.transform(owner), this.info.transform(descriptor));
    }

    public Value extractInstanceField(Value valueObj, TypeDescriptor owner, String name, TypeDescriptor type) {
        return super.extractInstanceField(valueObj, this.info.transform(owner), name, this.info.transform(type));
    }
}

