/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reflection;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.GlobalReadWriteAccessMode;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.Literal;
import org.qbicc.interpreter.Thrown;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmArray;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmPrimitiveClass;
import org.qbicc.interpreter.VmReferenceArray;
import org.qbicc.interpreter.VmString;
import org.qbicc.interpreter.VmThread;
import org.qbicc.interpreter.VmThrowableClass;
import org.qbicc.plugin.layout.Layout;
import org.qbicc.plugin.layout.LayoutInfo;
import org.qbicc.plugin.patcher.Patcher;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.plugin.reflection.ReflectiveElementRegistry;
import org.qbicc.pointer.Pointer;
import org.qbicc.pointer.StaticFieldPointer;
import org.qbicc.pointer.StaticMethodPointer;
import org.qbicc.type.CompoundType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.type.TypeAnnotationList;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.MethodBodyFactory;
import org.qbicc.type.definition.classfile.ConstantPool;
import org.qbicc.type.definition.element.AnnotatedElement;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.NestedClassElement;
import org.qbicc.type.definition.element.ParameterElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.definition.element.StaticMethodElement;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.BaseTypeSignature;
import org.qbicc.type.generic.MethodSignature;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;
import org.qbicc.type.methodhandle.MethodHandleKind;

public final class Reflection {
    private static final int IS_METHOD = 65536;
    private static final int IS_CONSTRUCTOR = 131072;
    private static final int IS_FIELD = 262144;
    private static final int IS_TYPE = 524288;
    private static final int CALLER_SENSITIVE = 0x100000;
    private static final int TRUSTED_FINAL = 0x200000;
    static final int KIND_SHIFT = 24;
    static final int KIND_GET_FIELD = MethodHandleKind.GET_FIELD.getId();
    static final int KIND_GET_STATIC = MethodHandleKind.GET_STATIC.getId();
    static final int KIND_PUT_FIELD = MethodHandleKind.PUT_FIELD.getId();
    static final int KIND_PUT_STATIC = MethodHandleKind.PUT_STATIC.getId();
    static final int KIND_INVOKE_VIRTUAL = MethodHandleKind.INVOKE_VIRTUAL.getId();
    static final int KIND_INVOKE_STATIC = MethodHandleKind.INVOKE_STATIC.getId();
    static final int KIND_INVOKE_SPECIAL = MethodHandleKind.INVOKE_SPECIAL.getId();
    static final int KIND_NEW_INVOKE_SPECIAL = MethodHandleKind.NEW_INVOKE_SPECIAL.getId();
    static final int KIND_INVOKE_INTERFACE = MethodHandleKind.INVOKE_INTERFACE.getId();
    static final int KIND_MASK = 15;
    private static final AttachmentKey<Reflection> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Map<VmClass, VmObject> cpMap = new ConcurrentHashMap<VmClass, VmObject>();
    private final Map<VmClass, VmReferenceArray> declaredFields = new ConcurrentHashMap<VmClass, VmReferenceArray>();
    private final Map<VmClass, VmReferenceArray> declaredPublicFields = new ConcurrentHashMap<VmClass, VmReferenceArray>();
    private final Map<VmClass, VmReferenceArray> declaredMethods = new ConcurrentHashMap<VmClass, VmReferenceArray>();
    private final Map<VmClass, VmReferenceArray> declaredPublicMethods = new ConcurrentHashMap<VmClass, VmReferenceArray>();
    private final Map<VmClass, VmReferenceArray> declaredConstructors = new ConcurrentHashMap<VmClass, VmReferenceArray>();
    private final Map<VmClass, VmReferenceArray> declaredPublicConstructors = new ConcurrentHashMap<VmClass, VmReferenceArray>();
    private final Map<VmObject, ConstantPool> cpObjs = new ConcurrentHashMap<VmObject, ConstantPool>();
    private final Map<AnnotatedElement, VmArray> annotatedElements = new ConcurrentHashMap<AnnotatedElement, VmArray>();
    private final Map<Element, VmObject> reflectionObjects = new ConcurrentHashMap<Element, VmObject>();
    private final Map<LoadedTypeDefinition, VmArray> annotatedTypes = new ConcurrentHashMap<LoadedTypeDefinition, VmArray>();
    private final Map<InvokableType, CompoundType> functionCallStructures = new ConcurrentHashMap<InvokableType, CompoundType>();
    private final Map<Element, Map<MethodHandleKind, Pointer>> dispatcherCache = new ConcurrentHashMap<Element, Map<MethodHandleKind, Pointer>>();
    private final VmArray noAnnotations;
    private final Vm vm;
    private final VmClass cpClass;
    private final VmClass classClass;
    private final VmClass fieldClass;
    private final VmClass methodClass;
    private final VmClass constructorClass;
    private final VmClass rmnClass;
    private final VmClass memberNameClass;
    private final VmThrowableClass nullPointerExceptionClass;
    private final VmThrowableClass linkageErrorClass;
    private final VmThrowableClass invocationTargetExceptionClass;
    private final VmClass byteClass;
    private final VmClass shortClass;
    private final VmClass integerClass;
    private final VmClass longClass;
    private final VmClass characterClass;
    private final VmClass floatClass;
    private final VmClass doubleClass;
    private final VmClass booleanClass;
    private final ConstructorElement cpCtor;
    private final ConstructorElement fieldCtor;
    private final ConstructorElement methodCtor;
    private final ConstructorElement ctorCtor;
    private final ConstructorElement rmnCtor;
    private final ConstructorElement memberName4Ctor;
    final InstanceFieldElement memberNameClazzField;
    final InstanceFieldElement memberNameNameField;
    final InstanceFieldElement memberNameTypeField;
    final InstanceFieldElement memberNameFlagsField;
    final InstanceFieldElement memberNameMethodField;
    final InstanceFieldElement memberNameIndexField;
    final InstanceFieldElement memberNameResolvedField;
    final InstanceFieldElement memberNameExactDispatcherField;
    private final InstanceFieldElement fieldClazzField;
    private final InstanceFieldElement fieldSlotField;
    private final InstanceFieldElement fieldNameField;
    private final InstanceFieldElement fieldTypeField;
    private final InstanceFieldElement methodClazzField;
    private final InstanceFieldElement methodSlotField;
    private final InstanceFieldElement methodNameField;
    private final InstanceFieldElement methodReturnTypeField;
    private final InstanceFieldElement methodParameterTypesField;
    private final InstanceFieldElement ctorClazzField;
    private final InstanceFieldElement ctorSlotField;
    private final InstanceFieldElement ctorParameterTypesField;
    private final InstanceFieldElement rmnIndexField;
    private final InstanceFieldElement rmnClazzField;
    private final InstanceFieldElement methodTypePTypesField;
    private final InstanceFieldElement methodTypeRTypeField;
    final InstanceFieldElement methodHandleLambdaFormField;
    final InstanceFieldElement lambdaFormMemberNameField;
    private final FieldElement byteValueField;
    private final FieldElement shortValueField;
    private final FieldElement integerValueField;
    private final FieldElement longValueField;
    private final FieldElement characterValueField;
    private final FieldElement floatValueField;
    private final FieldElement doubleValueField;
    private final FieldElement booleanValueField;
    final MethodElement methodHandleNativesFindMethodHandleType;
    final MethodElement methodHandleNativesLinkMethod;
    final MethodElement methodHandleNativesResolve;
    final MethodElement methodHandleCheckType;

    private Reflection(CompilationContext ctxt) {
        this.ctxt = ctxt;
        ClassContext classContext = ctxt.getBootstrapClassContext();
        Patcher patcher = Patcher.get((CompilationContext)ctxt);
        patcher.addField(classContext, "java/lang/invoke/MemberName", "index", (TypeDescriptor)BaseTypeDescriptor.I, this::resolveIndexField, 0, 0);
        patcher.addField(classContext, "java/lang/invoke/MemberName", "resolved", (TypeDescriptor)BaseTypeDescriptor.Z, this::resolveResolvedField, 0, 0);
        patcher.addField(classContext, "java/lang/invoke/MemberName", "exactDispatcher", (TypeDescriptor)BaseTypeDescriptor.V, this::resolveExactDispatcherField, 0, 0);
        patcher.addField(classContext, "java/lang/invoke/ResolvedMethodName", "index", (TypeDescriptor)BaseTypeDescriptor.I, this::resolveIndexField, 0, 0);
        patcher.addField(classContext, "java/lang/invoke/ResolvedMethodName", "clazz", (TypeDescriptor)ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class"), this::resolveClazzField, 0, 0);
        this.vm = ctxt.getVm();
        this.noAnnotations = this.vm.newByteArray(new byte[2]);
        LoadedTypeDefinition cpDef = classContext.findDefinedType("jdk/internal/reflect/ConstantPool").load();
        this.cpClass = cpDef.getVmClass();
        this.cpCtor = cpDef.getConstructor(0);
        this.vm.registerInvokable((ExecutableElement)cpDef.requireSingleMethod(me -> me.nameEquals("getIntAt0")), this::getIntAt0);
        this.vm.registerInvokable((ExecutableElement)cpDef.requireSingleMethod(me -> me.nameEquals("getLongAt0")), this::getLongAt0);
        this.vm.registerInvokable((ExecutableElement)cpDef.requireSingleMethod(me -> me.nameEquals("getFloatAt0")), this::getFloatAt0);
        this.vm.registerInvokable((ExecutableElement)cpDef.requireSingleMethod(me -> me.nameEquals("getDoubleAt0")), this::getDoubleAt0);
        this.vm.registerInvokable((ExecutableElement)cpDef.requireSingleMethod(me -> me.nameEquals("getUTF8At0")), this::getUTF8At0);
        LoadedTypeDefinition classDef = classContext.findDefinedType("java/lang/Class").load();
        this.classClass = classDef.getVmClass();
        this.vm.registerInvokable((ExecutableElement)classDef.requireSingleMethod(me -> me.nameEquals("getRawAnnotations")), this::getClassRawAnnotations);
        this.vm.registerInvokable((ExecutableElement)classDef.requireSingleMethod(me -> me.nameEquals("getDeclaredFields0")), this::getClassDeclaredFields0);
        this.vm.registerInvokable((ExecutableElement)classDef.requireSingleMethod(me -> me.nameEquals("getDeclaredMethods0")), this::getClassDeclaredMethods0);
        this.vm.registerInvokable((ExecutableElement)classDef.requireSingleMethod(me -> me.nameEquals("getDeclaredConstructors0")), this::getClassDeclaredConstructors0);
        this.vm.registerInvokable((ExecutableElement)classDef.requireSingleMethod(me -> me.nameEquals("getSimpleBinaryName")), (thread, target, args) -> {
            if (target instanceof VmPrimitiveClass) {
                return null;
            }
            NestedClassElement enc = ((VmClass)target).getTypeDefinition().getEnclosingNestedClass();
            return enc == null ? null : this.vm.intern(enc.getName());
        });
        this.vm.registerInvokable((ExecutableElement)classDef.requireSingleMethod(me -> me.nameEquals("getConstantPool")), (thread, target, args) -> {
            this.getConstantPoolForClass((VmClass)target);
            return this.cpMap.get(target);
        });
        LoadedTypeDefinition fieldDef = classContext.findDefinedType("java/lang/reflect/Field").load();
        this.fieldClass = fieldDef.getVmClass();
        this.fieldCtor = fieldDef.requireSingleConstructor(ce -> ce.getDescriptor().getParameterTypes().size() == 8);
        LoadedTypeDefinition methodDef = classContext.findDefinedType("java/lang/reflect/Method").load();
        this.methodClass = methodDef.getVmClass();
        this.methodCtor = methodDef.requireSingleConstructor(ce -> ce.getDescriptor().getParameterTypes().size() == 11);
        LoadedTypeDefinition ctorDef = classContext.findDefinedType("java/lang/reflect/Constructor").load();
        this.constructorClass = ctorDef.getVmClass();
        this.ctorCtor = ctorDef.requireSingleConstructor(ce -> ce.getDescriptor().getParameterTypes().size() == 8);
        LoadedTypeDefinition mhDef = classContext.findDefinedType("java/lang/invoke/MethodHandle").load();
        this.methodHandleCheckType = mhDef.requireSingleMethod("checkType");
        this.methodHandleLambdaFormField = mhDef.findInstanceField("form");
        LoadedTypeDefinition mhnDef = classContext.findDefinedType("java/lang/invoke/MethodHandleNatives").load();
        this.vm.registerInvokable((ExecutableElement)mhnDef.requireSingleMethod(me -> me.nameEquals("init")), this::methodHandleNativesInit);
        this.methodHandleNativesResolve = mhnDef.requireSingleMethod(me -> me.nameEquals("resolve"));
        this.vm.registerInvokable((ExecutableElement)this.methodHandleNativesResolve, this::methodHandleNativesResolve);
        this.vm.registerInvokable((ExecutableElement)mhnDef.requireSingleMethod(me -> me.nameEquals("objectFieldOffset")), this::methodHandleNativesObjectFieldOffset);
        this.vm.registerInvokable((ExecutableElement)mhnDef.requireSingleMethod(me -> me.nameEquals("staticFieldBase")), this::methodHandleNativesStaticFieldBase);
        this.vm.registerInvokable((ExecutableElement)mhnDef.requireSingleMethod(me -> me.nameEquals("staticFieldOffset")), this::methodHandleNativesStaticFieldOffset);
        this.vm.registerInvokable((ExecutableElement)mhnDef.requireSingleMethod(me -> me.nameEquals("verifyConstants")), (thread, target, args) -> Boolean.TRUE);
        LoadedTypeDefinition lfDef = classContext.findDefinedType("java/lang/invoke/LambdaForm").load();
        this.lambdaFormMemberNameField = lfDef.findInstanceField("vmentry");
        LoadedTypeDefinition nativeCtorAccImplDef = classContext.findDefinedType("jdk/internal/reflect/NativeConstructorAccessorImpl").load();
        this.vm.registerInvokable((ExecutableElement)nativeCtorAccImplDef.requireSingleMethod(me -> me.nameEquals("newInstance0")), this::nativeConstructorAccessorImplNewInstance0);
        LoadedTypeDefinition nativeMethodAccImplDef = classContext.findDefinedType("jdk/internal/reflect/NativeMethodAccessorImpl").load();
        this.vm.registerInvokable((ExecutableElement)nativeMethodAccImplDef.requireSingleMethod(me -> me.nameEquals("invoke0")), this::nativeMethodAccessorImplInvoke0);
        LoadedTypeDefinition reflectionFactoryDef = classContext.findDefinedType("jdk/internal/reflect/ReflectionFactory").load();
        this.vm.registerInvokable((ExecutableElement)reflectionFactoryDef.requireSingleMethod("inflationThreshold"), (thread, target, args) -> Integer.MAX_VALUE);
        LoadedTypeDefinition memberNameDef = classContext.findDefinedType("java/lang/invoke/MemberName").load();
        this.vm.registerInvokable((ExecutableElement)memberNameDef.requireSingleMethod(me -> me.nameEquals("vminfoIsConsistent")), (thread, target, args) -> Boolean.TRUE);
        this.memberNameClazzField = memberNameDef.findInstanceField("clazz");
        this.memberNameNameField = memberNameDef.findInstanceField("name");
        this.memberNameTypeField = memberNameDef.findInstanceField("type");
        this.memberNameFlagsField = memberNameDef.findInstanceField("flags");
        this.memberNameMethodField = memberNameDef.findInstanceField("method");
        this.memberNameIndexField = memberNameDef.findInstanceField("index");
        this.memberNameResolvedField = memberNameDef.findInstanceField("resolved");
        this.memberNameExactDispatcherField = memberNameDef.findInstanceField("exactDispatcher");
        MethodDescriptor memberName4Desc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(BaseTypeDescriptor.B, classDef.getDescriptor(), ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/String"), ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object")));
        this.memberNameClass = memberNameDef.getVmClass();
        this.memberName4Ctor = memberNameDef.resolveConstructorElement(memberName4Desc);
        this.methodHandleNativesLinkMethod = mhnDef.requireSingleMethod(me -> me.nameEquals("linkMethod"));
        this.methodHandleNativesFindMethodHandleType = mhnDef.requireSingleMethod(me -> me.nameEquals("findMethodHandleType"));
        this.fieldClazzField = fieldDef.findInstanceField("clazz");
        this.fieldSlotField = fieldDef.findInstanceField("slot");
        this.fieldNameField = fieldDef.findInstanceField("name");
        this.fieldTypeField = fieldDef.findInstanceField("type");
        this.methodClazzField = methodDef.findInstanceField("clazz");
        this.methodSlotField = methodDef.findInstanceField("slot");
        this.methodNameField = methodDef.findInstanceField("name");
        this.methodReturnTypeField = methodDef.findInstanceField("returnType");
        this.methodParameterTypesField = methodDef.findInstanceField("parameterTypes");
        this.ctorClazzField = ctorDef.findInstanceField("clazz");
        this.ctorSlotField = ctorDef.findInstanceField("slot");
        this.ctorParameterTypesField = ctorDef.findInstanceField("parameterTypes");
        LoadedTypeDefinition rmnDef = classContext.findDefinedType("java/lang/invoke/ResolvedMethodName").load();
        this.rmnCtor = rmnDef.getConstructor(0);
        this.rmnClass = rmnDef.getVmClass();
        this.rmnIndexField = rmnDef.findInstanceField("index");
        this.rmnClazzField = rmnDef.findInstanceField("clazz");
        LoadedTypeDefinition leDef = classContext.findDefinedType("java/lang/LinkageError").load();
        this.linkageErrorClass = (VmThrowableClass)leDef.getVmClass();
        LoadedTypeDefinition iteDef = classContext.findDefinedType("java/lang/reflect/InvocationTargetException").load();
        this.invocationTargetExceptionClass = (VmThrowableClass)iteDef.getVmClass();
        LoadedTypeDefinition npeDef = classContext.findDefinedType("java/lang/NullPointerException").load();
        this.nullPointerExceptionClass = (VmThrowableClass)npeDef.getVmClass();
        LoadedTypeDefinition mtDef = classContext.findDefinedType("java/lang/invoke/MethodType").load();
        this.methodTypeRTypeField = mtDef.findInstanceField("rtype");
        this.methodTypePTypesField = mtDef.findInstanceField("ptypes");
        LoadedTypeDefinition byteDef = classContext.findDefinedType("java/lang/Byte").load();
        this.byteClass = byteDef.getVmClass();
        this.byteValueField = byteDef.findField("value");
        LoadedTypeDefinition shortDef = classContext.findDefinedType("java/lang/Short").load();
        this.shortClass = shortDef.getVmClass();
        this.shortValueField = shortDef.findField("value");
        LoadedTypeDefinition integerDef = classContext.findDefinedType("java/lang/Integer").load();
        this.integerClass = integerDef.getVmClass();
        this.integerValueField = integerDef.findField("value");
        LoadedTypeDefinition longDef = classContext.findDefinedType("java/lang/Long").load();
        this.longClass = longDef.getVmClass();
        this.longValueField = longDef.findField("value");
        LoadedTypeDefinition characterDef = classContext.findDefinedType("java/lang/Character").load();
        this.characterClass = characterDef.getVmClass();
        this.characterValueField = characterDef.findField("value");
        LoadedTypeDefinition floatDef = classContext.findDefinedType("java/lang/Float").load();
        this.floatClass = floatDef.getVmClass();
        this.floatValueField = floatDef.findField("value");
        LoadedTypeDefinition doubleDef = classContext.findDefinedType("java/lang/Double").load();
        this.doubleClass = doubleDef.getVmClass();
        this.doubleValueField = doubleDef.findField("value");
        LoadedTypeDefinition booleanDef = classContext.findDefinedType("java/lang/Boolean").load();
        this.booleanClass = booleanDef.getVmClass();
        this.booleanValueField = booleanDef.findField("value");
    }

    public static Reflection get(CompilationContext ctxt) {
        Reflection appearing;
        Reflection instance = (Reflection)ctxt.getAttachment(KEY);
        if (instance == null && (appearing = (Reflection)ctxt.putAttachmentIfAbsent(KEY, (Object)(instance = new Reflection(ctxt)))) != null) {
            instance = appearing;
        }
        return instance;
    }

    public void generateReflectiveData(LoadedTypeDefinition ltd) {
        boolean isReflectiveType = ReflectiveElementRegistry.get(this.ctxt).isReflectiveType(ltd);
        if (isReflectiveType || ltd.isPrimitive() || !ltd.getVisibleAnnotations().isEmpty() || !ltd.isInterface() && this.hasInheritedAnnotations(ltd)) {
            MethodElement annotationData = this.classClass.getTypeDefinition().requireSingleMethod("annotationData");
            this.vm.invokeExact(annotationData, (VmObject)ltd.getVmClass(), List.of());
        }
        if (isReflectiveType || ltd.isPrimitive()) {
            MethodElement getGenericInfo = this.classClass.getTypeDefinition().requireSingleMethod("getGenericInfo");
            this.vm.invokeExact(getGenericInfo, (VmObject)ltd.getVmClass(), List.of());
        }
        if (ltd.isEnum()) {
            MethodElement getEC = this.classClass.getTypeDefinition().requireSingleMethod("getEnumConstantsShared");
            this.vm.invokeExact(getEC, (VmObject)ltd.getVmClass(), List.of());
        }
    }

    private boolean hasInheritedAnnotations(LoadedTypeDefinition ltd) {
        if (!ltd.hasSuperClass()) {
            return false;
        }
        if (!ltd.getVisibleAnnotations().isEmpty()) {
            return true;
        }
        return this.hasInheritedAnnotations(ltd.getSuperClass());
    }

    public void makeConstructorsAvailableForRuntimeReflection(LoadedTypeDefinition ltd) {
        VmClass c = ltd.getVmClass();
        this.getClassDeclaredConstructors(c, true);
        this.getClassDeclaredConstructors(c, false);
    }

    public void makeMethodsAvailableForRuntimeReflection(LoadedTypeDefinition ltd) {
        VmClass c = ltd.getVmClass();
        this.getClassDeclaredMethods(c, true);
        this.getClassDeclaredMethods(c, false);
    }

    public void makeFieldsAvailableForRuntimeReflection(LoadedTypeDefinition ltd) {
        VmClass c = ltd.getVmClass();
        this.getClassDeclaredFields(c, true);
        this.getClassDeclaredFields(c, false);
    }

    public void transferToReflectionData() {
        LoadedTypeDefinition rdDef = this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/Class$ReflectionData").load();
        LayoutInfo rdLayout = Layout.get((CompilationContext)this.ctxt).getInstanceLayoutInfo((DefinedTypeDefinition)rdDef);
        long rdIndex = this.classClass.indexOf(this.classClass.getTypeDefinition().findField("qbiccReflectionData"));
        long dfi = rdLayout.getMember(rdDef.findField("declaredFields")).getOffset();
        this.declaredFields.forEach((c, a) -> c.getMemory().loadRef(rdIndex, (ReadAccessMode)AccessModes.SinglePlain).getMemory().storeRef(dfi, (VmObject)a, (WriteAccessMode)AccessModes.SinglePlain));
        long dpfi = rdLayout.getMember(rdDef.findField("declaredPublicFields")).getOffset();
        this.declaredPublicFields.forEach((c, a) -> c.getMemory().loadRef(rdIndex, (ReadAccessMode)AccessModes.SinglePlain).getMemory().storeRef(dpfi, (VmObject)a, (WriteAccessMode)AccessModes.SinglePlain));
        long dmi = rdLayout.getMember(rdDef.findField("declaredMethods")).getOffset();
        this.declaredMethods.forEach((c, a) -> c.getMemory().loadRef(rdIndex, (ReadAccessMode)AccessModes.SinglePlain).getMemory().storeRef(dmi, (VmObject)a, (WriteAccessMode)AccessModes.SinglePlain));
        long dpmi = rdLayout.getMember(rdDef.findField("declaredPublicMethods")).getOffset();
        this.declaredPublicMethods.forEach((c, a) -> c.getMemory().loadRef(rdIndex, (ReadAccessMode)AccessModes.SinglePlain).getMemory().storeRef(dpmi, (VmObject)a, (WriteAccessMode)AccessModes.SinglePlain));
        long dci = rdLayout.getMember(rdDef.findField("declaredConstructors")).getOffset();
        this.declaredConstructors.forEach((c, a) -> c.getMemory().loadRef(rdIndex, (ReadAccessMode)AccessModes.SinglePlain).getMemory().storeRef(dci, (VmObject)a, (WriteAccessMode)AccessModes.SinglePlain));
        long dpci = rdLayout.getMember(rdDef.findField("publicConstructors")).getOffset();
        this.declaredPublicConstructors.forEach((c, a) -> c.getMemory().loadRef(rdIndex, (ReadAccessMode)AccessModes.SinglePlain).getMemory().storeRef(dpci, (VmObject)a, (WriteAccessMode)AccessModes.SinglePlain));
        long ii = rdLayout.getMember(rdDef.findField("interfaces")).getOffset();
        VmReferenceArray none = this.vm.newArrayOf(this.classClass, 0);
        ReachabilityInfo.get((CompilationContext)this.ctxt).visitReachableTypes(ltd -> {
            VmReferenceArray impl = none;
            LoadedTypeDefinition[] implemented = ltd.getInterfaces();
            if (implemented.length > 0) {
                impl = this.vm.newArrayOf(this.classClass, implemented.length);
                for (int j = 0; j < implemented.length; ++j) {
                    impl.store(j, (VmObject)implemented[j].getVmClass());
                }
            }
            ltd.getVmClass().getMemory().loadRef(rdIndex, (ReadAccessMode)AccessModes.SinglePlain).getMemory().storeRef(ii, (VmObject)impl, (WriteAccessMode)AccessModes.SinglePlain);
        });
    }

    static MethodDescriptor erase(ClassContext classContext, MethodDescriptor descriptor) {
        TypeDescriptor erasedRetType = Reflection.erase(classContext, descriptor.getReturnType());
        List<TypeDescriptor> erasedTypes = Reflection.erase(classContext, descriptor.getParameterTypes());
        return MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)erasedRetType, erasedTypes);
    }

    static TypeDescriptor erase(ClassContext classContext, TypeDescriptor type) {
        if (type instanceof BaseTypeDescriptor) {
            BaseTypeDescriptor btd = (BaseTypeDescriptor)type;
            return btd;
        }
        return ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
    }

    static List<TypeDescriptor> erase(ClassContext classContext, List<TypeDescriptor> types) {
        if (types.isEmpty()) {
            return List.of();
        }
        if (types.size() == 1) {
            return List.of(Reflection.erase(classContext, types.get(0)));
        }
        ArrayList<TypeDescriptor> list = new ArrayList<TypeDescriptor>(types.size());
        for (TypeDescriptor type : types) {
            list.add(Reflection.erase(classContext, type));
        }
        return list;
    }

    static boolean isErased(MethodDescriptor descriptor) {
        return Reflection.isErased(descriptor.getReturnType()) && Reflection.isErased(descriptor.getParameterTypes());
    }

    static boolean isErased(TypeDescriptor typeDescriptor) {
        ClassTypeDescriptor ctd;
        return typeDescriptor instanceof BaseTypeDescriptor || typeDescriptor instanceof ClassTypeDescriptor && (ctd = (ClassTypeDescriptor)typeDescriptor).packageAndClassNameEquals("java/lang", "Object");
    }

    static boolean isErased(List<TypeDescriptor> types) {
        for (TypeDescriptor type : types) {
            if (Reflection.isErased(type)) continue;
            return false;
        }
        return true;
    }

    ConstantPool getConstantPoolForClass(VmClass vmClass) {
        return this.cpObjs.computeIfAbsent(this.cpMap.computeIfAbsent(vmClass, this::makePoolObj), Reflection::makePool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VmArray getAnnotations(AnnotatedElement element) {
        VmArray bytes = this.annotatedElements.get(element);
        if (bytes != null) {
            return bytes;
        }
        List annotations = element.getVisibleAnnotations();
        if (annotations.isEmpty()) {
            this.annotatedElements.putIfAbsent(element, this.noAnnotations);
            return this.noAnnotations;
        }
        VmClass vmClass = element.getEnclosingType().load().getVmClass();
        ConstantPool constantPool = this.getConstantPoolForClass(vmClass);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ConstantPool constantPool2 = constantPool;
        synchronized (constantPool2) {
            int cnt = annotations.size();
            os.write(cnt >>> 8);
            os.write(cnt);
            for (Annotation annotation : annotations) {
                annotation.deparseTo(os, constantPool);
            }
        }
        bytes = this.vm.newByteArray(os.toByteArray());
        VmArray appearing = this.annotatedElements.putIfAbsent(element, bytes);
        if (appearing != null) {
            bytes = appearing;
        }
        return bytes;
    }

    VmArray getParameterAnnotations(InvokableElement element) {
        if (element.getParameters() == null || element.getParameters().isEmpty()) {
            return null;
        }
        List paramAnnotations = element.getParameterVisibleTypeAnnotations();
        boolean nonEmpty = false;
        for (TypeAnnotationList tl : paramAnnotations) {
            if (tl == TypeAnnotationList.empty()) continue;
            nonEmpty = true;
        }
        if (!nonEmpty) {
            return null;
        }
        this.ctxt.warning("Skipped generating parameter annotations for " + element, new Object[0]);
        return null;
    }

    private VmObject makePoolObj(Object ignored) {
        return this.vm.newInstance(this.cpClass, this.cpCtor, List.of());
    }

    private static ConstantPool makePool(Object ignored) {
        return new ConstantPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getIntAt0(VmThread vmThread, VmObject vmObject, List<Object> objects) {
        ConstantPool constantPool = this.cpObjs.get(vmObject);
        assert (constantPool != null);
        ConstantPool constantPool2 = constantPool;
        synchronized (constantPool2) {
            return constantPool.getIntConstant(((Number)objects.get(1)).intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLongAt0(VmThread vmThread, VmObject vmObject, List<Object> objects) {
        ConstantPool constantPool = this.cpObjs.get(vmObject);
        assert (constantPool != null);
        ConstantPool constantPool2 = constantPool;
        synchronized (constantPool2) {
            return constantPool.getLongConstant(((Number)objects.get(1)).intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFloatAt0(VmThread vmThread, VmObject vmObject, List<Object> objects) {
        ConstantPool constantPool = this.cpObjs.get(vmObject);
        assert (constantPool != null);
        ConstantPool constantPool2 = constantPool;
        synchronized (constantPool2) {
            return Float.valueOf(Float.intBitsToFloat(constantPool.getIntConstant(((Number)objects.get(1)).intValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDoubleAt0(VmThread vmThread, VmObject vmObject, List<Object> objects) {
        ConstantPool constantPool = this.cpObjs.get(vmObject);
        assert (constantPool != null);
        ConstantPool constantPool2 = constantPool;
        synchronized (constantPool2) {
            return constantPool.getLongConstant(((Number)objects.get(1)).intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUTF8At0(VmThread vmThread, VmObject vmObject, List<Object> objects) {
        ConstantPool constantPool = this.cpObjs.get(vmObject);
        assert (constantPool != null);
        ConstantPool constantPool2 = constantPool;
        synchronized (constantPool2) {
            return this.vm.intern(constantPool.getUtf8Constant(((Number)objects.get(1)).intValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getClassRawAnnotations(VmThread vmThread, VmObject vmObject, List<Object> objects) {
        VmClass vmClass = (VmClass)vmObject;
        LoadedTypeDefinition def = vmClass.getTypeDefinition();
        VmArray bytes = this.annotatedTypes.get(def);
        if (bytes != null) {
            return bytes;
        }
        List annotations = def.getVisibleAnnotations();
        if (annotations.isEmpty()) {
            this.annotatedTypes.putIfAbsent(def, this.noAnnotations);
            return this.noAnnotations;
        }
        ConstantPool constantPool = this.getConstantPoolForClass(vmClass);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int cnt = annotations.size();
        os.write(cnt >>> 8);
        os.write(cnt);
        ConstantPool constantPool2 = constantPool;
        synchronized (constantPool2) {
            for (Annotation annotation : annotations) {
                annotation.deparseTo(os, constantPool);
            }
        }
        bytes = this.vm.newByteArray(os.toByteArray());
        VmArray appearing = this.annotatedTypes.putIfAbsent(def, bytes);
        if (appearing != null) {
            bytes = appearing;
        }
        return bytes;
    }

    private Object getClassDeclaredFields0(VmThread vmThread, VmObject vmObject, List<Object> objects) {
        return this.getClassDeclaredFields((VmClass)vmObject, (Boolean)objects.get(0));
    }

    VmObject getField(FieldElement field) {
        VmObject vmObject = this.reflectionObjects.get(field);
        if (vmObject != null) {
            return vmObject;
        }
        if (!field.isStatic()) {
            field.setModifierFlags(65536);
        }
        VmClass declaringClass = field.getEnclosingType().load().getVmClass();
        vmObject = this.vm.newInstance(this.fieldClass, this.fieldCtor, Arrays.asList(declaringClass, this.vm.intern(field.getName()), this.vm.getClassForDescriptor(declaringClass.getClassLoader(), field.getTypeDescriptor()), field.getModifiers() & 0x1FFF, Boolean.FALSE, field.getIndex(), this.vm.intern(field.getTypeSignature().toString()), this.getAnnotations((AnnotatedElement)field)));
        int memOffset = this.fieldClass.indexOf(this.fieldClass.getTypeDefinition().findField("offset"));
        if (field.isStatic()) {
            vmObject.getMemory().storePointer((long)memOffset, (Pointer)StaticFieldPointer.of((StaticFieldElement)((StaticFieldElement)field)), (WriteAccessMode)AccessModes.SinglePlain);
        } else {
            LayoutInfo layoutInfo = Layout.get((CompilationContext)this.vm.getCompilationContext()).getInstanceLayoutInfo((DefinedTypeDefinition)field.getEnclosingType().load());
            CompoundType.Member member = layoutInfo.getMember(field);
            vmObject.getMemory().store64((long)memOffset, (long)member.getOffset(), (WriteAccessMode)AccessModes.SinglePlain);
        }
        VmObject appearing = this.reflectionObjects.putIfAbsent((Element)field, vmObject);
        if (appearing == null) {
            MethodElement afa = this.fieldClass.getTypeDefinition().requireSingleMethod("acquireFieldAccessor", 1);
            MethodElement da = this.fieldClass.getTypeDefinition().requireSingleMethod("declaredAnnotations");
            this.ctxt.submitTask((Object)vmObject, fieldObject -> {
                this.vm.invokeExact(afa, fieldObject, List.of(Boolean.TRUE));
                this.vm.invokeExact(afa, fieldObject, List.of(Boolean.FALSE));
                this.vm.invokeExact(da, fieldObject, List.of());
            });
        }
        return appearing != null ? appearing : vmObject;
    }

    private VmReferenceArray getClassDeclaredFields(VmClass vmClass, boolean publicOnly) {
        Map<VmClass, VmReferenceArray> map = publicOnly ? this.declaredPublicFields : this.declaredFields;
        VmReferenceArray result = map.get(vmClass);
        if (result != null) {
            return result;
        }
        int total = 0;
        LoadedTypeDefinition def = vmClass.getTypeDefinition();
        for (int i = 0; i < def.getFieldCount(); ++i) {
            FieldElement field = def.getField(i);
            if (field.hasAllModifiersOf(0x800000) || publicOnly && !field.isPublic()) continue;
            ++total;
        }
        VmReferenceArray pubFields = this.vm.newArrayOf(this.fieldClass, total);
        int pubIdx = 0;
        for (int i = 0; i < def.getFieldCount(); ++i) {
            FieldElement field = def.getField(i);
            if (field.hasAllModifiersOf(0x800000) || publicOnly && !field.isPublic()) continue;
            pubFields.getArray()[pubIdx++] = this.getField(field);
        }
        VmReferenceArray appearing = map.putIfAbsent(vmClass, pubFields);
        return appearing != null ? appearing : pubFields;
    }

    private Object getClassDeclaredMethods0(VmThread vmThread, VmObject vmObject, List<Object> objects) {
        return this.getClassDeclaredMethods((VmClass)vmObject, (Boolean)objects.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VmObject getMethod(MethodElement method) {
        VmArray dv;
        VmObject vmObject = this.reflectionObjects.get(method);
        if (vmObject != null) {
            return vmObject;
        }
        VmClass declaringClass = method.getEnclosingType().load().getVmClass();
        VmClassLoader classLoader = declaringClass.getClassLoader();
        MethodDescriptor desc = method.getDescriptor();
        List paramTypes = desc.getParameterTypes();
        VmReferenceArray paramTypesVal = this.vm.newArrayOf(this.classClass, paramTypes.size());
        VmObject[] paramTypesValArray = paramTypesVal.getArray();
        for (int j = 0; j < paramTypes.size(); ++j) {
            paramTypesValArray[j] = this.vm.getClassForDescriptor(classLoader, (TypeDescriptor)paramTypes.get(j));
        }
        AnnotationValue defaultValue = method.getDefaultValue();
        if (defaultValue == null) {
            dv = null;
        } else {
            ConstantPool cp;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ConstantPool constantPool = cp = this.getConstantPoolForClass(declaringClass);
            synchronized (constantPool) {
                defaultValue.deparseValueTo(os, cp);
            }
            dv = this.vm.newByteArray(os.toByteArray());
        }
        vmObject = this.vm.newInstance(this.methodClass, this.methodCtor, Arrays.asList(declaringClass, this.vm.intern(method.getName()), paramTypesVal, this.vm.getClassForDescriptor(classLoader, method.getDescriptor().getReturnType()), this.vm.newArrayOf(this.classClass, 0), method.getModifiers() & 0x1FFF, method.getIndex(), this.vm.intern(method.getSignature().toString()), this.getAnnotations((AnnotatedElement)method), this.getParameterAnnotations((InvokableElement)method), dv));
        VmObject appearing = this.reflectionObjects.putIfAbsent((Element)method, vmObject);
        if (appearing == null) {
            MethodElement ama = this.methodClass.getTypeDefinition().requireSingleMethod("acquireMethodAccessor", 0);
            MethodElement da = this.methodClass.getTypeDefinition().getSuperClass().requireSingleMethod("declaredAnnotations");
            this.ctxt.submitTask((Object)vmObject, methodObject -> {
                if (!method.isNative()) {
                    this.vm.invokeExact(ama, methodObject, List.of());
                }
                this.vm.invokeExact(da, methodObject, List.of());
                if (method.getVisibleTypeAnnotations() != TypeAnnotationList.empty()) {
                    this.ctxt.warning("Did not generate typeAnnotations for " + method, new Object[0]);
                }
            });
        }
        return appearing != null ? appearing : vmObject;
    }

    private VmReferenceArray getClassDeclaredMethods(VmClass vmClass, boolean publicOnly) {
        Map<VmClass, VmReferenceArray> map = publicOnly ? this.declaredPublicMethods : this.declaredMethods;
        VmReferenceArray result = map.get(vmClass);
        if (result != null) {
            return result;
        }
        int total = 0;
        LoadedTypeDefinition def = vmClass.getTypeDefinition();
        for (int i = 0; i < def.getMethodCount(); ++i) {
            MethodElement method = def.getMethod(i);
            if (method.hasAllModifiersOf(0x800000) || publicOnly && !method.isPublic()) continue;
            ++total;
        }
        VmReferenceArray pubMethods = this.vm.newArrayOf(this.methodClass, total);
        int pubIdx = 0;
        VmObject[] pubMethodsArray = pubMethods.getArray();
        for (int i = 0; i < def.getMethodCount(); ++i) {
            MethodElement method = def.getMethod(i);
            if (method.hasAllModifiersOf(0x800000) || publicOnly && !method.isPublic()) continue;
            pubMethodsArray[pubIdx++] = this.getMethod(method);
        }
        VmReferenceArray appearing = map.putIfAbsent(vmClass, pubMethods);
        return appearing != null ? appearing : pubMethods;
    }

    private Object getClassDeclaredConstructors0(VmThread vmThread, VmObject vmObject, List<Object> objects) {
        return this.getClassDeclaredConstructors((VmClass)vmObject, (Boolean)objects.get(0));
    }

    private VmObject getConstructor(ConstructorElement constructor) {
        VmObject vmObject = this.reflectionObjects.get(constructor);
        if (vmObject != null) {
            return vmObject;
        }
        VmClass declaringClass = constructor.getEnclosingType().load().getVmClass();
        VmClassLoader classLoader = declaringClass.getClassLoader();
        MethodDescriptor desc = constructor.getDescriptor();
        List paramTypes = desc.getParameterTypes();
        VmReferenceArray paramTypesVal = this.vm.newArrayOf(this.classClass, paramTypes.size());
        VmObject[] paramTypesValArray = paramTypesVal.getArray();
        for (int j = 0; j < paramTypes.size(); ++j) {
            paramTypesValArray[j] = this.vm.getClassForDescriptor(classLoader, (TypeDescriptor)paramTypes.get(j));
        }
        vmObject = this.vm.newInstance(this.constructorClass, this.ctorCtor, Arrays.asList(declaringClass, paramTypesVal, this.vm.newArrayOf(this.classClass, 0), constructor.getModifiers() & 0x1FFF, constructor.getIndex(), this.vm.intern(constructor.getSignature().toString()), this.getAnnotations((AnnotatedElement)constructor), this.getParameterAnnotations((InvokableElement)constructor)));
        VmObject appearing = this.reflectionObjects.putIfAbsent((Element)constructor, vmObject);
        if (appearing == null) {
            MethodElement aca = this.constructorClass.getTypeDefinition().requireSingleMethod("acquireConstructorAccessor", 0);
            MethodElement da = this.constructorClass.getTypeDefinition().getSuperClass().requireSingleMethod("declaredAnnotations");
            this.ctxt.submitTask((Object)vmObject, ctorObject -> {
                this.vm.invokeExact(aca, ctorObject, List.of());
                this.vm.invokeExact(da, ctorObject, List.of());
                constructor.getParameters();
                if (constructor.getVisibleTypeAnnotations() != TypeAnnotationList.empty()) {
                    this.ctxt.warning("Did not generate typeAnnotations for " + constructor, new Object[0]);
                }
            });
        }
        return appearing != null ? appearing : vmObject;
    }

    private VmReferenceArray getClassDeclaredConstructors(VmClass vmClass, boolean publicOnly) {
        Map<VmClass, VmReferenceArray> map = publicOnly ? this.declaredPublicConstructors : this.declaredConstructors;
        VmReferenceArray result = map.get(vmClass);
        if (result != null) {
            return result;
        }
        int total = 0;
        LoadedTypeDefinition def = vmClass.getTypeDefinition();
        for (int i = 0; i < def.getConstructorCount(); ++i) {
            ConstructorElement constructor = def.getConstructor(i);
            if (constructor.hasAllModifiersOf(0x800000) || publicOnly && !constructor.isPublic()) continue;
            ++total;
        }
        VmReferenceArray pubConstructors = this.vm.newArrayOf(this.constructorClass, total);
        int pubIdx = 0;
        VmObject[] pubConstructorsArray = pubConstructors.getArray();
        for (int i = 0; i < def.getConstructorCount(); ++i) {
            ConstructorElement constructor = def.getConstructor(i);
            if (constructor.hasAllModifiersOf(0x800000) || publicOnly && !constructor.isPublic()) continue;
            pubConstructorsArray[pubIdx++] = this.getConstructor(constructor);
        }
        VmReferenceArray appearing = map.putIfAbsent(vmClass, pubConstructors);
        return appearing != null ? appearing : pubConstructors;
    }

    private Object methodHandleNativesInit(VmThread thread, VmObject ignored, List<Object> args) {
        VmObject self = (VmObject)args.get(0);
        VmObject target = (VmObject)args.get(1);
        VmClass targetClass = target.getVmClass();
        LoadedTypeDefinition targetClassDef = targetClass.getTypeDefinition();
        String targetClassIntName = targetClassDef.getInternalName();
        if (targetClassIntName.equals("java/lang/reflect/Field")) {
            this.initMethodHandleField(self, target, false);
            return null;
        }
        if (targetClassIntName.equals("java/lang/reflect/Method")) {
            this.initMethodHandleMethod(self, target);
            return null;
        }
        if (targetClassIntName.equals("java/lang/reflect/Constructor")) {
            this.initMethodHandleCtor(self, target);
            return null;
        }
        throw new IllegalStateException("Unknown reflection object kind");
    }

    private void initMethodHandleMethod(VmObject memberName, VmObject methodTarget) {
        MethodHandleKind kind;
        VmClass clazzVal = (VmClass)methodTarget.getMemory().loadRef((long)methodTarget.indexOf((FieldElement)this.methodClazzField), (ReadAccessMode)AccessModes.SinglePlain);
        int index = methodTarget.getMemory().load32((long)methodTarget.indexOf((FieldElement)this.methodSlotField), (ReadAccessMode)AccessModes.SinglePlain);
        MethodElement refMethod = clazzVal.getTypeDefinition().getMethod(index);
        int flags = refMethod.getModifiers() & 0x1FFF;
        flags |= 0x10000;
        if (refMethod.isStatic()) {
            flags |= KIND_INVOKE_STATIC << 24;
            kind = MethodHandleKind.INVOKE_STATIC;
        } else {
            flags |= KIND_INVOKE_SPECIAL << 24;
            kind = MethodHandleKind.INVOKE_SPECIAL;
        }
        if (refMethod.hasAllModifiersOf(0x20000000)) {
            flags |= 0x100000;
        }
        VmObject rmn = this.vm.newInstance(this.rmnClass, this.rmnCtor, List.of());
        rmn.getMemory().storeRef((long)rmn.indexOf((FieldElement)this.rmnClazzField), (VmObject)refMethod.getEnclosingType().load().getVmClass(), (WriteAccessMode)AccessModes.SinglePlain);
        rmn.getMemory().store32((long)rmn.indexOf((FieldElement)this.rmnIndexField), refMethod.getIndex(), (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameFlagsField), flags, (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameClazzField), (VmObject)clazzVal, (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameMethodField), rmn, (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameIndexField), refMethod.getIndex(), (WriteAccessMode)AccessModes.SinglePlain);
        this.generateDispatcher(memberName, (Element)refMethod, kind);
    }

    private void initMethodHandleCtor(VmObject memberName, VmObject methodTarget) {
        VmClass clazzVal = (VmClass)methodTarget.getMemory().loadRef((long)methodTarget.indexOf((FieldElement)this.ctorClazzField), (ReadAccessMode)AccessModes.SinglePlain);
        int index = methodTarget.getMemory().load32((long)methodTarget.indexOf((FieldElement)this.ctorSlotField), (ReadAccessMode)AccessModes.SinglePlain);
        ConstructorElement refCtor = clazzVal.getTypeDefinition().getConstructor(index);
        int flags = refCtor.getModifiers() & 0x1FFF;
        VmObject rmn = this.vm.newInstance(this.rmnClass, this.rmnCtor, List.of());
        rmn.getMemory().storeRef((long)rmn.indexOf((FieldElement)this.rmnClazzField), (VmObject)refCtor.getEnclosingType().load().getVmClass(), (WriteAccessMode)AccessModes.SinglePlain);
        rmn.getMemory().store32((long)rmn.indexOf((FieldElement)this.rmnIndexField), refCtor.getIndex(), (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameFlagsField), flags |= 0x20000 | KIND_NEW_INVOKE_SPECIAL << 24, (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameClazzField), (VmObject)clazzVal, (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameMethodField), rmn, (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameIndexField), refCtor.getIndex(), (WriteAccessMode)AccessModes.SinglePlain);
        this.generateDispatcher(memberName, (Element)refCtor, MethodHandleKind.NEW_INVOKE_SPECIAL);
    }

    private void initMethodHandleField(VmObject memberName, VmObject fieldTarget, boolean isSetter) {
        MethodHandleKind kind;
        VmClass clazzVal = (VmClass)fieldTarget.getMemory().loadRef((long)fieldTarget.indexOf((FieldElement)this.fieldClazzField), (ReadAccessMode)AccessModes.SinglePlain);
        int index = fieldTarget.getMemory().load32((long)fieldTarget.indexOf((FieldElement)this.fieldSlotField), (ReadAccessMode)AccessModes.SinglePlain);
        VmString nameVal = (VmString)fieldTarget.getMemory().loadRef((long)fieldTarget.indexOf((FieldElement)this.fieldNameField), (ReadAccessMode)AccessModes.SinglePlain);
        VmClass fieldClazzVal = (VmClass)fieldTarget.getMemory().loadRef((long)fieldTarget.indexOf((FieldElement)this.fieldTypeField), (ReadAccessMode)AccessModes.SinglePlain);
        FieldElement refField = clazzVal.getTypeDefinition().getField(index);
        int flags = refField.getModifiers() & 0x1FFF;
        flags |= 0x40000;
        if (refField.isStatic()) {
            if (isSetter) {
                flags |= KIND_PUT_STATIC << 24;
                kind = MethodHandleKind.PUT_STATIC;
            } else {
                flags |= KIND_GET_STATIC << 24;
                kind = MethodHandleKind.GET_STATIC;
            }
        } else if (isSetter) {
            flags |= KIND_PUT_FIELD << 24;
            kind = MethodHandleKind.PUT_FIELD;
        } else {
            flags |= KIND_GET_FIELD << 24;
            kind = MethodHandleKind.GET_FIELD;
        }
        if (refField.isReallyFinal()) {
            flags |= 0x200000;
        }
        memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameFlagsField), flags, (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameClazzField), (VmObject)clazzVal, (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameNameField), (VmObject)nameVal, (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameTypeField), (VmObject)fieldClazzVal, (WriteAccessMode)AccessModes.SinglePlain);
        memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameIndexField), refField.getIndex(), (WriteAccessMode)AccessModes.SinglePlain);
        this.generateDispatcher(memberName, (Element)refField, kind);
    }

    Object methodHandleNativesResolve(VmThread thread, VmObject ignored, List<Object> args) {
        boolean bl;
        boolean resolvedFlag;
        VmObject memberName = (VmObject)args.get(0);
        boolean bl2 = resolvedFlag = (memberName.getMemory().load8((long)memberName.indexOf((FieldElement)this.memberNameResolvedField), (ReadAccessMode)AccessModes.SinglePlain) & 1) != 0;
        if (resolvedFlag) {
            return memberName;
        }
        VmClass caller = (VmClass)args.get(1);
        Object object = args.get(3);
        if (object instanceof Boolean) {
            Boolean bv = (Boolean)object;
            bl = bv;
        } else {
            bl = (((Number)args.get(3)).intValue() & 1) != 0;
        }
        boolean speculativeResolve = bl;
        VmClass clazz = (VmClass)memberName.getMemory().loadRef((long)memberName.indexOf((FieldElement)this.memberNameClazzField), (ReadAccessMode)AccessModes.SinglePlain);
        if (clazz == null) {
            throw new Thrown(this.nullPointerExceptionClass.newInstance("`clazz` is null"));
        }
        VmString name = (VmString)memberName.getMemory().loadRef((long)memberName.indexOf((FieldElement)this.memberNameNameField), (ReadAccessMode)AccessModes.SinglePlain);
        if (name == null) {
            throw new Thrown(this.nullPointerExceptionClass.newInstance("`name` is null"));
        }
        VmObject type = memberName.getMemory().loadRef((long)memberName.indexOf((FieldElement)this.memberNameTypeField), (ReadAccessMode)AccessModes.SinglePlain);
        if (type == null) {
            throw new Thrown(this.nullPointerExceptionClass.newInstance("`type` is null"));
        }
        int flags = memberName.getMemory().load32((long)memberName.indexOf((FieldElement)this.memberNameFlagsField), (ReadAccessMode)AccessModes.SinglePlain);
        int kind = flags >> 24 & 0xF;
        LoadedTypeDefinition typeDefinition = clazz.getTypeDefinition();
        ClassContext classContext = typeDefinition.getContext();
        if ((flags & 0x40000) != 0) {
            boolean isSetter;
            FieldElement resolved = typeDefinition.resolveField(((VmClass)type).getDescriptor(), name.getContent());
            if (resolved == null && !speculativeResolve) {
                throw new Thrown(this.linkageErrorClass.newInstance("No such field: " + clazz.getName() + "#" + name.getContent()));
            }
            if (resolved == null) {
                return null;
            }
            memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameClazzField), (VmObject)resolved.getEnclosingType().load().getVmClass(), (WriteAccessMode)AccessModes.SinglePlain);
            int newFlags = resolved.getModifiers() & 0xFFFF | 0x40000;
            boolean bl3 = isSetter = kind == KIND_PUT_STATIC || kind == KIND_PUT_FIELD;
            kind = resolved.isStatic() ? (isSetter ? KIND_PUT_STATIC : KIND_GET_STATIC) : (isSetter ? KIND_PUT_FIELD : KIND_GET_FIELD);
            newFlags |= kind << 24;
            if (resolved.isReallyFinal()) {
                newFlags |= 0x200000;
            }
            memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameFlagsField), newFlags, (WriteAccessMode)AccessModes.SinglePlain);
            memberName.getMemory().store8((long)memberName.indexOf((FieldElement)this.memberNameResolvedField), 1, (WriteAccessMode)AccessModes.SinglePlain);
            memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameClazzField), (VmObject)resolved.getEnclosingType().load().getVmClass(), (WriteAccessMode)AccessModes.SinglePlain);
            memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameTypeField), type, (WriteAccessMode)AccessModes.SinglePlain);
            memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameIndexField), resolved.getIndex(), (WriteAccessMode)AccessModes.GlobalRelease);
            this.generateDispatcher(memberName, (Element)resolved, MethodHandleKind.forId((int)kind));
            return memberName;
        }
        if ((flags & 0x80000) != 0) {
            throw new Thrown(this.linkageErrorClass.newInstance("Not sure what to do for resolving a type"));
        }
        MethodDescriptor desc = this.createFromMethodType(classContext, type);
        if ((flags & 0x20000) != 0) {
            int idx = typeDefinition.findConstructorIndex(desc);
            if (idx == -1) {
                if (!speculativeResolve) {
                    throw new Thrown(this.linkageErrorClass.newInstance("No such constructor: " + name.getContent() + ":" + desc.toString()));
                }
                return null;
            }
            if (kind != KIND_NEW_INVOKE_SPECIAL) {
                throw new Thrown(this.linkageErrorClass.newInstance("Unknown handle kind"));
            }
            ConstructorElement resolved = typeDefinition.getConstructor(idx);
            memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameClazzField), (VmObject)resolved.getEnclosingType().load().getVmClass(), (WriteAccessMode)AccessModes.SinglePlain);
            int newFlags = resolved.getModifiers() & 0xFFFF | 0x20000 | kind << 24;
            memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameFlagsField), newFlags, (WriteAccessMode)AccessModes.SinglePlain);
            memberName.getMemory().store8((long)memberName.indexOf((FieldElement)this.memberNameResolvedField), 1, (WriteAccessMode)AccessModes.SinglePlain);
            memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameIndexField), resolved.getIndex(), (WriteAccessMode)AccessModes.GlobalRelease);
            this.generateDispatcher(memberName, (Element)resolved, MethodHandleKind.forId((int)kind));
            return memberName;
        }
        if ((flags & 0x10000) != 0) {
            MethodElement resolved;
            ClassContext resolvingContext;
            ClassContext classContext2 = resolvingContext = caller == null ? this.ctxt.getBootstrapClassContext() : caller.getTypeDefinition().getContext();
            if (kind == KIND_INVOKE_STATIC) {
                resolved = typeDefinition.isInterface() ? typeDefinition.resolveMethodElementInterface(name.getContent(), desc) : typeDefinition.resolveMethodElementVirtual(resolvingContext, name.getContent(), desc);
            } else if (kind == KIND_INVOKE_INTERFACE) {
                resolved = typeDefinition.isInterface() ? typeDefinition.resolveMethodElementInterface(name.getContent(), desc) : typeDefinition.resolveMethodElementVirtual(resolvingContext, name.getContent(), desc);
            } else if (kind == KIND_INVOKE_SPECIAL) {
                resolved = typeDefinition.resolveMethodElementExact(resolvingContext, name.getContent(), desc);
            } else if (kind == KIND_INVOKE_VIRTUAL) {
                resolved = typeDefinition.resolveMethodElementVirtual(resolvingContext, name.getContent(), desc);
            } else {
                throw new Thrown(this.linkageErrorClass.newInstance("Unknown handle kind"));
            }
            if (resolved == null) {
                if (!speculativeResolve) {
                    throw new Thrown(this.linkageErrorClass.newInstance("No such method: " + clazz.getName() + "#" + name.getContent() + ":" + desc.toString()));
                }
                return null;
            }
            memberName.getMemory().storeRef((long)memberName.indexOf((FieldElement)this.memberNameClazzField), (VmObject)resolved.getEnclosingType().load().getVmClass(), (WriteAccessMode)AccessModes.SinglePlain);
            int newFlags = resolved.getModifiers() & 0xFFFF | 0x10000 | kind << 24;
            memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameFlagsField), newFlags, (WriteAccessMode)AccessModes.SinglePlain);
            memberName.getMemory().store8((long)memberName.indexOf((FieldElement)this.memberNameResolvedField), 1, (WriteAccessMode)AccessModes.SinglePlain);
            memberName.getMemory().store32((long)memberName.indexOf((FieldElement)this.memberNameIndexField), resolved.getIndex(), (WriteAccessMode)AccessModes.GlobalRelease);
            this.generateDispatcher(memberName, (Element)resolved, MethodHandleKind.forId((int)kind));
            return memberName;
        }
        throw new Thrown(this.linkageErrorClass.newInstance("Unknown resolution request"));
    }

    private void generateDispatcher(VmObject memberName, Element element, MethodHandleKind kind) {
        Pointer result = this.dispatcherCache.computeIfAbsent(element, Reflection::newMap).computeIfAbsent(kind, methodHandleKind -> switch (methodHandleKind) {
            default -> throw new IncompatibleClassChangeError();
            case MethodHandleKind.GET_FIELD, MethodHandleKind.GET_STATIC -> this.generateGetterDispatcher((FieldElement)element, kind);
            case MethodHandleKind.PUT_FIELD, MethodHandleKind.PUT_STATIC -> this.generateSetterDispatcher((FieldElement)element, kind);
            case MethodHandleKind.NEW_INVOKE_SPECIAL -> this.generateNewInstanceDispatcher((ConstructorElement)element);
            case MethodHandleKind.INVOKE_VIRTUAL, MethodHandleKind.INVOKE_SPECIAL, MethodHandleKind.INVOKE_INTERFACE, MethodHandleKind.INVOKE_STATIC -> this.generateInvokerDispatcher((MethodElement)element, kind);
        });
        memberName.getMemory().storePointer((long)memberName.indexOf((FieldElement)this.memberNameExactDispatcherField), result, (WriteAccessMode)AccessModes.SinglePlain);
    }

    private static <K, V> ConcurrentHashMap<K, V> newMap(Object ignored) {
        return new ConcurrentHashMap();
    }

    private Pointer generateGetterDispatcher(final FieldElement element, final MethodHandleKind kind) {
        List<Object> dispatchParams;
        MethodDescriptor desc;
        DefinedTypeDefinition enclosingType = element.getEnclosingType();
        final ClassContext classContext = enclosingType.getContext();
        if (element.isStatic()) {
            desc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)element.getTypeDescriptor(), List.of());
            dispatchParams = List.of();
        } else {
            desc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)element.getTypeDescriptor(), List.of(enclosingType.getDescriptor()));
            ParameterElement.Builder pb = ParameterElement.builder((String)"instance", (TypeDescriptor)enclosingType.getDescriptor(), (int)0);
            pb.setEnclosingType(enclosingType);
            pb.setTypeParameterContext((TypeParameterContext)enclosingType);
            pb.setSignature(TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)pb.getDescriptor()));
            dispatchParams = List.of(pb.build());
        }
        MethodElement.Builder builder = MethodElement.builder((String)("dispatch_get_" + element.getName()), (MethodDescriptor)desc, (int)0);
        builder.setModifiers(25427978);
        builder.setEnclosingType(enclosingType);
        builder.setParameters(dispatchParams);
        builder.setSignature(MethodSignature.synthesize((ClassContext)classContext, (MethodDescriptor)desc));
        builder.setMethodBodyFactory(new MethodBodyFactory(){

            public MethodBody createMethodBody(int index, ExecutableElement e) {
                Value value;
                BasicBlockBuilder bbb = classContext.newBasicBlockBuilder(e);
                BlockLabel entryLabel = new BlockLabel();
                bbb.begin(entryLabel);
                if (kind == MethodHandleKind.GET_FIELD) {
                    BlockParameter instance = bbb.addParam(entryLabel, Slot.funcParam((int)0), (ValueType)e.getEnclosingType().load().getObjectType().getReference());
                    GlobalReadWriteAccessMode mode = element.isVolatile() ? AccessModes.GlobalSeqCst : AccessModes.SinglePlain;
                    value = bbb.load(bbb.instanceFieldOf(bbb.decodeReference((Value)instance), (InstanceFieldElement)element), (ReadAccessMode)mode);
                } else {
                    assert (kind == MethodHandleKind.GET_STATIC);
                    GlobalReadWriteAccessMode mode = element.isVolatile() ? AccessModes.GlobalSeqCst : AccessModes.SinglePlain;
                    value = bbb.load((Value)bbb.getLiteralFactory().literalOf((StaticFieldElement)element), (ReadAccessMode)mode);
                }
                bbb.return_(value);
                bbb.finish();
                BasicBlock entryBlock = BlockLabel.getTargetOf((BlockLabel)entryLabel);
                return MethodBody.of((BasicBlock)entryBlock, (List)Slot.simpleArgList((int)(element.isStatic() ? 0 : 1)));
            }
        }, 0);
        StaticMethodElement dispatcher = (StaticMethodElement)builder.build();
        this.ctxt.enqueue((ExecutableElement)dispatcher);
        return StaticMethodPointer.of((StaticMethodElement)dispatcher);
    }

    private Pointer generateSetterDispatcher(final FieldElement element, final MethodHandleKind kind) {
        List<ParameterElement> dispatchParams;
        MethodDescriptor desc;
        DefinedTypeDefinition enclosingType = element.getEnclosingType();
        final ClassContext classContext = enclosingType.getContext();
        if (element.isStatic()) {
            desc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(element.getTypeDescriptor()));
            pb = ParameterElement.builder((String)"value", (TypeDescriptor)element.getTypeDescriptor(), (int)0);
            pb.setEnclosingType(enclosingType);
            pb.setTypeParameterContext((TypeParameterContext)enclosingType);
            pb.setSignature(TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)pb.getDescriptor()));
            dispatchParams = List.of(pb.build());
        } else {
            desc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)element.getTypeDescriptor(), List.of(enclosingType.getDescriptor()));
            pb = ParameterElement.builder((String)"instance", (TypeDescriptor)enclosingType.getDescriptor(), (int)0);
            pb.setEnclosingType(enclosingType);
            pb.setTypeParameterContext((TypeParameterContext)enclosingType);
            pb.setSignature(TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)pb.getDescriptor()));
            ParameterElement instanceParam = pb.build();
            pb = ParameterElement.builder((String)"value", (TypeDescriptor)element.getTypeDescriptor(), (int)1);
            pb.setEnclosingType(enclosingType);
            pb.setTypeParameterContext((TypeParameterContext)enclosingType);
            pb.setSignature(TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)pb.getDescriptor()));
            dispatchParams = List.of(instanceParam, pb.build());
        }
        MethodElement.Builder builder = MethodElement.builder((String)("dispatch_put_" + element.getName()), (MethodDescriptor)desc, (int)0);
        builder.setModifiers(25427978);
        builder.setEnclosingType(enclosingType);
        builder.setParameters(dispatchParams);
        builder.setSignature(MethodSignature.synthesize((ClassContext)classContext, (MethodDescriptor)desc));
        builder.setMethodBodyFactory(new MethodBodyFactory(){

            public MethodBody createMethodBody(int index, ExecutableElement e) {
                BasicBlockBuilder bbb = classContext.newBasicBlockBuilder(e);
                BlockLabel entryLabel = new BlockLabel();
                bbb.begin(entryLabel);
                BlockParameter value = bbb.addParam(entryLabel, Slot.funcParam((int)(element.isStatic() ? 0 : 1)), element.getType());
                if (kind == MethodHandleKind.PUT_FIELD) {
                    BlockParameter instance = bbb.addParam(entryLabel, Slot.funcParam((int)0), (ValueType)element.getEnclosingType().load().getObjectType().getReference());
                    GlobalReadWriteAccessMode mode = element.isVolatile() ? AccessModes.GlobalSeqCst : AccessModes.SinglePlain;
                    bbb.store(bbb.instanceFieldOf(bbb.decodeReference((Value)instance), (InstanceFieldElement)element), (Value)value, (WriteAccessMode)mode);
                } else {
                    assert (kind == MethodHandleKind.PUT_STATIC);
                    GlobalReadWriteAccessMode mode = element.isVolatile() ? AccessModes.GlobalSeqCst : AccessModes.SinglePlain;
                    bbb.store((Value)bbb.getLiteralFactory().literalOf((StaticFieldElement)element), (Value)value, (WriteAccessMode)mode);
                }
                bbb.return_();
                bbb.finish();
                BasicBlock entryBlock = BlockLabel.getTargetOf((BlockLabel)entryLabel);
                return MethodBody.of((BasicBlock)entryBlock, (List)Slot.simpleArgList((int)(element.isStatic() ? 1 : 2)));
            }
        }, 0);
        StaticMethodElement dispatcher = (StaticMethodElement)builder.build();
        this.ctxt.enqueue((ExecutableElement)dispatcher);
        return StaticMethodPointer.of((StaticMethodElement)dispatcher);
    }

    private Pointer generateInvokerDispatcher(final MethodElement element, MethodHandleKind kind) {
        if (element instanceof StaticMethodElement) {
            StaticMethodElement sme = (StaticMethodElement)element;
            this.ctxt.enqueue((ExecutableElement)element);
            return StaticMethodPointer.of((StaticMethodElement)sme);
        }
        DefinedTypeDefinition enclosingType = element.getEnclosingType();
        TypeDescriptor enclosingDesc = enclosingType.getDescriptor();
        final ClassContext classContext = enclosingType.getContext();
        MethodDescriptor origDesc = element.getDescriptor();
        List origParamTypes = origDesc.getParameterTypes();
        ArrayList<TypeDescriptor> newParamTypes = new ArrayList<TypeDescriptor>(origParamTypes.size() + 1);
        newParamTypes.add(enclosingDesc);
        newParamTypes.addAll(origParamTypes);
        MethodDescriptor newDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)origDesc.getReturnType(), newParamTypes);
        List origParams = element.getParameters();
        ArrayList<ParameterElement> dispatchParams = new ArrayList<ParameterElement>(origParams.size() + 1);
        ParameterElement.Builder pb = ParameterElement.builder((String)"this", (TypeDescriptor)enclosingDesc, (int)0);
        pb.setSignature(TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)enclosingDesc));
        pb.setEnclosingType(enclosingType);
        pb.setTypeParameterContext((TypeParameterContext)enclosingType);
        dispatchParams.add(pb.build());
        int origParamCnt = origParamTypes.size();
        for (int i = 0; i < origParamCnt; ++i) {
            pb = ParameterElement.builder((String)((ParameterElement)origParams.get(i)).getName(), (TypeDescriptor)((TypeDescriptor)origParamTypes.get(i)), (int)(i + 1));
            pb.setSignature(TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)((TypeDescriptor)origParamTypes.get(i))));
            pb.setEnclosingType(enclosingType);
            pb.setTypeParameterContext((TypeParameterContext)enclosingType);
            dispatchParams.add(pb.build());
        }
        final MethodHandleKind resolvedKind = kind != MethodHandleKind.INVOKE_SPECIAL && (element.isPrivate() || element.isFinal() || enclosingType.isFinal()) ? MethodHandleKind.INVOKE_SPECIAL : kind;
        String kindStr = switch (resolvedKind) {
            case MethodHandleKind.INVOKE_VIRTUAL -> "virtual_";
            case MethodHandleKind.INVOKE_SPECIAL -> "special_";
            case MethodHandleKind.INVOKE_INTERFACE -> "interface_";
            default -> throw new IllegalStateException();
        };
        MethodElement.Builder builder = MethodElement.builder((String)("dispatch_" + kindStr + element.getName()), (MethodDescriptor)newDesc, (int)0);
        builder.setModifiers(25427978);
        builder.setEnclosingType(enclosingType);
        builder.setParameters(dispatchParams);
        builder.setSignature(MethodSignature.synthesize((ClassContext)classContext, (MethodDescriptor)newDesc));
        builder.setMethodBodyFactory(new MethodBodyFactory(){

            public MethodBody createMethodBody(int index, ExecutableElement e) {
                BasicBlockBuilder bbb = classContext.newBasicBlockBuilder(e);
                BlockLabel entryLabel = new BlockLabel();
                bbb.begin(entryLabel);
                InvokableType type = e.getType();
                int pcnt = type.getParameterCount();
                ArrayList<BlockParameter> paramValues = new ArrayList<BlockParameter>(pcnt);
                for (int i = 0; i < pcnt; ++i) {
                    paramValues.add(bbb.addParam(entryLabel, Slot.funcParam((int)i), type.getParameterType(i)));
                }
                List values = paramValues.subList(1, paramValues.size());
                InstanceMethodElement ime = (InstanceMethodElement)element;
                switch (resolvedKind) {
                    case INVOKE_VIRTUAL: {
                        bbb.tailCall(bbb.lookupVirtualMethod((Value)paramValues.get(0), ime), (Value)paramValues.get(0), values);
                        break;
                    }
                    case INVOKE_SPECIAL: {
                        bbb.tailCall((Value)bbb.getLiteralFactory().literalOf(ime), (Value)paramValues.get(0), values);
                        break;
                    }
                    case INVOKE_INTERFACE: {
                        bbb.tailCall(bbb.lookupInterfaceMethod((Value)paramValues.get(0), ime), (Value)paramValues.get(0), values);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                bbb.finish();
                BasicBlock entryBlock = BlockLabel.getTargetOf((BlockLabel)entryLabel);
                return MethodBody.of((BasicBlock)entryBlock, (List)Slot.simpleArgList((int)pcnt));
            }
        }, 0);
        StaticMethodElement dispatcher = (StaticMethodElement)builder.build();
        this.ctxt.enqueue((ExecutableElement)dispatcher);
        return StaticMethodPointer.of((StaticMethodElement)dispatcher);
    }

    private Pointer generateNewInstanceDispatcher(final ConstructorElement element) {
        DefinedTypeDefinition enclosingType = element.getEnclosingType();
        TypeDescriptor enclosingDesc = enclosingType.getDescriptor();
        final ClassContext classContext = enclosingType.getContext();
        MethodDescriptor origDesc = element.getDescriptor();
        List origParamTypes = origDesc.getParameterTypes();
        ArrayList<TypeDescriptor> newParamTypes = new ArrayList<TypeDescriptor>(origParamTypes.size() + 1);
        newParamTypes.add(enclosingDesc);
        newParamTypes.addAll(origParamTypes);
        MethodDescriptor newDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)origDesc.getReturnType(), newParamTypes);
        List origParams = element.getParameters();
        ArrayList<ParameterElement> dispatchParams = new ArrayList<ParameterElement>(origParams.size() + 1);
        ParameterElement.Builder pb = ParameterElement.builder((String)"this", (TypeDescriptor)enclosingDesc, (int)0);
        pb.setSignature(TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)enclosingDesc));
        pb.setEnclosingType(enclosingType);
        pb.setTypeParameterContext((TypeParameterContext)enclosingType);
        dispatchParams.add(pb.build());
        int origParamCnt = origParamTypes.size();
        for (int i = 0; i < origParamCnt; ++i) {
            pb = ParameterElement.builder((String)((ParameterElement)origParams.get(i)).getName(), (TypeDescriptor)((TypeDescriptor)origParamTypes.get(i)), (int)(i + 1));
            pb.setSignature(TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)((TypeDescriptor)origParamTypes.get(i))));
            pb.setEnclosingType(enclosingType);
            pb.setTypeParameterContext((TypeParameterContext)enclosingType);
            dispatchParams.add(pb.build());
        }
        MethodElement.Builder builder = MethodElement.builder((String)"dispatch_init", (MethodDescriptor)newDesc, (int)0);
        builder.setModifiers(25427978);
        builder.setEnclosingType(enclosingType);
        builder.setParameters(dispatchParams);
        builder.setSignature(MethodSignature.synthesize((ClassContext)classContext, (MethodDescriptor)newDesc));
        builder.setMethodBodyFactory(new MethodBodyFactory(){

            public MethodBody createMethodBody(int index, ExecutableElement e) {
                BasicBlockBuilder bbb = classContext.newBasicBlockBuilder(e);
                BlockLabel entryLabel = new BlockLabel();
                bbb.begin(entryLabel);
                InvokableType type = e.getType();
                int pcnt = type.getParameterCount();
                ArrayList<BlockParameter> paramValues = new ArrayList<BlockParameter>(pcnt);
                for (int i = 0; i < pcnt; ++i) {
                    paramValues.add(bbb.addParam(entryLabel, Slot.funcParam((int)i), type.getParameterType(i)));
                }
                List values = paramValues.subList(1, paramValues.size());
                bbb.tailCall((Value)bbb.getLiteralFactory().literalOf(element), (Value)paramValues.get(0), values);
                bbb.finish();
                BasicBlock entryBlock = BlockLabel.getTargetOf((BlockLabel)entryLabel);
                return MethodBody.of((BasicBlock)entryBlock, (List)Slot.simpleArgList((int)pcnt));
            }
        }, 0);
        StaticMethodElement dispatcher = (StaticMethodElement)builder.build();
        this.ctxt.enqueue((ExecutableElement)dispatcher);
        return StaticMethodPointer.of((StaticMethodElement)dispatcher);
    }

    MethodDescriptor createFromMethodType(ClassContext classContext, VmObject methodType) {
        VmClass mtClass = methodType.getVmClass();
        if (!mtClass.getName().equals("java.lang.invoke.MethodType")) {
            throw new Thrown(this.linkageErrorClass.newInstance("Type argument is of wrong class"));
        }
        VmClass rtype = (VmClass)methodType.getMemory().loadRef((long)methodType.indexOf((FieldElement)this.methodTypeRTypeField), (ReadAccessMode)AccessModes.SinglePlain);
        if (rtype == null) {
            throw new Thrown(this.linkageErrorClass.newInstance("MethodType has null return type"));
        }
        VmReferenceArray ptypes = (VmReferenceArray)methodType.getMemory().loadRef((long)methodType.indexOf((FieldElement)this.methodTypePTypesField), (ReadAccessMode)AccessModes.SinglePlain);
        if (ptypes == null) {
            throw new Thrown(this.linkageErrorClass.newInstance("MethodType has null param types"));
        }
        int pcnt = ptypes.getLength();
        VmObject[] ptypesArray = ptypes.getArray();
        ArrayList<TypeDescriptor> paramTypes = new ArrayList<TypeDescriptor>(pcnt);
        for (int i = 0; i < pcnt; ++i) {
            VmClass clazz = (VmClass)ptypesArray[i];
            paramTypes.add(clazz.getDescriptor());
        }
        return MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)rtype.getDescriptor(), paramTypes);
    }

    private Object methodHandleNativesObjectFieldOffset(VmThread thread, VmObject ignored, List<Object> args) {
        FieldElement field;
        VmObject name = (VmObject)args.get(0);
        VmClass clazz = (VmClass)name.getMemory().loadRef((long)name.indexOf((FieldElement)this.memberNameClazzField), (ReadAccessMode)AccessModes.SinglePlain);
        int idx = name.getMemory().load32((long)name.indexOf((FieldElement)this.memberNameIndexField), (ReadAccessMode)AccessModes.SinglePlain);
        if (idx == 0) {
            idx = 0;
        }
        if ((field = clazz.getTypeDefinition().getField(idx)).isStatic()) {
            throw new Thrown(this.linkageErrorClass.newInstance("Wrong field kind"));
        }
        LayoutInfo layoutInfo = Layout.get((CompilationContext)this.ctxt).getInstanceLayoutInfo(field.getEnclosingType());
        return (long)layoutInfo.getMember(field).getOffset();
    }

    private Object methodHandleNativesStaticFieldBase(VmThread thread, VmObject ignored, List<Object> args) {
        return null;
    }

    private Object methodHandleNativesStaticFieldOffset(VmThread thread, VmObject ignored, List<Object> args) {
        VmObject name = (VmObject)args.get(0);
        VmClass clazz = (VmClass)name.getMemory().loadRef((long)name.indexOf((FieldElement)this.memberNameClazzField), (ReadAccessMode)AccessModes.SinglePlain);
        int idx = name.getMemory().load32((long)name.indexOf((FieldElement)this.memberNameIndexField), (ReadAccessMode)AccessModes.SinglePlain);
        if (idx == 0) {
            idx = 0;
        }
        StaticFieldElement field = (StaticFieldElement)clazz.getTypeDefinition().getField(idx);
        return StaticFieldPointer.of((StaticFieldElement)field);
    }

    private Object nativeConstructorAccessorImplNewInstance0(VmThread thread, VmObject ignored, List<Object> args) {
        List<Object> unboxed;
        VmObject ctor = (VmObject)args.get(0);
        VmReferenceArray argsArray = (VmReferenceArray)args.get(1);
        if (argsArray == null) {
            unboxed = List.of();
        } else {
            int argCnt = argsArray.getLength();
            unboxed = new ArrayList(argCnt);
            VmObject[] argsArrayArray = argsArray.getArray();
            for (int i = 0; i < argCnt; ++i) {
                unboxed.add(this.unbox(argsArrayArray[i]));
            }
        }
        VmClass clazz = (VmClass)ctor.getMemory().loadRef((long)ctor.indexOf((FieldElement)this.ctorClazzField), (ReadAccessMode)AccessModes.SinglePlain);
        int slot = ctor.getMemory().load32((long)ctor.indexOf((FieldElement)this.ctorSlotField), (ReadAccessMode)AccessModes.SinglePlain);
        ConstructorElement ce = clazz.getTypeDefinition().getConstructor(slot);
        this.ctxt.enqueue((ExecutableElement)ce);
        try {
            return this.vm.newInstance(clazz, ce, unboxed);
        }
        catch (Thrown thrown) {
            throw new Thrown(this.invocationTargetExceptionClass.newInstance(thrown.getThrowable()));
        }
    }

    private Object nativeMethodAccessorImplInvoke0(VmThread thread, VmObject ignored, List<Object> args) {
        List<Object> unboxed;
        VmObject method = (VmObject)args.get(0);
        VmObject receiver = (VmObject)args.get(1);
        VmReferenceArray argsArray = (VmReferenceArray)args.get(2);
        if (argsArray == null) {
            unboxed = List.of();
        } else {
            int argCnt = argsArray.getLength();
            unboxed = new ArrayList(argCnt);
            VmObject[] argsArrayArray = argsArray.getArray();
            for (int i = 0; i < argCnt; ++i) {
                unboxed.add(this.unbox(argsArrayArray[i]));
            }
        }
        VmClass clazz = (VmClass)method.getMemory().loadRef((long)method.indexOf((FieldElement)this.methodClazzField), (ReadAccessMode)AccessModes.SinglePlain);
        int slot = method.getMemory().load32((long)method.indexOf((FieldElement)this.methodSlotField), (ReadAccessMode)AccessModes.SinglePlain);
        MethodElement me = clazz.getTypeDefinition().getMethod(slot);
        this.ctxt.enqueue((ExecutableElement)me);
        try {
            if (me.isStatic()) {
                return this.box(this.vm.invokeExact(me, null, unboxed));
            }
            return this.box(this.vm.invokeVirtual(me, receiver, unboxed));
        }
        catch (Thrown thrown) {
            throw new Thrown(this.invocationTargetExceptionClass.newInstance(thrown.getThrowable()));
        }
    }

    private Object unbox(VmObject boxed) {
        if (boxed == null) {
            return null;
        }
        VmClass vmClass = boxed.getVmClass();
        if (vmClass == this.byteClass) {
            return (byte)boxed.getMemory().load8((long)boxed.indexOf(this.byteValueField), (ReadAccessMode)AccessModes.SinglePlain);
        }
        if (vmClass == this.shortClass) {
            return (short)boxed.getMemory().load16((long)boxed.indexOf(this.shortValueField), (ReadAccessMode)AccessModes.SinglePlain);
        }
        if (vmClass == this.integerClass) {
            return boxed.getMemory().load32((long)boxed.indexOf(this.integerValueField), (ReadAccessMode)AccessModes.SinglePlain);
        }
        if (vmClass == this.longClass) {
            return boxed.getMemory().load64((long)boxed.indexOf(this.longValueField), (ReadAccessMode)AccessModes.SinglePlain);
        }
        if (vmClass == this.characterClass) {
            return Character.valueOf((char)boxed.getMemory().load16((long)boxed.indexOf(this.characterValueField), (ReadAccessMode)AccessModes.SinglePlain));
        }
        if (vmClass == this.floatClass) {
            return Float.valueOf(boxed.getMemory().loadFloat((long)boxed.indexOf(this.floatValueField), (ReadAccessMode)AccessModes.SinglePlain));
        }
        if (vmClass == this.doubleClass) {
            return boxed.getMemory().loadDouble((long)boxed.indexOf(this.doubleValueField), (ReadAccessMode)AccessModes.SinglePlain);
        }
        if (vmClass == this.booleanClass) {
            return (boxed.getMemory().load8((long)boxed.indexOf(this.booleanValueField), (ReadAccessMode)AccessModes.SinglePlain) & 1) != 0;
        }
        return boxed;
    }

    private VmObject box(Object unboxed) {
        if (unboxed == null || unboxed instanceof VmObject) {
            return (VmObject)unboxed;
        }
        if (unboxed instanceof Boolean) {
            Boolean bv = (Boolean)unboxed;
            return this.vm.box(this.ctxt.getBootstrapClassContext(), (Literal)this.ctxt.getLiteralFactory().literalOf(bv.booleanValue()));
        }
        if (unboxed instanceof Byte) {
            Byte bv = (Byte)unboxed;
            return this.vm.box(this.ctxt.getBootstrapClassContext(), (Literal)this.ctxt.getLiteralFactory().literalOf(bv.byteValue()));
        }
        if (unboxed instanceof Character) {
            Character cv = (Character)unboxed;
            return this.vm.box(this.ctxt.getBootstrapClassContext(), (Literal)this.ctxt.getLiteralFactory().literalOf(cv.charValue()));
        }
        if (unboxed instanceof Short) {
            Short sv = (Short)unboxed;
            return this.vm.box(this.ctxt.getBootstrapClassContext(), (Literal)this.ctxt.getLiteralFactory().literalOf(sv.shortValue()));
        }
        if (unboxed instanceof Integer) {
            Integer iv = (Integer)unboxed;
            return this.vm.box(this.ctxt.getBootstrapClassContext(), (Literal)this.ctxt.getLiteralFactory().literalOf(iv.intValue()));
        }
        if (unboxed instanceof Float) {
            Float fv = (Float)unboxed;
            return this.vm.box(this.ctxt.getBootstrapClassContext(), (Literal)this.ctxt.getLiteralFactory().literalOf(fv.floatValue()));
        }
        if (unboxed instanceof Long) {
            Long lv = (Long)unboxed;
            return this.vm.box(this.ctxt.getBootstrapClassContext(), (Literal)this.ctxt.getLiteralFactory().literalOf(lv.longValue()));
        }
        if (unboxed instanceof Double) {
            Double dv = (Double)unboxed;
            return this.vm.box(this.ctxt.getBootstrapClassContext(), (Literal)this.ctxt.getLiteralFactory().literalOf(dv.doubleValue()));
        }
        throw new UnsupportedOperationException("Unexpected value for hyperboxing");
    }

    private FieldElement resolveIndexField(int index, DefinedTypeDefinition typeDef, FieldElement.Builder builder) {
        builder.setEnclosingType(typeDef);
        builder.setModifiers(0x800002);
        builder.setSignature((TypeSignature)BaseTypeSignature.I);
        return builder.build();
    }

    private FieldElement resolveResolvedField(int index, DefinedTypeDefinition typeDef, FieldElement.Builder builder) {
        builder.setEnclosingType(typeDef);
        builder.setModifiers(0x800002);
        builder.setSignature((TypeSignature)BaseTypeSignature.Z);
        return builder.build();
    }

    private FieldElement resolveExactDispatcherField(int index, DefinedTypeDefinition typeDef, FieldElement.Builder builder) {
        builder.setEnclosingType(typeDef);
        builder.setModifiers(0x800002);
        builder.setSignature((TypeSignature)BaseTypeSignature.V);
        builder.setTypeResolver(fe -> this.ctxt.getTypeSystem().getVoidType().getPointer());
        return builder.build();
    }

    private FieldElement resolveClazzField(int index, DefinedTypeDefinition typeDef, FieldElement.Builder builder) {
        builder.setEnclosingType(typeDef);
        builder.setModifiers(0x800002);
        builder.setSignature(TypeSignature.synthesize((ClassContext)typeDef.getContext(), (TypeDescriptor)builder.getDescriptor()));
        return builder.build();
    }

    public CompoundType getCallStructureType(InvokableType functionType) {
        CompoundType compoundType = this.functionCallStructures.get(functionType);
        if (compoundType == null) {
            int parameterCount = functionType.getParameterCount();
            if (parameterCount == 0) {
                return null;
            }
            CompoundType.Builder builder = CompoundType.builder((TypeSystem)this.ctxt.getTypeSystem());
            for (int i = 0; i < parameterCount; ++i) {
                builder.addNextMember(functionType.getParameterType(i));
            }
            compoundType = builder.build();
            CompoundType appearing = this.functionCallStructures.putIfAbsent(functionType, compoundType);
            if (appearing != null) {
                compoundType = appearing;
            }
        }
        return compoundType;
    }
}

