/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reflection;

import java.util.List;
import org.qbicc.context.CompilationContext;
import org.qbicc.facts.Condition;
import org.qbicc.facts.Fact;
import org.qbicc.facts.Facts;
import org.qbicc.plugin.reachability.ServiceLoaderAnalyzer;
import org.qbicc.plugin.reachability.TypeReachabilityFacts;
import org.qbicc.plugin.reflection.Reflection;
import org.qbicc.plugin.reflection.ReflectiveElementRegistry;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.descriptor.MethodDescriptor;

public class ReflectionFactsSetup {
    private ReflectionFactsSetup() {
    }

    public static void setupAdd(CompilationContext ctxt) {
        Facts facts = Facts.get((CompilationContext)ctxt);
        facts.registerAction(Condition.when((Fact)TypeReachabilityFacts.HAS_CLASS), (ltd, f) -> {
            Reflection.get(ctxt).generateReflectiveData((LoadedTypeDefinition)ltd);
            List providers = ServiceLoaderAnalyzer.get((CompilationContext)ctxt).getProviders(ltd);
            for (LoadedTypeDefinition pc : providers) {
                int index;
                if (pc.isInterface() || (index = pc.findConstructorIndex(MethodDescriptor.VOID_METHOD_DESCRIPTOR)) == -1) continue;
                ConstructorElement ce = pc.getConstructor(index);
                ReflectiveElementRegistry.get(ctxt).registerReflectiveConstructor(ce);
            }
        });
    }
}

