/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reflection;

import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.ClassOf;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.literal.InstanceMethodLiteral;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.graph.literal.StringLiteral;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.interpreter.Thrown;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmObject;
import org.qbicc.plugin.intrinsics.InstanceIntrinsic;
import org.qbicc.plugin.intrinsics.Intrinsics;
import org.qbicc.plugin.intrinsics.StaticIntrinsic;
import org.qbicc.plugin.patcher.Patcher;
import org.qbicc.plugin.reflection.Reflection;
import org.qbicc.plugin.reflection.ReflectiveElementRegistry;
import org.qbicc.pointer.InstanceMethodPointer;
import org.qbicc.pointer.Pointer;
import org.qbicc.pointer.StaticMethodPointer;
import org.qbicc.type.InstanceMethodType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.StaticMethodType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.MethodBodyFactory;
import org.qbicc.type.definition.VerifyFailedException;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.StaticMethodElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class ReflectionIntrinsics {
    private static final Logger log = Logger.getLogger((String)"org.qbicc.plugin.reflection");

    private ReflectionIntrinsics() {
    }

    public static void register(CompilationContext ctxt) {
        ReflectionIntrinsics.registerReflectionAnalysisIntrinsics(ctxt);
        Intrinsics intrinsics = Intrinsics.get((CompilationContext)ctxt);
        Patcher patcher = Patcher.get((CompilationContext)ctxt);
        ClassContext bootstrapClassContext = ctxt.getBootstrapClassContext();
        String methodHandleInt = "java/lang/invoke/MethodHandle";
        String varHandleInt = "java/lang/invoke/VarHandle";
        ClassTypeDescriptor methodHandleDesc = ClassTypeDescriptor.synthesize((ClassContext)bootstrapClassContext, (String)methodHandleInt);
        ClassTypeDescriptor objDesc = ClassTypeDescriptor.synthesize((ClassContext)bootstrapClassContext, (String)"java/lang/Object");
        ClassTypeDescriptor internalErrorDesc = ClassTypeDescriptor.synthesize((ClassContext)bootstrapClassContext, (String)"java/lang/InternalError");
        ClassTypeDescriptor throwableDesc = ClassTypeDescriptor.synthesize((ClassContext)bootstrapClassContext, (String)"java/lang/Throwable");
        ArrayTypeDescriptor objArrayDesc = ArrayTypeDescriptor.of((ClassContext)bootstrapClassContext, (TypeDescriptor)objDesc);
        MethodDescriptor objArrayToObj = MethodDescriptor.synthesize((ClassContext)bootstrapClassContext, (TypeDescriptor)objDesc, List.of(objArrayDesc));
        MethodDescriptor objArrayToVoid = MethodDescriptor.synthesize((ClassContext)bootstrapClassContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(objArrayDesc));
        MethodDescriptor objArrayToBool = MethodDescriptor.synthesize((ClassContext)bootstrapClassContext, (TypeDescriptor)BaseTypeDescriptor.Z, List.of(objArrayDesc));
        MethodDescriptor throwableToVoid = MethodDescriptor.synthesize((ClassContext)bootstrapClassContext, (TypeDescriptor)BaseTypeDescriptor.V, List.of(throwableDesc));
        InstanceIntrinsic invokeIntrinsic = (builder, instance, target, arguments) -> {
            Value realHandle;
            VmObject realType;
            LiteralFactory lf = ctxt.getLiteralFactory();
            InstanceMethodElement element = target.getExecutable();
            MethodDescriptor callSiteDescriptor = element.getDescriptor();
            BasicBlockBuilder fb = builder.getFirstBuilder();
            Vm vm = Vm.requireCurrent();
            ClassContext classContext = builder.getCurrentClassContext();
            try {
                realType = vm.createMethodType(classContext, callSiteDescriptor);
            }
            catch (Thrown t) {
                ctxt.warning(fb.getLocation(), "Failed to create method type: %s", new Object[]{t});
                log.warnf((Throwable)t, "Failed to create method type", new Object[0]);
                throw new BlockEarlyTermination(fb.throw_((Value)lf.literalOf((VmObject)t.getThrowable())));
            }
            LoadedTypeDefinition mhDef = element.getEnclosingType().load();
            int asTypeIdx = mhDef.findMethodIndex(me -> me.nameEquals("asType"));
            InstanceMethodElement asType = (InstanceMethodElement)mhDef.getMethod(asTypeIdx);
            if (instance instanceof ObjectLiteral) {
                ObjectLiteral instanceLit = (ObjectLiteral)instance;
                try {
                    realHandle = lf.literalOf((VmObject)vm.invokeVirtual((MethodElement)asType, instanceLit.getValue(), List.of(realType)));
                }
                catch (Thrown t) {
                    ctxt.warning(fb.getLocation(), "Failed to expand MethodHandle.invoke intrinsic: %s", new Object[]{t});
                    log.warnf((Throwable)t, "Failed to expand MethodHandle.invoke intrinsic", new Object[0]);
                    throw new BlockEarlyTermination(fb.throw_((Value)lf.literalOf((VmObject)t.getThrowable())));
                }
            } else {
                realHandle = fb.call(fb.lookupVirtualMethod(instance, asType), instance, List.of(lf.literalOf(realType)));
            }
            Value invokeExactHandle = fb.resolveInstanceMethod((TypeDescriptor)methodHandleDesc, "invokeExact", callSiteDescriptor);
            return fb.call(invokeExactHandle, realHandle, arguments);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)methodHandleDesc, "invoke", invokeIntrinsic);
        InstanceIntrinsic invokeExactIntrinsic = (builder, instance, target, arguments) -> {
            VmObject realType;
            LiteralFactory lf = ctxt.getLiteralFactory();
            InstanceMethodElement element = target.getExecutable();
            MethodDescriptor callSiteDescriptor = element.getDescriptor();
            BasicBlockBuilder fb = builder.getFirstBuilder();
            Vm vm = Vm.requireCurrent();
            ClassContext classContext = builder.getCurrentClassContext();
            try {
                realType = vm.createMethodType(classContext, callSiteDescriptor);
            }
            catch (Thrown t) {
                ctxt.warning(fb.getLocation(), "Failed to create method type: %s", new Object[]{t});
                log.warnf((Throwable)t, "Failed to create method type", new Object[0]);
                throw new BlockEarlyTermination(fb.throw_((Value)lf.literalOf((VmObject)t.getThrowable())));
            }
            LoadedTypeDefinition mhDef = element.getEnclosingType().load();
            int checkTypeIdx = mhDef.findMethodIndex(me -> me.nameEquals("checkType"));
            InstanceMethodElement checkType = (InstanceMethodElement)mhDef.getMethod(checkTypeIdx);
            if (instance instanceof ObjectLiteral) {
                ObjectLiteral instanceLit = (ObjectLiteral)instance;
                try {
                    vm.invokeExact((MethodElement)checkType, instanceLit.getValue(), List.of(realType));
                }
                catch (Thrown t) {
                    ctxt.warning(fb.getLocation(), "Failed to expand MethodHandle.invokeExact intrinsic: %s", new Object[]{t});
                    log.warnf((Throwable)t, "Failed to expand MethodHandle.invokeExact intrinsic", new Object[0]);
                    throw new BlockEarlyTermination(fb.throw_((Value)lf.literalOf((VmObject)t.getThrowable())));
                }
            } else {
                fb.call(fb.lookupVirtualMethod(instance, checkType), instance, List.of(lf.literalOf(realType)));
            }
            Value invokeBasicHandle = fb.resolveInstanceMethod((TypeDescriptor)methodHandleDesc, "invokeBasic", callSiteDescriptor);
            return fb.call(invokeBasicHandle, instance, arguments);
        };
        intrinsics.registerIntrinsic((TypeDescriptor)methodHandleDesc, "invokeExact", invokeExactIntrinsic);
        InstanceIntrinsic invokeBasicIntrinsic = (builder, instance, target, arguments) -> {
            LiteralFactory lf = ctxt.getLiteralFactory();
            if (instance instanceof ObjectLiteral) {
                ObjectLiteral instanceLit = (ObjectLiteral)instance;
                Reflection reflection = Reflection.get(ctxt);
                BasicBlockBuilder fb = builder.getFirstBuilder();
                try {
                    VmObject methodHandle = instanceLit.getValue();
                    VmObject lambdaForm = methodHandle.getMemory().loadRef((long)methodHandle.indexOf((FieldElement)reflection.methodHandleLambdaFormField), (ReadAccessMode)AccessModes.SinglePlain);
                    VmObject memberName = lambdaForm.getMemory().loadRef((long)lambdaForm.indexOf((FieldElement)reflection.lambdaFormMemberNameField), (ReadAccessMode)AccessModes.SinglePlain);
                    Pointer methodPtr = memberName.getMemory().loadPointer((long)memberName.indexOf((FieldElement)reflection.memberNameExactDispatcherField), (ReadAccessMode)AccessModes.SinglePlain);
                    ArrayList<Value> newArgs = new ArrayList<Value>(arguments.size() + 1);
                    newArgs.add(instance);
                    newArgs.addAll(arguments);
                    if (methodPtr instanceof StaticMethodPointer) {
                        StaticMethodPointer smp = (StaticMethodPointer)methodPtr;
                        return fb.call((Value)lf.literalOf(smp.getExecutableElement()), newArgs);
                    }
                    if (methodPtr instanceof InstanceMethodPointer) {
                        InstanceMethodPointer imp = (InstanceMethodPointer)methodPtr;
                        return fb.call((Value)lf.literalOf(imp.getExecutableElement()), (Value)arguments.get(0), newArgs.subList(1, newArgs.size()));
                    }
                    ctxt.warning(fb.getLocation(), "Unknown method handle pointer type: %s", new Object[]{methodPtr.getClass()});
                    return null;
                }
                catch (Thrown t) {
                    ctxt.warning(fb.getLocation(), "Failed to expand MethodHandle.invokeBasic intrinsic: %s", new Object[]{t});
                    log.warnf((Throwable)t, "Failed to expand MethodHandle.invokeBasic intrinsic", new Object[0]);
                    Value ie = fb.new_(internalErrorDesc);
                    fb.call(fb.resolveConstructor((TypeDescriptor)internalErrorDesc, throwableToVoid), ie, List.of(lf.literalOf((VmObject)t.getThrowable())));
                    throw new BlockEarlyTermination(fb.throw_(ie));
                }
            }
            return null;
        };
        intrinsics.registerIntrinsic((TypeDescriptor)methodHandleDesc, "invokeBasic", invokeBasicIntrinsic);
        InstanceIntrinsic invokeBasicMethodBody = (builder, instance, target, arguments) -> {
            TypeSystem ts = ctxt.getTypeSystem();
            Reflection reflection = Reflection.get(ctxt);
            BasicBlockBuilder fb = builder.getFirstBuilder();
            Value lambdaForm = fb.load(fb.instanceFieldOf(fb.decodeReference(instance), reflection.methodHandleLambdaFormField));
            Value memberName = fb.load(fb.instanceFieldOf(fb.decodeReference(lambdaForm), reflection.lambdaFormMemberNameField));
            Value methodPtr = fb.load(fb.instanceFieldOf(fb.decodeReference(memberName), reflection.memberNameExactDispatcherField));
            ArrayList<Value> newArgs = new ArrayList<Value>(arguments.size() + 1);
            newArgs.add(instance);
            newArgs.addAll(arguments);
            InstanceMethodType methodType = target.getExecutable().getType();
            List parameterTypes = methodType.getParameterTypes();
            StaticMethodType dispatcherType = ts.getStaticMethodType(methodType.getReturnType(), parameterTypes).withFirstParameterType(methodType.getReceiverType());
            Value castMethodPtr = fb.bitCast(methodPtr, (WordType)dispatcherType.getPointer());
            throw new BlockEarlyTermination(fb.tailCall(castMethodPtr, newArgs));
        };
        patcher.replaceMethodBody(bootstrapClassContext, methodHandleInt, "invokeBasic", objArrayToObj, (MethodBodyFactory)new InstanceIntrinsicMethodBodyFactory(invokeBasicMethodBody), 0);
        StaticIntrinsic linkToStaticIntrinsic = (builder, target, arguments) -> {
            LiteralFactory lf = ctxt.getLiteralFactory();
            int lastArg = arguments.size() - 1;
            Value memberNameValue = (Value)arguments.get(lastArg);
            if (memberNameValue instanceof ObjectLiteral) {
                ObjectLiteral memberNameLit = (ObjectLiteral)memberNameValue;
                Reflection reflection = Reflection.get(ctxt);
                BasicBlockBuilder fb = builder.getFirstBuilder();
                try {
                    VmObject memberName = memberNameLit.getValue();
                    Pointer methodPtr = memberName.getMemory().loadPointer((long)memberName.indexOf((FieldElement)reflection.memberNameExactDispatcherField), (ReadAccessMode)AccessModes.SinglePlain);
                    if (methodPtr instanceof StaticMethodPointer) {
                        StaticMethodPointer smp = (StaticMethodPointer)methodPtr;
                        return fb.call((Value)lf.literalOf(smp.getExecutableElement()), arguments.subList(0, lastArg));
                    }
                    ctxt.warning(fb.getLocation(), "Unknown method handle pointer type: %s", new Object[]{methodPtr.getClass()});
                    return null;
                }
                catch (Thrown t) {
                    ctxt.warning(fb.getLocation(), "Failed to expand MethodHandle.linkToStatic intrinsic: %s", new Object[]{t});
                    log.warnf((Throwable)t, "Failed to expand MethodHandle.linkToStatic intrinsic", new Object[0]);
                    throw new BlockEarlyTermination(fb.throw_((Value)lf.literalOf((VmObject)t.getThrowable())));
                }
            }
            return null;
        };
        intrinsics.registerIntrinsic((TypeDescriptor)methodHandleDesc, "linkToStatic", linkToStaticIntrinsic);
        StaticIntrinsic linkToStaticMethodBody = (builder, target, arguments) -> {
            Reflection reflection = Reflection.get(ctxt);
            BasicBlockBuilder fb = builder.getFirstBuilder();
            int lastArg = arguments.size() - 1;
            Value memberName = (Value)arguments.get(lastArg);
            Value methodPtr = fb.load(fb.instanceFieldOf(fb.decodeReference(memberName), reflection.memberNameExactDispatcherField));
            StaticMethodType methodType = target.getExecutable().getType();
            Value castMethodPtr = fb.bitCast(methodPtr, (WordType)methodType.trimLastParameter().getPointer());
            throw new BlockEarlyTermination(fb.tailCall(castMethodPtr, arguments.subList(0, lastArg)));
        };
        patcher.replaceMethodBody(bootstrapClassContext, methodHandleInt, "linkToStatic", objArrayToObj, (MethodBodyFactory)new StaticIntrinsicMethodBodyFactory(linkToStaticMethodBody), 0);
        StaticIntrinsic linkToInterfaceIntrinsic = (builder, target, arguments) -> {
            LiteralFactory lf = ctxt.getLiteralFactory();
            int lastArg = arguments.size() - 1;
            Value memberNameValue = (Value)arguments.get(lastArg);
            if (memberNameValue instanceof ObjectLiteral) {
                ObjectLiteral memberNameLit = (ObjectLiteral)memberNameValue;
                Reflection reflection = Reflection.get(ctxt);
                BasicBlockBuilder fb = builder.getFirstBuilder();
                try {
                    VmObject memberName = memberNameLit.getValue();
                    Pointer methodPtr = memberName.getMemory().loadPointer((long)memberName.indexOf((FieldElement)reflection.memberNameExactDispatcherField), (ReadAccessMode)AccessModes.SinglePlain);
                    if (methodPtr instanceof StaticMethodPointer) {
                        StaticMethodPointer smp = (StaticMethodPointer)methodPtr;
                        return fb.call((Value)lf.literalOf(smp.getExecutableElement()), arguments.subList(0, lastArg));
                    }
                    ctxt.warning(fb.getLocation(), "Unknown method handle pointer type: %s", new Object[]{methodPtr.getClass()});
                    return null;
                }
                catch (Thrown t) {
                    ctxt.warning(fb.getLocation(), "Failed to expand MethodHandle.linkToInterface intrinsic: %s", new Object[]{t});
                    log.warnf((Throwable)t, "Failed to expand MethodHandle.linkToInterface intrinsic", new Object[0]);
                    throw new BlockEarlyTermination(fb.throw_((Value)lf.literalOf((VmObject)t.getThrowable())));
                }
            }
            return null;
        };
        intrinsics.registerIntrinsic((TypeDescriptor)methodHandleDesc, "linkToInterface", linkToInterfaceIntrinsic);
        StaticIntrinsic linkToInterfaceMethodBody = (builder, target, arguments) -> {
            Reflection reflection = Reflection.get(ctxt);
            BasicBlockBuilder fb = builder.getFirstBuilder();
            int lastArg = arguments.size() - 1;
            Value memberName = (Value)arguments.get(lastArg);
            Value methodPtr = fb.load(fb.instanceFieldOf(fb.decodeReference(memberName), reflection.memberNameExactDispatcherField));
            StaticMethodType methodType = target.getExecutable().getType();
            Value castMethodPtr = fb.bitCast(methodPtr, (WordType)methodType.trimLastParameter().getPointer());
            throw new BlockEarlyTermination(fb.tailCall(castMethodPtr, arguments.subList(0, lastArg)));
        };
        patcher.replaceMethodBody(bootstrapClassContext, methodHandleInt, "linkToInterface", objArrayToObj, (MethodBodyFactory)new StaticIntrinsicMethodBodyFactory(linkToInterfaceMethodBody), 0);
        StaticIntrinsic linkToSpecialIntrinsic = (builder, target, arguments) -> {
            LiteralFactory lf = ctxt.getLiteralFactory();
            int lastArg = arguments.size() - 1;
            Value memberNameValue = (Value)arguments.get(lastArg);
            if (memberNameValue instanceof ObjectLiteral) {
                ObjectLiteral memberNameLit = (ObjectLiteral)memberNameValue;
                Reflection reflection = Reflection.get(ctxt);
                BasicBlockBuilder fb = builder.getFirstBuilder();
                try {
                    VmObject memberName = memberNameLit.getValue();
                    Pointer methodPtr = memberName.getMemory().loadPointer((long)memberName.indexOf((FieldElement)reflection.memberNameExactDispatcherField), (ReadAccessMode)AccessModes.SinglePlain);
                    if (methodPtr instanceof StaticMethodPointer) {
                        StaticMethodPointer smp = (StaticMethodPointer)methodPtr;
                        return fb.call((Value)lf.literalOf(smp.getExecutableElement()), arguments.subList(0, lastArg));
                    }
                    ctxt.warning(fb.getLocation(), "Unknown method handle pointer type: %s", new Object[]{methodPtr.getClass()});
                    return null;
                }
                catch (Thrown t) {
                    ctxt.warning(fb.getLocation(), "Failed to expand MethodHandle.linkToSpecial intrinsic: %s", new Object[]{t});
                    log.warnf((Throwable)t, "Failed to expand MethodHandle.linkToSpecial intrinsic", new Object[0]);
                    throw new BlockEarlyTermination(fb.throw_((Value)lf.literalOf((VmObject)t.getThrowable())));
                }
            }
            return null;
        };
        intrinsics.registerIntrinsic((TypeDescriptor)methodHandleDesc, "linkToSpecial", linkToSpecialIntrinsic);
        StaticIntrinsic linkToSpecialMethodBody = (builder, target, arguments) -> {
            Reflection reflection = Reflection.get(ctxt);
            BasicBlockBuilder fb = builder.getFirstBuilder();
            int lastArg = arguments.size() - 1;
            Value memberName = (Value)arguments.get(lastArg);
            Value methodPtr = fb.load(fb.instanceFieldOf(fb.decodeReference(memberName), reflection.memberNameExactDispatcherField));
            StaticMethodType methodType = target.getExecutable().getType();
            Value castMethodPtr = fb.bitCast(methodPtr, (WordType)methodType.trimLastParameter().getPointer());
            throw new BlockEarlyTermination(fb.tailCall(castMethodPtr, arguments.subList(0, lastArg)));
        };
        patcher.replaceMethodBody(bootstrapClassContext, methodHandleInt, "linkToSpecial", objArrayToObj, (MethodBodyFactory)new StaticIntrinsicMethodBodyFactory(linkToSpecialMethodBody), 0);
        StaticIntrinsic linkToVirtualIntrinsic = (builder, target, arguments) -> {
            LiteralFactory lf = ctxt.getLiteralFactory();
            int lastArg = arguments.size() - 1;
            Value memberNameValue = (Value)arguments.get(lastArg);
            if (memberNameValue instanceof ObjectLiteral) {
                ObjectLiteral memberNameLit = (ObjectLiteral)memberNameValue;
                Reflection reflection = Reflection.get(ctxt);
                BasicBlockBuilder fb = builder.getFirstBuilder();
                try {
                    VmObject memberName = memberNameLit.getValue();
                    Pointer methodPtr = memberName.getMemory().loadPointer((long)memberName.indexOf((FieldElement)reflection.memberNameExactDispatcherField), (ReadAccessMode)AccessModes.SinglePlain);
                    if (methodPtr instanceof StaticMethodPointer) {
                        StaticMethodPointer smp = (StaticMethodPointer)methodPtr;
                        return fb.call((Value)lf.literalOf(smp.getExecutableElement()), arguments.subList(0, lastArg));
                    }
                    ctxt.warning(fb.getLocation(), "Unknown method handle pointer type: %s", new Object[]{methodPtr.getClass()});
                    return null;
                }
                catch (Thrown t) {
                    ctxt.warning(fb.getLocation(), "Failed to expand MethodHandle.linkToVirtual intrinsic: %s", new Object[]{t});
                    log.warnf((Throwable)t, "Failed to expand MethodHandle.linkToVirtual intrinsic", new Object[0]);
                    throw new BlockEarlyTermination(fb.throw_((Value)lf.literalOf((VmObject)t.getThrowable())));
                }
            }
            return null;
        };
        intrinsics.registerIntrinsic((TypeDescriptor)methodHandleDesc, "linkToVirtual", linkToVirtualIntrinsic);
        StaticIntrinsic linkToVirtualMethodBody = (builder, target, arguments) -> {
            Reflection reflection = Reflection.get(ctxt);
            BasicBlockBuilder fb = builder.getFirstBuilder();
            int lastArg = arguments.size() - 1;
            Value memberName = (Value)arguments.get(lastArg);
            Value methodPtr = fb.load(fb.instanceFieldOf(fb.decodeReference(memberName), reflection.memberNameExactDispatcherField));
            StaticMethodType methodType = target.getExecutable().getType();
            Value castMethodPtr = fb.bitCast(methodPtr, (WordType)methodType.trimLastParameter().getPointer());
            throw new BlockEarlyTermination(fb.tailCall(castMethodPtr, arguments.subList(0, lastArg)));
        };
        patcher.replaceMethodBody(bootstrapClassContext, methodHandleInt, "linkToVirtual", objArrayToObj, (MethodBodyFactory)new StaticIntrinsicMethodBodyFactory(linkToVirtualMethodBody), 0);
        final LoadedTypeDefinition wmteDef = bootstrapClassContext.findDefinedType("java/lang/invoke/WrongMethodTypeException").load();
        final ConstructorElement wmteCtor = wmteDef.requireSingleConstructor(ce -> ce.getParameters().isEmpty());
        final class VarHandleBodyIntrinsic
        implements InstanceIntrinsic {
            VarHandleBodyIntrinsic() {
            }

            public Value emitIntrinsic(BasicBlockBuilder builder, Value instance, InstanceMethodLiteral target, List<Value> arguments) {
                InstanceMethodElement methodElement = target.getExecutable();
                MethodDescriptor descriptor = methodElement.getDescriptor();
                DefinedTypeDefinition enclosingType = methodElement.getEnclosingType();
                if (Reflection.isErased(descriptor)) {
                    Value ex = builder.new_((ClassTypeDescriptor)wmteDef.getDescriptor());
                    builder.call((Value)builder.getLiteralFactory().literalOf(wmteCtor), ex, List.of());
                    throw new BlockEarlyTermination(builder.throw_(ex));
                }
                ClassContext classContext = target.getExecutable().getEnclosingType().getContext();
                MethodDescriptor erased = Reflection.erase(classContext, descriptor);
                TypeDescriptor returnTypeDesc = descriptor.getReturnType();
                if (Reflection.isErased(returnTypeDesc)) {
                    throw new BlockEarlyTermination(builder.tailCall(builder.lookupVirtualMethod(instance, enclosingType.getDescriptor(), methodElement.getName(), erased), instance, arguments));
                }
                Value result = builder.call(builder.lookupVirtualMethod(instance, enclosingType.getDescriptor(), methodElement.getName(), erased), instance, arguments);
                throw new BlockEarlyTermination(builder.return_(builder.checkcast(result, returnTypeDesc)));
            }
        }
        InstanceIntrinsicMethodBodyFactory varHandleBodyFactory = new InstanceIntrinsicMethodBodyFactory(new VarHandleBodyIntrinsic());
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "get", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "set", objArrayToVoid, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getVolatile", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "setVolatile", objArrayToVoid, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAcquire", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "setRelease", objArrayToVoid, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getOpaque", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "setOpaque", objArrayToVoid, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "compareAndSet", objArrayToBool, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "compareAndExchange", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "compareAndExchangeAcquire", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "compareAndExchangeRelease", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "weakCompareAndSetPlain", objArrayToBool, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "weakCompareAndSet", objArrayToBool, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "weakCompareAndSetAcquire", objArrayToBool, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "weakCompareAndSetRelease", objArrayToBool, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndSet", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndSetAcquire", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndSetRelease", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndAdd", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndAddAcquire", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndAddRelease", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndBitwiseOr", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndBitwiseOrRelease", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndBitwiseOrAcquire", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndBitwiseAnd", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndBitwiseAndRelease", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndBitwiseAndAcquire", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndBitwiseXor", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndBitwiseXorRelease", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
        patcher.replaceMethodBody(bootstrapClassContext, varHandleInt, "getAndBitwiseXorAcquire", objArrayToObj, (MethodBodyFactory)varHandleBodyFactory, 0);
    }

    public static void registerReflectionAnalysisIntrinsics(CompilationContext ctxt) {
        Intrinsics intrinsics = Intrinsics.get((CompilationContext)ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor jlcDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Class");
        ClassTypeDescriptor jloDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/Object");
        ClassTypeDescriptor jlsDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/String");
        ClassTypeDescriptor cnfeDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/ClassNotFoundException");
        ClassTypeDescriptor jlrCtorDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/reflect/Constructor");
        ClassTypeDescriptor jlrFieldDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/reflect/Field");
        ClassTypeDescriptor jlrMethodDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/reflect/Method");
        ArrayTypeDescriptor jlcADesc = ArrayTypeDescriptor.of((ClassContext)classContext, (TypeDescriptor)jlcDesc);
        MethodDescriptor stringToClass = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)jlcDesc, List.of(jlsDesc));
        MethodDescriptor stringToField = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)jlrFieldDesc, List.of(jlsDesc));
        MethodDescriptor stringAndClassesToMethod = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)jlrMethodDesc, List.of(jlsDesc, jlcADesc));
        MethodDescriptor classesToCtor = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)jlrCtorDesc, List.of(jlcADesc));
        StaticIntrinsic forName = (builder, target, arguments) -> {
            Object patt33462$temp = arguments.get(0);
            if (patt33462$temp instanceof StringLiteral) {
                StringLiteral sl = (StringLiteral)patt33462$temp;
                String internalName = sl.getValue().replace('.', '/');
                DefinedTypeDefinition dtd = builder.getCurrentClassContext().findDefinedType(internalName);
                if (dtd != null) {
                    LoadedTypeDefinition loaded;
                    BasicBlockBuilder fb = builder.getFirstBuilder();
                    try {
                        loaded = dtd.load();
                    }
                    catch (VerifyFailedException e) {
                        Value ex = fb.new_(cnfeDesc);
                        fb.call(fb.resolveConstructor((TypeDescriptor)cnfeDesc, MethodDescriptor.VOID_METHOD_DESCRIPTOR), ex, List.of());
                        throw new BlockEarlyTermination(fb.throw_(ex));
                    }
                    Value cls = fb.classOf(loaded.getObjectType());
                    fb.initializeClass(cls);
                    return cls;
                }
            }
            return null;
        };
        intrinsics.registerIntrinsic((TypeDescriptor)jlcDesc, "forName", stringToClass, forName);
        InstanceIntrinsic findField = (builder, instance, target, arguments) -> {
            TypeLiteral tl;
            ValueType patt34918$temp;
            ClassOf co;
            Value patt34875$temp;
            if (instance instanceof ClassOf && (patt34875$temp = (co = (ClassOf)instance).getInput()) instanceof TypeLiteral && (patt34918$temp = (tl = (TypeLiteral)patt34875$temp).getValue()) instanceof ObjectType) {
                StringLiteral sl;
                FieldElement fe;
                ObjectType ot = (ObjectType)patt34918$temp;
                LoadedTypeDefinition receivingClass = ot.getDefinition().load();
                Object patt35064$temp = arguments.get(0);
                if (patt35064$temp instanceof StringLiteral && (fe = receivingClass.findField((sl = (StringLiteral)patt35064$temp).getValue())) != null) {
                    VmObject fObj = Reflection.get(builder.getContext()).getField(fe);
                    return builder.getContext().getLiteralFactory().literalOf(fObj);
                }
                ReflectiveElementRegistry.get(builder.getContext()).bulkRegisterElementsForReflection(receivingClass, true, false, false);
            }
            return null;
        };
        intrinsics.registerIntrinsic((TypeDescriptor)jlcDesc, "getField", stringToField, findField);
        intrinsics.registerIntrinsic((TypeDescriptor)jlcDesc, "getDeclaredField", stringToField, findField);
        InstanceIntrinsic findMethod = (builder, instance, target, arguments) -> {
            TypeLiteral tl;
            ValueType patt36098$temp;
            ClassOf co;
            Value patt36055$temp;
            if (instance instanceof ClassOf && (patt36055$temp = (co = (ClassOf)instance).getInput()) instanceof TypeLiteral && (patt36098$temp = (tl = (TypeLiteral)patt36055$temp).getValue()) instanceof ObjectType) {
                ObjectType ot = (ObjectType)patt36098$temp;
                LoadedTypeDefinition receivingClass = ot.getDefinition().load();
                ReflectiveElementRegistry.get(ctxt).bulkRegisterElementsForReflection(receivingClass, false, false, true);
            }
            return null;
        };
        intrinsics.registerIntrinsic((TypeDescriptor)jlcDesc, "getMethod", stringAndClassesToMethod, findMethod);
        intrinsics.registerIntrinsic((TypeDescriptor)jlcDesc, "getDeclaredMethod", stringAndClassesToMethod, findMethod);
        InstanceIntrinsic findConstructor = (builder, instance, target, arguments) -> {
            TypeLiteral tl;
            ValueType patt37131$temp;
            ClassOf co;
            Value patt37088$temp;
            if (instance instanceof ClassOf && (patt37088$temp = (co = (ClassOf)instance).getInput()) instanceof TypeLiteral && (patt37131$temp = (tl = (TypeLiteral)patt37088$temp).getValue()) instanceof ObjectType) {
                ObjectType ot = (ObjectType)patt37131$temp;
                LoadedTypeDefinition receivingClass = ot.getDefinition().load();
                ReflectiveElementRegistry.get(ctxt).bulkRegisterElementsForReflection(receivingClass, false, true, false);
            }
            return null;
        };
        intrinsics.registerIntrinsic((TypeDescriptor)jlcDesc, "getConstructor", classesToCtor, findConstructor);
        intrinsics.registerIntrinsic((TypeDescriptor)jlcDesc, "getDeclaredConstructor", classesToCtor, findConstructor);
    }

    static final class InstanceIntrinsicMethodBodyFactory
    implements MethodBodyFactory {
        private final InstanceIntrinsic methodBodyIntrinsic;

        InstanceIntrinsicMethodBodyFactory(InstanceIntrinsic methodBodyIntrinsic) {
            this.methodBodyIntrinsic = methodBodyIntrinsic;
        }

        public MethodBody createMethodBody(int index, ExecutableElement element) {
            if (!(element instanceof InstanceMethodElement)) {
                throw new IllegalStateException();
            }
            InstanceMethodElement ime = (InstanceMethodElement)element;
            ime.setModifierFlags(262144);
            InvokableType type = element.getType();
            DefinedTypeDefinition enclosingType = element.getEnclosingType();
            ClassContext classContext = enclosingType.getContext();
            LiteralFactory lf = classContext.getLiteralFactory();
            BasicBlockBuilder bbb = classContext.newBasicBlockBuilder(element);
            BlockLabel entryLabel = new BlockLabel();
            bbb.begin(entryLabel);
            BlockParameter this_ = bbb.addParam(entryLabel, Slot.this_(), (ValueType)element.getEnclosingType().load().getObjectType().getReference(), false);
            ArrayList<BlockParameter> paramValues = new ArrayList<BlockParameter>(type.getParameterCount());
            int cnt = type.getParameterCount();
            for (int i = 0; i < cnt; ++i) {
                paramValues.add(bbb.addParam(entryLabel, Slot.funcParam((int)i), type.getParameterType(i)));
            }
            try {
                Value retVal = this.methodBodyIntrinsic.emitIntrinsic(bbb, (Value)this_, lf.literalOf(ime), paramValues);
                if (retVal == null) {
                    throw new IllegalStateException("Failed to emit method body");
                }
                bbb.return_(retVal);
            }
            catch (BlockEarlyTermination retVal) {
                // empty catch block
            }
            bbb.finish();
            BasicBlock entryBlock = BlockLabel.getTargetOf((BlockLabel)entryLabel);
            return MethodBody.of((BasicBlock)entryBlock, (List)Slot.simpleArgList((int)cnt));
        }
    }

    static final class StaticIntrinsicMethodBodyFactory
    implements MethodBodyFactory {
        private final StaticIntrinsic methodBodyIntrinsic;

        StaticIntrinsicMethodBodyFactory(StaticIntrinsic methodBodyIntrinsic) {
            this.methodBodyIntrinsic = methodBodyIntrinsic;
        }

        public MethodBody createMethodBody(int index, ExecutableElement element) {
            if (!(element instanceof StaticMethodElement)) {
                throw new IllegalStateException();
            }
            StaticMethodElement sme = (StaticMethodElement)element;
            sme.setModifierFlags(262144);
            InvokableType type = element.getType();
            DefinedTypeDefinition enclosingType = element.getEnclosingType();
            ClassContext classContext = enclosingType.getContext();
            LiteralFactory lf = classContext.getLiteralFactory();
            BasicBlockBuilder bbb = classContext.newBasicBlockBuilder(element);
            BlockLabel entryLabel = new BlockLabel();
            bbb.begin(entryLabel);
            ArrayList<BlockParameter> paramValues = new ArrayList<BlockParameter>(type.getParameterCount());
            int cnt = type.getParameterCount();
            for (int i = 0; i < cnt; ++i) {
                paramValues.add(bbb.addParam(entryLabel, Slot.funcParam((int)i), type.getParameterType(i)));
            }
            try {
                Value retVal = this.methodBodyIntrinsic.emitIntrinsic(bbb, lf.literalOf(sme), paramValues);
                if (retVal == null) {
                    throw new IllegalStateException("Failed to emit method body");
                }
                bbb.return_(retVal);
            }
            catch (BlockEarlyTermination retVal) {
                // empty catch block
            }
            bbb.finish();
            BasicBlock entryBlock = BlockLabel.getTargetOf((BlockLabel)entryLabel);
            return MethodBody.of((BasicBlock)entryBlock, (List)Slot.simpleArgList((int)cnt));
        }
    }
}

