/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reflection;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.apploader.AppClassLoader;
import org.qbicc.plugin.reachability.ReachabilityRoots;
import org.qbicc.plugin.reflection.Reflection;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public class ReflectiveElementRegistry {
    private static final AttachmentKey<ReflectiveElementRegistry> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Map<String, ClassInfo> reflectiveClasses = new ConcurrentHashMap<String, ClassInfo>();
    private final Map<String, Set<String>> reflectiveConstructors = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> reflectiveFields = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> reflectiveMethods = new ConcurrentHashMap<String, Set<String>>();
    private final Set<MethodElement> reflectiveMethodElements = ConcurrentHashMap.newKeySet();
    private final Set<ConstructorElement> reflectiveConstructorElements = ConcurrentHashMap.newKeySet();
    private final Set<FieldElement> reflectiveFieldElements = ConcurrentHashMap.newKeySet();
    private final Set<LoadedTypeDefinition> reflectiveLoadedTypes = ConcurrentHashMap.newKeySet();

    private ReflectiveElementRegistry(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static ReflectiveElementRegistry get(CompilationContext ctxt) {
        ReflectiveElementRegistry appearing;
        ReflectiveElementRegistry patcher = (ReflectiveElementRegistry)ctxt.getAttachment(KEY);
        if (patcher == null && (appearing = (ReflectiveElementRegistry)ctxt.putAttachmentIfAbsent(KEY, (Object)(patcher = new ReflectiveElementRegistry(ctxt)))) != null) {
            patcher = appearing;
        }
        return patcher;
    }

    public void addReflectiveClass(String internalName, boolean fields, boolean methods, boolean constructors) {
        ClassInfo prior = this.reflectiveClasses.putIfAbsent(internalName, new ClassInfo(fields, methods, constructors));
        if (prior != null) {
            prior.fields |= fields;
            prior.methods |= methods;
            prior.constructors |= constructors;
        }
    }

    boolean isReflectiveClass(String internalName) {
        return this.reflectiveClasses.containsKey(internalName);
    }

    public void addReflectiveConstructor(String className, String[] parameterTypes) {
        this.reflectiveConstructors.computeIfAbsent(className, k -> ConcurrentHashMap.newKeySet()).add(this.encodeArguments(parameterTypes));
    }

    boolean hasReflectiveConstructors(String className) {
        ClassInfo ci = this.reflectiveClasses.get(className);
        return ci != null && ci.constructors || this.reflectiveConstructors.containsKey(className);
    }

    boolean isReflectiveConstructor(String className, MethodDescriptor descriptor) {
        ClassInfo ci = this.reflectiveClasses.get(className);
        if (ci != null && ci.constructors) {
            return true;
        }
        Set<String> constructors = this.reflectiveConstructors.get(className);
        if (constructors != null) {
            for (String candidate : constructors) {
                if (!this.matchesArguments(candidate, descriptor.getParameterTypes())) continue;
                return true;
            }
        }
        return false;
    }

    public void addReflectiveField(String className, String fieldName) {
        this.reflectiveFields.computeIfAbsent(className, k -> ConcurrentHashMap.newKeySet()).add(fieldName);
    }

    boolean hasReflectiveFields(String className) {
        ClassInfo ci = this.reflectiveClasses.get(className);
        return ci != null && ci.fields || this.reflectiveFields.containsKey(className);
    }

    boolean isReflectiveField(String className, String fieldName) {
        ClassInfo ci = this.reflectiveClasses.get(className);
        if (ci != null && ci.fields) {
            return true;
        }
        Set<String> fields = this.reflectiveFields.get(className);
        return fields != null && fields.contains(fieldName);
    }

    public void addReflectiveMethod(String className, String methodName, String[] parameterTypes) {
        this.reflectiveMethods.computeIfAbsent(className, k -> ConcurrentHashMap.newKeySet()).add(methodName + ":" + this.encodeArguments(parameterTypes));
    }

    boolean hasReflectiveMethods(String className) {
        ClassInfo ci = this.reflectiveClasses.get(className);
        return ci != null && ci.methods || this.reflectiveMethods.containsKey(className);
    }

    boolean isReflectiveMethod(String className, String methodName, MethodDescriptor descriptor) {
        ClassInfo ci = this.reflectiveClasses.get(className);
        if (ci != null && ci.methods) {
            return true;
        }
        Set<String> encodedMethods = this.reflectiveMethods.get(className);
        if (encodedMethods != null) {
            for (String candidate : encodedMethods) {
                String[] split = candidate.split(":");
                if (!methodName.equals(split[0]) || !this.matchesArguments(split.length == 1 ? "" : split[1], descriptor.getParameterTypes())) continue;
                return true;
            }
        }
        return false;
    }

    public static void ensureReflectiveClassesLoaded(CompilationContext ctxt) {
        ClassContext cc = AppClassLoader.get((CompilationContext)ctxt).getAppClassLoader().getClassContext();
        ReflectiveElementRegistry re = ReflectiveElementRegistry.get(ctxt);
        for (String cn : re.reflectiveClasses.keySet()) {
            DefinedTypeDefinition dtd = cc.findDefinedType(cn);
            if (dtd != null) continue;
            ctxt.warning("Failed to load reflective class %s", new Object[]{cn});
        }
    }

    public void registerReflectiveType(LoadedTypeDefinition ltd) {
        ClassInfo ci;
        boolean added = this.reflectiveLoadedTypes.add(ltd);
        if (added && (ci = this.reflectiveClasses.get(ltd.getInternalName())) != null) {
            if (ci.methods && ltd.getMethodCount() == 0) {
                Reflection.get(this.ctxt).makeMethodsAvailableForRuntimeReflection(ltd);
            }
            if (ci.fields && ltd.getFieldCount() == 0) {
                Reflection.get(this.ctxt).makeFieldsAvailableForRuntimeReflection(ltd);
            }
        }
    }

    public boolean isReflectiveType(LoadedTypeDefinition ltd) {
        return this.reflectiveLoadedTypes.contains(ltd);
    }

    public void registerReflectiveMethod(MethodElement e) {
        boolean added = this.reflectiveMethodElements.add(e);
        if (added) {
            ReachabilityRoots.get((CompilationContext)this.ctxt).registerReflectiveEntrypoint((ExecutableElement)e);
            this.ctxt.submitTask((Object)e, methodElement -> Reflection.get(this.ctxt).makeMethodsAvailableForRuntimeReflection(methodElement.getEnclosingType().load()));
        }
    }

    public void registerReflectiveConstructor(ConstructorElement e) {
        boolean added = this.reflectiveConstructorElements.add(e);
        if (added) {
            ReachabilityRoots.get((CompilationContext)this.ctxt).registerReflectiveEntrypoint((ExecutableElement)e);
            this.ctxt.submitTask((Object)e, constructorElement -> Reflection.get(this.ctxt).makeConstructorsAvailableForRuntimeReflection(constructorElement.getEnclosingType().load()));
        }
    }

    public void registerReflectiveField(FieldElement f) {
        boolean added = this.reflectiveFieldElements.add(f);
        if (added) {
            if (f.isStatic()) {
                ReachabilityRoots.get((CompilationContext)this.ctxt).registerHeapRoot((StaticFieldElement)f);
            }
            this.ctxt.submitTask((Object)f, fieldElement -> Reflection.get(this.ctxt).makeFieldsAvailableForRuntimeReflection(fieldElement.getEnclosingType().load()));
        }
    }

    public void bulkRegisterElementsForReflection(LoadedTypeDefinition cls, boolean fields, boolean constructors, boolean methods) {
        this.registerReflectiveType(cls);
        Reflection reflect = Reflection.get(this.ctxt);
        if (fields) {
            reflect.makeFieldsAvailableForRuntimeReflection(cls);
        }
        if (constructors) {
            reflect.makeConstructorsAvailableForRuntimeReflection(cls);
        }
        if (methods) {
            reflect.makeMethodsAvailableForRuntimeReflection(cls);
            for (MethodElement m : cls.getInstanceMethods()) {
                if (m.getEnclosingType().equals(cls)) continue;
                reflect.makeMethodsAvailableForRuntimeReflection(m.getEnclosingType().load());
            }
        }
    }

    private String encodeArguments(String[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        if (args.length == 1 && args[0].equals("*")) {
            return "*";
        }
        StringBuilder ans = new StringBuilder(this.toDescriptorString(args[0]));
        for (int i = 1; i < args.length; ++i) {
            ans.append(",").append(this.toDescriptorString(args[i]));
        }
        return ans.toString();
    }

    private String toDescriptorString(String t) {
        return switch (t) {
            case "boolean" -> "Z";
            case "byte" -> "B";
            case "short" -> "S";
            case "char" -> "C";
            case "int" -> "I";
            case "float" -> "F";
            case "long" -> "J";
            case "double" -> "D";
            default -> t.startsWith("[") ? t : "L" + t.replace('.', '/') + ";";
        };
    }

    private boolean matchesArguments(String encodedArgs, List<TypeDescriptor> paramTypes) {
        if (paramTypes.isEmpty() && encodedArgs.equals("")) {
            return true;
        }
        String[] args = encodedArgs.split(",");
        if (args.length == 1 && args[0].equals("*")) {
            return true;
        }
        if (args.length != paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(paramTypes.get(i).toString())) continue;
            return false;
        }
        return true;
    }

    private static class ClassInfo {
        boolean fields;
        boolean methods;
        boolean constructors;

        ClassInfo(boolean f, boolean m, boolean c) {
            this.fields = f;
            this.methods = m;
            this.constructors = c;
        }
    }
}

