/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reflection;

import java.util.List;
import java.util.function.Predicate;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Locatable;
import org.qbicc.plugin.core.ConditionEvaluation;
import org.qbicc.plugin.reflection.ReflectiveElementRegistry;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.ValueType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.ArrayAnnotationValue;
import org.qbicc.type.annotation.ClassAnnotationValue;
import org.qbicc.type.annotation.StringAnnotationValue;
import org.qbicc.type.definition.ConstructorResolver;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.MethodResolver;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;

public class ReflectiveElementTypeBuilder
implements DefinedTypeDefinition.Builder.Delegating {
    private final DefinedTypeDefinition.Builder delegate;
    private final ClassContext classContext;
    private boolean reflectiveClass;
    private boolean reflectiveFields;
    private boolean reflectiveConstructors;
    private boolean reflectiveMethods;
    private final ClassTypeDescriptor reflectivelyAccessed;
    private final ClassTypeDescriptor reflectivelyAccesses;

    public ReflectiveElementTypeBuilder(ClassContext classCtxt, DefinedTypeDefinition.Builder delegate) {
        this.delegate = delegate;
        this.classContext = classCtxt;
        this.reflectivelyAccessed = ClassTypeDescriptor.synthesize((ClassContext)classCtxt, (String)"org/qbicc/runtime/ReflectivelyAccessed");
        this.reflectivelyAccesses = ClassTypeDescriptor.synthesize((ClassContext)classCtxt, (String)"org/qbicc/runtime/ReflectivelyAccesses");
    }

    public DefinedTypeDefinition.Builder getDelegate() {
        return this.delegate;
    }

    public void setName(String internalName) {
        ReflectiveElementRegistry registry = ReflectiveElementRegistry.get(this.classContext.getCompilationContext());
        if (registry.isReflectiveClass(internalName)) {
            this.reflectiveClass = true;
        }
        if (registry.hasReflectiveConstructors(internalName)) {
            this.reflectiveConstructors = true;
        }
        if (registry.hasReflectiveFields(internalName)) {
            this.reflectiveFields = true;
        }
        if (registry.hasReflectiveMethods(internalName)) {
            this.reflectiveMethods = true;
        }
        this.delegate.setName(internalName);
    }

    public void setInvisibleAnnotations(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            CompilationContext ctxt;
            ConditionEvaluation conditionEvaluation;
            if (!annotation.getDescriptor().equals(this.reflectivelyAccesses) || !(conditionEvaluation = ConditionEvaluation.get((CompilationContext)(ctxt = this.classContext.getCompilationContext()))).evaluateConditions(this.classContext, (Locatable)this, annotation)) continue;
            ReflectiveElementRegistry registry = ReflectiveElementRegistry.get(ctxt);
            ArrayAnnotationValue array = (ArrayAnnotationValue)annotation.getValue("value");
            int cnt = array.getElementCount();
            for (int j = 0; j < cnt; ++j) {
                Annotation element = (Annotation)array.getValue(j);
                TypeDescriptor clazz = ((ClassAnnotationValue)element.getValue("clazz")).getDescriptor();
                String method = ((StringAnnotationValue)element.getValue("method")).getString();
                try {
                    int idx;
                    Predicate<List> checkParams;
                    ValueType vt = this.classContext.resolveTypeFromDescriptor(clazz, TypeParameterContext.EMPTY, TypeSignature.synthesize((ClassContext)this.classContext, (TypeDescriptor)clazz));
                    if (!(vt instanceof ClassObjectType)) continue;
                    ClassObjectType ct = (ClassObjectType)vt;
                    LoadedTypeDefinition ltd = ct.getDefinition().load();
                    ArrayAnnotationValue ap = (ArrayAnnotationValue)element.getValue("params");
                    if (ap == null) {
                        checkParams = args -> true;
                    } else {
                        TypeDescriptor[] params = new TypeDescriptor[ap.getElementCount()];
                        for (int i = 0; i < params.length; ++i) {
                            params[i] = ((ClassAnnotationValue)ap.getValue(i)).getDescriptor();
                        }
                        checkParams = args -> {
                            if (args.size() != params.length) {
                                return false;
                            }
                            for (int i = 0; i < params.length; ++i) {
                                if (((TypeDescriptor)args.get(i)).equals(params[i])) continue;
                                return false;
                            }
                            return true;
                        };
                    }
                    if (method.equals("<init>")) {
                        idx = ltd.findSingleConstructorIndex(ce -> checkParams.test(ce.getDescriptor().getParameterTypes()));
                        if (idx != -1) {
                            registry.registerReflectiveConstructor(ltd.getConstructor(idx));
                            continue;
                        }
                        ctxt.warning("@RA Annotation not processed on %s. No match for %s.%s", new Object[]{this.getLocation(), clazz, method});
                        continue;
                    }
                    idx = ltd.findSingleMethodIndex(me -> me.nameEquals(method) && checkParams.test(me.getDescriptor().getParameterTypes()));
                    if (idx != -1) {
                        registry.registerReflectiveMethod(ltd.getMethod(idx));
                        continue;
                    }
                    ctxt.warning("RA Annotation not processed on %s. No match for %s.%s", new Object[]{this.getLocation(), clazz, method});
                    continue;
                }
                catch (Exception e) {
                    ctxt.warning((Throwable)e, "RA Annotation not processed in %s. No unique match for  %s.%s", new Object[]{this.getLocation(), clazz, method});
                }
            }
        }
        this.getDelegate().setInvisibleAnnotations(annotations);
    }

    public void addConstructor(final ConstructorResolver resolver, int index, MethodDescriptor descriptor) {
        if (this.reflectiveConstructors) {
            super.addConstructor(new ConstructorResolver(){

                public ConstructorElement resolveConstructor(int index, DefinedTypeDefinition enclosing, ConstructorElement.Builder builder) {
                    ConstructorElement constructorElement = resolver.resolveConstructor(index, enclosing, builder);
                    ReflectiveElementRegistry registry = ReflectiveElementRegistry.get(ReflectiveElementTypeBuilder.this.classContext.getCompilationContext());
                    String className = constructorElement.getEnclosingType().getInternalName();
                    boolean isReflective = registry.isReflectiveConstructor(className, constructorElement.getDescriptor());
                    for (Annotation annotation : constructorElement.getInvisibleAnnotations()) {
                        if (!annotation.getDescriptor().equals(ReflectiveElementTypeBuilder.this.reflectivelyAccessed)) continue;
                        isReflective = true;
                    }
                    if (isReflective) {
                        registry.registerReflectiveConstructor(constructorElement);
                    }
                    return constructorElement;
                }
            }, index, descriptor);
        } else {
            this.delegate.addConstructor(resolver, index, descriptor);
        }
    }

    public void addMethod(final MethodResolver resolver, int index, String name, MethodDescriptor descriptor) {
        if (this.reflectiveMethods) {
            super.addMethod(new MethodResolver(){

                public MethodElement resolveMethod(int index, DefinedTypeDefinition enclosing, MethodElement.Builder builder) {
                    MethodElement methodElement = resolver.resolveMethod(index, enclosing, builder);
                    ReflectiveElementRegistry registry = ReflectiveElementRegistry.get(ReflectiveElementTypeBuilder.this.classContext.getCompilationContext());
                    String className = methodElement.getEnclosingType().getInternalName();
                    boolean isReflective = registry.isReflectiveMethod(className, methodElement.getName(), methodElement.getDescriptor());
                    for (Annotation annotation : methodElement.getInvisibleAnnotations()) {
                        if (!annotation.getDescriptor().equals(ReflectiveElementTypeBuilder.this.reflectivelyAccessed)) continue;
                        isReflective = true;
                    }
                    if (isReflective) {
                        registry.registerReflectiveMethod(methodElement);
                    }
                    return methodElement;
                }
            }, index, name, descriptor);
        } else {
            this.delegate.addMethod(resolver, index, name, descriptor);
        }
    }

    public void addField(FieldResolver resolver, int index, String name, TypeDescriptor descriptor) {
        if (this.reflectiveFields) {
            final FieldResolver fr = resolver;
            super.addField(new FieldResolver(){

                public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
                    FieldElement fieldElement = fr.resolveField(index, enclosing, builder);
                    ReflectiveElementRegistry registry = ReflectiveElementRegistry.get(ReflectiveElementTypeBuilder.this.classContext.getCompilationContext());
                    String className = fieldElement.getEnclosingType().getInternalName();
                    boolean isReflective = registry.isReflectiveField(className, fieldElement.getName());
                    for (Annotation annotation : fieldElement.getInvisibleAnnotations()) {
                        if (!annotation.getDescriptor().equals(ReflectiveElementTypeBuilder.this.reflectivelyAccessed)) continue;
                        isReflective = true;
                    }
                    if (isReflective) {
                        registry.registerReflectiveField(fieldElement);
                    }
                    return fieldElement;
                }
            }, index, name, descriptor);
        } else {
            this.delegate.addField(resolver, index, name, descriptor);
        }
    }

    public DefinedTypeDefinition build() {
        DefinedTypeDefinition result = this.delegate.build();
        if (this.reflectiveClass) {
            ReflectiveElementRegistry registry = ReflectiveElementRegistry.get(this.classContext.getCompilationContext());
            this.classContext.getCompilationContext().submitTask((Object)result, dtd -> registry.registerReflectiveType(dtd.load()));
        }
        return result;
    }
}

