/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reflection;

import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Value;
import org.qbicc.plugin.reflection.Reflection;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class VarHandleResolvingBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();

    public VarHandleResolvingBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value lookupVirtualMethod(Value reference, TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        ClassTypeDescriptor ctd;
        if (owner instanceof ClassTypeDescriptor && (ctd = (ClassTypeDescriptor)owner).packageAndClassNameEquals("java/lang/invoke", "VarHandle")) {
            return super.lookupVirtualMethod(reference, owner, name, this.translate(name, descriptor));
        }
        return super.lookupVirtualMethod(reference, owner, name, descriptor);
    }

    public Value resolveInstanceMethod(TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        ClassTypeDescriptor ctd;
        if (owner instanceof ClassTypeDescriptor && (ctd = (ClassTypeDescriptor)owner).packageAndClassNameEquals("java/lang/invoke", "VarHandle")) {
            return super.resolveInstanceMethod(owner, name, this.translate(name, descriptor));
        }
        return super.resolveInstanceMethod(owner, name, descriptor);
    }

    private MethodDescriptor translate(String name, MethodDescriptor descriptor) {
        BaseTypeDescriptor fixedRetType;
        ClassContext classContext = this.ctxt.getBootstrapClassContext();
        TypeDescriptor retType = descriptor.getReturnType();
        MethodDescriptor erased = Reflection.erase(classContext, descriptor);
        List erasedParamTypes = erased.getParameterTypes();
        int paramCnt = erasedParamTypes.size();
        switch (name) {
            case "compareAndSet": 
            case "weakCompareAndSetPlain": 
            case "weakCompareAndSet": 
            case "weakCompareAndSetAcquire": 
            case "weakCompareAndSetRelease": {
                fixedRetType = BaseTypeDescriptor.Z;
                break;
            }
            case "set": 
            case "setVolatile": 
            case "setRelease": 
            case "setOpaque": {
                fixedRetType = retType;
                break;
            }
            case "get": 
            case "getVolatile": 
            case "getAcquire": 
            case "getOpaque": {
                fixedRetType = retType;
                break;
            }
            case "compareAndExchange": 
            case "compareAndExchangeAcquire": 
            case "compareAndExchangeRelease": 
            case "getAndSet": 
            case "getAndSetAcquire": 
            case "getAndSetRelease": 
            case "getAndAdd": 
            case "getAndAddAcquire": 
            case "getAndAddRelease": 
            case "getAndBitwiseOr": 
            case "getAndBitwiseOrAcquire": 
            case "getAndBitwiseOrRelease": 
            case "getAndBitwiseAnd": 
            case "getAndBitwiseAndAcquire": 
            case "getAndBitwiseAndRelease": 
            case "getAndBitwiseXor": 
            case "getAndBitwiseXorAcquire": 
            case "getAndBitwiseXorRelease": {
                fixedRetType = (TypeDescriptor)erasedParamTypes.get(paramCnt - 1);
                break;
            }
            default: {
                return descriptor;
            }
        }
        if (retType == BaseTypeDescriptor.V) {
            return MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)fixedRetType, (List)erasedParamTypes);
        }
        return MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)retType, (List)erasedParamTypes);
    }
}

