/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.serialization;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.OffsetOfField;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.literal.BooleanLiteral;
import org.qbicc.graph.literal.ElementOfLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.graph.literal.ZeroInitializerLiteral;
import org.qbicc.interpreter.Memory;
import org.qbicc.interpreter.VmArray;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmReferenceArray;
import org.qbicc.interpreter.VmReferenceArrayClass;
import org.qbicc.interpreter.memory.ByteArrayMemory;
import org.qbicc.machine.arch.Platform;
import org.qbicc.object.Data;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.Function;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.Linkage;
import org.qbicc.object.ModuleSection;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.ProgramObject;
import org.qbicc.object.Section;
import org.qbicc.object.Segment;
import org.qbicc.plugin.constants.Constants;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.layout.Layout;
import org.qbicc.plugin.layout.LayoutInfo;
import org.qbicc.plugin.threadlocal.ThreadLocals;
import org.qbicc.pointer.GlobalPointer;
import org.qbicc.pointer.IntegerAsPointer;
import org.qbicc.pointer.MemoryPointer;
import org.qbicc.pointer.Pointer;
import org.qbicc.pointer.ProgramObjectPointer;
import org.qbicc.pointer.StaticFieldPointer;
import org.qbicc.pointer.StaticMethodPointer;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FloatType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NullableType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.PrimitiveArrayObjectType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.TypeType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.GlobalVariableElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.definition.element.StaticMethodElement;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeSignature;

public class BuildtimeHeap {
    private static final AttachmentKey<BuildtimeHeap> KEY = new AttachmentKey();
    private static final Logger slog = Logger.getLogger((String)"org.qbicc.plugin.serialization.stats");
    private final CompilationContext ctxt;
    private final Layout layout;
    private final CoreClasses coreClasses;
    private final HashMap<String, CompoundType> arrayTypes = new HashMap();
    private final IdentityHashMap<VmObject, DataDeclaration> vmObjects = new IdentityHashMap();
    private final HashMap<GlobalVariableElement, DataDeclaration> nativeMemory = new HashMap();
    private final ModuleSection classSection;
    private final ModuleSection stringSection;
    private final ModuleSection objectSection;
    private final Section refSection;
    private DataDeclaration rootClassesDecl;
    private Literal[] rootClasses;
    private final Map<FieldElement, GlobalVariableElement> staticFields = new ConcurrentHashMap<FieldElement, GlobalVariableElement>();
    private int literalCounter = 0;

    private BuildtimeHeap(CompilationContext ctxt) {
        this.ctxt = ctxt;
        this.layout = Layout.get((CompilationContext)ctxt);
        this.coreClasses = CoreClasses.get((CompilationContext)ctxt);
        Platform p = ctxt.getPlatform();
        this.refSection = Section.defineSection((CompilationContext)ctxt, (int)0, (String)"refs", (Segment)Segment.DATA, (Section.Attribute[])new Section.Attribute[]{Section.Flag.DATA_ONLY});
        Section classSection = Section.defineSection((CompilationContext)ctxt, (int)3, (String)"classes", (Segment)Segment.DATA, (Section.Attribute[])new Section.Attribute[]{Section.Flag.DATA_ONLY});
        this.classSection = ctxt.getOrAddProgramModule((DefinedTypeDefinition)ctxt.getBootstrapClassContext().findDefinedType("org/qbicc/runtime/main/InitialHeap$ClassSection").load()).inSection(classSection);
        Section stringSection = Section.defineSection((CompilationContext)ctxt, (int)4, (String)"strings", (Segment)Segment.DATA, (Section.Attribute[])new Section.Attribute[]{Section.Flag.DATA_ONLY});
        this.stringSection = ctxt.getOrAddProgramModule((DefinedTypeDefinition)ctxt.getBootstrapClassContext().findDefinedType("org/qbicc/runtime/main/InitialHeap$InternedStringSection").load()).inSection(stringSection);
        Section objectSection = Section.defineSection((CompilationContext)ctxt, (int)4, (String)"objects", (Segment)Segment.DATA, (Section.Attribute[])new Section.Attribute[]{Section.Flag.DATA_ONLY});
        this.objectSection = ctxt.getOrAddProgramModule((DefinedTypeDefinition)ctxt.getBootstrapClassContext().findDefinedType("org/qbicc/runtime/main/InitialHeap$ObjectSection").load()).inSection(objectSection);
    }

    public static BuildtimeHeap get(CompilationContext ctxt) {
        BuildtimeHeap appearing;
        BuildtimeHeap heap = (BuildtimeHeap)ctxt.getAttachment(KEY);
        if (heap == null && (appearing = (BuildtimeHeap)ctxt.putAttachmentIfAbsent(KEY, (Object)(heap = new BuildtimeHeap(ctxt)))) != null) {
            heap = appearing;
        }
        return heap;
    }

    public static void reportStats(CompilationContext ctxt) {
        if (!slog.isDebugEnabled()) {
            return;
        }
        BuildtimeHeap heap = (BuildtimeHeap)ctxt.getAttachment(KEY);
        slog.debugf("The initial heap contains %,d objects.", heap.vmObjects.size());
        HashMap<LoadedTypeDefinition, Integer> instanceCounts = new HashMap<LoadedTypeDefinition, Integer>();
        for (VmObject obj : heap.vmObjects.keySet()) {
            LoadedTypeDefinition ltd = obj.getVmClass().getTypeDefinition();
            instanceCounts.put(ltd, instanceCounts.getOrDefault(ltd, 0) + 1);
        }
        slog.debugf("The types with more than 5 instances are: ", new Object[0]);
        instanceCounts.entrySet().stream().filter(x -> (Integer)x.getValue() > 5).sorted((x, y) -> ((Integer)y.getValue()).compareTo((Integer)x.getValue())).forEach(e -> slog.debugf("  %,6d instances of %s", e.getValue(), (Object)((LoadedTypeDefinition)e.getKey()).getDescriptor()));
    }

    void initializeRootClassArray(int numTypeIds) {
        LoadedTypeDefinition jlc = this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/Class").load();
        CompoundType jlcType = this.layout.getInstanceLayoutInfo((DefinedTypeDefinition)jlc).getCompoundType();
        ArrayType rootArrayType = this.ctxt.getTypeSystem().getArrayType((ValueType)jlcType, (long)numTypeIds);
        this.rootClassesDecl = this.classSection.getProgramModule().declareData(null, "qbicc_jlc_lookup_table", (ValueType)rootArrayType);
        this.rootClasses = new Literal[numTypeIds];
        this.rootClasses[0] = this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)jlc.getObjectType());
    }

    void emitRootClassArray() {
        Data d = this.classSection.addData(null, this.rootClassesDecl.getName(), (Value)this.ctxt.getLiteralFactory().literalOf((ArrayType)this.rootClassesDecl.getValueType(), List.of(this.rootClasses)));
        d.setLinkage(Linkage.EXTERNAL);
    }

    void emitRootClassDictionaries(ArrayList<VmClass> reachableClasses) {
        LoadedTypeDefinition ih = this.ctxt.getBootstrapClassContext().findDefinedType("org/qbicc/runtime/main/InitialHeap").load();
        ModuleSection section = this.ctxt.getImplicitSection((DefinedTypeDefinition)ih);
        LoadedTypeDefinition jls_td = this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/String").load();
        LoadedTypeDefinition jlc_td = this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/Class").load();
        LoadedTypeDefinition jlcl_td = this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/ClassLoader").load();
        VmClass jls = jls_td.getVmClass();
        VmClass jlc = jlc_td.getVmClass();
        VmClass jlcl = jlcl_td.getVmClass();
        VmClassLoader bootLoader = this.ctxt.getBootstrapClassContext().getClassLoader();
        HashMap<VmClassLoader, ArrayList> clMap = new HashMap<VmClassLoader, ArrayList>();
        for (VmClass c : reachableClasses) {
            VmClassLoader cl = c.getClassLoader();
            if (cl == null) {
                cl = bootLoader;
            }
            clMap.computeIfAbsent(cl, k -> new ArrayList()).add(c);
        }
        int numClassLoaders = clMap.size();
        VmClassLoader[] classLoaders = new VmClassLoader[numClassLoaders];
        VmReferenceArray[] names = new VmReferenceArray[numClassLoaders];
        VmReferenceArray[] classes = new VmReferenceArray[numClassLoaders];
        classLoaders[0] = bootLoader;
        int nextSlot = 1;
        for (VmClassLoader cl : clMap.keySet()) {
            if (cl == bootLoader) continue;
            classLoaders[nextSlot++] = cl;
        }
        int nameIdx = jlc.indexOf(jlc_td.findField("name"));
        for (int clIndex = 0; clIndex < numClassLoaders; ++clIndex) {
            ArrayList myDefines = (ArrayList)clMap.get(classLoaders[clIndex]);
            myDefines.sort(Comparator.comparing(x -> x.getTypeDefinition().getInternalName()));
            VmObject[] myNames = new VmObject[myDefines.size()];
            VmObject[] myClasses = new VmObject[myDefines.size()];
            for (int i = 0; i < myDefines.size(); ++i) {
                myClasses[i] = (VmObject)myDefines.get(i);
                myNames[i] = myClasses[i].getMemory().loadRef((long)nameIdx, (ReadAccessMode)AccessModes.SinglePlain);
            }
            classes[clIndex] = this.ctxt.getVm().newArrayOf(jlc, myClasses);
            names[clIndex] = this.ctxt.getVm().newArrayOf(jls, myNames);
        }
        VmReferenceArray loaders = this.ctxt.getVm().newArrayOf(jlcl, (VmObject[])classLoaders);
        VmReferenceArray nameSpine = this.ctxt.getVm().newArrayOf((VmClass)jls.getArrayClass(), (VmObject[])names);
        VmReferenceArray classSpine = this.ctxt.getVm().newArrayOf((VmClass)jlc.getArrayClass(), (VmObject[])classes);
        this.serializeVmObject((VmObject)loaders, false);
        this.serializeVmObject((VmObject)nameSpine, false);
        this.serializeVmObject((VmObject)classSpine, false);
        String fn = ih.getInternalName().replace('/', '.') + "." + ih.findField("classLoaders").getName();
        Data d = section.addData(null, fn, (Value)this.referToSerializedVmObject((VmObject)loaders, (NullableType)loaders.getObjectType().getReference(), section.getProgramModule()));
        d.setLinkage(Linkage.EXTERNAL);
        d.setDsoLocal();
        fn = ih.getInternalName().replace('/', '.') + "." + ih.findField("classNames").getName();
        d = section.addData(null, fn, (Value)this.referToSerializedVmObject((VmObject)nameSpine, (NullableType)nameSpine.getObjectType().getReference(), section.getProgramModule()));
        d.setLinkage(Linkage.EXTERNAL);
        d.setDsoLocal();
        fn = ih.getInternalName().replace('/', '.') + "." + ih.findField("classes").getName();
        d = section.addData(null, fn, (Value)this.referToSerializedVmObject((VmObject)classSpine, (NullableType)classSpine.getObjectType().getReference(), section.getProgramModule()));
        d.setLinkage(Linkage.EXTERNAL);
        d.setDsoLocal();
    }

    public ProgramObject getAndRegisterGlobalClassArray(ExecutableElement originalElement) {
        ProgramModule programModule = this.ctxt.getOrAddProgramModule(originalElement.getEnclosingType());
        DataDeclaration decl = programModule.declareData(this.rootClassesDecl);
        return decl;
    }

    public GlobalVariableElement getGlobalForStaticField(StaticFieldElement field) {
        Literal initialValue;
        GlobalVariableElement global = this.staticFields.get(field);
        if (global != null) {
            return global;
        }
        DefinedTypeDefinition typeDef = field.getEnclosingType();
        ClassContext classContext = typeDef.getContext();
        CompilationContext ctxt = classContext.getCompilationContext();
        StringBuilder b = new StringBuilder(64);
        b.append(typeDef.getInternalName().replace('/', '.'));
        b.append('.');
        b.append(field.getName());
        TypeDescriptor fieldDesc = field.getTypeDescriptor();
        String globalName = b.toString();
        GlobalVariableElement.Builder builder = GlobalVariableElement.builder((String)globalName, (TypeDescriptor)fieldDesc);
        ValueType globalType = this.widenBoolean(field.getType());
        builder.setType(globalType);
        builder.setSignature(TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)fieldDesc));
        builder.setModifiers(field.getModifiers());
        builder.setEnclosingType(typeDef);
        Section section = field.getType() instanceof ReferenceType ? this.refSection : ctxt.getImplicitSection();
        builder.setSection(section);
        builder.setMinimumAlignment(field.getMinimumAlignment());
        global = builder.build();
        GlobalVariableElement appearing = this.staticFields.putIfAbsent((FieldElement)field, global);
        if (appearing != null) {
            return appearing;
        }
        if (typeDef.internalPackageAndNameEquals("org/qbicc/runtime/main", "InitialHeap")) {
            return global;
        }
        LiteralFactory lf = ctxt.getLiteralFactory();
        ModuleSection moduleSection = ctxt.getOrAddProgramModule(typeDef).inSection(section);
        if (field.getRunTimeInitializer() != null) {
            initialValue = lf.zeroInitializerLiteralOfType(globalType);
        } else {
            initialValue = field.getReplacementValue(ctxt);
            if (initialValue == null) {
                initialValue = typeDef.load().getInitialValue((FieldElement)field);
            }
            if (initialValue == null && (initialValue = Constants.get((CompilationContext)ctxt).getConstantValue((FieldElement)field)) == null) {
                initialValue = lf.zeroInitializerLiteralOfType(globalType);
            }
        }
        if (initialValue instanceof OffsetOfField) {
            OffsetOfField oof = (OffsetOfField)initialValue;
            FieldElement offsetField = oof.getFieldElement();
            LayoutInfo instanceLayout = Layout.get((CompilationContext)ctxt).getInstanceLayoutInfo(offsetField.getEnclosingType());
            initialValue = offsetField.isStatic() ? lf.literalOf(0) : lf.literalOf(instanceLayout.getMember(offsetField).getOffset());
        }
        if (initialValue.getType() instanceof BooleanType && globalType instanceof IntegerType) {
            IntegerType it = (IntegerType)globalType;
            if (initialValue instanceof BooleanLiteral) {
                initialValue = lf.literalOf(it, ((BooleanLiteral)initialValue).booleanValue() ? 1L : 0L);
            } else if (initialValue instanceof ZeroInitializerLiteral) {
                initialValue = lf.literalOf(it, 0L);
            } else {
                throw new IllegalArgumentException("Cannot initialize boolean field");
            }
        }
        if (initialValue instanceof ObjectLiteral) {
            ObjectLiteral ol = (ObjectLiteral)initialValue;
            BuildtimeHeap bth = BuildtimeHeap.get(ctxt);
            bth.serializeVmObject(ol.getValue(), false);
            initialValue = bth.referToSerializedVmObject(ol.getValue(), (NullableType)ol.getType(), moduleSection.getProgramModule());
        }
        Data data = moduleSection.addData((MemberElement)field, globalName, (Value)initialValue);
        data.setLinkage(Linkage.EXTERNAL);
        data.setDsoLocal();
        return global;
    }

    private ValueType widenBoolean(ValueType type) {
        if (type instanceof BooleanType) {
            TypeSystem ts = type.getTypeSystem();
            return ts.getUnsignedInteger8Type();
        }
        if (type instanceof ArrayType) {
            ValueType widened;
            ArrayType arrayType = (ArrayType)type;
            TypeSystem ts = type.getTypeSystem();
            ValueType elementType = arrayType.getElementType();
            return elementType == (widened = this.widenBoolean(elementType)) ? type : ts.getArrayType(widened, arrayType.getElementCount());
        }
        return type;
    }

    public boolean containsObject(VmObject value) {
        return this.vmObjects.containsKey(value);
    }

    public synchronized Literal referToSerializedVmObject(VmObject value, NullableType desiredType, ProgramModule from) {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (this.isRootClass(value)) {
            DataDeclaration d = from.declareData(this.rootClassesDecl);
            int typeId = ((VmClass)value).getTypeDefinition().getTypeId();
            ElementOfLiteral elem = lf.elementOfLiteral((Literal)lf.literalOf((ProgramObject)d), (Literal)lf.literalOf(typeId));
            return lf.valueConvertLiteral((Literal)elem, (WordType)desiredType);
        }
        DataDeclaration objDecl = this.vmObjects.get(value);
        if (objDecl == null) {
            this.ctxt.warning("Requested VmObject not found in build time heap: " + value, new Object[0]);
            return lf.nullLiteralOfType(desiredType);
        }
        DataDeclaration decl = from.declareData(objDecl);
        return lf.valueConvertLiteral((Literal)lf.literalOf((ProgramObject)decl), (WordType)desiredType);
    }

    public synchronized void serializeVmObject(VmObject value, boolean toInternedStringSection) {
        if (toInternedStringSection) {
            this.serializeVmObject(value, this.stringSection);
        } else {
            this.serializeVmObject(value, this.objectSection);
        }
    }

    private void serializeVmObject(VmObject value, ModuleSection into) {
        int typeId;
        if (this.vmObjects.containsKey(value)) {
            return;
        }
        if (this.isRootClass(value) && this.rootClasses[typeId = ((VmClass)value).getTypeDefinition().getTypeId()] != null) {
            return;
        }
        Layout layout = Layout.get((CompilationContext)this.ctxt);
        PhysicalObjectType ot = value.getObjectType();
        if (ot instanceof ClassObjectType) {
            LoadedTypeDefinition concreteType = ot.getDefinition().load();
            LayoutInfo objLayout = layout.getInstanceLayoutInfo((DefinedTypeDefinition)concreteType);
            if (concreteType.getTypeId() == -1) {
                this.ctxt.warning("Serialized an instance of %s whose typeId is -1 (unreachable type)", new Object[]{concreteType.getDescriptor().toString()});
            }
            if (this.isRootClass(value)) {
                int typeId2 = ((VmClass)value).getTypeDefinition().getTypeId();
                this.rootClasses[typeId2] = this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)value.getObjectType());
                this.serializeVmObject(concreteType, objLayout, value, this.classSection, typeId2, null);
            } else {
                if (into == this.objectSection && this.ctxt.getVm().isInternedString(value)) {
                    into = this.stringSection;
                }
                String name = this.nextLiteralName(into);
                DataDeclaration decl = into.getProgramModule().declareData(null, name, (ValueType)objLayout.getCompoundType());
                this.vmObjects.put(value, decl);
                this.serializeVmObject(concreteType, objLayout, value, into, -1, decl.getName());
            }
        } else if (ot instanceof ReferenceArrayObjectType) {
            InstanceFieldElement contentsField = this.coreClasses.getRefArrayContentField();
            LayoutInfo info = layout.getInstanceLayoutInfo(contentsField.getEnclosingType());
            Memory memory = value.getMemory();
            int length = memory.load32((long)info.getMember((FieldElement)this.coreClasses.getArrayLengthField()).getOffset(), (ReadAccessMode)AccessModes.SinglePlain);
            CompoundType literalCT = this.arrayLiteralType((FieldElement)contentsField, length);
            DataDeclaration decl = into.getProgramModule().declareData(null, this.nextLiteralName(into), (ValueType)literalCT);
            this.vmObjects.put(value, decl);
            this.serializeRefArray((ReferenceArrayObjectType)ot, literalCT, length, into, decl, (VmArray)value);
        } else {
            this.vmObjects.put(value, this.serializePrimArray((PrimitiveArrayObjectType)ot, (VmArray)value, into));
        }
    }

    private boolean isRootClass(VmObject value) {
        VmClass vmClass;
        return value instanceof VmClass && !((vmClass = (VmClass)value) instanceof VmReferenceArrayClass) && vmClass.getTypeDefinition().getTypeId() != -1;
    }

    private String nextLiteralName(ModuleSection into) {
        if (into == this.objectSection) {
            return "qbicc_initial_heap_obj_" + this.literalCounter++;
        }
        return "qbicc_initial_heap_iss_" + this.literalCounter++;
    }

    private Data defineData(ModuleSection into, String name, Literal value) {
        Data d = into.addData(null, name, (Value)value);
        d.setLinkage(Linkage.EXTERNAL);
        return d;
    }

    private CompoundType arrayLiteralType(FieldElement contents, int length) {
        LoadedTypeDefinition ltd = contents.getEnclosingType().load();
        String typeName = ltd.getInternalName() + "_" + length;
        CompoundType sizedArrayType = this.arrayTypes.get(typeName);
        Layout layout = Layout.get((CompilationContext)this.ctxt);
        if (sizedArrayType == null) {
            TypeSystem ts = this.ctxt.getTypeSystem();
            LayoutInfo objLayout = layout.getInstanceLayoutInfo((DefinedTypeDefinition)ltd);
            CompoundType arrayCT = objLayout.getCompoundType();
            CompoundType.Member contentMem = objLayout.getMember(contents);
            ArrayType sizedContentMem = ts.getArrayType(((ArrayType)contents.getType()).getElementType(), (long)length);
            CompoundType.Member realContentMem = ts.getCompoundTypeMember(contentMem.getName(), (ValueType)sizedContentMem, contentMem.getOffset(), contentMem.getAlign());
            Supplier<List> thunk = () -> {
                CompoundType.Member[] items = (CompoundType.Member[])arrayCT.getMembers().toArray(CompoundType.Member[]::new);
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] != contentMem) continue;
                    items[i] = realContentMem;
                }
                return Arrays.asList(items);
            };
            sizedArrayType = ts.getCompoundType(CompoundType.Tag.STRUCT, typeName, arrayCT.getSize() + sizedContentMem.getSize(), arrayCT.getAlign(), thunk);
            this.arrayTypes.put(typeName, sizedArrayType);
        }
        return sizedArrayType;
    }

    private void serializeVmObject(LoadedTypeDefinition concreteType, LayoutInfo objLayout, VmObject value, ModuleSection into, int typeId, String name) {
        Memory memory = value.getMemory();
        LayoutInfo memLayout = this.layout.getInstanceLayoutInfo((DefinedTypeDefinition)concreteType);
        CompoundType objType = objLayout.getCompoundType();
        HashMap<CompoundType.Member, Literal> memberMap = new HashMap<CompoundType.Member, Literal>();
        this.populateMemberMap(concreteType, objType, objLayout, memLayout, memory, memberMap, into);
        if (typeId == -1) {
            this.defineData(into, name, this.ctxt.getLiteralFactory().literalOf(objType, memberMap));
        } else {
            this.rootClasses[typeId] = this.ctxt.getLiteralFactory().literalOf(objType, memberMap);
        }
    }

    private void populateMemberMap(LoadedTypeDefinition concreteType, CompoundType objType, LayoutInfo objLayout, LayoutInfo memLayout, Memory memory, HashMap<CompoundType.Member, Literal> memberMap, ModuleSection into) {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        for (CompoundType.Member m : objType.getMembers()) {
            memberMap.put(m, lf.zeroInitializerLiteralOfType(m.getType()));
        }
        this.populateClearedMemberMap(concreteType, objLayout, memLayout, memory, memberMap, into);
    }

    private void populateClearedMemberMap(LoadedTypeDefinition concreteType, LayoutInfo objLayout, LayoutInfo memLayout, Memory memory, HashMap<CompoundType.Member, Literal> memberMap, ModuleSection into) {
        if (concreteType.hasSuperClass()) {
            this.populateClearedMemberMap(concreteType.getSuperClass(), objLayout, memLayout, memory, memberMap, into);
        }
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        int fc = concreteType.getFieldCount();
        for (int i = 0; i < fc; ++i) {
            ValueType contents;
            ValueType type;
            ValueType asPointerVal;
            ValueType bl;
            FieldElement f = concreteType.getField(i);
            if (f.isStatic()) continue;
            CompoundType.Member im = memLayout.getMember(f);
            CompoundType.Member om = objLayout.getMember(f);
            if (im == null || om == null) {
                if (ThreadLocals.get((CompilationContext)this.ctxt).isThreadLocalField((InstanceFieldElement)f)) continue;
                this.ctxt.warning("Field " + f + " not serialized due to incomplete layout", new Object[0]);
                continue;
            }
            Literal replacement = f.getReplacementValue(this.ctxt);
            if (replacement != null) {
                if (replacement instanceof BooleanLiteral) {
                    bl = (BooleanLiteral)replacement;
                    replacement = lf.literalOf((IntegerType)om.getType(), bl.booleanValue() ? 1L : 0L);
                }
                memberMap.put(om, replacement);
                continue;
            }
            bl = im.getType();
            if (bl instanceof IntegerType) {
                FunctionDeclaration decl;
                IntegerType it = (IntegerType)bl;
                if (it.getSize() == 1L) {
                    memberMap.put(om, (Literal)lf.literalOf(it, (long)memory.load8((long)im.getOffset(), (ReadAccessMode)AccessModes.SinglePlain)));
                    continue;
                }
                if (it.getSize() == 2L) {
                    memberMap.put(om, (Literal)lf.literalOf(it, (long)memory.load16((long)im.getOffset(), (ReadAccessMode)AccessModes.SinglePlain)));
                    continue;
                }
                if (it.getSize() == 4L) {
                    memberMap.put(om, (Literal)lf.literalOf(it, (long)memory.load32((long)im.getOffset(), (ReadAccessMode)AccessModes.SinglePlain)));
                    continue;
                }
                asPointerVal = memory.loadPointer((long)im.getOffset(), (ReadAccessMode)AccessModes.SinglePlain);
                if (asPointerVal instanceof IntegerAsPointer) {
                    IntegerAsPointer iap = (IntegerAsPointer)asPointerVal;
                    memberMap.put(om, (Literal)lf.literalOf(it, iap.getValue()));
                    continue;
                }
                if (asPointerVal == null) {
                    memberMap.put(om, (Literal)lf.literalOf(it, 0L));
                    continue;
                }
                if (asPointerVal instanceof StaticMethodPointer) {
                    StaticMethodPointer smp = (StaticMethodPointer)asPointerVal;
                    StaticMethodElement method = smp.getStaticMethod();
                    this.ctxt.enqueue((ExecutableElement)method);
                    Function function = this.ctxt.getExactFunction((ExecutableElement)method);
                    decl = into.getProgramModule().declareFunction(function);
                    memberMap.put(om, lf.valueConvertLiteral(lf.literalOf((Pointer)ProgramObjectPointer.of((ProgramObject)decl)), (WordType)it));
                    continue;
                }
                if (asPointerVal instanceof StaticFieldPointer) {
                    StaticFieldPointer sfp = (StaticFieldPointer)asPointerVal;
                    StaticFieldElement sfe = sfp.getStaticField();
                    GlobalVariableElement global = this.getGlobalForStaticField(sfe);
                    decl = into.getProgramModule().declareData((MemberElement)sfe, global.getName(), global.getType());
                    memberMap.put(om, lf.valueConvertLiteral(lf.literalOf((Pointer)ProgramObjectPointer.of((ProgramObject)decl)), (WordType)it));
                    continue;
                }
                if (asPointerVal instanceof GlobalPointer) {
                    GlobalPointer gp = (GlobalPointer)asPointerVal;
                    Memory m = this.ctxt.getVm().getGlobal(gp.getGlobalVariable());
                    if (m instanceof ByteArrayMemory) {
                        ByteArrayMemory bam = (ByteArrayMemory)m;
                        DataDeclaration memDecl = this.serializeNativeMemory(gp.getGlobalVariable(), bam.getArray(), this.objectSection);
                        memberMap.put(om, lf.valueConvertLiteral((Literal)lf.literalOf((ProgramObject)memDecl), (WordType)it));
                        continue;
                    }
                    this.ctxt.error(f.getLocation(), "An object contains an unlowerable pointer: %s", new Object[]{gp});
                    continue;
                }
                memberMap.put(om, lf.bitcastLiteral(lf.literalOf((Pointer)asPointerVal), (WordType)it));
                continue;
            }
            asPointerVal = im.getType();
            if (asPointerVal instanceof FloatType) {
                FloatType ft = (FloatType)asPointerVal;
                if (ft.getSize() == 4L) {
                    memberMap.put(om, (Literal)lf.literalOf(ft, (double)memory.loadFloat((long)im.getOffset(), (ReadAccessMode)AccessModes.SinglePlain)));
                    continue;
                }
                memberMap.put(om, (Literal)lf.literalOf(ft, memory.loadDouble((long)im.getOffset(), (ReadAccessMode)AccessModes.SinglePlain)));
                continue;
            }
            if (im.getType() instanceof TypeType) {
                type = memory.loadType((long)im.getOffset(), (ReadAccessMode)AccessModes.SinglePlain);
                memberMap.put(om, (Literal)(type == null ? lf.zeroInitializerLiteralOfType(im.getType()) : lf.literalOfType(type)));
                continue;
            }
            if (im.getType() instanceof ArrayType) {
                if (im.getType().getSize() <= 0L) continue;
                throw new UnsupportedOperationException("Copying array data is not yet supported");
            }
            type = im.getType();
            if (type instanceof ReferenceType) {
                ReferenceType rt = (ReferenceType)type;
                contents = memory.loadRef((long)im.getOffset(), (ReadAccessMode)AccessModes.SinglePlain);
                if (contents == null) {
                    memberMap.put(om, lf.zeroInitializerLiteralOfType(om.getType()));
                    continue;
                }
                this.serializeVmObject((VmObject)contents, into == this.classSection ? this.objectSection : into);
                memberMap.put(om, this.referToSerializedVmObject((VmObject)contents, (NullableType)rt, into.getProgramModule()));
                continue;
            }
            contents = im.getType();
            if (contents instanceof PointerType) {
                FunctionDeclaration decl;
                PointerType pt = (PointerType)contents;
                Pointer pointer = memory.loadPointer((long)im.getOffset(), (ReadAccessMode)AccessModes.SinglePlain);
                if (pointer == null) {
                    memberMap.put(om, (Literal)lf.nullLiteralOfType((NullableType)pt));
                    continue;
                }
                if (pointer instanceof StaticMethodPointer) {
                    StaticMethodPointer smp = (StaticMethodPointer)pointer;
                    StaticMethodElement method = smp.getStaticMethod();
                    this.ctxt.enqueue((ExecutableElement)method);
                    Function function = this.ctxt.getExactFunction((ExecutableElement)method);
                    decl = into.getProgramModule().declareFunction(function);
                    memberMap.put(om, lf.bitcastLiteral(lf.literalOf((Pointer)ProgramObjectPointer.of((ProgramObject)decl)), (WordType)pt));
                    continue;
                }
                if (pointer instanceof StaticFieldPointer) {
                    StaticFieldPointer sfp = (StaticFieldPointer)pointer;
                    StaticFieldElement sfe = sfp.getStaticField();
                    GlobalVariableElement global = this.getGlobalForStaticField(sfe);
                    decl = into.getProgramModule().declareData((MemberElement)sfe, global.getName(), global.getType());
                    memberMap.put(om, lf.bitcastLiteral(lf.literalOf((Pointer)ProgramObjectPointer.of((ProgramObject)decl)), (WordType)sfp.getType()));
                    continue;
                }
                if (pointer instanceof MemoryPointer) {
                    MemoryPointer mp = (MemoryPointer)pointer;
                    this.ctxt.error(f.getLocation(), "An object contains a memory pointer: %s", new Object[]{mp});
                    continue;
                }
                memberMap.put(om, lf.literalOf(pointer));
                continue;
            }
            this.ctxt.warning("Serializing " + f + " as zero literal. Unsupported type", new Object[0]);
            memberMap.put(om, lf.zeroInitializerLiteralOfType(im.getType()));
        }
    }

    private void serializeRefArray(ReferenceArrayObjectType at, CompoundType literalCT, int length, ModuleSection into, DataDeclaration sl, VmArray value) {
        LoadedTypeDefinition jlo = this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/Object").load();
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        Layout layout = Layout.get((CompilationContext)this.ctxt);
        Memory memory = value.getMemory();
        InstanceFieldElement contentField = this.coreClasses.getRefArrayContentField();
        DefinedTypeDefinition concreteType = contentField.getEnclosingType();
        LayoutInfo objLayout = layout.getInstanceLayoutInfo(concreteType);
        LayoutInfo memLayout = this.layout.getInstanceLayoutInfo(concreteType);
        CompoundType objType = objLayout.getCompoundType();
        HashMap<CompoundType.Member, Literal> memberMap = new HashMap<CompoundType.Member, Literal>();
        this.populateMemberMap(concreteType.load(), objType, objLayout, memLayout, memory, memberMap, into);
        ArrayList<Literal> elements = new ArrayList<Literal>(length);
        VmObject[] elementArray = ((VmReferenceArray)value).getArray();
        for (int i = 0; i < length; ++i) {
            VmObject e = elementArray[i];
            if (e == null) {
                elements.add(lf.zeroInitializerLiteralOfType((ValueType)at.getElementType()));
                continue;
            }
            this.serializeVmObject(e, into);
            elements.add(this.referToSerializedVmObject(e, (NullableType)jlo.getClassType().getReference(), into.getProgramModule()));
        }
        ArrayType arrayType = this.ctxt.getTypeSystem().getArrayType((ValueType)jlo.getClassType().getReference(), (long)length);
        memberMap.put(literalCT.getMember(literalCT.getMemberCount() - 1), lf.literalOf(arrayType, elements));
        this.defineData(into, sl.getName(), this.ctxt.getLiteralFactory().literalOf(literalCT, memberMap));
    }

    private DataDeclaration serializePrimArray(PrimitiveArrayObjectType at, VmArray value, ModuleSection into) {
        Literal arrayContentsLiteral;
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        Layout layout = Layout.get((CompilationContext)this.ctxt);
        FieldElement contentsField = this.coreClasses.getArrayContentField((ObjectType)at);
        DefinedTypeDefinition concreteType = contentsField.getEnclosingType();
        LayoutInfo objLayout = layout.getInstanceLayoutInfo(concreteType);
        LayoutInfo memLayout = this.layout.getInstanceLayoutInfo(concreteType);
        CompoundType objType = objLayout.getCompoundType();
        Memory memory = value.getMemory();
        int length = memory.load32((long)objLayout.getMember((FieldElement)this.coreClasses.getArrayLengthField()).getOffset(), (ReadAccessMode)AccessModes.SinglePlain);
        CompoundType literalCT = this.arrayLiteralType(contentsField, length);
        if (contentsField.equals(this.coreClasses.getByteArrayContentField())) {
            byte[] contents = (byte[])value.getArray();
            arrayContentsLiteral = lf.literalOf(this.ctxt.getTypeSystem().getArrayType((ValueType)at.getElementType(), (long)length), contents);
        } else {
            ArrayList<Object> elements = new ArrayList<Object>(length);
            if (contentsField.equals(this.coreClasses.getBooleanArrayContentField())) {
                contents = (boolean[])value.getArray();
                for (int i = 0; i < length; ++i) {
                    elements.add(lf.literalOf(contents[i]));
                }
            } else if (contentsField.equals(this.coreClasses.getShortArrayContentField())) {
                contents = (short[])value.getArray();
                for (int i = 0; i < length; ++i) {
                    elements.add(lf.literalOf(contents[i]));
                }
            } else if (contentsField.equals(this.coreClasses.getCharArrayContentField())) {
                contents = (char[])value.getArray();
                for (int i = 0; i < length; ++i) {
                    elements.add(lf.literalOf(contents[i]));
                }
            } else if (contentsField.equals(this.coreClasses.getIntArrayContentField())) {
                contents = (int[])value.getArray();
                for (int i = 0; i < length; ++i) {
                    elements.add(lf.literalOf(contents[i]));
                }
            } else if (contentsField.equals(this.coreClasses.getLongArrayContentField())) {
                contents = (long[])value.getArray();
                for (int i = 0; i < length; ++i) {
                    elements.add(lf.literalOf((long)contents[i]));
                }
            } else if (contentsField.equals(this.coreClasses.getFloatArrayContentField())) {
                contents = (float[])value.getArray();
                for (int i = 0; i < length; ++i) {
                    elements.add(lf.literalOf((float)contents[i]));
                }
            } else {
                Assert.assertTrue((boolean)contentsField.equals(this.coreClasses.getDoubleArrayContentField()));
                contents = (double[])value.getArray();
                for (int i = 0; i < length; ++i) {
                    elements.add(lf.literalOf((double)contents[i]));
                }
            }
            arrayContentsLiteral = lf.literalOf(this.ctxt.getTypeSystem().getArrayType((ValueType)at.getElementType(), (long)length), elements);
        }
        HashMap<CompoundType.Member, Literal> memberMap = new HashMap<CompoundType.Member, Literal>();
        this.populateMemberMap(concreteType.load(), objType, objLayout, memLayout, memory, memberMap, into);
        memberMap.put(literalCT.getMember(literalCT.getMemberCount() - 1), arrayContentsLiteral);
        Data arrayData = this.defineData(into, this.nextLiteralName(into), this.ctxt.getLiteralFactory().literalOf(literalCT, memberMap));
        return arrayData.getDeclaration();
    }

    private DataDeclaration serializeNativeMemory(GlobalVariableElement globalVariable, byte[] bytes, ModuleSection into) {
        DataDeclaration existing = this.nativeMemory.get(globalVariable);
        if (existing != null) {
            return existing;
        }
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        Literal memoryLiteral = lf.literalOf(this.ctxt.getTypeSystem().getArrayType((ValueType)this.ctxt.getTypeSystem().getSignedInteger8Type(), (long)bytes.length), bytes);
        Data memoryData = this.defineData(into, globalVariable.getName(), memoryLiteral);
        DataDeclaration decl = memoryData.getDeclaration();
        this.nativeMemory.put(globalVariable, decl);
        return decl;
    }
}

