/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.serialization;

import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmObject;
import org.qbicc.plugin.serialization.BuildtimeHeap;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FunctionElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.MethodElement;

public final class MethodDataStringsSerializer
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();

    public MethodDataStringsSerializer(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    private void createMethodDataStrings() {
        ExecutableElement element = this.getCurrentElement();
        Vm vm = this.ctxt.getVm();
        BuildtimeHeap heap = BuildtimeHeap.get(this.ctxt);
        String methodName = "";
        if (element instanceof ConstructorElement) {
            methodName = "<init>";
        } else if (element instanceof InitializerElement) {
            methodName = "<clinit>";
        } else if (element instanceof MethodElement) {
            methodName = ((MethodElement)element).getName();
        } else if (element instanceof FunctionElement) {
            methodName = ((FunctionElement)element).getName();
        }
        String fileName = element.getSourceFileName();
        String className = element.getEnclosingType().getInternalName().replace('/', '.');
        String methodDesc = element.getDescriptor().toString();
        if (fileName != null) {
            heap.serializeVmObject((VmObject)vm.intern(fileName), true);
        }
        heap.serializeVmObject((VmObject)vm.intern(className), true);
        heap.serializeVmObject((VmObject)vm.intern(methodName), true);
        heap.serializeVmObject((VmObject)vm.intern(methodDesc), true);
    }

    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        this.createMethodDataStrings();
        return super.call(targetPtr, receiver, arguments);
    }

    public Value callNoSideEffects(Value targetPtr, Value receiver, List<Value> arguments) {
        this.createMethodDataStrings();
        return super.callNoSideEffects(targetPtr, receiver, arguments);
    }

    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        this.createMethodDataStrings();
        return super.callNoReturn(targetPtr, receiver, arguments);
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        this.createMethodDataStrings();
        return super.invoke(targetPtr, receiver, arguments, catchLabel, resumeLabel, targetArguments);
    }

    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        this.createMethodDataStrings();
        return super.invokeNoReturn(targetPtr, receiver, arguments, catchLabel, targetArguments);
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        this.createMethodDataStrings();
        return super.tailCall(targetPtr, receiver, arguments);
    }
}

