/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.serialization;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmReferenceArray;
import org.qbicc.interpreter.VmString;
import org.qbicc.object.Data;
import org.qbicc.object.Linkage;
import org.qbicc.object.ModuleSection;
import org.qbicc.plugin.serialization.BuildtimeHeap;
import org.qbicc.type.NullableType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.FieldElement;

public class StringInternTableEmitter
implements Consumer<CompilationContext> {
    @Override
    public void accept(CompilationContext ctxt) {
        BuildtimeHeap bth = BuildtimeHeap.get(ctxt);
        ArrayList<VmString> used = new ArrayList<VmString>();
        ctxt.getVm().forEachInternedString(vs -> {
            if (bth.containsObject((VmObject)vs)) {
                used.add((VmString)vs);
            }
        });
        used.sort(Comparator.comparing(VmString::getContent));
        VmClass jls = ctxt.getBootstrapClassContext().findDefinedType("java/lang/String").load().getVmClass();
        VmReferenceArray internedStrings = ctxt.getVm().newArrayOf(jls, used.toArray(new VmObject[used.size()]));
        bth.serializeVmObject((VmObject)internedStrings, true);
        LoadedTypeDefinition ih = ctxt.getBootstrapClassContext().findDefinedType("org/qbicc/runtime/main/InitialHeap").load();
        FieldElement field = ih.findField("internedStrings");
        ModuleSection section = ctxt.getImplicitSection((DefinedTypeDefinition)ih);
        Literal theTable = bth.referToSerializedVmObject((VmObject)internedStrings, (NullableType)internedStrings.getObjectType().getReference(), section.getProgramModule());
        String name = ih.getInternalName().replace('/', '.') + "." + field.getName();
        Data d = section.addData(null, name, (Value)theTable);
        d.setLinkage(Linkage.EXTERNAL);
        d.setDsoLocal();
    }
}

