/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.source;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.qbicc.context.ClassContext;
import org.qbicc.driver.ClassPathElement;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class SourceEmittingElementHandler
implements Consumer<ExecutableElement> {
    private final Path outputPath;
    private final Map<ClassContext, List<ClassPathElement>> sourcePaths;
    private final Map<ClassContext, Map<String, Set<String>>> visited = new ConcurrentHashMap<ClassContext, Map<String, Set<String>>>();

    public SourceEmittingElementHandler(Path outputPath, Map<ClassContext, List<ClassPathElement>> sourcePaths) {
        this.outputPath = outputPath;
        this.sourcePaths = sourcePaths;
    }

    @Override
    public void accept(ExecutableElement executableElement) {
        List<ClassPathElement> elements;
        String string;
        LoadedTypeDefinition loaded = executableElement.getEnclosingType().load();
        ClassContext classContext = loaded.getContext();
        Map visitedByPackage = this.visited.computeIfAbsent(classContext, SourceEmittingElementHandler::newConcurrentMap);
        TypeDescriptor typeDescriptor = loaded.getDescriptor();
        if (typeDescriptor instanceof ClassTypeDescriptor) {
            ClassTypeDescriptor ctd = (ClassTypeDescriptor)typeDescriptor;
            string = ctd.getPackageName();
        } else {
            string = "";
        }
        String packageName = string;
        Set visitedBySourceFileName = visitedByPackage.computeIfAbsent(packageName, SourceEmittingElementHandler::newConcurrentSet);
        String sourceFileName = executableElement.getSourceFileName();
        if (sourceFileName != null && visitedBySourceFileName.add(sourceFileName) && (elements = this.sourcePaths.get(classContext)) != null) {
            String fullName = packageName.isEmpty() ? sourceFileName : packageName + "/" + sourceFileName;
            for (ClassPathElement element : elements) {
                try {
                    ClassPathElement.Resource resource = element.getResource(fullName);
                    if (resource == null) continue;
                    Path writePath = this.outputPath.resolve(packageName);
                    Files.createDirectories(writePath, new FileAttribute[0]);
                    try (InputStream stream = resource.openStream();){
                        Files.copy(stream, writePath.resolve(sourceFileName), new CopyOption[0]);
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static <K, V> Map<K, V> newConcurrentMap(Object ignored) {
        return new ConcurrentHashMap();
    }

    private static <E> Set<E> newConcurrentSet(Object ignored) {
        return ConcurrentHashMap.newKeySet();
    }
}

