/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.threadlocal;

import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.StaticFieldElement;

public final class ThreadLocals {
    private static final AttachmentKey<ThreadLocals> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final ConcurrentHashMap<StaticFieldElement, InstanceFieldElement> threadLocalFields = new ConcurrentHashMap();

    private ThreadLocals(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static ThreadLocals get(CompilationContext ctxt) {
        ThreadLocals appearing;
        ThreadLocals nativeInfo = (ThreadLocals)ctxt.getAttachment(KEY);
        if (nativeInfo == null && (appearing = (ThreadLocals)ctxt.putAttachmentIfAbsent(KEY, (Object)(nativeInfo = new ThreadLocals(ctxt)))) != null) {
            nativeInfo = appearing;
        }
        return nativeInfo;
    }

    public InstanceFieldElement getThreadLocalField(StaticFieldElement staticField) {
        return this.threadLocalFields.get(staticField);
    }

    void registerThreadLocalField(StaticFieldElement staticField, InstanceFieldElement injectedField) {
        this.threadLocalFields.put(staticField, injectedField);
    }

    public boolean isThreadLocalField(InstanceFieldElement instanceField) {
        return this.threadLocalFields.contains(instanceField);
    }
}

