/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.trycatch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qbicc.context.ClassContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.type.definition.element.InstanceFieldElement;

final class ExceptionOnThreadBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final InstanceFieldElement exceptionField;
    private final Map<BlockLabel, BlockLabel> landingPads = new HashMap<BlockLabel, BlockLabel>();

    ExceptionOnThreadBasicBlockBuilder(BasicBlockBuilder delegate) {
        super(delegate);
        ClassContext bcc = delegate.getContext().getBootstrapClassContext();
        this.exceptionField = bcc.findDefinedType("java/lang/Thread").load().findInstanceField("thrown", true);
    }

    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        return super.invokeNoReturn(targetPtr, receiver, arguments, this.getLandingPad(catchLabel), targetArguments);
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        return super.invoke(targetPtr, receiver, arguments, this.getLandingPad(catchLabel), resumeLabel, targetArguments);
    }

    private BlockLabel getLandingPad(BlockLabel catchLabel) {
        return this.landingPads.computeIfAbsent(catchLabel, ExceptionOnThreadBasicBlockBuilder::newLabel);
    }

    private static BlockLabel newLabel(Object ignored) {
        return new BlockLabel();
    }

    public BasicBlock throw_(Value value) {
        this.store(this.instanceFieldOf(this.decodeReference(this.load(this.currentThread(), (ReadAccessMode)AccessModes.SingleUnshared)), this.exceptionField), value, (WriteAccessMode)AccessModes.SingleUnshared);
        return super.throw_(value);
    }

    public void finish() {
        LiteralFactory lf = this.getLiteralFactory();
        for (Map.Entry<BlockLabel, BlockLabel> entry : this.landingPads.entrySet()) {
            BlockLabel delegateCatch = entry.getKey();
            BlockLabel landingPad = entry.getValue();
            this.begin(landingPad);
            Value ex = this.readModifyWrite(this.instanceFieldOf(this.decodeReference(this.load(this.currentThread(), (ReadAccessMode)AccessModes.SingleUnshared)), this.exceptionField), ReadModifyWrite.Op.SET, (Value)lf.zeroInitializerLiteralOfType(this.exceptionField.getType()), (ReadAccessMode)AccessModes.SingleUnshared, (WriteAccessMode)AccessModes.SingleUnshared);
            this.goto_(delegateCatch, Slot.thrown(), ex);
        }
        super.finish();
    }
}

