/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.trycatch;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;

public class SynchronizedMethodBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private static final Slot THROWN = Slot.thrown();
    private Value monitor;
    private final ReferenceType throwable = this.getContext().getBootstrapClassContext().findDefinedType("java/lang/Throwable").load().getClassType().getReference();
    private boolean started;

    private SynchronizedMethodBasicBlockBuilder(BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Node begin(BlockLabel blockLabel) {
        Node node = super.begin(blockLabel);
        if (!this.started) {
            this.started = true;
            ExecutableElement element = this.getCurrentElement();
            DefinedTypeDefinition enclosing = element.getEnclosingType();
            this.monitor = element.isStatic() ? this.classOf(enclosing.load().getObjectType()) : this.addParam(blockLabel, Slot.this_(), (ValueType)enclosing.load().getObjectType().getReference(), false);
            this.monitorEnter(this.monitor);
        }
        return node;
    }

    public <T> BasicBlock begin(BlockLabel blockLabel, T arg, BiConsumer<T, BasicBlockBuilder> maker) {
        if (!this.started) {
            ExecutableElement element = this.getCurrentElement();
            DefinedTypeDefinition enclosing = element.getEnclosingType();
            this.monitor = element.isStatic() ? this.classOf(enclosing.load().getObjectType()) : this.addParam(blockLabel, Slot.this_(), (ValueType)enclosing.load().getObjectType().getReference(), false);
            return super.begin(blockLabel, bbb -> {
                this.started = true;
                this.monitorEnter(this.monitor);
                maker.accept(arg, (BasicBlockBuilder)bbb);
            });
        }
        return super.begin(blockLabel, arg, maker);
    }

    public BasicBlock return_(Value value) {
        this.monitorExit(this.monitor);
        return super.return_(value);
    }

    public BasicBlock throw_(Value value) {
        this.monitorExit(this.monitor);
        return super.throw_(value);
    }

    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        BlockLabel resumeLabel = new BlockLabel();
        BlockLabel handlerLabel = new BlockLabel();
        Value rv = this.invoke(targetPtr, receiver, arguments, BlockLabel.of((BasicBlock)this.begin(handlerLabel, ignored -> this.throw_((Value)this.addParam(handlerLabel, THROWN, (ValueType)this.throwable, false)))), resumeLabel, Map.of());
        this.begin(resumeLabel);
        return this.addParam(resumeLabel, Slot.result(), rv.getType());
    }

    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        BlockLabel handlerLabel = new BlockLabel();
        return this.invokeNoReturn(targetPtr, receiver, arguments, BlockLabel.of((BasicBlock)this.begin(handlerLabel, ignored -> this.throw_((Value)this.addParam(handlerLabel, THROWN, (ValueType)this.throwable, false)))), Map.of());
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        BasicBlockBuilder fb = this.getFirstBuilder();
        return fb.return_(fb.call(targetPtr, receiver, arguments));
    }

    public static BasicBlockBuilder createIfNeeded(BasicBlockBuilder.FactoryContext fc, BasicBlockBuilder delegate) {
        if (delegate.getCurrentElement().hasAllModifiersOf(32)) {
            return new SynchronizedMethodBasicBlockBuilder(delegate);
        }
        return delegate;
    }
}

