/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.unwind;

import java.util.List;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.patcher.Patcher;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeSignature;

public class UnwindExceptionStrategy {
    private static final AttachmentKey<UnwindExceptionStrategy> KEY = new AttachmentKey();
    private final InstanceFieldElement unwindExceptionField;
    private final MethodElement raiseExceptionMethod;
    private final MethodElement personalityMethod;

    private UnwindExceptionStrategy(CompilationContext ctxt) {
        ClassContext classContext = ctxt.getBootstrapClassContext();
        ClassTypeDescriptor desc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/unwind/Unwind$struct__Unwind_Exception");
        DefinedTypeDefinition threadDef = classContext.findDefinedType("java/lang/Thread");
        this.unwindExceptionField = (InstanceFieldElement)threadDef.load().resolveField((TypeDescriptor)desc, "unwindException", true);
        String unwindClass = "org/qbicc/runtime/unwind/Unwind";
        DefinedTypeDefinition unwindDefined = classContext.findDefinedType(unwindClass);
        if (unwindDefined != null) {
            LoadedTypeDefinition unwindValidated = unwindDefined.load();
            int index = unwindValidated.findMethodIndex(e -> e.getName().equals("_Unwind_RaiseException"));
            this.raiseExceptionMethod = unwindValidated.getMethod(index);
            index = unwindValidated.findMethodIndex(e -> e.getName().equals("personality"));
            this.personalityMethod = unwindValidated.getMethod(index);
        } else {
            this.raiseExceptionMethod = null;
            this.personalityMethod = null;
            ctxt.error("Required class \"%s\" is not found on boot classpath", new Object[]{unwindClass});
        }
    }

    public static UnwindExceptionStrategy get(CompilationContext ctxt) {
        UnwindExceptionStrategy appearing;
        UnwindExceptionStrategy helper = (UnwindExceptionStrategy)ctxt.getAttachment(KEY);
        if (helper == null && (appearing = (UnwindExceptionStrategy)ctxt.putAttachmentIfAbsent(KEY, (Object)(helper = new UnwindExceptionStrategy(ctxt)))) != null) {
            helper = appearing;
        }
        return helper;
    }

    public static void init(CompilationContext ctxt) {
        final ClassContext classContext = ctxt.getBootstrapClassContext();
        final ClassTypeDescriptor desc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/unwind/Unwind$struct__Unwind_Exception");
        final ClassTypeDescriptor serAsZero = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"org/qbicc/runtime/SerializeAsZero");
        Patcher.get((CompilationContext)ctxt).addField(classContext, "java/lang/Thread", "unwindException", (TypeDescriptor)desc, new FieldResolver(){

            public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
                builder.setSignature(TypeSignature.synthesize((ClassContext)classContext, (TypeDescriptor)desc));
                builder.setModifiers(25165826);
                builder.addInvisibleAnnotations(List.of(Annotation.synthesize((ClassTypeDescriptor)serAsZero)));
                DefinedTypeDefinition jltDefined = classContext.findDefinedType("java/lang/Thread");
                builder.setEnclosingType(jltDefined);
                return builder.build();
            }
        }, 0, 0);
    }

    public InstanceFieldElement getUnwindExceptionField() {
        return this.unwindExceptionField;
    }

    public MethodElement getRaiseExceptionMethod() {
        return this.raiseExceptionMethod;
    }

    public MethodElement getPersonalityMethod() {
        return this.personalityMethod;
    }
}

