/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.verification;

import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.graph.literal.ExecutableLiteral;
import org.qbicc.graph.literal.StaticFieldLiteral;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.InstanceFieldElement;

public class ClassInitializingBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();

    public ClassInitializingBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value instanceFieldOf(Value instance, InstanceFieldElement field) {
        this.initialize(field.getEnclosingType());
        return super.instanceFieldOf(instance, field);
    }

    public Value load(Value pointer, ReadAccessMode accessMode) {
        if (pointer instanceof StaticFieldLiteral) {
            StaticFieldLiteral sfl = (StaticFieldLiteral)pointer;
            this.initializeStaticMember(sfl.getVariableElement().getEnclosingType());
        }
        return super.load(pointer, accessMode);
    }

    public Node store(Value pointer, Value value, WriteAccessMode accessMode) {
        if (pointer instanceof StaticFieldLiteral) {
            StaticFieldLiteral sfl = (StaticFieldLiteral)pointer;
            this.initializeStaticMember(sfl.getVariableElement().getEnclosingType());
        }
        return super.store(pointer, value, accessMode);
    }

    public Value readModifyWrite(Value pointer, ReadModifyWrite.Op op, Value update, ReadAccessMode readMode, WriteAccessMode writeMode) {
        if (pointer instanceof StaticFieldLiteral) {
            StaticFieldLiteral sfl = (StaticFieldLiteral)pointer;
            this.initializeStaticMember(sfl.getVariableElement().getEnclosingType());
        }
        return super.readModifyWrite(pointer, op, update, readMode, writeMode);
    }

    public Value cmpAndSwap(Value pointer, Value expect, Value update, ReadAccessMode readMode, WriteAccessMode writeMode, CmpAndSwap.Strength strength) {
        if (pointer instanceof StaticFieldLiteral) {
            StaticFieldLiteral sfl = (StaticFieldLiteral)pointer;
            this.initializeStaticMember(sfl.getVariableElement().getEnclosingType());
        }
        return super.cmpAndSwap(pointer, expect, update, readMode, writeMode, strength);
    }

    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.call(this.initialize(targetPtr), receiver, arguments);
    }

    public Value callNoSideEffects(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.callNoSideEffects(this.initialize(targetPtr), receiver, arguments);
    }

    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.callNoReturn(this.initialize(targetPtr), receiver, arguments);
    }

    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        return super.invokeNoReturn(this.initialize(targetPtr), receiver, arguments, catchLabel, targetArguments);
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        return super.tailCall(this.initialize(targetPtr), receiver, arguments);
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        return super.invoke(this.initialize(targetPtr), receiver, arguments, catchLabel, resumeLabel, targetArguments);
    }

    public Value new_(ClassObjectType type, Value typeId, Value size, Value align) {
        this.initialize(type.getDefinition());
        return super.new_(type, typeId, size, align);
    }

    private Value initialize(Value targetPtr) {
        if (targetPtr instanceof ExecutableLiteral) {
            ExecutableLiteral el = (ExecutableLiteral)targetPtr;
            this.initialize(el.getExecutable().getEnclosingType());
        }
        return targetPtr;
    }

    private void initializeStaticMember(DefinedTypeDefinition definition) {
        if (definition.isInterface()) {
            this.initializeSingle(definition.load());
        } else {
            this.initialize(definition);
        }
    }

    private void initialize(DefinedTypeDefinition definition) {
        LoadedTypeDefinition superClass;
        LoadedTypeDefinition ltd = definition.load();
        if (ltd.hasSuperClass() && (superClass = ltd.getSuperClass()) != null) {
            this.initialize((DefinedTypeDefinition)superClass);
        }
        this.maybeInitializeInterfaces(ltd);
        this.initializeSingle(ltd);
    }

    private void initializeSingle(LoadedTypeDefinition ltd) {
        InitializerElement initializer = ltd.getInitializer();
        if (initializer != null) {
            this.ctxt.enqueue((ExecutableElement)initializer);
            initializer.tryCreateMethodBody();
        }
    }

    private void maybeInitializeInterfaces(LoadedTypeDefinition ltd) {
        int cnt = ltd.getInterfaceCount();
        for (int i = 0; i < cnt; ++i) {
            LoadedTypeDefinition interfaceLtd = ltd.getInterface(i);
            if (interfaceLtd.declaresDefaultMethods()) {
                this.initialize((DefinedTypeDefinition)interfaceLtd);
                continue;
            }
            this.maybeInitializeInterfaces(interfaceLtd);
        }
    }
}

