/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.verification;

import java.util.List;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.StringLiteral;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.VerifyFailedException;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public class ClassLoadingBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private static final AttachmentKey<Info> KEY = new AttachmentKey();
    private final CompilationContext ctxt = this.getContext();

    public ClassLoadingBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value instanceFieldOf(Value instancePointer, TypeDescriptor owner, String name, TypeDescriptor type) {
        if (this.loadClass(owner)) {
            return super.instanceFieldOf(instancePointer, owner, name, type);
        }
        throw new BlockEarlyTermination(this.noClassDefFound(owner));
    }

    public Value resolveStaticField(TypeDescriptor owner, String name, TypeDescriptor type) {
        if (this.loadClass(owner)) {
            return super.resolveStaticField(owner, name, type);
        }
        throw new BlockEarlyTermination(this.noClassDefFound(owner));
    }

    public Value resolveInstanceMethod(TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        if (this.loadClass(owner)) {
            return super.resolveInstanceMethod(owner, name, descriptor);
        }
        throw new BlockEarlyTermination(this.noClassDefFound(owner));
    }

    public Value lookupVirtualMethod(Value reference, TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        if (this.loadClass(owner)) {
            return super.lookupVirtualMethod(reference, owner, name, descriptor);
        }
        throw new BlockEarlyTermination(this.noClassDefFound(owner));
    }

    public Value lookupInterfaceMethod(Value reference, TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        if (this.loadClass(owner)) {
            return super.lookupInterfaceMethod(reference, owner, name, descriptor);
        }
        throw new BlockEarlyTermination(this.noClassDefFound(owner));
    }

    public Value resolveStaticMethod(TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        if (this.loadClass(owner)) {
            return super.resolveStaticMethod(owner, name, descriptor);
        }
        throw new BlockEarlyTermination(this.noClassDefFound(owner));
    }

    public Value resolveConstructor(TypeDescriptor owner, MethodDescriptor descriptor) {
        if (this.loadClass(owner)) {
            return super.resolveConstructor(owner, descriptor);
        }
        throw new BlockEarlyTermination(this.noClassDefFound(owner));
    }

    public Value checkcast(Value value, TypeDescriptor desc) {
        TypeDescriptor orig = desc;
        while (desc instanceof ArrayTypeDescriptor) {
            desc = ((ArrayTypeDescriptor)desc).getElementTypeDescriptor();
        }
        if (desc instanceof ClassTypeDescriptor && !this.loadClass((ClassTypeDescriptor)desc)) {
            throw new BlockEarlyTermination(this.noClassDefFound(desc));
        }
        return super.checkcast(value, orig);
    }

    public Value instanceOf(Value input, TypeDescriptor desc) {
        TypeDescriptor baseDescriptor = desc;
        while (baseDescriptor instanceof ArrayTypeDescriptor) {
            baseDescriptor = ((ArrayTypeDescriptor)baseDescriptor).getElementTypeDescriptor();
        }
        if (baseDescriptor instanceof ClassTypeDescriptor && !this.loadClass((ClassTypeDescriptor)baseDescriptor)) {
            throw new BlockEarlyTermination(this.noClassDefFound(desc));
        }
        return super.instanceOf(input, desc);
    }

    public Value new_(ClassTypeDescriptor desc) {
        if (this.loadClass(desc)) {
            return super.new_(desc);
        }
        throw new BlockEarlyTermination(this.noClassDefFound((TypeDescriptor)desc));
    }

    public Value newArray(ArrayTypeDescriptor desc, Value size) {
        TypeDescriptor elemDesc = desc.getElementTypeDescriptor();
        while (elemDesc instanceof ArrayTypeDescriptor) {
            elemDesc = ((ArrayTypeDescriptor)elemDesc).getElementTypeDescriptor();
        }
        if (!(elemDesc instanceof ClassTypeDescriptor) || this.loadClass((ClassTypeDescriptor)elemDesc)) {
            return super.newArray(desc, size);
        }
        throw new BlockEarlyTermination(this.noClassDefFound(elemDesc));
    }

    public Value multiNewArray(ArrayTypeDescriptor desc, List<Value> dimensions) {
        TypeDescriptor elemDesc = desc.getElementTypeDescriptor();
        while (elemDesc instanceof ArrayTypeDescriptor) {
            elemDesc = ((ArrayTypeDescriptor)elemDesc).getElementTypeDescriptor();
        }
        if (!(elemDesc instanceof ClassTypeDescriptor) || this.loadClass((ClassTypeDescriptor)elemDesc)) {
            return super.multiNewArray(desc, dimensions);
        }
        throw new BlockEarlyTermination(this.noClassDefFound(elemDesc));
    }

    private BasicBlock noClassDefFound(TypeDescriptor desc) {
        ClassTypeDescriptor ctd;
        Info info = Info.get(this.ctxt);
        ClassTypeDescriptor ncdfeClass = info.ncdfeClass;
        Value ncdfe = this.new_(ncdfeClass);
        Object fullName = desc instanceof ClassTypeDescriptor ? ((ctd = (ClassTypeDescriptor)desc).getPackageName().isEmpty() ? ctd.getClassName() : ctd.getPackageName() + "/" + ctd.getClassName()) : desc.toString();
        StringLiteral msg = this.ctxt.getLiteralFactory().literalOf((String)fullName, this.getClassContext().findDefinedType("java/lang/String").load().getObjectType().getReference());
        this.call(this.resolveConstructor((TypeDescriptor)ncdfeClass, info.voidStringDesc), ncdfe, List.of(msg));
        return this.throw_(ncdfe);
    }

    private BasicBlock verifyError(TypeDescriptor desc) {
        ClassTypeDescriptor ctd;
        Info info = Info.get(this.ctxt);
        ClassTypeDescriptor veClass = info.veClass;
        Value ve = this.new_(veClass);
        Object fullName = desc instanceof ClassTypeDescriptor ? ((ctd = (ClassTypeDescriptor)desc).getPackageName().isEmpty() ? ctd.getClassName() : ctd.getPackageName() + "/" + ctd.getClassName()) : desc.toString();
        StringLiteral msg = this.ctxt.getLiteralFactory().literalOf((String)fullName, this.getClassContext().findDefinedType("java/lang/String").load().getObjectType().getReference());
        this.call(this.resolveConstructor((TypeDescriptor)veClass, info.voidStringDesc), ve, List.of(msg));
        return this.throw_(ve);
    }

    private boolean loadClass(TypeDescriptor desc) {
        return !(desc instanceof ClassTypeDescriptor) || this.loadClass((ClassTypeDescriptor)desc);
    }

    private boolean loadClass(ClassTypeDescriptor desc) {
        if (desc == this.getCurrentElement().getEnclosingType().getDescriptor()) {
            return true;
        }
        Object typeName = desc.getPackageName().isEmpty() ? desc.getClassName() : desc.getPackageName() + "/" + desc.getClassName();
        DefinedTypeDefinition definedType = this.getClassContext().findDefinedType((String)typeName);
        if (definedType == null) {
            return false;
        }
        try {
            definedType.load();
        }
        catch (VerifyFailedException e) {
            throw new BlockEarlyTermination(this.verifyError((TypeDescriptor)desc));
        }
        return true;
    }

    private ClassContext getClassContext() {
        return this.getCurrentElement().getEnclosingType().getContext();
    }

    static final class Info {
        final ClassTypeDescriptor ncdfeClass;
        final ClassTypeDescriptor veClass;
        final MethodDescriptor voidStringDesc;

        private Info(CompilationContext ctxt) {
            DefinedTypeDefinition type = ctxt.getBootstrapClassContext().findDefinedType("java/lang/NoClassDefFoundError");
            this.ncdfeClass = (ClassTypeDescriptor)type.getDescriptor();
            type = ctxt.getBootstrapClassContext().findDefinedType("java/lang/VerifyError");
            this.veClass = (ClassTypeDescriptor)type.getDescriptor();
            type = ctxt.getBootstrapClassContext().findDefinedType("java/lang/String");
            this.voidStringDesc = MethodDescriptor.synthesize((ClassContext)ctxt.getBootstrapClassContext(), (TypeDescriptor)BaseTypeDescriptor.V, List.of(type.getDescriptor()));
        }

        static Info get(CompilationContext ctxt) {
            return (Info)ctxt.computeAttachmentIfAbsent(KEY, () -> new Info(ctxt));
        }
    }
}

