/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.verification;

import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.PrimitiveArrayObjectType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.InitializerElement;

public class LowerVerificationBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();

    public LowerVerificationBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public BasicBlock throw_(Value value) {
        this.invalidNode("throw");
        return this.return_();
    }

    public BasicBlock ret(Value address, Map<Slot, Value> targetArguments) {
        this.invalidNode("ret");
        return this.return_();
    }

    public Node monitorEnter(Value obj) {
        this.invalidNode("monitorEnter");
        return this.nop();
    }

    public Node monitorExit(Value obj) {
        this.invalidNode("monitorExit");
        return this.nop();
    }

    public Node initCheck(InitializerElement initializer, Value initThunk) {
        this.invalidNode("runtimeInitCheck");
        return this.nop();
    }

    public Value new_(ClassObjectType type, Value typeId, Value size, Value align) {
        this.invalidNode("new");
        return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)type.getReference());
    }

    public Value newArray(PrimitiveArrayObjectType arrayType, Value size) {
        this.invalidNode("newArray");
        return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)arrayType.getReference());
    }

    public Value newReferenceArray(ReferenceArrayObjectType arrayType, Value elemTypeId, Value dimensions, Value size) {
        this.invalidNode("newReferenceArray");
        return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)arrayType.getReference());
    }

    public Value multiNewArray(ArrayObjectType arrayType, List<Value> dimensions) {
        this.invalidNode("multiNewArray");
        return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)arrayType.getReference());
    }

    private void invalidNode(String name) {
        this.ctxt.warning(this.getLocation(), "Invalid node encountered (cannot directly lower %s)", new Object[]{name});
    }
}

