/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.verification;

import io.smallrye.common.constraint.Assert;
import java.util.List;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.CheckCast;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Dereference;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.ConstantLiteral;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.StringLiteral;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.graph.literal.UndefinedLiteral;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.layout.Layout;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ArrayType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.PrimitiveArrayObjectType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;

public class MemberResolvingBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private static final AttachmentKey<Info> KEY = new AttachmentKey();
    private final CompilationContext ctxt = this.getContext();

    public MemberResolvingBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value instanceFieldOf(Value instance, TypeDescriptor owner, String name, TypeDescriptor type) {
        return this.instanceFieldOf(instance, this.resolveInstanceField(owner, name, type));
    }

    public Value resolveStaticField(TypeDescriptor owner, String name, TypeDescriptor type) {
        FieldElement field = this.resolveField(owner, name, type);
        if (field instanceof StaticFieldElement) {
            StaticFieldElement sfe = (StaticFieldElement)field;
            return this.getLiteralFactory().literalOf(sfe);
        }
        return super.resolveStaticField(owner, name, type);
    }

    public Value resolveInstanceMethod(TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        DefinedTypeDefinition definedType = this.resolveDescriptor(owner);
        if (definedType != null) {
            MethodElement element = definedType.isInterface() ? definedType.load().resolveMethodElementInterface(name, descriptor) : definedType.load().resolveMethodElementVirtual(this.getClassContext(), name, descriptor);
            if (element == null) {
                throw new BlockEarlyTermination(this.nsme(name));
            }
            return this.getLiteralFactory().literalOf(element);
        }
        this.ctxt.error(this.getLocation(), "Resolve method on a non-class type `%s` (did you forget a plugin?)", new Object[]{owner});
        throw new BlockEarlyTermination(this.nsme(name));
    }

    public Value lookupVirtualMethod(Value reference, TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        DefinedTypeDefinition definedType = this.resolveDescriptor(owner);
        if (definedType != null) {
            MethodElement element = definedType.load().resolveMethodElementVirtual(this.getClassContext(), name, descriptor);
            if (element == null) {
                throw new BlockEarlyTermination(this.nsme(name));
            }
            return this.getFirstBuilder().lookupVirtualMethod(reference, (InstanceMethodElement)element);
        }
        this.ctxt.error(this.getLocation(), "Resolve method on a non-class type `%s` (did you forget a plugin?)", new Object[]{owner});
        throw new BlockEarlyTermination(this.nsme(name));
    }

    public Value lookupInterfaceMethod(Value reference, TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        DefinedTypeDefinition definedType = this.resolveDescriptor(owner);
        if (definedType != null) {
            MethodElement element = definedType.load().resolveMethodElementInterface(name, descriptor);
            if (element == null) {
                throw new BlockEarlyTermination(this.nsme(name));
            }
            return this.getFirstBuilder().lookupInterfaceMethod(reference, (InstanceMethodElement)element);
        }
        this.ctxt.error(this.getLocation(), "Resolve method on a non-class type `%s` (did you forget a plugin?)", new Object[]{owner});
        throw new BlockEarlyTermination(this.nsme(name));
    }

    public Value resolveStaticMethod(TypeDescriptor owner, String name, MethodDescriptor descriptor) {
        DefinedTypeDefinition definedType = this.resolveDescriptor(owner);
        if (definedType != null) {
            MethodElement element = definedType.isInterface() ? definedType.load().resolveMethodElementInterface(name, descriptor) : definedType.load().resolveMethodElementVirtual(this.getClassContext(), name, descriptor);
            if (element == null) {
                throw new BlockEarlyTermination(this.nsme(name));
            }
            return this.getLiteralFactory().literalOf(element);
        }
        this.ctxt.error(this.getLocation(), "Resolve method on a non-class type `%s` (did you forget a plugin?)", new Object[]{owner});
        throw new BlockEarlyTermination(this.nsme(name));
    }

    public Value resolveConstructor(TypeDescriptor owner, MethodDescriptor descriptor) {
        DefinedTypeDefinition definedType = this.resolveDescriptor(owner);
        if (definedType != null) {
            ConstructorElement element = definedType.load().resolveConstructorElement(descriptor);
            if (element == null) {
                throw new BlockEarlyTermination(this.nsme("<init>"));
            }
            return this.getLiteralFactory().literalOf(element);
        }
        this.ctxt.error(this.getLocation(), "Resolve method on a non-class type `%s` (did you forget a plugin?)", new Object[]{owner});
        throw new BlockEarlyTermination(this.nsme("<init>"));
    }

    public Value extractInstanceField(Value valueObj, TypeDescriptor owner, String name, TypeDescriptor type) {
        return this.extractInstanceField(valueObj, this.resolveField(owner, name, type));
    }

    public Value checkcast(Value value, TypeDescriptor desc) {
        ClassContext cc = this.getClassContext();
        ValueType castType = cc.resolveTypeFromDescriptor(desc, TypeParameterContext.of((Element)this.getCurrentElement()), TypeSignature.synthesize((ClassContext)cc, (TypeDescriptor)desc));
        ValueType valueType = value.getType();
        if (value instanceof ConstantLiteral) {
            return this.ctxt.getLiteralFactory().constantLiteralOfType(castType);
        }
        if (value instanceof UndefinedLiteral) {
            return this.ctxt.getLiteralFactory().undefinedLiteralOfType(castType);
        }
        if (castType instanceof ObjectType) {
            ObjectType originalToType;
            ObjectType toType = originalToType = (ObjectType)castType;
            int toDimensions = 0;
            if (toType instanceof ReferenceArrayObjectType) {
                toDimensions = ((ReferenceArrayObjectType)toType).getDimensionCount();
                toType = ((ReferenceArrayObjectType)toType).getLeafElementType();
            }
            return this.checkcast(value, (Value)cc.getLiteralFactory().literalOfType((ValueType)toType), (Value)cc.getLiteralFactory().literalOf((IntegerType)this.ctxt.getTypeSystem().getUnsignedInteger8Type(), (long)toDimensions), CheckCast.CastType.Cast, originalToType);
        }
        if (castType instanceof WordType) {
            Value sizedValue;
            WordType toType = (WordType)castType;
            WordType fromType = (WordType)valueType;
            if (value.isDefEq((Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)fromType))) {
                return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)toType);
            }
            if (fromType instanceof IntegerType) {
                IntegerType it = (IntegerType)fromType;
                if (toType instanceof PointerType) {
                    return super.valueConvert(value, toType);
                }
                sizedValue = toType.getMinBits() < fromType.getMinBits() ? super.truncate(value, (WordType)it.asSized(toType.getMinBits())) : (toType.getMinBits() > fromType.getMinBits() ? super.extend(value, (WordType)it.asSized(toType.getMinBits())) : value);
            } else {
                sizedValue = value;
            }
            if (fromType instanceof PointerType && toType instanceof IntegerType || fromType instanceof IntegerType && toType instanceof PointerType) {
                return super.valueConvert(sizedValue, toType);
            }
            return super.bitCast(sizedValue, toType);
        }
        if (castType instanceof CompoundType) {
            if (value instanceof Literal && ((Literal)value).isZero()) {
                return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(castType);
            }
            if (castType.equals(valueType)) {
                return value;
            }
            if (value instanceof Dereference) {
                return value;
            }
            this.ctxt.error(this.getLocation(), "Disallowed cast of value from %s to %s", new Object[]{valueType, castType});
            return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(castType);
        }
        if (valueType instanceof PointerType && castType instanceof ArrayType) {
            return value;
        }
        this.ctxt.error(this.getLocation(), "Disallowed cast of value from %s to %s", new Object[]{valueType, castType});
        return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(castType);
    }

    public Value instanceOf(Value input, TypeDescriptor desc) {
        ArrayObjectType ot;
        ClassContext cc = this.getClassContext();
        int dimensions = 0;
        if (desc instanceof ArrayTypeDescriptor) {
            ot = cc.resolveArrayObjectTypeFromDescriptor(desc, TypeParameterContext.of((Element)this.getCurrentElement()), TypeSignature.synthesize((ClassContext)cc, (TypeDescriptor)desc));
            if (ot instanceof ReferenceArrayObjectType) {
                dimensions = ((ReferenceArrayObjectType)ot).getDimensionCount();
                ot = ((ReferenceArrayObjectType)ot).getLeafElementType();
            }
        } else if (desc instanceof ClassTypeDescriptor) {
            ClassTypeDescriptor classDesc = (ClassTypeDescriptor)desc;
            String className = (String)(classDesc.getPackageName().isEmpty() ? "" : classDesc.getPackageName() + "/") + classDesc.getClassName();
            DefinedTypeDefinition definedType = cc.findDefinedType(className);
            ot = definedType.load().getObjectType();
        } else {
            throw Assert.unreachableCode();
        }
        return this.instanceOf(input, (ObjectType)ot, dimensions);
    }

    public Value new_(ClassTypeDescriptor desc) {
        ClassContext cc = this.getClassContext();
        DefinedTypeDefinition enclosingType = this.getCurrentElement().getEnclosingType();
        Object type = desc == enclosingType.getDescriptor() ? enclosingType.load().getObjectType() : cc.resolveTypeFromDescriptor((TypeDescriptor)desc, TypeParameterContext.of((Element)this.getCurrentElement()), TypeSignature.synthesize((ClassContext)cc, (TypeDescriptor)desc));
        if (type instanceof ClassObjectType) {
            ClassObjectType cot = (ClassObjectType)type;
            Layout layout = Layout.get((CompilationContext)this.ctxt);
            CompoundType compoundType = layout.getInstanceLayoutInfo(cot.getDefinition()).getCompoundType();
            LiteralFactory lf = this.ctxt.getLiteralFactory();
            return super.new_(cot, (Value)lf.literalOfType((ValueType)cot), (Value)lf.literalOf(compoundType.getSize()), (Value)lf.literalOf(compoundType.getAlign()));
        }
        return super.new_(desc);
    }

    public Value newArray(ArrayTypeDescriptor desc, Value size) {
        ClassContext cc = this.getClassContext();
        ValueType type = cc.resolveTypeFromDescriptor((TypeDescriptor)desc, TypeParameterContext.of((Element)this.getCurrentElement()), TypeSignature.synthesize((ClassContext)cc, (TypeDescriptor)desc));
        if (type instanceof PrimitiveArrayObjectType) {
            PrimitiveArrayObjectType pat = (PrimitiveArrayObjectType)type;
            return super.newArray(pat, size);
        }
        if (type instanceof ReferenceArrayObjectType) {
            ReferenceArrayObjectType rat = (ReferenceArrayObjectType)type;
            IntegerLiteral dimensions = this.ctxt.getLiteralFactory().literalOf((IntegerType)CoreClasses.get((CompilationContext)this.ctxt).getRefArrayDimensionsField().getType(), (long)rat.getDimensionCount());
            TypeLiteral elemTypeId = this.ctxt.getLiteralFactory().literalOfType((ValueType)rat.getLeafElementType());
            return super.newReferenceArray(rat, (Value)elemTypeId, (Value)dimensions, size);
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            if (size instanceof IntegerLiteral) {
                IntegerLiteral il = (IntegerLiteral)size;
                return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)this.ctxt.getTypeSystem().getArrayType(at.getElementType(), il.longValue()));
            }
            this.ctxt.error(this.getLocation(), "Native arrays must have a literal length", new Object[0]);
            return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)at);
        }
        return super.newArray(desc, size);
    }

    public Value multiNewArray(ArrayTypeDescriptor desc, List<Value> dimensions) {
        ClassContext cc = this.getClassContext();
        ValueType type = cc.resolveTypeFromDescriptor((TypeDescriptor)desc, TypeParameterContext.of((Element)this.getCurrentElement()), TypeSignature.synthesize((ClassContext)cc, (TypeDescriptor)desc));
        if (type instanceof ArrayObjectType) {
            return super.multiNewArray((ArrayObjectType)type, dimensions);
        }
        return super.multiNewArray(desc, dimensions);
    }

    private InstanceFieldElement resolveInstanceField(TypeDescriptor owner, String name, TypeDescriptor desc) {
        FieldElement field = this.resolveField(owner, name, desc);
        if (field instanceof InstanceFieldElement) {
            InstanceFieldElement ife = (InstanceFieldElement)field;
            return ife;
        }
        this.ctxt.warning(this.getLocation(), "Incompatible class change: non-static to static field %s#%s", new Object[]{field.getEnclosingType().getInternalName().replace('/', '.'), name});
        throw new BlockEarlyTermination(this.icce(name));
    }

    private FieldElement resolveField(TypeDescriptor owner, String name, TypeDescriptor desc) {
        DefinedTypeDefinition definedType = this.resolveDescriptor(owner);
        if (definedType != null) {
            FieldElement element = definedType.load().resolveField(desc, name);
            if (element == null) {
                throw new BlockEarlyTermination(this.nsfe(name));
            }
            return element;
        }
        this.ctxt.error(this.getLocation(), "Resolve field on a non-class type `%s` (did you forget a plugin?)", new Object[]{owner});
        throw new BlockEarlyTermination(this.nsfe(name));
    }

    private DefinedTypeDefinition resolveDescriptor(TypeDescriptor owner) {
        DefinedTypeDefinition enclosingType = this.getCurrentElement().getEnclosingType();
        if (owner == enclosingType.getDescriptor()) {
            return enclosingType;
        }
        if (owner instanceof ClassTypeDescriptor) {
            Object typeName = ((ClassTypeDescriptor)owner).getPackageName().isEmpty() ? ((ClassTypeDescriptor)owner).getClassName() : ((ClassTypeDescriptor)owner).getPackageName() + "/" + ((ClassTypeDescriptor)owner).getClassName();
            return this.getClassContext().findDefinedType((String)typeName);
        }
        if (owner instanceof ArrayTypeDescriptor) {
            ArrayTypeDescriptor atd = (ArrayTypeDescriptor)owner;
            CoreClasses coreClasses = CoreClasses.get((CompilationContext)this.ctxt);
            TypeDescriptor elementDesc = atd.getElementTypeDescriptor();
            if (elementDesc instanceof BaseTypeDescriptor) {
                if (elementDesc == BaseTypeDescriptor.B) {
                    return coreClasses.getByteArrayContentField().getEnclosingType();
                }
                if (elementDesc == BaseTypeDescriptor.C) {
                    return coreClasses.getCharArrayContentField().getEnclosingType();
                }
                if (elementDesc == BaseTypeDescriptor.D) {
                    return coreClasses.getDoubleArrayContentField().getEnclosingType();
                }
                if (elementDesc == BaseTypeDescriptor.F) {
                    return coreClasses.getFloatArrayContentField().getEnclosingType();
                }
                if (elementDesc == BaseTypeDescriptor.I) {
                    return coreClasses.getIntArrayContentField().getEnclosingType();
                }
                if (elementDesc == BaseTypeDescriptor.J) {
                    return coreClasses.getLongArrayContentField().getEnclosingType();
                }
                if (elementDesc == BaseTypeDescriptor.S) {
                    return coreClasses.getShortArrayContentField().getEnclosingType();
                }
                assert (elementDesc == BaseTypeDescriptor.Z);
                return coreClasses.getShortArrayContentField().getEnclosingType();
            }
            if (elementDesc instanceof ClassTypeDescriptor || elementDesc instanceof ArrayTypeDescriptor) {
                return coreClasses.getRefArrayContentField().getEnclosingType();
            }
        }
        return null;
    }

    private BasicBlock nsfe(String name) {
        Info info = Info.get(this.ctxt);
        Value nsfe = this.new_(info.nsfeClass);
        StringLiteral l = this.ctxt.getLiteralFactory().literalOf(name, this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/String").load().getObjectType().getReference());
        this.call(this.resolveConstructor((TypeDescriptor)info.nsfeClass, info.cd), nsfe, List.of(l));
        return this.throw_(nsfe);
    }

    private BasicBlock nsme(String name) {
        Info info = Info.get(this.ctxt);
        Value nsme = this.new_(info.nsmeClass);
        StringLiteral l = this.ctxt.getLiteralFactory().literalOf(name, this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/String").load().getObjectType().getReference());
        this.call(this.resolveConstructor((TypeDescriptor)info.nsmeClass, info.cd), nsme, List.of(l));
        return this.throw_(nsme);
    }

    private BasicBlock icce(String name) {
        Info info = Info.get(this.ctxt);
        Value icce = this.new_(info.icceClass);
        StringLiteral l = this.ctxt.getLiteralFactory().literalOf(name, this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/String").load().getObjectType().getReference());
        this.call(this.resolveConstructor((TypeDescriptor)info.icceClass, info.cd), icce, List.of(l));
        return this.throw_(icce);
    }

    private ClassContext getClassContext() {
        return this.getCurrentElement().getEnclosingType().getContext();
    }

    static final class Info {
        final ClassTypeDescriptor nsmeClass;
        final ClassTypeDescriptor nsfeClass;
        final ClassTypeDescriptor icceClass;
        final MethodDescriptor cd;

        private Info(CompilationContext ctxt) {
            DefinedTypeDefinition type = ctxt.getBootstrapClassContext().findDefinedType("java/lang/NoSuchMethodError");
            this.nsmeClass = (ClassTypeDescriptor)type.getDescriptor();
            type = ctxt.getBootstrapClassContext().findDefinedType("java/lang/NoSuchFieldError");
            this.nsfeClass = (ClassTypeDescriptor)type.getDescriptor();
            type = ctxt.getBootstrapClassContext().findDefinedType("java/lang/IncompatibleClassChangeError");
            this.icceClass = (ClassTypeDescriptor)type.getDescriptor();
            ClassTypeDescriptor string = ClassTypeDescriptor.synthesize((ClassContext)ctxt.getBootstrapClassContext(), (String)"java/lang/String");
            this.cd = MethodDescriptor.synthesize((ClassContext)ctxt.getBootstrapClassContext(), (TypeDescriptor)BaseTypeDescriptor.V, List.of(string));
        }

        static Info get(CompilationContext ctxt) {
            return (Info)ctxt.computeAttachmentIfAbsent(KEY, () -> new Info(ctxt));
        }
    }
}

