/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.vfs;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.List;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.interpreter.Thrown;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmArray;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmReferenceArray;
import org.qbicc.interpreter.VmString;
import org.qbicc.interpreter.VmThread;
import org.qbicc.interpreter.VmThrowableClass;
import org.qbicc.machine.arch.OS;
import org.qbicc.machine.vfs.AbsoluteVirtualPath;
import org.qbicc.machine.vfs.PosixVirtualFileSystem;
import org.qbicc.machine.vfs.VirtualFileStatBuffer;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;
import org.qbicc.machine.vfs.WindowsVirtualFileSystem;
import org.qbicc.machine.vio.VIOSystem;
import org.qbicc.plugin.vio.VIO;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.ParameterElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class VFS {
    private static final AttachmentKey<VFS> KEY = new AttachmentKey();
    private static final AttachmentKey<List<VirtualPath>> CLASS_PATH_KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final VirtualFileSystem fileSystem;
    private final AbsoluteVirtualPath qbiccPath;
    private final VIOSystem vioSystem;
    private final VmThrowableClass ioException;
    private final VmThrowableClass unsupportedOperationException;

    private VFS(CompilationContext ctxt) {
        this.ctxt = ctxt;
        ClassContext classContext = ctxt.getBootstrapClassContext();
        this.ioException = (VmThrowableClass)classContext.findDefinedType("java/io/IOException").load().getVmClass();
        this.unsupportedOperationException = (VmThrowableClass)classContext.findDefinedType("java/lang/UnsupportedOperationException").load().getVmClass();
        this.vioSystem = VIO.get((CompilationContext)ctxt).getVIOSystem();
        OS os = ctxt.getPlatform().getOs();
        this.fileSystem = os == OS.WIN32 ? new WindowsVirtualFileSystem(this.vioSystem) : new PosixVirtualFileSystem(this.vioSystem, os != OS.DARWIN);
        this.qbiccPath = this.fileSystem.getPath("/qbicc", new String[0]).toAbsolutePath();
    }

    public static VFS initialize(CompilationContext ctxt) {
        VFS attachment = (VFS)ctxt.getAttachment(KEY);
        if (attachment != null) {
            throw new IllegalStateException();
        }
        attachment = new VFS(ctxt);
        VFS appearing = (VFS)ctxt.putAttachmentIfAbsent(KEY, (Object)attachment);
        if (appearing != null) {
            throw new IllegalStateException();
        }
        attachment.registerInvokables();
        try {
            attachment.fileSystem.mkdirs((VirtualPath)attachment.qbiccPath, 493);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return attachment;
    }

    public static VFS get(CompilationContext ctxt) {
        VFS attachment = (VFS)ctxt.getAttachment(KEY);
        if (attachment == null) {
            throw new IllegalStateException();
        }
        return attachment;
    }

    private void registerInvokables() {
        Vm vm = this.ctxt.getVm();
        ClassContext classContext = this.ctxt.getBootstrapClassContext();
        LoadedTypeDefinition hostIoDef = classContext.findDefinedType("org/qbicc/runtime/host/HostIO").load();
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("open"), this::doHostOpen);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("reopen"), this::doHostReopen);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("mkdir"), this::doHostMkdir);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("unlink"), this::doHostUnlink);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("getBooleanAttributes"), this::doHostGetBooleanAttributes);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("stat"), this::doHostStat);
        vm.registerInvokable((ExecutableElement)hostIoDef.requireSingleMethod("readDirectoryEntry"), this::doHostReadDirectoryEntry);
        LoadedTypeDefinition ufspDef = classContext.findDefinedType("sun/nio/fs/UnixFileSystemProvider").load();
        vm.registerInvokable((ExecutableElement)ufspDef.requireSingleMethod("checkAccess"), this::doUfspCheckAccess);
        vm.registerInvokable((ExecutableElement)ufspDef.requireSingleMethod("isRegularFile"), this::doUfspIsRegularFile);
        vm.registerInvokable((ExecutableElement)ufspDef.requireSingleMethod("isDirectory"), this::doUfspIsDirectory);
        vm.registerInvokable((ExecutableElement)ufspDef.requireSingleMethod("newDirectoryStream"), this::doUfspNewDirectoryStream);
        vm.registerInvokable((ExecutableElement)ufspDef.requireSingleMethod("exists"), this::doUfspExists);
        vm.registerInvokable((ExecutableElement)ufspDef.requireSingleMethod("readAttributes"), this::doUfspReadAttributes);
    }

    private Object doHostOpen(VmThread vmThread, VmObject ignored, List<Object> args) {
        int fd;
        String pathName = ((VmString)args.get(0)).getContent();
        int openFlags = (Integer)args.get(1);
        int mode = (Integer)args.get(2);
        try {
            fd = this.fileSystem.open(this.fileSystem.getPath(pathName, new String[0]), openFlags, mode);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return fd;
    }

    private Object doHostReopen(VmThread vmThread, VmObject ignored, List<Object> args) {
        int fd = (Integer)args.get(0);
        String pathName = ((VmString)args.get(1)).getContent();
        int openFlags = (Integer)args.get(2);
        int mode = (Integer)args.get(3);
        try {
            this.fileSystem.open(fd, this.fileSystem.getPath(pathName, new String[0]), openFlags, mode);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return null;
    }

    private Object doHostMkdir(VmThread vmThread, VmObject ignored, List<Object> args) {
        String pathName = ((VmString)args.get(0)).getContent();
        int mode = (Integer)args.get(1);
        try {
            this.fileSystem.mkdir(this.fileSystem.getPath(pathName, new String[0]), mode);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return null;
    }

    private Object doHostUnlink(VmThread vmThread, VmObject ignored, List<Object> args) {
        String pathName = ((VmString)args.get(0)).getContent();
        try {
            this.fileSystem.unlink(this.fileSystem.getPath(pathName, new String[0]));
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return null;
    }

    private Object doHostGetBooleanAttributes(VmThread vmThread, VmObject ignored, List<Object> args) {
        int val;
        String pathName = ((VmString)args.get(0)).getContent();
        try {
            val = this.fileSystem.getBooleanAttributes(this.fileSystem.getPath(pathName, new String[0]), true);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return val;
    }

    private Object doHostStat(VmThread vmThread, VmObject ignored, List<Object> args) {
        VirtualFileStatBuffer buf;
        String pathName = ((VmString)args.get(0)).getContent();
        boolean followLinks = (Boolean)args.get(1);
        try {
            buf = this.fileSystem.stat(this.fileSystem.getPath(pathName, new String[0]), followLinks);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        Vm vm = vmThread.getVM();
        return this.createBasicFileAttributes(vm, buf);
    }

    private Object doHostReadDirectoryEntry(VmThread vmThread, VmObject ignored, List<Object> args) {
        String entry;
        int fd = (Integer)args.get(0);
        try {
            entry = this.fileSystem.getVioSystem().readDirectoryEntry(fd);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return entry == null ? null : vmThread.getVM().intern(entry);
    }

    private Object doUfspCheckAccess(VmThread vmThread, VmObject provider, List<Object> args) {
        return this.doUfspExists(vmThread, provider, args);
    }

    private Object doUfspIsRegularFile(VmThread vmThread, VmObject provider, List<Object> args) {
        boolean result;
        String pathStr = this.toString(vmThread, (VmObject)args.get(0));
        try {
            result = (this.fileSystem.getBooleanAttributes(this.fileSystem.getPath(pathStr, new String[0]), true) & 2) != 0;
        }
        catch (IOException e) {
            return Boolean.FALSE;
        }
        return result;
    }

    private Object doUfspIsDirectory(VmThread vmThread, VmObject provider, List<Object> args) {
        boolean result;
        String pathStr = this.toString(vmThread, (VmObject)args.get(0));
        try {
            result = (this.fileSystem.getBooleanAttributes(this.fileSystem.getPath(pathStr, new String[0]), true) & 4) != 0;
        }
        catch (IOException e) {
            return Boolean.FALSE;
        }
        return result;
    }

    private Object doUfspNewDirectoryStream(VmThread vmThread, VmObject ufsp, List<Object> args) {
        String pathStr = this.toString(vmThread, (VmObject)args.get(0));
        VmObject filter = (VmObject)args.get(1);
        LoadedTypeDefinition hdsDef = this.ctxt.getBootstrapClassContext().findDefinedType("org/qbicc/runtime/host/HostDirectoryStream").load();
        return vmThread.getVM().newInstance(hdsDef.getVmClass(), hdsDef.requireSingleConstructor(ce -> {
            ClassTypeDescriptor ctd;
            TypeDescriptor patt10236$temp = ((ParameterElement)ce.getParameters().get(0)).getTypeDescriptor();
            return patt10236$temp instanceof ClassTypeDescriptor && (ctd = (ClassTypeDescriptor)patt10236$temp).packageAndClassNameEquals("java/lang", "String");
        }), List.of(vmThread.getVM().intern(pathStr), filter));
    }

    private Object doUfspExists(VmThread vmThread, VmObject ufsp, List<Object> args) {
        String pathName = this.toString(vmThread, (VmObject)args.get(0));
        try {
            return (this.fileSystem.getBooleanAttributes(this.fileSystem.getPath(pathName, new String[0]), true) & 1) != 0;
        }
        catch (IOException e) {
            return Boolean.FALSE;
        }
    }

    private Object doUfspReadAttributes(VmThread vmThread, VmObject ufsp, List<Object> args) {
        VirtualFileStatBuffer buf;
        Vm vm = vmThread.getVM();
        String pathName = this.toString(vmThread, (VmObject)args.get(0));
        VmClass type = (VmClass)args.get(1);
        if (!type.getTypeDefinition().internalNameEquals("java/nio/file/attribute/BasicFileAttributes")) {
            throw new Thrown(this.unsupportedOperationException.newInstance("Only basic file attributes supported at build time"));
        }
        boolean followLinks = this.isFollowLinks(((VmReferenceArray)args.get(2)).getArray());
        try {
            buf = this.fileSystem.stat(this.fileSystem.getPath(pathName, new String[0]), followLinks);
        }
        catch (IOException e) {
            throw this.wrapIOE(e);
        }
        return this.createBasicFileAttributes(vm, buf);
    }

    private boolean isFollowLinks(VmObject[] options) {
        boolean followLinks = true;
        for (VmObject option : options) {
            if (option == null) continue;
            followLinks = false;
            break;
        }
        return followLinks;
    }

    private VmObject createBasicFileAttributes(Vm vm, VirtualFileStatBuffer buf) {
        VmArray vmArray = vm.newLongArray(new long[]{buf.getModTime(), buf.getAccessTime(), buf.getCreateTime(), buf.getBooleanAttributes(), buf.getSize(), buf.getFileId()});
        LoadedTypeDefinition hbfaDef = this.ctxt.getBootstrapClassContext().findDefinedType("org/qbicc/runtime/host/HostBasicFileAttributes").load();
        VmClass hbfaClass = hbfaDef.getVmClass();
        return vm.newInstance(hbfaClass, hbfaDef.requireSingleConstructor(ce -> true), List.of(vmArray));
    }

    private String toString(VmThread vmThread, VmObject pathObj) {
        Vm vm = vmThread.getVM();
        ClassContext classContext = this.ctxt.getBootstrapClassContext();
        ClassTypeDescriptor stringDesc = ClassTypeDescriptor.synthesize((ClassContext)classContext, (String)"java/lang/String");
        MethodDescriptor toStringDesc = MethodDescriptor.synthesize((ClassContext)classContext, (TypeDescriptor)stringDesc, List.of());
        MethodElement toStringMethod = pathObj.getVmClass().getTypeDefinition().resolveMethodElementVirtual(classContext, "toString", toStringDesc);
        VmString str = (VmString)vm.invokeExact(toStringMethod, pathObj, List.of());
        return str.getContent();
    }

    public static List<VirtualPath> getClassPathEntries(CompilationContext ctxt) {
        return (List)ctxt.getAttachment(CLASS_PATH_KEY);
    }

    public static void attachClassPath(CompilationContext ctxt, List<VirtualPath> paths) {
        ctxt.putAttachment(CLASS_PATH_KEY, paths);
    }

    public VirtualFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public AbsoluteVirtualPath getQbiccPath() {
        return this.qbiccPath;
    }

    private Thrown wrapIOE(IOException e) {
        if (e instanceof NoSuchFileException) {
            ClassContext classContext = this.ctxt.getBootstrapClassContext();
            return new Thrown(((VmThrowableClass)classContext.findDefinedType("java/nio/file/NoSuchFileException").load().getVmClass()).newInstance(e.getMessage()));
        }
        return new Thrown(this.ioException.newInstance(e.getMessage()));
    }
}

